% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_non_nbrs.R
\name{get_non_nbrs}
\alias{get_non_nbrs}
\title{Get non-neighbors of a node in a graph}
\usage{
get_non_nbrs(graph, node)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node}{A single-length vector containing a node ID value.}
}
\value{
A vector of node ID values.
}
\description{
Get the set of all nodes not neighboring a single graph node.
}
\examples{
# Create a simple, directed graph with 5
# nodes and 4 edges
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Find all non-neighbors of node `2`
graph \%>\% get_non_nbrs(node = 2)

}
