/*
 * Copyright © 2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** @file bind_image_error.c
 *
 * Test the BindImageTextureEXT errors.
 *
 */

#include "piglit-util-gl.h"

PIGLIT_GL_TEST_CONFIG_BEGIN

config.supports_gl_core_version = 32;

PIGLIT_GL_TEST_CONFIG_END


void
piglit_init(int argc, char **argv)
{
	bool pass = true;
	GLuint texture;
	GLint maxImageUnits;

	piglit_require_extension("GL_EXT_shader_image_load_store");

	glGetIntegerv(GL_MAX_IMAGE_UNITS_EXT, &maxImageUnits);

	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);

	/* Valid call */
	glBindImageTextureEXT(0, texture, 0, GL_FALSE, 0, GL_READ_WRITE, GL_RGBA32I);
	pass = pass && piglit_check_gl_error(GL_NO_ERROR);

	/* The EXT_shader_image_load_store spec says:
	 *
	 *     "INVALID_VALUE is generated by BindImageTextureEXT if <index> is less than
	 *     zero or greater than or equal to MAX_IMAGE_UNITS_EXT."
	 */
	glBindImageTextureEXT(maxImageUnits, texture, 0, GL_FALSE, 0, GL_READ_WRITE, GL_RGBA32I);
	pass = pass && piglit_check_gl_error(GL_INVALID_VALUE);

	/* The EXT_shader_image_load_store spec says:
	 *
	 *     "INVALID_VALUE is generated by BindImageTextureEXT if <texture> is not the
	 *     name of an existing texture object."
	 */
	glBindImageTextureEXT(0, texture + 1, 0, GL_FALSE, 0, GL_READ_WRITE, GL_RGBA32I);
	pass = pass && piglit_check_gl_error(GL_INVALID_VALUE);

	/* The EXT_shader_image_load_store spec says:
	 *
	 *     "INVALID_VALUE is generated by BindImageTextureEXT if <format> is not
	 *     a legal format"
	 */
	glBindImageTextureEXT(0, texture, 0, GL_FALSE, 0, GL_READ_WRITE, 12);
	pass = pass && piglit_check_gl_error(GL_INVALID_VALUE);

	piglit_report_result(pass ? PIGLIT_PASS : PIGLIT_FAIL);
}

enum piglit_result
piglit_display(void)
{
		return PIGLIT_FAIL;
}
