/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


/** FSP-S Configuration
**/
typedef struct {

/** Offset 0x0020
**/
  UINT32                      PcdCpuMicrocodePatchBase;

/** Offset 0x0024
**/
  UINT32                      PcdCpuMicrocodePatchSize;

/** Offset 0x0028 - SATA Controllers
  Enable/disable SATA Controller. Byte 0,2 is for SATA controller 0,2 respectively.
  Byte1 and 4 are unused
**/
  UINT32                      PcdEnableSATA;

/** Offset 0x002C - SATA port Enable for Controller 0
  0:Disabled , 1: Enabled .  Each one of 8 ports are represented by a nibble . for
  example : nibble 0 controls port 0 , nibble 1 controls port 1
**/
  UINT32                      PcdSATA0PortEnable;

/** Offset 0x0030 - SATA port HotPlug capability for Controller 0
  0:Disabled , 1: Enabled .  Each one of 8 ports are represented by a nibble . for
  example : nibble 0 controls port 0 , nibble 1 controls port 1
**/
  UINT32                      PcdSATA0PortHotplug;

/** Offset 0x0034 - SATA port Enable for Controller 2
  0:Disabled , 1: Enabled .  Each one of 8 ports are represented by a nibble . for
  example : nibble 0 controls port 0 , nibble 1 controls port 1
**/
  UINT32                      PcdSATA2PortEnable;

/** Offset 0x0038 - SATA port HotPlug capability for Controller 2
  0:Disabled , 1: Enabled .  Each one of 8 ports are represented by a nibble . for
  example : nibble 0 controls port 0 , nibble 1 controls port 1
**/
  UINT32                      PcdSATA2PortHotplug;

/** Offset 0x003C - EMMC controller
  Enable/Disable EMMC controller.
  $EN_DIS
**/
  UINT8                       PcdEmmc;

/** Offset 0x003D - EMMC HS400 Support
  Enable/Disable EMMC HS400 Support.
  $EN_DIS
**/
  UINT8                       PcdEmmcHS400Support;

/** Offset 0x003E - PCH PCIe Root Port 0 Link Speed
  Desired Link Speed level for PCIe Root Port 0
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort0LinkSpeed;

/** Offset 0x003F - PCH PCIe Root Port 1 Link Speed
  Desired Link Speed level for PCIe Root Port 1
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort1LinkSpeed;

/** Offset 0x0040 - PCH PCIe Root Port 2 Link Speed
  Desired Link Speed level for PCIe Root Port 0
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort2LinkSpeed;

/** Offset 0x0041 - PCH PCIe Root Port 3 Link Speed
  Desired Link Speed level for PCIe Root Port 3
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort3LinkSpeed;

/** Offset 0x0042 - PCH PCIe Root Port 8 Link Speed
  Desired Link Speed level for PCIe Root Port 8
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort8LinkSpeed;

/** Offset 0x0043 - PCH PCIe Root Port 9 Link Speed
  Desired Link Speed level for PCIe Root Port 9
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort9LinkSpeed;

/** Offset 0x0044 - PCH PCIe Root Port 10 Link Speed
  Desired Link Speed level for PCIe Root Port 10
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort10LinkSpeed;

/** Offset 0x0045 - PCH PCIe Root Port 11 Link Speed
  Desired Link Speed level for PCIe Root Port 11
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdPcieRootPort11LinkSpeed;

/** Offset 0x0046 - PCH PCIe Root Port 0 Aspm
  Desired Active state power management settings for PCIe Root Port 0
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort0Aspm;

/** Offset 0x0047 - PCH PCIe Root Port 1 Aspm
  Desired Active state power management settings for PCIe Root Port 1
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort1Aspm;

/** Offset 0x0048 - PCH PCIe Root Port 2 Aspm
  Desired Active state power management settings for PCIe Root Port 2
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort2Aspm;

/** Offset 0x0049 - PCH PCIe Root Port 3 Aspm
  Desired Active state power management settings for PCIe Root Port 3
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort3Aspm;

/** Offset 0x004A - PCH PCIe Root Port 8 Aspm
  Desired Active state power management settings for PCIe Root Port 8
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort8Aspm;

/** Offset 0x004B - PCH PCIe Root Port 9 Aspm
  Desired Active state power management settings for PCIe Root Port 9
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort9Aspm;

/** Offset 0x004C - PCH PCIe Root Port 10 Aspm
  Desired Active state power management settings for PCIe Root Port 10
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort10Aspm;

/** Offset 0x004D - PCH PCIe Root Port 11 Aspm
  Desired Active state power management settings for PCIe Root Port 11
  0:Disabled, 1:L0, 2:L1, 3:L0SL1
**/
  UINT8                       PcdPcieRootPort11Aspm;

/** Offset 0x004E - PCH PCIe Root Port 0 Connection Type
  Set Connection Type for PCIe Root Port 0. PCIe Root Port 0 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort0ConnectionType;

/** Offset 0x004F - PCH PCIe Root Port 1 Connection Type
  Set Connection Type for PCIe Root Port 1. PCIe Root Port 1 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort1ConnectionType;

/** Offset 0x0050 - PCH PCIe Root Port 2 Connection Type
  Set Connection Type for PCIe Root Port 2. PCIe Root Port 2 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort2ConnectionType;

/** Offset 0x0051 - PCH PCIe Root Port 3 Connection Type
  Set Connection Type for PCIe Root Port 3. PCIe Root Port 3 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort3ConnectionType;

/** Offset 0x0052 - PCH PCIe Root Port 8 Connection Type
  Set Connection Type for PCIe Root Port 8. PCIe Root Port 8 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort8ConnectionType;

/** Offset 0x0053 - PCH PCIe Root Port 9 Connection Type
  Set Connection Type for PCIe Root Port 9. PCIe Root Port 9 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort9ConnectionType;

/** Offset 0x0054 - PCH PCIe Root Port 10 Connection Type
  Set Connection Type for PCIe Root Port 10. PCIe Root Port 10 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort10ConnectionType;

/** Offset 0x0055 - PCH PCIe Root Port 11 Connection Type
  Set Connection Type for PCIe Root Port 11. PCIe Root Port 11 Hotplug enable forces
  connection type to Slot.
  0:Built-In, 1:Slot
**/
  UINT8                       PcdPcieRootPort11ConnectionType;

/** Offset 0x0056 - PCH PCIe Root Port 0 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 0
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort0HotPlug;

/** Offset 0x0057 - PCH PCIe Root Port 1 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 1
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort1HotPlug;

/** Offset 0x0058 - PCH PCIe Root Port 2 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 2
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort2HotPlug;

/** Offset 0x0059 - PCH PCIe Root Port 3 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 3
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort3HotPlug;

/** Offset 0x005A - PCH PCIe Root Port 8 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 8
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort8HotPlug;

/** Offset 0x005B - PCH PCIe Root Port 9 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 9
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort9HotPlug;

/** Offset 0x005C - PCH PCIe Root Port 10 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 10
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort10HotPlug;

/** Offset 0x005D - PCH PCIe Root Port 11 HotPlug
  Enable/Disable HotPlug for PCIe Root Port 11
  $EN_DIS
**/
  UINT8                       PcdPcieRootPort11HotPlug;

/** Offset 0x005E - IO-APIC 24-119 RTE
  Enable/Disable IO APIC entries 24-119
  $EN_DIS
**/
  UINT8                       PcdPchIoApic24119Entries;

/** Offset 0x005F
**/
  UINT8                       UnusedUpdSpace0[125];

/** Offset 0x00DC
**/
  UINT32                      PcdEMMCDLLConfigPtr;

/** Offset 0x00E0
**/
  UINT8                       ReservedSiliconInitUpd[16];
} FSP_S_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x00F0
**/
  UINT8                       UnusedUpdSpace1[14];

/** Offset 0x00FE
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
