# CiviCRM 5.50.0

Released June 1, 2022

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   | **yes** |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="security"></a>Security advisories

- **[CIVI-SA-2022-07: APIv3 Access Bypass](https://civicrm.org/advisory/civi-sa-2022-07-apiv3-access-bypass)**

## <a name="features"></a>Features

### Core CiviCRM

- **System Check - Add a reminder about CIVICRM_SIGN_KEYS.
  ([23224](https://github.com/civicrm/civicrm-core/pull/23224))**

  Adds a system status check that generates a reminder about cryptographic
  signing keys.

- **Restrict allowed uploads - contact image
  ([23147](https://github.com/civicrm/civicrm-core/pull/23147))**

  Restrict file types allowed for the contact image field.

- **Add tracking table for import jobs
  ([dev/core#1307](https://lab.civicrm.org/dev/core/-/issues/1307):
  [23199](https://github.com/civicrm/civicrm-core/pull/23199) and
  [23245](https://github.com/civicrm/civicrm-core/pull/23245))**

  This adds a new table for the purpose of tracking user jobs (e.g. imports) and
  associated temp tables and starts tracking the submittedValues and data source
  with it.

- **CustomFields - Improve metadata about which custom groups belong to which
  entities ([23336](https://github.com/civicrm/civicrm-core/pull/23336))**

  Makes the relationship between Custom Field Groups, entity types and subtypes
  discoverable via APIv4 metadata.

- **Upgrader - Add support for automatic snapshots
  ([23522](https://github.com/civicrm/civicrm-core/pull/23522) and
  [23544](https://github.com/civicrm/civicrm-core/pull/23594))**

  This adds a utility for recording a snapshot of certain columns in a database
  table prior to applying any upgrade steps to it.  This will make it easier to
  roll back or compare changes if necessary after the upgrade.

  The snapshot tables begin with the prefix `snap_civicrm_` and will be cleaned
  up after a certain number of minor version upgrades.  For now, the feature is
  disabled by default, but you may enable it by adding

      define('CIVICRM_UPGRADE_SNAPSHOT', TRUE);

  to the settings file.

- **Api4 - minor fixes and updates
  ([23310](https://github.com/civicrm/civicrm-core/pull/23310))**

  A few minor tweaks to APIv4 to improve working with extensions that have
  virtual entities.

- **APIv4 - Add NOW() date function
  ([23378](https://github.com/civicrm/civicrm-core/pull/23378))**

  Adds a function for NOW to APIv4 which returns the full date+time, and
  distinguishes it from CURDATE which just returns the date part.

- **APIv4 - Add MONTH sql function
  ([23377](https://github.com/civicrm/civicrm-core/pull/23377))**

  Adds the MONTH function to APIv4 & SearchKit, which enables e.g. filtering
  birthdays by month.

- **APIv4 - Add `is_active` extra field to Domain entity
  ([22159](https://github.com/civicrm/civicrm-core/pull/22159))**

  Adds a new calculated field to APIv4 making it easier to get the current
  active domain.

- **APIv4 - Add `Managed::reconcile` action.
  ([23243](https://github.com/civicrm/civicrm-core/pull/23243))**

  Adds APIv4 wrapper around ManagedEntities->reconcile();

- **Implement countFetched() and countMatched() on api4 results.
  ([22115](https://github.com/civicrm/civicrm-core/pull/22115))**

  Provides clearer methods for finding out how many API4 results you've got.

- **SearchKit - Add data segmentation functionality
  ([23059](https://github.com/civicrm/civicrm-core/pull/23059))**

  Creates virtual fields based on flexible segmentation criteria.

- **SearchKit - Add date pseudo-fields
  ([23381](https://github.com/civicrm/civicrm-core/pull/23381))**

  Exposes date pseudo-fields to SearchKit.

- **make survey title available in form builder
  ([23322](https://github.com/civicrm/civicrm-core/pull/23322))**

  Makes the Survey title field available in Afform.

- **Afform - Dispatch event to alter admin metadata; provide mixin
  ([23303](https://github.com/civicrm/civicrm-core/pull/23303))**

  Makes Form-Builder more extensible by allowing extensions to add to the list
  of available entities, elements, input types, styles, etc.

- **Afform - Improve dragging into dropzones
  ([23239](https://github.com/civicrm/civicrm-core/pull/23239))**

  Improves the drag-n-drop UX in Afform when composing complex layouts.

- **AfformGui - Optional reset button for search and submit forms
  ([dev/core#3430](https://lab.civicrm.org/dev/core/-/issues/3430):
  [23334](https://github.com/civicrm/civicrm-core/pull/23334))**

  Adds a "reset" button for search forms.

- **Add icons for SavedSearch and SearchDisplay entities
  ([23149](https://github.com/civicrm/civicrm-core/pull/23149))**

  Improves user experience by adding icons for Saved Search and Search Display
  entities.

- **Simplify and improve performance of query to insert updated cache
  ([21943](https://github.com/civicrm/civicrm-core/pull/21943))**

  Caching performance improvement.

### CiviCampaign

- **Make links to sign a petition easily accessible on the form.
  ([23316](https://github.com/civicrm/civicrm-core/pull/23316))**

  Adds links to the bottom of the petition edit form so users can more easily
  publicize their petition.

### CiviCase

- **Activity Type + Activity Status + Case Type not being Combined Correctly in
  Search Builder
  ([dev/core#3249](https://lab.civicrm.org/dev/core/-/issues/3249):
  [23313](https://github.com/civicrm/civicrm-core/pull/23313))**

  This makes `CaseType` in APIv4 a managed entity.  This is part of a move
  towards having all cases defined in configuration and deprecating XML-defined
  case types.

### CiviContribute

- **Define return parameters for doPayment
  ([dev/financial#141](https://lab.civicrm.org/dev/financial/-/issues/141):
  [22683](https://github.com/civicrm/civicrm-core/pull/22683))**

  Updates return parameters on all payment processors to match expected results.

### Drupal Integration

- **Extend command drush civicrm-ext-list for Drupal 8
  ([72](https://github.com/civicrm/civicrm-drupal-8/pull/72))**

  Extends the `drush civicrm-ext-list` command to work for drupal 8.

### Wordpress Integration

- **WordPress - Display site-theme/decorations on error screens
  ([22805](https://github.com/civicrm/civicrm-core/pull/22805))**

  Improve error screen user experience by displaying site theme/decorations.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Improve validation of start and end dates for events, contribution pages and
  more (Work Towards
  [dev/core#2846](https://lab.civicrm.org/dev/core/-/issues/2846):
  [21513](https://github.com/civicrm/civicrm-core/pull/21513))**

  Applies form-level validation to start and end dates.

- **Report Filter Statistics don't show filters with value of "0"
  ([dev/core#3164](https://lab.civicrm.org/dev/core/-/issues/3164):
  [23191](https://github.com/civicrm/civicrm-core/pull/23191))**

- **Fix 'Authorization Failed' regression when submitting eg. webform via
  checksum ([23607](https://github.com/civicrm/civicrm-core/pull/23607))**

  This resolves a bug where accessing an entity through APIv3, coming in via a
  checksum link, results in a failed authorization for the step of updating the
  recent items stack via APIv4.

- **Manage Extensions - Hide nag for core exts
  ([dev/core#3171](https://lab.civicrm.org/dev/core/-/issues/3171):
  [23204](https://github.com/civicrm/civicrm-core/pull/23204))**

- **AuthX: Breaks sites when Basic Auth is enabled
  ([dev/core#3416](https://lab.civicrm.org/dev/core/-/issues/3416):
  [22837](https://github.com/civicrm/civicrm-core/pull/22837))**

- **Save button on API4 explorer is misleading
  ([dev/core#3155](https://lab.civicrm.org/dev/core/-/issues/3155):
  [23144](https://github.com/civicrm/civicrm-core/pull/23144))**

- **APIv4 - Support pseudoconstant suffixes in getFields
  ([23348](https://github.com/civicrm/civicrm-core/pull/23348))**

- **APIv4 - Deprecate unnecessary event
  ([23311](https://github.com/civicrm/civicrm-core/pull/23311))**

- **SearchKit - Consistently check for date field
  ([23354](https://github.com/civicrm/civicrm-core/pull/23354))**

- **SearchKit - Ensure all date and timestamp fields are presented with datepicker
  ([23335](https://github.com/civicrm/civicrm-core/pull/23335))**

- **SearchKit - Keep label when switching entity
  ([23319](https://github.com/civicrm/civicrm-core/pull/23319))**

- **SearchKit - Move grid css to its own file
  ([23315](https://github.com/civicrm/civicrm-core/pull/23315))**

- **SearchKit - Fix 'undefined var' error after import
  ([23572](https://github.com/civicrm/civicrm-core/pull/23572))**

  Fixes an unresponsive screen after importing multiple records into SearchKit
  (using the Import dialog).

- **add missing Parishes of Bermuda (civicrm_state_province)
  ([23339](https://github.com/civicrm/civicrm-core/pull/23339))**

- **PR 22070 follow-up: reinstate respecting no_display on report column headers
  ([23321](https://github.com/civicrm/civicrm-core/pull/23321))**

  Respect no_display on report column headers.

- **Remove preferred email format from inline edit
  ([23269](https://github.com/civicrm/civicrm-core/pull/23269))**

- **Do not escape wizard class - procede straight to Hogwarts
  ([23185](https://github.com/civicrm/civicrm-core/pull/23185))**

- **jira/browse/CRM-18217 On the website front-end, CiviCRM page heading should
  start from h2 and not h1
  ([23324](https://github.com/civicrm/civicrm-core/pull/23324))**

- **Disable scrolling on time inputs
  ([dev/user-interface#47](https://lab.civicrm.org/dev/user-interface/-/issues/47):
  [23264](https://github.com/civicrm/civicrm-core/pull/23264))**

- **SearchKit - Fix selection of fields when creating a Data Segment
  ([23265](https://github.com/civicrm/civicrm-core/pull/23265))**

- **APIv4 - Fix fatal error on getFields when passing in contact id
  ([23389](https://github.com/civicrm/civicrm-core/pull/23389))**

- **ACLCache: Efficiency. Fix duplicate inserts
  ([21993](https://github.com/civicrm/civicrm-core/pull/21993))**

- **Update expired root certs (5.50)
  ([23387](https://github.com/civicrm/civicrm-core/pull/23387))**

- **Fix 'Table already exists' error when running 5.50 upgrade twice
  ([23355](https://github.com/civicrm/civicrm-core/pull/23355))**

- **5.50.alpha1.mysql.tpl - Escape `grouping` (reserved word in MySQL 8.0)
  ([23396](https://github.com/civicrm/civicrm-core/pull/23396))**

- **Import code cleanup (Work Towards
  [dev/core#3414](https://lab.civicrm.org/dev/core/-/issues/3414):
  [23291](https://github.com/civicrm/civicrm-core/pull/23291))**

  Stop dropping temp table on finish of contact import job.

- **[Import] Upgrade saved import names for contacts
  ([23288](https://github.com/civicrm/civicrm-core/pull/23288))**

  Fixes the Contact import such that the name field hold the name of the field
  being upgraded to rather than the label (and fixes the import such that it
  expects name going forwards).

- **[Import] Enotice fix on contact import field mapping screen
  ([23306](https://github.com/civicrm/civicrm-core/pull/23306))**

- **[Import] Output errors, duplicates csvs directly from the user job table
  ([23292](https://github.com/civicrm/civicrm-core/pull/23292))**

- **Import - fix comment
  ([23361](https://github.com/civicrm/civicrm-core/pull/23361))**

- **resolve TypeError: unsupported operand types: string + int;
  ([23015](https://github.com/civicrm/civicrm-core/pull/23015))**

- **Ensure tags fields are assigned to tpl for email form test
  ([23183](https://github.com/civicrm/civicrm-core/pull/23183))**

- **Don't overescape links in pledge tab
  ([23206](https://github.com/civicrm/civicrm-core/pull/23206))**

- **Don't overescape tab links
  ([23205](https://github.com/civicrm/civicrm-core/pull/23205))**

- **🪲 🪳 Bug Fix: The option "Enable multiple bulk email address for a contact"
  does not apply when editing a Contact, only works for inline edit of email
  addresses ([23082](https://github.com/civicrm/civicrm-core/pull/23082))**

- **Translation - distinguish between 'On' for date and 'On'/'Off'
  ([23379](https://github.com/civicrm/civicrm-core/pull/23379))**

- **getSelfServiceEligibility: fix string translation
  ([23163](https://github.com/civicrm/civicrm-core/pull/23163))**

- **Centralise skipColumnHeader to one function (fixes notices, cleans code)
  ([23135](https://github.com/civicrm/civicrm-core/pull/23135))**

- **✍🏼 Fix spelling of "additional". Numerous uses of "additonal"
  ([23162](https://github.com/civicrm/civicrm-core/pull/23162))**

- **Ensure deleteURL variable for ContactImage.tpl
  ([23150](https://github.com/civicrm/civicrm-core/pull/23150))**

- **Don't overescape weights in default-escape mode
  ([23152](https://github.com/civicrm/civicrm-core/pull/23152))**

- **Avoid PHP notices on FinancialAccount table
  ([23151](https://github.com/civicrm/civicrm-core/pull/23151))**

- **Apply nodefaults to row actions
  ([23207](https://github.com/civicrm/civicrm-core/pull/23207))**

- **Add nodefaults to access.tpl
  ([23208](https://github.com/civicrm/civicrm-core/pull/23208))**

- **Add nodefaults to group edit form
  ([23225](https://github.com/civicrm/civicrm-core/pull/23225))**

- **Add smarty:nodefaults to ManageEvent page.
  ([23173](https://github.com/civicrm/civicrm-core/pull/23173))**

- **Add smarty:nodefaults to default.tpl form.
  ([23153](https://github.com/civicrm/civicrm-core/pull/23153))**

- **Apply nodefaults to contact tabs for escape-on-output
  ([23232](https://github.com/civicrm/civicrm-core/pull/23232))**

- **MultipleRecordFieldsListing.tpl - JS strings should us JS escaping
  ([23499](https://github.com/civicrm/civicrm-core/pull/23499))**

### CiviCampaign

- **update-supporter-url
  ([23287](https://github.com/civicrm/civicrm-core/pull/23287))**

### CiviCase

- **Case Resources cuts off at 25 contacts when creating case activity
  ([dev/core#3431](https://lab.civicrm.org/dev/core/-/issues/3431):
  [23327](https://github.com/civicrm/civicrm-core/pull/23327))**

  Case activity only has 25 contacts listed from Case Resources in the Send Copy
  section.

### CiviContribute

- **Paypal pro, a.net ipn - do not update start date, status
  ([23156](https://github.com/civicrm/civicrm-core/pull/23156))**

- **Compare currencies as well as amounts on template Contribution change
  ([23298](https://github.com/civicrm/civicrm-core/pull/23298))**

- **Start to fix misnamed FinancialTrxn bao
  ([23190](https://github.com/civicrm/civicrm-core/pull/23190))**

- **ensure checkbox custom fields on contributions import properly
  ([23246](https://github.com/civicrm/civicrm-core/pull/23246))**

- **Always assign pay_later_receipt
  ([23080](https://github.com/civicrm/civicrm-core/pull/23080))**

- **Contribution dashboard links work in escape-on-output mode
  ([23174](https://github.com/civicrm/civicrm-core/pull/23174))**

- **Improve financial trxn spec to require required fields
  ([22571](https://github.com/civicrm/civicrm-core/pull/22571))**

- **Always use cancelSubscription form for cancelling recurring contributions
  ([23210](https://github.com/civicrm/civicrm-core/pull/23210))**

- **financialacls core extension uses a global callback in
  hook_civicrm_container, which might be iffy
  ([dev/core#3184](https://lab.civicrm.org/dev/core/-/issues/3184):
  [23268](https://github.com/civicrm/civicrm-core/pull/23268))**

  Definitively load main files during bootstrap.

- **Fix empty money handling
  ([23528](https://github.com/civicrm/civicrm-core/pull/23528))**

  Tokens representing money fields will now default to 0 for empty values.

- **Calculate unit_price based on qty
  ([23566](https://github.com/civicrm/civicrm-core/pull/23566))**

  This resolves a bug when a template contribution was created for a recurring
  contribution: the unit_price on the line item was set to match the line_total,
  ignoring qty.

### CiviEvent

- **batch geocode API does not process event addresses
  ([dev/core#3439](https://lab.civicrm.org/dev/core/-/issues/3439):
  [23351](https://github.com/civicrm/civicrm-core/pull/23351))**

- **Event template scheduled reminders lost when creating a new event using API4
  ([dev/core#3183](https://lab.civicrm.org/dev/core/-/issues/3183):
  [23238](https://github.com/civicrm/civicrm-core/pull/23238))**

- **Scheduled Reminders "Additional Recipients" feature sends at wrong time, is
  incompatible with tokens
  ([dev/core#1836](https://lab.civicrm.org/dev/core/-/issues/1836):
  [23101](https://github.com/civicrm/civicrm-core/pull/23101))**

- **Event self-service cancel: allow cancelling Waitlist registration
  ([23164](https://github.com/civicrm/civicrm-core/pull/23164))**

### CiviMail

- **send group subscription welcome email only if template is enabled
  ([23139](https://github.com/civicrm/civicrm-core/pull/23139))**

### CiviMember

- **Limit issue fix
  ([23229](https://github.com/civicrm/civicrm-core/pull/23229))**

  Remove limit when printing labels from member search action.

- **Set default values on MembershipView to stop PHP notices
  ([22664](https://github.com/civicrm/civicrm-core/pull/22664))**

### Drupal Integration

- **Epic: Drupal 10 readiness (Work Towards
  [dev/drupal#176](https://lab.civicrm.org/dev/drupal/-/issues/176):
  [23302](https://github.com/civicrm/civicrm-core/pull/23302))**

  Fixes the 'Error: Class "Symfony\Cmf\Component\Routing\RouteObjectInterface"
  not found' when using cv in drupal 9 and 10.

## <a name="misc"></a>Miscellany

- **ManagedEntities - Allow targeted reconciliation. Add hook parameter.
  Simplify logic.
  ([22959](https://github.com/civicrm/civicrm-core/pull/22959))**

- **DAOs out of date
  ([23362](https://github.com/civicrm/civicrm-core/pull/23362))**

- **[Import] Rename dedupe rule id field from dedupe to dedupe_rule_id field
  ([23263](https://github.com/civicrm/civicrm-core/pull/23263))**

- **Add import function to parser
  ([23338](https://github.com/civicrm/civicrm-core/pull/23338))**

- **I have no words
  ([23244](https://github.com/civicrm/civicrm-core/pull/23244))**

- **Update phpleague/csv from 9.2 to 9.6 (supports php 8)
  ([dev/core#3172](https://lab.civicrm.org/dev/core/-/issues/3172):
  [23180](https://github.com/civicrm/civicrm-core/pull/23180))**

- **Stop adding obsolete currencies to new installs
  ([23345](https://github.com/civicrm/civicrm-core/pull/23345))**

- **Managed entity cleanup
  ([23251](https://github.com/civicrm/civicrm-core/pull/23251))**

- **Take a reality check on moneyCleaning in test
  ([23215](https://github.com/civicrm/civicrm-core/pull/23215))**

- **Minor simplification of getAmountLevelText
  ([23159](https://github.com/civicrm/civicrm-core/pull/23159))**

- **Standardise activity datasource text
  ([23217](https://github.com/civicrm/civicrm-core/pull/23217))**

- **Standardise participant import text
  ([23218](https://github.com/civicrm/civicrm-core/pull/23218))**

- **Standardize DataSource file for Contribution & Membership
  ([23186](https://github.com/civicrm/civicrm-core/pull/23186))**

- **Release - Set version compatibility for core extensions when updating core
  ([23143](https://github.com/civicrm/civicrm-core/pull/23143))**

- **Make static function static - processCaseTags
  ([23278](https://github.com/civicrm/civicrm-core/pull/23278))**

- **Whitespace cleanup in template file
  ([23277](https://github.com/civicrm/civicrm-core/pull/23277))**

- **IDE cheer - cast var explicitly to an int
  ([23350](https://github.com/civicrm/civicrm-core/pull/23350))**

- **Remove unused variable
  ([23352](https://github.com/civicrm/civicrm-core/pull/23352))**

- **Minor function simplification in private function
  ([23364](https://github.com/civicrm/civicrm-core/pull/23364))**

- **ManagedEntities - Update version number for mgd-php
  ([23422](https://github.com/civicrm/civicrm-core/pull/23422))**

- **Minor readability improvement
  ([23157](https://github.com/civicrm/civicrm-core/pull/23157))**

- **Cleanup crmMailing/Templates.js
  ([23188](https://github.com/civicrm/civicrm-core/pull/23188))**

- **Further simplify variable retrieval
  ([23172](https://github.com/civicrm/civicrm-core/pull/23172))**

- **Remove unused parameter from private function
  ([23194](https://github.com/civicrm/civicrm-core/pull/23194))**

- **Remove code only needed by Drupal6
  ([23212](https://github.com/civicrm/civicrm-core/pull/23212))**

- **Remove unused function
  ([23200](https://github.com/civicrm/civicrm-core/pull/23200))**

- **Remove an unset variable
  ([23285](https://github.com/civicrm/civicrm-core/pull/23285))**

- **Remove some copy & paste
  ([23171](https://github.com/civicrm/civicrm-core/pull/23171))**

- **Remove another good intention - unused variables
  ([23275](https://github.com/civicrm/civicrm-core/pull/23275))**

- **Reduce use of reference
  ([23165](https://github.com/civicrm/civicrm-core/pull/23165))**

- **Remove-single-value-loop
  ([23155](https://github.com/civicrm/civicrm-core/pull/23155))**

- **[REF] [Import] Use shared file instead of now-identical files
  ([23216](https://github.com/civicrm/civicrm-core/pull/23216))**

- **[REF] [Import] Standardise import text for CustomData import
  ([23219](https://github.com/civicrm/civicrm-core/pull/23219))**

- **[Ref] [Import] [csv] Remove non-functional code
  ([23195](https://github.com/civicrm/civicrm-core/pull/23195))**

- **[REF] [Import] Handle limit with more sanity
  ([23262](https://github.com/civicrm/civicrm-core/pull/23262))**

- **[Import] [Ref] Simplify string concatenation
  ([23330](https://github.com/civicrm/civicrm-core/pull/23330))**

- **[REF][Import] (minor) Extract getHightlightedFields
  ([23304](https://github.com/civicrm/civicrm-core/pull/23304))**

- **[REF] [Import] Obsolete if removal
  ([23253](https://github.com/civicrm/civicrm-core/pull/23253))**

- **[REF] [Import] [Custom] Remove another in-between class
  ([23222](https://github.com/civicrm/civicrm-core/pull/23222))**

- **[REF] [Import] [Trivial] Minor test fixes
  ([23341](https://github.com/civicrm/civicrm-core/pull/23341))**

- **[REF] [Import] Trivial - simplify variable
  ([23347](https://github.com/civicrm/civicrm-core/pull/23347))**

- **[REF] [Import] Ensure jobID is set in contact flow
  ([23280](https://github.com/civicrm/civicrm-core/pull/23280))**

- **[REF] [Import] call non-deprecated function instead of deprecated
  ([23293](https://github.com/civicrm/civicrm-core/pull/23293))**

- **[REF] [Import] [Trivial] Make 'mapper' field available as a submittable
  value throughout the flow
  ([23308](https://github.com/civicrm/civicrm-core/pull/23308))**

- **[REF] [Import] Extract getContactType
  ([23284](https://github.com/civicrm/civicrm-core/pull/23284))**

- **[REF] [Import] [Trivial] Make mapperKeys parameter optional in construct
  ([23307](https://github.com/civicrm/civicrm-core/pull/23307))**

- **[REF] [Import] [Trivial] Extract duplicate match options
  ([23300](https://github.com/civicrm/civicrm-core/pull/23300))**

- **[REF] [Import] Remove another good intention from the import class
  ([23261](https://github.com/civicrm/civicrm-core/pull/23261))**

- **[REF] [Import] Stop overloading dataSource form
  ([23237](https://github.com/civicrm/civicrm-core/pull/23237))**

- **[REF] [Import] Remove meaningless code
  ([23242](https://github.com/civicrm/civicrm-core/pull/23242))**

- **[REF] [Import] remove pointless fini functions.
  ([23241](https://github.com/civicrm/civicrm-core/pull/23241))**

- **[REF] [Import] Remove warning count - never returned
  ([23240](https://github.com/civicrm/civicrm-core/pull/23240))**

- **[Ref] [Import] Remove another good intention....mapField
  ([23236](https://github.com/civicrm/civicrm-core/pull/23236))**

- **[REF] [Import] Remove last in-between parser class
  ([23227](https://github.com/civicrm/civicrm-core/pull/23227))**

- **[Ref] [Import] Remove another 'in-between' class
  ([23221](https://github.com/civicrm/civicrm-core/pull/23221))**

- **[REF] [Import] [Contact] Remove in-between class
  ([23223](https://github.com/civicrm/civicrm-core/pull/23223))**

- **[Ref] [Import] Cleanup cleanup on old tables for form re-submission
  ([23276](https://github.com/civicrm/civicrm-core/pull/23276))**

- **[REF] [Import] Trivial - simplify variable
  ([23360](https://github.com/civicrm/civicrm-core/pull/23360))**

- **[REF][Import] [Contact] Clean up preview screen
  ([23340](https://github.com/civicrm/civicrm-core/pull/23340))**

- **[Import] [Ref] [Contact] Extract row mapping and add test
  ([23342](https://github.com/civicrm/civicrm-core/pull/23342))**

- **[Ref] [Import] Add extra functions to DataSource
  ([23344](https://github.com/civicrm/civicrm-core/pull/23344))**

- **[REF] [Import] Trivial - simplify variable
  ([23349](https://github.com/civicrm/civicrm-core/pull/23349))**

- **(REF) CryptoRegistry - Fix type declaration
  ([23220](https://github.com/civicrm/civicrm-core/pull/23220))**

- **[REF] [Import] extract validation functionality
  ([23371](https://github.com/civicrm/civicrm-core/pull/23371))**

- **[REF] [Import] Trivial - simplify variables
  ([23369](https://github.com/civicrm/civicrm-core/pull/23369))**

- **[Ref] Get rid of private deprecated legacy function
  ([23375](https://github.com/civicrm/civicrm-core/pull/23375))**

- **[REF] Do not treat site having a default location type as optional
  ([23282](https://github.com/civicrm/civicrm-core/pull/23282))**

- **[REF] Minor code simplifcation - reduce silly lines
  ([23368](https://github.com/civicrm/civicrm-core/pull/23368))**

- **[REF] [Import] Remove unused tpl assign showColNames
  ([23366](https://github.com/civicrm/civicrm-core/pull/23366))**

- **[Import] [Ref] [Minor] Simplify error handling with a try-catch block
  ([23370](https://github.com/civicrm/civicrm-core/pull/23370))**

- **[Ref][Import] Remove another good intention - random email counting
  ([23367](https://github.com/civicrm/civicrm-core/pull/23367))**

- **[REF] [Import] Simplify dataSource contract - remove unused preProcess
  ([23272](https://github.com/civicrm/civicrm-core/pull/23272))**

- **[REF] [Import] Trivial - simplify variables
  ([23363](https://github.com/civicrm/civicrm-core/pull/23363))**

- **(REF) Fix test to use full flow
  ([23160](https://github.com/civicrm/civicrm-core/pull/23160))**

- **[REF] Extract getContributionRecurID
  ([23158](https://github.com/civicrm/civicrm-core/pull/23158))**

- **[REF] [Import] Stop passing submittedValues as parameters
  ([23343](https://github.com/civicrm/civicrm-core/pull/23343))**

- **[REF] [Import] Remove another good intention - import 'conflicts'
  ([23380](https://github.com/civicrm/civicrm-core/pull/23380))**

- **[REF] Code cleanup on location entities for the Contact Summary screen
  ([22967](https://github.com/civicrm/civicrm-core/pull/22967))**

- **[REF] Fix test to use form flow / helper
  ([23211](https://github.com/civicrm/civicrm-core/pull/23211))**

- **[REF][Test] Update loadMappingTest to use form flow
  ([23286](https://github.com/civicrm/civicrm-core/pull/23286))**

- **[REF] Do not pass form properties within the form
  ([23213](https://github.com/civicrm/civicrm-core/pull/23213))**

- **(NFC) authx - Update descriptions and links in `info.xml`
  ([23169](https://github.com/civicrm/civicrm-core/pull/23169))**

- **(NFC) mixin/**.php - Add @since tags
  ([23423](https://github.com/civicrm/civicrm-core/pull/23423) and
  [23440](https://github.com/civicrm/civicrm-core/pull/23440))**

- **(NFC) Skip CliRunnerTest on php80+drush+Backdrop
  ([23184](https://github.com/civicrm/civicrm-core/pull/23184))**

- **NFC Minor cleanup to Participant confirm
  ([23357](https://github.com/civicrm/civicrm-core/pull/23357))**

- **[NFC] Fix APIv4 docblock annotations for Managed API
  ([23359](https://github.com/civicrm/civicrm-core/pull/23359))**

- **E2E_Core_ErrorTest - Demonstrate whether error pages are well-formed
  ([23257](https://github.com/civicrm/civicrm-core/pull/23257))**

- **(E2E) `testErrorChrome` - Update assertions for page-chrome
  ([23397](https://github.com/civicrm/civicrm-core/pull/23397))**

- **(E2E) testErrorChrome - Skip Backdrop and D8+ (much like D7)
  ([23398](https://github.com/civicrm/civicrm-core/pull/23398))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
Benjamin W; BrightMinded Ltd - Bradley Taylor; Circle Interactive - Pradeep
Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop
SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; Freeform Solutions - Herb
van den Dool; Ginkgo Street Labs - Michael Z Daryabeygi; iXiam - Luciano
Spiegel; JMA Consulting - Monish Deb, Seamus Lee; John Kingsnorth; Joinery -
Allen Shaw; Lighthouse Consulting and Design - Brian Shaughnessy; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Progressive
Technology Project - Jamie McClelland; Third Sector Design - Kurund Jalmi;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Andreas Howiller; Andy Burns; Artful Robot - Rich Lott; Australian Greens - John
Twyman; Betty Dolfing; Christian Wach; Circle Interactive - Dave Jenkins, Matt
Trim; CiviCoop - Jaap Jansma; iXiam - Vangelis Pantazis; JMA Consulting - Edsel
Lopez; John Kingsnorth; Joinery - Allen Shaw; Nicol Wistreich; Tadpole
Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
