# CiviCRM 5.36.0

Released April 7, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Remove campaign_id pseudoconstants
  ([19463](https://github.com/civicrm/civicrm-core/pull/19463))**

  Improves performance by not loading (potentially huge) list of campaigns
  into memory.

- **Custom setting for boolean checkbox is serialized as int value
  ([dev/core#2371](https://lab.civicrm.org/dev/core/-/issues/2371):
  [19576](https://github.com/civicrm/civicrm-core/pull/19576))**

  Serializes setting value as boolean for checkbox in CRM_Admin_Form_Generic.

- **Apply bootstrap theme to searchKit dashlets
  ([19577](https://github.com/civicrm/civicrm-core/pull/19577))**

  Themes SearchKit dashlets.

- **Crypto - Add support for signing and verifying JSON Web Tokens
  ([19599](https://github.com/civicrm/civicrm-core/pull/19599))**

  Introduces a mechanism for working with JSON Web Tokens.

- **Add 'readonly' attribute to fields in schema
  ([dev/core#2397](https://lab.civicrm.org/dev/core/-/issues/2397):
  [19627](https://github.com/civicrm/civicrm-core/pull/19627))**

  Adds 'readonly' metadata to all id fields, custom fields with 'is_view' and
  appropriate contact fields.

- **Show Contact age on deceased date
  ([19348](https://github.com/civicrm/civicrm-core/pull/19348))**

  Shows age of contact when it was deceased if deceased date is present.

- **View sent emails in activities
  ([dev/core#1750](https://lab.civicrm.org/dev/core/-/issues/1750):
  [18299](https://github.com/civicrm/civicrm-core/pull/18299))**

  Replaces tokens in Activity content for sent emails.

- **Expose a REST end-point through standard routing
  ([dev/core#2077](https://lab.civicrm.org/dev/core/-/issues/2077):
  [19728](https://github.com/civicrm/civicrm-core/pull/19728))**

  Provides a binding for CRM_Utils_REST in the conventional routing system.

- **Improve activity import to support updates (Work Towards
  [dev/core#2308](https://lab.civicrm.org/dev/core/-/issues/2308):
  [19421](https://github.com/civicrm/civicrm-core/pull/19421),
  [19553](https://github.com/civicrm/civicrm-core/pull/19553) and
  [19555](https://github.com/civicrm/civicrm-core/pull/19555))**

  Clean up and tests in preparation for changes to the Activity Import.

- **Support chain-select elements in .setting.php files
  ([dev/core#2386](https://lab.civicrm.org/dev/core/-/issues/2386):
  [19629](https://github.com/civicrm/civicrm-core/pull/19629))**

  Makes it possible to create metadata-driven chain select fields.

- **Add no results found on empty civireports dashlet
  ([dev/core#2420](https://lab.civicrm.org/dev/core/-/issues/2420):
  [19668](https://github.com/civicrm/civicrm-core/pull/19668))**

  Adds text to report template saying no results found if that is the case.

- **Search kit navigation - once I've created an afform it's hard to edit it
  ([dev/core#2389](https://lab.civicrm.org/dev/core/-/issues/2389):
  [19617](https://github.com/civicrm/civicrm-core/pull/19617))**

  Improves SearchKit admin page by including links to edit.

- **Afform - Add 'View Page' link from afform edit screen
  ([19645](https://github.com/civicrm/civicrm-core/pull/19645))**

  Improves Afform edit screen by adding a link to "View Page".

- **Afform - Add link to edit form in breadcrumbs
 ([19691](https://github.com/civicrm/civicrm-core/pull/19691))**

  If the user has permission to edit the Afform form (and the afform_admin
  extension is enabled), shows a breadcrumb back to edit the form.

- **Afform - Remove ngRoute from afformStandalone page
 ([19703](https://github.com/civicrm/civicrm-core/pull/19703))**

  Removes an unused dependency from the Afform standalone page, making it
  more flexible and reusable.

- **Afform Gui - Block editing enhancements
 ([19530](https://github.com/civicrm/civicrm-core/pull/19530))**

  Improves block editing in the Afform GUI.

- **Add created_id & modified_id to civicrm_saved_search
  ([dev/core#2422](https://lab.civicrm.org/dev/core/-/issues/2422):
  [19709](https://github.com/civicrm/civicrm-core/pull/19709))**

  Sites using search kit will rapidly start to accumulate a large number of saved
  searches and will want better filtering (& cleanup). This adds created_id and
  modified_id and starts populating them as well as expires_date (which won't
  start populating until it is exposed in the search kit UI).

- **afform_mock - Hide extension. Clearly indicate as development-only
  ([19541](https://github.com/civicrm/civicrm-core/pull/19541))**

  Hides the afform_mock extensio and clearly indicates it as development-only.

- **Afform - Support date range filters for search displays
  ([19632](https://github.com/civicrm/civicrm-core/pull/19632))**

  Adds support for date range filters for Afform search displays.

- **Afform - Allow public submission (PUB-CONTACT). Expand E2E test coverage.
  ([19579](https://github.com/civicrm/civicrm-core/pull/19579))**

  Makes it possible to submit new contact records to Afform as an anonymous
  user, and includes E2E test-coverage to that effect.

- **Afform - SearchKit support for calculated fields
  ([19612](https://github.com/civicrm/civicrm-core/pull/19612))**

  Adds support for calculated fields as afform search filters.

- **Search kit select current user
  ([19620](https://github.com/civicrm/civicrm-core/pull/19620))**

  Adds the ability to choose "Current User" for search criteria which allows
  displays to show different results to different users.

- **Search Kit - Use wrapper api to run searches
  ([19585](https://github.com/civicrm/civicrm-core/pull/19585))**

  Adds a new `SearchDisplay.Run` api action to centralize the logic and
  permissions for retrieving results for search displays.

- **SearchKit - Enable links for implicit joins
  ([19631](https://github.com/civicrm/civicrm-core/pull/19631))**

  Improves SearchKit to show links for implicitly joined entities.

- **SearchKit - cleanup display configuration and add "rewrite" feature
  ([19662](https://github.com/civicrm/civicrm-core/pull/19662))**

  Adds the ability to rewrite fields in search displays, while streamlining the
  display administration screen.

- **SearchKit - Take search filters from the url when viewing a standalone
  display ([19713](https://github.com/civicrm/civicrm-core/pull/19713))**

  Passes all query params from the url fragment as search filters to
  the display.

- **SearchKit - Add links/menus/buttons to search displays
  ([19673](https://github.com/civicrm/civicrm-core/pull/19673))**

  Gives the ability to configure sets of links, buttons or menus in SearchKit
  search displays.

- **SearchKit - Add implicit joins for displaying labels of related entities
  ([19554](https://github.com/civicrm/civicrm-core/pull/19554))**

  Gives SearchKit the ability to display labels of related entities, for
  example, displaying the Campaign title instead of just the Campaign ID.

- **SearchKit - Add links to view multi-record custom data
  ([19626](https://github.com/civicrm/civicrm-core/pull/19626))**

  When creating a search display, you can now add a link to view a Multi-Record
  custom entity.

- **APIv4 - Add option lists to getFields html_type and data_type
  ([19596](https://github.com/civicrm/civicrm-core/pull/19596))**

  Adds option lists to html_type and data_type in APIv4 getFields to make them
  easier to discover in the API Explorer.

- **Add is empty filter to search / api
  ([19736](https://github.com/civicrm/civicrm-core/pull/19736))**

  Adds 2 new operators, "Is Empty" & "Not Empty" to SearchKit (and APIv4 in
  general). Removes the "Is Null / Not Null" operators from SearchKit because
  they are overly technical and have confusingly similar names to the new
  operators (they are still available in the API generally, just not the SearchKit
  UI).

- **Improve search display filter validation
  ([19720](https://github.com/civicrm/civicrm-core/pull/19720))**

  When viewing a SearchDisplay, this will verify all filters are permitted by
  first checking the SELECT clause, and secondly checking for a containing Afform
  with exposed filters.

- **AuthX - Extended authentication support (portable and router-friendly)
  ([19590](https://github.com/civicrm/civicrm-core/pull/19590))**

  Introduces an extension, authx, which broadly improves
  support for HTTP authentication on any CiviCRM route.

- **info.xml - Allow multiple `<author>`s
  ([19684](https://github.com/civicrm/civicrm-core/pull/19684))**

  Allows info.xml files to list multiple authors.

- **APIv3 - Improve array-based apis to support sorting and operators
  ([19690](https://github.com/civicrm/civicrm-core/pull/19690))**

  Backports some APIv4 code to v3, for the purpose of supporting entityRef
  widgets for Afform.

- **Metadata: Add html:label for Contribution Status ID
  ([19669](https://github.com/civicrm/civicrm-core/pull/19669))**

  Adds html:label for Contribution Status ID to the metadata.

- **APIv4 explorer, search kit - entity reference fields tricky if you know the
  id ([dev/core#2400](https://lab.civicrm.org/dev/core/-/issues/2400):
  [19638](https://github.com/civicrm/civicrm-core/pull/19638))**

  Ensures when the user types an integer into an EntityRef field, the record
  with that ID is returned first.

- **Enable-"Do-no-trade"-filter
  ([19650](https://github.com/civicrm/civicrm-core/pull/19650))**

  Adds a Do not trade filter.

### CiviCase

- **Investigate replacing civicase views with something that is not views (Add
  test for [dev/core#2385](https://lab.civicrm.org/dev/core/-/issues/2385):
  [19609](https://github.com/civicrm/civicrm-core/pull/19609))**

  Adds test coverage for getCaseActivityQuery.

### CiviContribute

- **Delay on rendering contribution dashboard charts seems unnecessary
  ([dev/core#2365](https://lab.civicrm.org/dev/core/-/issues/2365):
  [19544](https://github.com/civicrm/civicrm-core/pull/19544))**

  Speeds up rendering of contribution dashboard charts.

### Joomla Integration

- **Use Joomla style language strings to allow translations
  ([56](https://github.com/civicrm/civicrm-joomla/pull/56))**

  Changes some hardcoded english strings to use the Joomla translation system
  so users can create translation overrides.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Ensure dispatcher has loaded listeners
  ([19614](https://github.com/civicrm/civicrm-core/pull/19614))**

  Fixes an edge case where the dispatcher can fail to load listeners

- **Correct sms numbers
  ([19509](https://github.com/civicrm/civicrm-core/pull/19509))**

  When sending SMS messages to contacts in search results, under some
  conditions a single contact's mobile phone number is repeated over and over
  again for remaining contacts.

- **Asset building breaks the site (Work towards
  [dev/core#2137](https://lab.civicrm.org/dev/core/-/issues/2137):
  [19559](https://github.com/civicrm/civicrm-core/pull/19559) and
  [18830](https://github.com/civicrm/civicrm-core/pull/18830))**

  Enhances log messages when AssetBuilder fails and put it inside a try/catch.

- **documentation on CIVICRM_CRED_KEYS (Work Towards
  [dev/core#2370](https://lab.civicrm.org/dev/core/-/issues/2370):
  [19568](https://github.com/civicrm/civicrm-core/pull/19568))**

  Slightly expands the amount of entropy for certain auto-generated values.

- **Prevent double clicking submit button
  ([dev/core#2372](https://lab.civicrm.org/dev/core/-/issues/2372):
  [19610](https://github.com/civicrm/civicrm-core/pull/19610))**

  Prevents double clicking of submit button on any standard form without ajax
  (ex: New Contribution Form).

- **Geocoding saves values that web UI doesn't accept (Work Towards
  [dev/core#2379](https://lab.civicrm.org/dev/core/-/issues/2379):
  [19588](https://github.com/civicrm/civicrm-core/pull/19588))**

  The CiviCRM UI doesn't allow saving more than 14 characters in a geocoding
  field. However, geocoders themselves aren't restricted to 14 characters. This
  means that geocoders can enter a geocode that prevents editing the address.

- **Afform permissions - open access didn't seem to work (search kit)
  ([dev/core#2404](https://lab.civicrm.org/dev/core/-/issues/2404):
  [19657](https://github.com/civicrm/civicrm-core/pull/19657))**

  Addresses some ambiguities/confusion in permission for Afform. The basic
  question -- if permission is omitted (in various ways -- unset, null,
  empty-string), then what is the effective permission?

- **Navigation menu order
  ([dev/core#2424](https://lab.civicrm.org/dev/core/-/issues/2424):
  [19671](https://github.com/civicrm/civicrm-core/pull/19671))**

  Ensures one can change the order of navigation items from an extension.

- **Create followup section at bottom of non-bulk email activities crashes
  ([dev/core#2473](https://lab.civicrm.org/dev/core/-/issues/2473):
  [19874](https://github.com/civicrm/civicrm-core/pull/19874))**

  Prevents a crash when the assignee is left blank when creating followup on
  email activity.

- **Afform - Show breadcrumbs appropriate to whether a form can be edited
  ([19739](https://github.com/civicrm/civicrm-core/pull/19739))**

  Removes the "Edit" link from non-editable forms, and adds the current
  form back into the breadcrumbs, for the sake of forms which use url params for
  routing.

- **APIv4 - Improve handling of joins & custom fields
  ([19562](https://github.com/civicrm/civicrm-core/pull/19562))**

  Fixes some apparent bugs in SearchKit where certain fields were apparently
  supported in the UI but the API would crash when trying to query them.

- **APIv4 - Increase alias max length to 256
  ([19537](https://github.com/civicrm/civicrm-core/pull/19537))**

  Fixes a bug in Search Kit where fields derived from long complex joins would
  disappear because their alias was longer than the default length of 63 output
  by CRM_Utils_String::munge().

- **GuzzleMiddleware::url() - Distinguish frontend and backend routes
  ([19678](https://github.com/civicrm/civicrm-core/pull/19678))**

  GuzzleMiddlware::url() is a helper that simplifies writing URLs within
  Guzzle-based tests. For example, $http->get('route://civicrm/dashboard') send
  a GET request to the local site's civicrm/dashboard page.

- **Cannot create proper `Group`s on multilingual with MySQL 5.6 and Civi
  5.31-rc
  ([dev/translation#58](https://lab.civicrm.org/dev/translation/-/issues/58):
  [19740](https://github.com/civicrm/civicrm-core/pull/19740))**

- **fieldOptions hook fatal error
  ([dev/core#1132](https://lab.civicrm.org/dev/core/-/issues/1132):
  [19580](https://github.com/civicrm/civicrm-core/pull/19580))**

- **CiviCRM Find and Merge Duplicate Contacts, does not validate the weight and
  weight threshold, possible to set a weight threshold which can never be
  achieved. ([dev/core#2309](https://lab.civicrm.org/dev/core/-/issues/2309):
  [19604](https://github.com/civicrm/civicrm-core/pull/19604))**

- **SearchKit : use of rows in query cause mysql errors
  ([dev/core#2360](https://lab.civicrm.org/dev/core/-/issues/2360):
  [19535](https://github.com/civicrm/civicrm-core/pull/19535))**

- **Searchkit bug - not displaying grouped by field
  ([dev/core#2388](https://lab.civicrm.org/dev/core/-/issues/2388):
  [19618](https://github.com/civicrm/civicrm-core/pull/19618))**

- **On mail accounts form, pressing save and test followed by save creates a
  duplicate account
  ([dev/core#2398](https://lab.civicrm.org/dev/core/-/issues/2398):
  [19636](https://github.com/civicrm/civicrm-core/pull/19636))**

- **5.36 upgrade should check if foreign keys exist before adding them
  ([dev/core#2452](https://lab.civicrm.org/dev/core/-/issues/2452):
  [19773](https://github.com/civicrm/civicrm-core/pull/19773))**

- **Afform (et al) - Fetch more complete list of permissions via APIv4
  ([19536](https://github.com/civicrm/civicrm-core/pull/19536))**

- **Afform: Only permit Date fields to be made into a select list if it is a
  search form ([19665](https://github.com/civicrm/civicrm-core/pull/19665))**

- **SearchKit - Don't save on enter key
  ([19643](https://github.com/civicrm/civicrm-core/pull/19643))**

- **SearchKit - Fix token menu positioning
  ([19780](https://github.com/civicrm/civicrm-core/pull/19780))**

- **SearchKit - Fix broken update dialog and add input type float
  ([19758](https://github.com/civicrm/civicrm-core/pull/19758))**

- **SearchKit - Fix removing all related fields from SELECT when removing a JOIN
  ([19747](https://github.com/civicrm/civicrm-core/pull/19747))**

- **SearchKit - Fix clearing selection behavior
  ([19686](https://github.com/civicrm/civicrm-core/pull/19686))**

- **APIv4 - Rename 'controlField' property to 'control_field'
  ([19699](https://github.com/civicrm/civicrm-core/pull/19699))**

- **APIv4 - Fix HTTP status code selection
  ([19533](https://github.com/civicrm/civicrm-core/pull/19533))**

- **APIv4 - AJAX errors should say *something* useful
  ([19526](https://github.com/civicrm/civicrm-core/pull/19526))**

- **avoid error when reserving respondents in a survey.
  ([19811](https://github.com/civicrm/civicrm-core/pull/19811))**

- **Search display fixes
  ([19683](https://github.com/civicrm/civicrm-core/pull/19683))**

- **Fix migrateUtf8mb4 for special database names
  ([19708](https://github.com/civicrm/civicrm-core/pull/19708))**

- **Angular - Remove deprecated js file
  ([19704](https://github.com/civicrm/civicrm-core/pull/19704))**

- **Fix for missing function CodeGen_Util::removeDir
  ([19688](https://github.com/civicrm/civicrm-core/pull/19688))**

- **Reduce wasted space in civicrm dashboard margins
  ([19682](https://github.com/civicrm/civicrm-core/pull/19682))**

- **Fix i18n issue with changeLog in data templates
  ([19651](https://github.com/civicrm/civicrm-core/pull/19651))**

- **Improve consistency of field titles, labels, types across the schema
  ([19531](https://github.com/civicrm/civicrm-core/pull/19531))**

- **Remove single use of extraParams in CRM_Utils_Token::getTokenDetails()
  ([19640](https://github.com/civicrm/civicrm-core/pull/19640))**

- **Fix incorrect use of ts when setting custom data form title
  ([19625](https://github.com/civicrm/civicrm-core/pull/19625))**

- **Remove check for safe_mode/open_basedir on extension downloader because it
  triggers false positives
  ([19582](https://github.com/civicrm/civicrm-core/pull/19582))**

- **Delete repeated title and fix some labels
  ([19565](https://github.com/civicrm/civicrm-core/pull/19565))**

- **Fix angular error when user is not logged in.
  ([19575](https://github.com/civicrm/civicrm-core/pull/19575))**

- **Fix 'Unsupported html-element' error on forms using EntityFormTrait
  ([19560](https://github.com/civicrm/civicrm-core/pull/19560))**

- **php 7.4 deprecated squiggly brackets - html/quickform date
  ([316](https://github.com/civicrm/civicrm-packages/pull/316))**

- **php 7.4 - E_NOTICE on membership dashboard
  ([19545](https://github.com/civicrm/civicrm-core/pull/19545))**

- **php 7.4 E_NOTICE in Contact/BAO/Query
  ([19552](https://github.com/civicrm/civicrm-core/pull/19552))**

### CiviCase

- **Users with 'view own cases' permission can't open resolved cases
  ([dev/core#1400](https://lab.civicrm.org/dev/core/-/issues/1400):
  [19674](https://github.com/civicrm/civicrm-core/pull/19674),
  [19666](https://github.com/civicrm/civicrm-core/pull/19666) and
  [19675](https://github.com/civicrm/civicrm-core/pull/19675))**

- **"My Cases" dashlet gives datatables error
  ([dev/core#1207](https://lab.civicrm.org/dev/core/-/issues/1207):
  [19689](https://github.com/civicrm/civicrm-core/pull/19689))**

### CiviContribute

- **Account IIF Export Amount Format improper
  ([dev/financial#166](https://lab.civicrm.org/dev/financial/-/issues/166):
  [19634](https://github.com/civicrm/civicrm-core/pull/19634))**

  Ensures money fields are formatted properly (no $ sign) when exporting.

- **Remove legacy php money_format use, switch to brickmoney
  ([dev/translation#65](https://lab.civicrm.org/dev/translation/-/issues/65):
  [19605](https://github.com/civicrm/civicrm-core/pull/19605))**

- **Recurring contributions: ThankYou page does not translate the contribution
  unit
  ([dev/translation#32](https://lab.civicrm.org/dev/translation/-/issues/32):
  [19655](https://github.com/civicrm/civicrm-core/pull/19655))**

- **Deprecated force url for contribution dashboard links
  ([dev/core#2392](https://lab.civicrm.org/dev/core/-/issues/2392):
  [19621](https://github.com/civicrm/civicrm-core/pull/19621))**

- **Use specific function when formatting money for a default
  ([19602](https://github.com/civicrm/civicrm-core/pull/19602))**

- **Use specific function when formatting money for a default ([19652]
  (https://github.com/civicrm/civicrm-core/pull/19652))**

### CiviEvent

- **deprecated function error
  ([dev/event#50](https://lab.civicrm.org/dev/event/-/issues/50):
  [19637](https://github.com/civicrm/civicrm-core/pull/19637))**

  Fixes a Deprecated function error: "Non-static method
  CRM_Event_ICalendar::run() should not be called statically in
  CRM_Core_Invoke::runItem()" when clicking on the ical button on the Manage
  Events form.

- **Obsolete wkhtmltopdfPath causes hard fail in event registration due to
  internal fatal error for the missing package
  (Revert: [dev/core#2028](https://lab.civicrm.org/dev/core/-/issues/2028):
  [19942](https://github.com/civicrm/civicrm-core/pull/19942))**

  Reverts the fix for this issue because it caused a regression.

- **Partial payments fail on events in a modal dialog box
  ([dev/event#48](https://lab.civicrm.org/dev/event/-/issues/48):
  [19572](https://github.com/civicrm/civicrm-core/pull/19572))**

### CiviMember

- **Sales tax and Vat issue within memberships - membership fee increases
  incorrectly when the membership has an error
  ([dev/core#778](https://lab.civicrm.org/dev/core/-/issues/778):
  [19648](https://github.com/civicrm/civicrm-core/pull/19648))**

  Fixes a bug where when sales tax is enabled and is used for a membership form
  sales tax was added every time the form validation failed.

- **Fix display of membership dates on receipts when lineitems do not have a
  price_set_id ([19508](https://github.com/civicrm/civicrm-core/pull/19508))**

- **Fix membership form to correctly calculate tax when a discount is applied
  ([19476](https://github.com/civicrm/civicrm-core/pull/19476))**

### Drupal Integration

- **system_get_info() is deprecated in drupal 9
  ([dev/drupal#156](https://lab.civicrm.org/dev/drupal/-/issues/156):
  [19583](https://github.com/civicrm/civicrm-core/pull/19583))**

  Fixes fatal errors when viewing any CiviReport on a Drupal 9 integration.

- **'Recent Items' fails to show list of Recent Items
  ([dev/core#2387](https://lab.civicrm.org/dev/core/-/issues/2387):
  [62](https://github.com/civicrm/civicrm-drupal-8/pull/62))**

  Ensures that the "Recent Items" block shows the list of recent items.

- **drush install - Bump up entropy for autogenerated creds. Add signing key.
  #640  ([58](https://github.com/civicrm/civicrm-drupal-8/pull/58))**

### Joomla Integration

- **Joomla::synchronizeUsers - Fix notice due to old style reference
  ([19677](https://github.com/civicrm/civicrm-core/pull/19677))**

- **Joomla - Implement getUfId(). Fix `@user:<name>`.
  ([19615](https://github.com/civicrm/civicrm-core/pull/19615))**

### WordPress Integration

- **WordPress - If we hit a "permission denied" error, return HTTP 403
  ([19608](https://github.com/civicrm/civicrm-core/pull/19608))**

  Ensures if the user hits a permission denied error http 403 is returned
  instead of 200.

## <a name="misc"></a>Miscellany

- **Add contactlayouteditor to gitignore
  ([19611](https://github.com/civicrm/civicrm-core/pull/19611))**

- **Convert Smarty & domain token processing to use token processor
  ([19598](https://github.com/civicrm/civicrm-core/pull/19598))**

- **HttpTestTrait - Define helper methods for E2E tests of Civi's HTTP routes
  ([19600](https://github.com/civicrm/civicrm-core/pull/19600))**

- **Mark Old Cividiscount hook support deprecated
  ([19649](https://github.com/civicrm/civicrm-core/pull/19649))**

- **Cleanup - Remove old unused schema/xml files.
  ([19570](https://github.com/civicrm/civicrm-core/pull/19570))**

- **Afform - move contentEditable directive into crmUI library for reusability
  ([19672](https://github.com/civicrm/civicrm-core/pull/19672))**

- **Remove unreachable code & variable cleanup in membership back office form
  template ([19647](https://github.com/civicrm/civicrm-core/pull/19647))**

- **Remove unused code
  ([19567](https://github.com/civicrm/civicrm-core/pull/19567))**

- **Remove empty {ts}
  ([19622](https://github.com/civicrm/civicrm-core/pull/19622))**

- **Remove always-true-if
  ([19566](https://github.com/civicrm/civicrm-core/pull/19566))**

- **REF Regenerate DAOs and I18n Schema Structure following merge of #19565
  ([19581](https://github.com/civicrm/civicrm-core/pull/19581))**

- **[REF] do not needlessly pass as reference, enforce valid param
  ([19478](https://github.com/civicrm/civicrm-core/pull/19478))**

- **[REF] Simplfy parameter
  ([19654](https://github.com/civicrm/civicrm-core/pull/19654))**

- **[REF] Use form property rather than formValues to pass generated invoice ID
  on membership forms
  ([19549](https://github.com/civicrm/civicrm-core/pull/19549))**

- **[REF] simplify parameter, use preferred strict
  ([19597](https://github.com/civicrm/civicrm-core/pull/19597))**

- **[REF] Stop passing contribution into completeOrder, id is enough
  ([19571](https://github.com/civicrm/civicrm-core/pull/19571))**

- **[REF] replace deprecated calls with buildOptions
  ([19578](https://github.com/civicrm/civicrm-core/pull/19578))**

- **[REF] Fully remove contribution object from repeattransaction function
  ([19547](https://github.com/civicrm/civicrm-core/pull/19547))**

- **[REF] Remove unused pcp & soft credit handling from previously shared code
  ([19525](https://github.com/civicrm/civicrm-core/pull/19525))**

- **[REF] Rename variable to clarify it's usage
  ([19556](https://github.com/civicrm/civicrm-core/pull/19556))**

- **[REF] Load participant id within completeOrder rather than passing it in
  ([19641](https://github.com/civicrm/civicrm-core/pull/19641))**

- **[REF] Move code that relates to receipts when paying by credit card out of
  the shared function
  ([19658](https://github.com/civicrm/civicrm-core/pull/19658))**

- **[REF] Complete order Unset contribution once we have finished with it.
  ([19527](https://github.com/civicrm/civicrm-core/pull/19527))**

- **[REF] Further extract the portion of sendTemplate that relates to rendering
  ([19522](https://github.com/civicrm/civicrm-core/pull/19522))**

- **(REF) APIv4 - Add hook for whitelisting select AJAX API's for anonymous
  invocation ([19494](https://github.com/civicrm/civicrm-core/pull/19494))**

- **[REF] [Repeattransaction] Stop setting contribution->id
  ([19538](https://github.com/civicrm/civicrm-core/pull/19538))**

- **[REF] [Repeattransaction] use financial_type_id from getTemplateContribution
  (which already has handling)
  ([19539](https://github.com/civicrm/civicrm-core/pull/19539))**

- **[REF] [Repeattransaction] Remove loading contribution page id from passed in
  object ([19540](https://github.com/civicrm/civicrm-core/pull/19540))**

- **[REF] Fix array access on NULL error when running afform unit tests o…
  ([19542](https://github.com/civicrm/civicrm-core/pull/19542))**

- **[REF] clean up if
  ([19693](https://github.com/civicrm/civicrm-core/pull/19693))**

- **[REF] Simplify is_email_receipt handling
  ([19524](https://github.com/civicrm/civicrm-core/pull/19524))**

- **Add unit test cover for the MessageTemplate::renderMessageTemplate function
  ([19551](https://github.com/civicrm/civicrm-core/pull/19551))**

- **[NFC/Unit Test] Fix passing test that should pass but also should fail
  ([19607](https://github.com/civicrm/civicrm-core/pull/19607))**

- **[NFC] Code cleanup - use use statements, hints
  ([19595](https://github.com/civicrm/civicrm-core/pull/19595))**

- **[NFC] Add in unit test to prove that domain tokens are able to be inc…
  ([19702](https://github.com/civicrm/civicrm-core/pull/19702))**

- **NFC Update comments in token classes
  ([19715](https://github.com/civicrm/civicrm-core/pull/19715))**

- **[NFC] minor cleanup in testCaseCreateWithResolvedStatus
  ([19664](https://github.com/civicrm/civicrm-core/pull/19664))**

- **Minor cleanup - ChangeCaseStatus
  ([19663](https://github.com/civicrm/civicrm-core/pull/19663))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Blackfly Solutions - Alan Dixon;
CiviCoop - Jaap Jansma, Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten;
CompuCorp - Ahed Eid; Coop SymbioTIC - Mathieu Lutfy; Dave D; elinw; iXiam -
Luciano Spiegel; J0WI; JMA Consulting - Monish Deb, Seamus Lee; lunar-debian;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Progressive Technology Project - Jamie McClelland; Skvare - Sunil Pawar; Tadpole
Collective - Kevin Cristiano; tapashdatta; Timbsoft Technologies - Tunbola
Ogunwande; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; Agileware - Justin
Freeman; Artful Robot - Rich Lott; Christian Wach; CiviDesk - Yashodha Chaku;
Dave T; Fuzion - Peter Davis; JMA Consulting - Joe Murray; MJCO - Mikey O'Toole;
Nicol Wistreich; Semper IT - Karin Gerritsen;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
