#include <dfilechooseredit.h>
#include "savepathfilechooser.h"
#include "messagebox.h"
#include <QDebug>
#include <QRadioButton>
#include <QButtonGroup>
#include <QVBoxLayout>
#include <QPainter>


SavePathFileChooser::SavePathFileChooser()
{

}
SavePathFileChooser::SavePathFileChooser(int iCurrentSelect,QString file_path)
{
    auto_last_path = new QRadioButton(tr("Automatically change to last used directory"));
    custom_last_path = new QRadioButton(tr("Set default destination directory"));
    custom_file_chooser  = new DFileChooserEdit();
    custom_file_chooser->lineEdit()->setReadOnly(true);
    custom_file_chooser->lineEdit()->setClearButtonEnabled(false);
    custom_file_chooser->setFileMode(QFileDialog::FileMode::DirectoryOnly);
    if(iCurrentSelect == 1)
    {
        auto_last_path->setChecked(true);
        this->custom_file_chooser->setDisabled(true);
    }
    else
    {
        custom_last_path->setChecked(true);
    }
    custom_file_chooser->setText(file_path);
    QVBoxLayout * vboxlayout = new QVBoxLayout(this);
    vboxlayout->addWidget(auto_last_path);
    vboxlayout->addWidget(custom_last_path);
    vboxlayout->setContentsMargins(0,0,0,0);


    QHBoxLayout * hfilechooserLayout = new QHBoxLayout();

    hfilechooserLayout->setContentsMargins(28,0,0,0);
    hfilechooserLayout->addWidget(custom_file_chooser);


    vboxlayout->addLayout(hfilechooserLayout);
    this->setLayout(vboxlayout);

    connect(auto_last_path,&QRadioButton::clicked,this,&SavePathFileChooser::on_auto_changed);
    connect(custom_last_path,&QRadioButton::clicked,this,&SavePathFileChooser::on_custom_changed);
    connect(custom_file_chooser,&DFileChooserEdit::textChanged,this,&SavePathFileChooser::on_filechooser_changed);


}
void SavePathFileChooser::on_auto_changed(int index)
{
    if(index ==1)
    {
        this->custom_file_chooser->setDisabled(true);
    }
    QString current_set_info = "auto;" + custom_file_chooser->text();
    emit textChanged(current_set_info);
}

void SavePathFileChooser::on_custom_changed(int index)
{
    if(index ==1)
    {
        this->custom_file_chooser->setDisabled(false);
    }
     QString current_set_info = "custom;" + custom_file_chooser->text();
     emit textChanged(current_set_info);
}

void SavePathFileChooser::on_filechooser_changed(const QString file_path)
{
    QFileInfo fileinfo;
    fileinfo.setFile(file_path);
    if(!fileinfo.isWritable())
    {
        MessageBox *msg=new MessageBox(Warnings);
        msg->set_warning_MsgBox(tr("select directory not writeable"),tr("sure"));
        QString download_path = QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + QString("/Downloads");
        custom_file_chooser->setText(download_path);
        msg->exec();
    }
    else {
        QString current_set_info = "custom;" + custom_file_chooser->text();
        emit textChanged(current_set_info);
    }

}
//设置选择下载文件路径
void SavePathFileChooser::setSelectPath(QString file_path)
{
    if(!file_path.isEmpty())
    {
        QFileInfo fileinfo;
        fileinfo.setFile(file_path);
        if(fileinfo.isWritable())
        {
            custom_file_chooser->setText(file_path);
        }

    }
}

void SavePathFileChooser::setSelectRadio(QString selectName)
{
    if(selectName == "auto")
    {
        auto_last_path->setChecked(true);
        this->custom_file_chooser->setDisabled(true);
    }
    else {
         custom_last_path->setChecked(true);
         this->custom_file_chooser->setDisabled(false);
    }
}
