/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H
#include "global.h"
#include "btinfodialog.h"
#include <DDialog>
#include <DLabel>
#include <DTitlebar>
#include <DPushButton>
#include <DCheckBox>
#include <DIconButton>
#include <DTextEdit>
#include <DFileDialog>
#include <DLineEdit>
#include <DSuggestButton>
#include <QStandardPaths>
#include <QDragEnterEvent>
#include <QHBoxLayout>



DWIDGET_USE_NAMESPACE
using namespace Global;

class MessageBox:public DDialog
{
    Q_OBJECT

public:
    explicit MessageBox(int Msg_box);
    void addLabel(QString lableText);
    void addCheckbox(QString checkboxText);
    void addTextBrowser(QString placehold,QString filename="");
    void addLineEdit(QString oldname,int x, int y, int w,int h);
    void set_delete_Task_MsgBox(bool permanently);
    void set_clear_Task_MsgBox();
    void set_new_download_MsgBox(QString save_path,QString url="");
    void set_warning_MsgBox(QString warningMsg,QString surebtntext,QString cancalbtntext="",int sameurl_count=0,QList<QString> same_url_list={});
    void set_rename_MsgBox(QString title,QString surebtntext,QString cancelbtn,QString oldname);
private:
    void initUI();
    DLabel *iconLable;
    DTitlebar *m_titlebar;
    QWidget *main_widget;
    DTextEdit *textBrowser;
    DCheckBox *checkbox;
    DLineEdit *newName_lineedit;
    int Msg_type_flag;
    bool delete_flag;
    DFileChooserEdit *filechooserEdit;
    QPushButton *rename_sure_button;
    QString default_download_path;
    QString last_save_path;
private slots:
    void onCancelBtnClicked();
    void onSureBtnClicked();
    void openfileDialog();
    void get_buttonClicked(int index,const QString & text);
    void get_renameLineEdit_changed(const QString &);
    void get_filechoosed_signal(const QString &);
signals:
    void NewDownload_sig(QString url,QString save_path);
    void ReDownload_sig();
    void ReName_sig(QString newname);
    void DeleteDownload_sig(bool,bool);
    void ClearRecycle_sig(bool);
    void DownloadTorrent_sig(QString filename,QMap<QString, QVariant> opt,QString infoName,QString infoHash);
    void RepeatDownload_sig();
protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);
};

#endif // MESSAGEBOX_H
