// SPDX-FileCopyrightText: 2020 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: LGPL-3.0-or-later

#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQuickStyle>
#include <QQuickWindow>

int main(int argc, char *argv[])
{
    QCoreApplication::setAttribute(Qt::AA_UseHighDpiPixmaps);

    QGuiApplication app(argc, argv);
    app.setOrganizationName("deepin");
    app.setApplicationName("Example");

    QQuickStyle::setStyle(CHAMELEON_PATH"/Chameleon");
    QQmlApplicationEngine engine;
//    qputenv("D_POPUP_MODE", "embed");

//    QQuickWindow::setSceneGraphBackend(QSGRendererInterface::Software);
    engine.addImportPath(CHAMELEON_PATH);
    engine.load(QUrl(QStringLiteral("qrc:/main.qml")));
    if (engine.rootObjects().isEmpty())
        return -1;

    return app.exec();
}
