# Tencent is pleased to support the open source community by making ncnn available.
#
# Copyright (C) 2022 THL A29 Limited, a Tencent company. All rights reserved.
#
# Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
# in compliance with the License. You may obtain a copy of the License at
#
# https://opensource.org/licenses/BSD-3-Clause
#
# Unless required by applicable law or agreed to in writing, software distributed
# under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
# CONDITIONS OF ANY KIND, either express or implied. See the License for the
# specific language governing permissions and limitations under the License.

import torch
import torch.nn as nn
import torch.nn.functional as F
import torchvision

class Model(nn.Module):
    def __init__(self):
        super(Model, self).__init__()

        self.roi_align = torchvision.ops.RoIAlign(output_size=(3,3), spatial_scale=0.25, sampling_ratio=3, aligned=False)
        self.rois = nn.Parameter(torch.tensor([[0, 0, 10, 12, 20]], dtype=torch.float))

    def forward(self, x):
        x = self.roi_align(x, self.rois)
        return x

def test():
    net = Model()
    net.eval()

    torch.manual_seed(0)
    x = torch.rand(1, 12, 64, 64)

    a = net(x)

    # export torchscript
    mod = torch.jit.trace(net, x)
    mod.save("test_torchvision_RoIAlign.pt")

    # torchscript to pnnx
    import os
    os.system("../src/pnnx test_torchvision_RoIAlign.pt inputshape=[1,12,64,64]")

    # pnnx inference
    import test_torchvision_RoIAlign_pnnx
    b = test_torchvision_RoIAlign_pnnx.test_inference()

    return torch.equal(a, b)

if __name__ == "__main__":
    if test():
        exit(0)
    else:
        exit(1)
