# 项目简介
* 本项目创立是为了减少程序之间调用相同资源造成的内存浪费，所以使用共享内存的方式来提供资源的加载，目前主要是使用在锁屏壁纸和工作区的壁纸上，通过注册在SessionBus上提供接口，传递由QSharedMemroy 提供的KEY值来供其他程序调取资源

# 使用说明
* 本程序启动后会在sessionBus中启动服务 com.deepin.dde.preload
* 接口: QString requestSource(int uid, int purpose)  uid 使用默认的 Linux getuid()取得当前用户ID传入即可  purpose 参数  1 代表登陆锁屏背景  2 代表启动器全屏背景  3以后提供给工作区背景图片，其中 1 2获得的背景默认做虚化处理
* 信号1: 为通知调用应用程序共享变量已创建，提供了一个 void createSuccessful(int uid, int purpose, const QString &key); 信号  uid为调用者的UID purpose 同上， key代表共享变量的KEY
* 信号2: 当用户重新调用 requestSource 函数时，默认当用户放弃当前的共享内存，在服务端上会使用 detach 释放掉，重新生成共享内存，并发送 void releaseSuccessful(int uid, int purpose, const QString &key) 信号通知用户