/* db-reader.c generated by valac 0.38.8, the Vala compiler
 * generated from db-reader.vala, do not modify */

/* db-reader.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;
typedef struct _ZeitgeistDbReaderPrivate ZeitgeistDbReaderPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
enum  {
	ZEITGEIST_DB_READER_0_PROPERTY,
	ZEITGEIST_DB_READER_DATABASE_PROPERTY,
	ZEITGEIST_DB_READER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())

#define ZEITGEIST_DB_READER_TYPE_RELATED_URI (zeitgeist_db_reader_related_uri_get_type ())
typedef struct _ZeitgeistDbReaderRelatedUri ZeitgeistDbReaderRelatedUri;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _zeitgeist_db_reader_related_uri_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL)))
#define __g_list_free__zeitgeist_db_reader_related_uri_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__zeitgeist_db_reader_related_uri_free0_ (var), NULL)))
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;

struct _ZeitgeistDbReader {
	GObject parent_instance;
	ZeitgeistDbReaderPrivate * priv;
	sqlite3* db;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistDbReaderClass {
	GObjectClass parent_class;
	void (*close) (ZeitgeistDbReader* self);
};

struct _ZeitgeistDbReaderPrivate {
	ZeitgeistSQLiteDatabase* _database;
};

typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI
} ZeitgeistSQLiteEventViewRows;

typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

struct _ZeitgeistDbReaderRelatedUri {
	guint32 id;
	gint64 timestamp;
	gchar* uri;
	gint32 counter;
};

typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};


static gpointer zeitgeist_db_reader_parent_class = NULL;

GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DB_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderPrivate))
ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error);
ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type, GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error);
ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, guint32 event_id, GError** error);
GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id, GError** error);
ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, GError** error);
GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
static void _g_object_unref0_ (gpointer var);
ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self, ZeitgeistWhereClause* where, guint max_events, guint result_type, int* result_length1, GError** error);
gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
static gchar* zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self, const gchar* field, ZeitgeistWhereClause* where, gboolean* count_asc, const gchar* aggregation_type);
gboolean zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self);
GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
static void _vala_array_add1 (guint32* * array, int* length, int* size, guint32 value);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, GError** error);
GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error);
GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST;
ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate);
ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate);
void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument);
void zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self, gboolean simple);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self, GPtrArray* templates, GError** error);
void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause);
gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error);
static GType zeitgeist_db_reader_related_uri_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ZeitgeistDbReaderRelatedUri* zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self, ZeitgeistDbReaderRelatedUri* dest);
static void zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self);
static void _zeitgeist_db_reader_related_uri_free0_ (gpointer var);
static void _g_free0_ (gpointer var);
static gboolean _vala_uint32_array_contains (guint32 * stack, int stack_length, guint32 needle);
static gint ___lambda8_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda8__gcompare_func (gconstpointer a, gconstpointer b);
static gint ___lambda9_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda9__gcompare_func (gconstpointer a, gconstpointer b);
static gint ____lambda10_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b);
static gint _____lambda10__gcompare_func (gconstpointer a, gconstpointer b);
static inline void _g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self);
void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
static void zeitgeist_db_reader_real_close (ZeitgeistDbReader* self);
void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
gboolean zeitgeist_where_clause_has_non_timestamp_condition (ZeitgeistWhereClause* self);
static ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self, ZeitgeistEvent* template, GError** error);
void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error);
void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation);
void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation);
gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self, const gchar* name);
void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
static void zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self, const gchar* table, gint64 rowid);
void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id);
static void zeitgeist_db_reader_set_database (ZeitgeistDbReader* self, ZeitgeistSQLiteDatabase* value);
static GObject * zeitgeist_db_reader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
void zeitgeist_sq_lite_database_set_cache_size (ZeitgeistSQLiteDatabase* self, gint size);
static void zeitgeist_db_reader_finalize (GObject * obj);
static void _vala_zeitgeist_db_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_db_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type, GError** error) {
	ZeitgeistDbReader * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new_read_only (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self = (ZeitgeistDbReader*) g_object_new (object_type, "database", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}


ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error) {
	return zeitgeist_db_reader_construct (ZEITGEIST_TYPE_DB_READER, error);
}


ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, guint32 event_id, GError** error) {
	ZeitgeistEvent* result = NULL;
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint64 _tmp5_;
	const gchar* _tmp6_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	const gchar* _tmp12_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	const gchar* _tmp18_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_;
	const gchar* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	ZeitgeistEvent* _tmp24_;
	sqlite3_stmt* _tmp25_;
	const gchar* _tmp26_;
	guint8* data = NULL;
	sqlite3_stmt* _tmp27_;
	void* _tmp28_;
	gint data_length1;
	gint _data_size_;
	sqlite3_stmt* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = event_id;
	zeitgeist_event_set_id (_tmp1_, _tmp2_);
	_tmp3_ = event;
	_tmp4_ = stmt;
	_tmp5_ = sqlite3_column_int64 (_tmp4_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP);
	zeitgeist_event_set_timestamp (_tmp3_, _tmp5_);
	_tmp7_ = self->interpretations_table;
	_tmp8_ = stmt;
	_tmp9_ = sqlite3_column_int (_tmp8_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION);
	_tmp10_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp7_, _tmp9_, &_inner_error_);
	_tmp6_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = event;
	zeitgeist_event_set_interpretation (_tmp11_, _tmp6_);
	_tmp13_ = self->manifestations_table;
	_tmp14_ = stmt;
	_tmp15_ = sqlite3_column_int (_tmp14_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION);
	_tmp16_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp13_, _tmp15_, &_inner_error_);
	_tmp12_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = event;
	zeitgeist_event_set_manifestation (_tmp17_, _tmp12_);
	_tmp19_ = self->actors_table;
	_tmp20_ = stmt;
	_tmp21_ = sqlite3_column_int (_tmp20_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR);
	_tmp22_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp19_, _tmp21_, &_inner_error_);
	_tmp18_ = _tmp22_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = event;
	zeitgeist_event_set_actor (_tmp23_, _tmp18_);
	_tmp24_ = event;
	_tmp25_ = stmt;
	_tmp26_ = sqlite3_column_text (_tmp25_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI);
	zeitgeist_event_set_origin (_tmp24_, _tmp26_);
	_tmp27_ = stmt;
	_tmp28_ = sqlite3_column_blob (_tmp27_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data = (guint8*) _tmp28_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp29_ = stmt;
	_tmp30_ = sqlite3_column_bytes (_tmp29_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data_length1 = _tmp30_;
	_tmp31_ = data_length1;
	_tmp32_ = data;
	_tmp32__length1 = data_length1;
	if (_tmp32_ != NULL) {
		ZeitgeistEvent* _tmp33_;
		GByteArray* _tmp34_;
		GByteArray* _tmp35_;
		ZeitgeistEvent* _tmp36_;
		GByteArray* _tmp37_;
		GByteArray* _tmp38_;
		guint8* _tmp39_;
		gint _tmp39__length1;
		_tmp33_ = event;
		_tmp34_ = g_byte_array_new ();
		_tmp35_ = _tmp34_;
		zeitgeist_event_set_payload (_tmp33_, _tmp35_);
		_g_byte_array_unref0 (_tmp35_);
		_tmp36_ = event;
		_tmp37_ = zeitgeist_event_get_payload (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = data;
		_tmp39__length1 = data_length1;
		g_byte_array_append (_tmp38_, _tmp39_, _tmp39__length1);
	}
	result = event;
	return result;
}


ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, GError** error) {
	ZeitgeistSubject* result = NULL;
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_;
	ZeitgeistSubject* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	sqlite3_stmt* _tmp8_;
	const gchar* _tmp9_;
	ZeitgeistSubject* _tmp10_;
	sqlite3_stmt* _tmp11_;
	const gchar* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	ZeitgeistSubject* _tmp16_;
	sqlite3_stmt* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp20_;
	sqlite3_stmt* _tmp21_;
	gint _tmp22_;
	const gchar* _tmp23_;
	ZeitgeistSubject* _tmp24_;
	const gchar* _tmp25_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp26_;
	sqlite3_stmt* _tmp27_;
	gint _tmp28_;
	const gchar* _tmp29_;
	ZeitgeistSubject* _tmp30_;
	const gchar* _tmp31_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp32_;
	sqlite3_stmt* _tmp33_;
	gint _tmp34_;
	const gchar* _tmp35_;
	ZeitgeistSubject* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_subject_new ();
	subject = _tmp0_;
	_tmp1_ = subject;
	_tmp2_ = stmt;
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI);
	zeitgeist_subject_set_uri (_tmp1_, _tmp3_);
	_tmp4_ = subject;
	_tmp5_ = stmt;
	_tmp6_ = sqlite3_column_text (_tmp5_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT);
	zeitgeist_subject_set_text (_tmp4_, _tmp6_);
	_tmp7_ = subject;
	_tmp8_ = stmt;
	_tmp9_ = sqlite3_column_text (_tmp8_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE);
	zeitgeist_subject_set_storage (_tmp7_, _tmp9_);
	_tmp10_ = subject;
	_tmp11_ = stmt;
	_tmp12_ = sqlite3_column_text (_tmp11_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI);
	zeitgeist_subject_set_origin (_tmp10_, _tmp12_);
	_tmp13_ = subject;
	_tmp14_ = stmt;
	_tmp15_ = sqlite3_column_text (_tmp14_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI);
	zeitgeist_subject_set_current_uri (_tmp13_, _tmp15_);
	_tmp16_ = subject;
	_tmp17_ = stmt;
	_tmp18_ = sqlite3_column_text (_tmp17_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI);
	zeitgeist_subject_set_current_origin (_tmp16_, _tmp18_);
	_tmp20_ = self->interpretations_table;
	_tmp21_ = stmt;
	_tmp22_ = sqlite3_column_int (_tmp21_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION);
	_tmp23_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp20_, _tmp22_, &_inner_error_);
	_tmp19_ = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp24_ = subject;
	zeitgeist_subject_set_interpretation (_tmp24_, _tmp19_);
	_tmp26_ = self->manifestations_table;
	_tmp27_ = stmt;
	_tmp28_ = sqlite3_column_int (_tmp27_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION);
	_tmp29_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp26_, _tmp28_, &_inner_error_);
	_tmp25_ = _tmp29_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp30_ = subject;
	zeitgeist_subject_set_manifestation (_tmp30_, _tmp25_);
	_tmp32_ = self->mimetypes_table;
	_tmp33_ = stmt;
	_tmp34_ = sqlite3_column_int (_tmp33_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE);
	_tmp35_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp32_, _tmp34_, &_inner_error_);
	_tmp31_ = _tmp35_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = subject;
	zeitgeist_subject_set_mimetype (_tmp36_, _tmp31_);
	result = subject;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	_tmp1_ = index;
	g_ptr_array_remove_index_fast (self, _tmp1_);
}


GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	gchar* sql_event_ids = NULL;
	ZeitgeistSQLiteDatabase* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* sql = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_;
	ZeitgeistSQLiteDatabase* _tmp11_;
	gint _tmp12_;
	GHashTable* events = NULL;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	ZeitgeistSQLiteDatabase* _tmp39_;
	gint _tmp40_;
	GPtrArray* results = NULL;
	GPtrArray* _tmp41_;
	GPtrArray* _tmp42_;
	guint32* _tmp43_;
	gint _tmp43__length1;
	gint i = 0;
	guint32* _tmp44_;
	gint _tmp44__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	if (_tmp0__length1 == 0) {
		GPtrArray* _tmp1_;
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_database;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp2_, _tmp3_, _tmp3__length1);
	sql_event_ids = _tmp4_;
	_tmp5_ = sql_event_ids;
	_tmp6_ = g_strdup_printf ("\n" \
"            SELECT * FROM event_view\n" \
"            WHERE id IN (%s)\n" \
"            ", _tmp5_);
	sql = _tmp6_;
	_tmp7_ = self->db;
	_tmp8_ = sql;
	_tmp10_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	rc = _tmp10_;
	_tmp11_ = self->priv->_database;
	_tmp12_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp11_, _tmp12_, "db-reader.vala:142: SQL error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = g_direct_hash;
	_tmp14_ = g_direct_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, _g_object_unref0_);
	events = _tmp15_;
	while (TRUE) {
		sqlite3_stmt* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		guint32 event_id = 0U;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_;
		ZeitgeistEvent* event = NULL;
		GHashTable* _tmp21_;
		guint32 _tmp22_;
		gconstpointer _tmp23_;
		ZeitgeistEvent* _tmp24_;
		ZeitgeistEvent* _tmp25_;
		ZeitgeistSubject* subject = NULL;
		sqlite3_stmt* _tmp35_;
		ZeitgeistSubject* _tmp36_;
		ZeitgeistEvent* _tmp37_;
		ZeitgeistSubject* _tmp38_;
		_tmp16_ = stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (!(_tmp18_ == SQLITE_ROW)) {
			break;
		}
		_tmp19_ = stmt;
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		event_id = (guint32) _tmp20_;
		_tmp21_ = events;
		_tmp22_ = event_id;
		_tmp23_ = g_hash_table_lookup (_tmp21_, (gpointer) ((guintptr) _tmp22_));
		_tmp24_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp23_);
		event = _tmp24_;
		_tmp25_ = event;
		if (_tmp25_ == NULL) {
			ZeitgeistEvent* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_;
			guint32 _tmp28_;
			ZeitgeistEvent* _tmp29_;
			ZeitgeistEvent* _tmp30_;
			GHashTable* _tmp31_;
			guint32 _tmp32_;
			ZeitgeistEvent* _tmp33_;
			ZeitgeistEvent* _tmp34_;
			_tmp27_ = stmt;
			_tmp28_ = event_id;
			_tmp29_ = zeitgeist_db_reader_get_event_from_row (self, _tmp27_, _tmp28_, &_inner_error_);
			_tmp26_ = _tmp29_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					return NULL;
				} else {
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp30_ = _tmp26_;
			_tmp26_ = NULL;
			_g_object_unref0 (event);
			event = _tmp30_;
			_tmp31_ = events;
			_tmp32_ = event_id;
			_tmp33_ = event;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			g_hash_table_insert (_tmp31_, (gpointer) ((guintptr) _tmp32_), _tmp34_);
			_g_object_unref0 (_tmp26_);
		}
		_tmp35_ = stmt;
		_tmp36_ = zeitgeist_db_reader_get_subject_from_row (self, _tmp35_, &_inner_error_);
		subject = _tmp36_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				return NULL;
			} else {
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp37_ = event;
		_tmp38_ = subject;
		zeitgeist_event_add_subject (_tmp37_, _tmp38_);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
	}
	_tmp39_ = self->priv->_database;
	_tmp40_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp39_, _tmp40_, "Error", SQLITE_DONE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp41_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	results = _tmp41_;
	_tmp42_ = results;
	_tmp43_ = event_ids;
	_tmp43__length1 = event_ids_length1;
	g_ptr_array_set_length (_tmp42_, _tmp43__length1);
	i = 0;
	_tmp44_ = event_ids;
	_tmp44__length1 = event_ids_length1;
	{
		guint32* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp44_;
		id_collection_length1 = _tmp44__length1;
		for (id_it = 0; id_it < _tmp44__length1; id_it = id_it + 1) {
			guint32 id = 0U;
			id = id_collection[id_it];
			{
				GPtrArray* _tmp45_;
				gint _tmp46_;
				GHashTable* _tmp47_;
				guint32 _tmp48_;
				gconstpointer _tmp49_;
				ZeitgeistEvent* _tmp50_;
				_tmp45_ = results;
				_tmp46_ = i;
				i = _tmp46_ + 1;
				_tmp47_ = events;
				_tmp48_ = id;
				_tmp49_ = g_hash_table_lookup (_tmp47_, (gpointer) ((guintptr) _tmp48_));
				_tmp50_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp49_);
				g_ptr_array_set (_tmp45_, (guint) _tmp46_, _tmp50_);
			}
		}
	}
	result = results;
	_g_hash_table_unref0 (events);
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	_g_free0 (sql_event_ids);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (guint32* * array, int* length, int* size, guint32 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint32, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self, ZeitgeistWhereClause* where, guint max_events, guint result_type, int* result_length1, GError** error) {
	guint32* result = NULL;
	gchar* sql = NULL;
	gchar* _tmp0_;
	gchar* where_sql = NULL;
	gchar* _tmp1_;
	ZeitgeistWhereClause* _tmp2_;
	gboolean _tmp3_;
	guint _tmp8_;
	gboolean time_asc = FALSE;
	guint _tmp105_;
	gboolean _tmp106_;
	const gchar* _tmp107_ = NULL;
	gboolean _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	ZeitgeistWhereClause* _tmp113_;
	gboolean _tmp114_;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp117_;
	const gchar* _tmp118_;
	sqlite3_stmt* _tmp119_ = NULL;
	gint _tmp120_;
	ZeitgeistSQLiteDatabase* _tmp121_;
	gint _tmp122_;
	GPtrArray* arguments = NULL;
	ZeitgeistWhereClause* _tmp123_;
	GPtrArray* _tmp124_;
	GPtrArray* _tmp125_;
	guint32* event_ids = NULL;
	guint32* _tmp139_;
	gint event_ids_length1;
	gint _event_ids_size_;
	gboolean _tmp156_ = FALSE;
	gint _tmp157_;
	guint32* _tmp168_;
	gint _tmp168__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (where != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT id FROM event_view ");
	sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	where_sql = _tmp1_;
	_tmp2_ = where;
	_tmp3_ = zeitgeist_where_clause_is_empty (_tmp2_);
	if (!_tmp3_) {
		ZeitgeistWhereClause* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = where;
		_tmp5_ = zeitgeist_where_clause_get_sql_conditions (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("WHERE ", _tmp6_, NULL);
		_g_free0 (where_sql);
		where_sql = _tmp7_;
		_g_free0 (_tmp6_);
	}
	_tmp8_ = result_type;
	switch (_tmp8_) {
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = sql;
			_tmp10_ = where_sql;
			_tmp11_ = g_strconcat (_tmp10_, " ORDER BY ", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (sql);
			sql = _tmp13_;
			_g_free0 (_tmp12_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		{
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = sql;
			_tmp15_ = where_sql;
			_tmp16_ = g_strconcat (_tmp15_, " ORDER BY ", NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
			_g_free0 (sql);
			sql = _tmp18_;
			_g_free0 (_tmp17_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = where;
			_tmp20_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp19_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp20_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp21_;
			gchar* _tmp22_;
			_tmp21_ = where;
			_tmp22_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp21_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp22_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp23_;
			gboolean _tmp24_;
			gchar* _tmp25_;
			_tmp23_ = where;
			_tmp24_ = FALSE;
			_tmp25_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp23_, &_tmp24_, "max");
			_g_free0 (sql);
			sql = _tmp25_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp26_;
			gboolean _tmp27_;
			gchar* _tmp28_;
			_tmp26_ = where;
			_tmp27_ = TRUE;
			_tmp28_ = zeitgeist_db_reader_group_and_sort (self, "origin", _tmp26_, &_tmp27_, "max");
			_g_free0 (sql);
			sql = _tmp28_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		{
			ZeitgeistWhereClause* _tmp29_;
			gchar* _tmp30_;
			_tmp29_ = where;
			_tmp30_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp29_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp30_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		{
			ZeitgeistWhereClause* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = where;
			_tmp32_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp31_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp32_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		{
			ZeitgeistWhereClause* _tmp33_;
			gboolean _tmp34_;
			gchar* _tmp35_;
			_tmp33_ = where;
			_tmp34_ = FALSE;
			_tmp35_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp33_, &_tmp34_, "max");
			_g_free0 (sql);
			sql = _tmp35_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		{
			ZeitgeistWhereClause* _tmp36_;
			gboolean _tmp37_;
			gchar* _tmp38_;
			_tmp36_ = where;
			_tmp37_ = TRUE;
			_tmp38_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", _tmp36_, &_tmp37_, "max");
			_g_free0 (sql);
			sql = _tmp38_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		{
			ZeitgeistWhereClause* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = where;
			_tmp40_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp39_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp40_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		{
			ZeitgeistWhereClause* _tmp41_;
			gchar* _tmp42_;
			_tmp41_ = where;
			_tmp42_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp41_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp42_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		{
			ZeitgeistWhereClause* _tmp43_;
			gboolean _tmp44_;
			gchar* _tmp45_;
			_tmp43_ = where;
			_tmp44_ = FALSE;
			_tmp45_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp43_, &_tmp44_, "max");
			_g_free0 (sql);
			sql = _tmp45_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		{
			ZeitgeistWhereClause* _tmp46_;
			gboolean _tmp47_;
			gchar* _tmp48_;
			_tmp46_ = where;
			_tmp47_ = TRUE;
			_tmp48_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", _tmp46_, &_tmp47_, "max");
			_g_free0 (sql);
			sql = _tmp48_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		{
			ZeitgeistWhereClause* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = where;
			_tmp50_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp49_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp50_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		{
			ZeitgeistWhereClause* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = where;
			_tmp52_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp51_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp52_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		{
			ZeitgeistWhereClause* _tmp53_;
			gboolean _tmp54_;
			gchar* _tmp55_;
			_tmp53_ = where;
			_tmp54_ = FALSE;
			_tmp55_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp53_, &_tmp54_, "max");
			_g_free0 (sql);
			sql = _tmp55_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		{
			ZeitgeistWhereClause* _tmp56_;
			gboolean _tmp57_;
			gchar* _tmp58_;
			_tmp56_ = where;
			_tmp57_ = TRUE;
			_tmp58_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp56_, &_tmp57_, "max");
			_g_free0 (sql);
			sql = _tmp58_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		{
			ZeitgeistWhereClause* _tmp59_;
			gchar* _tmp60_;
			_tmp59_ = where;
			_tmp60_ = zeitgeist_db_reader_group_and_sort (self, "actor", _tmp59_, NULL, "min");
			_g_free0 (sql);
			sql = _tmp60_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp61_;
			gchar* _tmp62_;
			_tmp61_ = where;
			_tmp62_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp61_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp62_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp63_;
			gchar* _tmp64_;
			_tmp63_ = where;
			_tmp64_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp63_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp64_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp65_;
			gboolean _tmp66_;
			gchar* _tmp67_;
			_tmp65_ = where;
			_tmp66_ = FALSE;
			_tmp67_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp65_, &_tmp66_, "max");
			_g_free0 (sql);
			sql = _tmp67_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp68_;
			gboolean _tmp69_;
			gchar* _tmp70_;
			_tmp68_ = where;
			_tmp69_ = TRUE;
			_tmp70_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", _tmp68_, &_tmp69_, "max");
			_g_free0 (sql);
			sql = _tmp70_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp71_;
			gchar* _tmp72_;
			_tmp71_ = where;
			_tmp72_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", _tmp71_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp72_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp73_;
			gchar* _tmp74_;
			_tmp73_ = where;
			_tmp74_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", _tmp73_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp74_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp75_;
			gboolean _tmp76_;
			gchar* _tmp77_;
			_tmp75_ = where;
			_tmp76_ = FALSE;
			_tmp77_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", _tmp75_, &_tmp76_, "max");
			_g_free0 (sql);
			sql = _tmp77_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN:
		{
			ZeitgeistWhereClause* _tmp78_;
			gboolean _tmp79_;
			gchar* _tmp80_;
			_tmp78_ = where;
			_tmp79_ = TRUE;
			_tmp80_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", _tmp78_, &_tmp79_, "max");
			_g_free0 (sql);
			sql = _tmp80_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		{
			ZeitgeistWhereClause* _tmp81_;
			gchar* _tmp82_;
			_tmp81_ = where;
			_tmp82_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp81_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp82_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		{
			ZeitgeistWhereClause* _tmp83_;
			gchar* _tmp84_;
			_tmp83_ = where;
			_tmp84_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp83_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp84_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		{
			ZeitgeistWhereClause* _tmp85_;
			gboolean _tmp86_;
			gchar* _tmp87_;
			_tmp85_ = where;
			_tmp86_ = FALSE;
			_tmp87_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp85_, &_tmp86_, "max");
			_g_free0 (sql);
			sql = _tmp87_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		{
			ZeitgeistWhereClause* _tmp88_;
			gboolean _tmp89_;
			gchar* _tmp90_;
			_tmp88_ = where;
			_tmp89_ = TRUE;
			_tmp90_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", _tmp88_, &_tmp89_, "max");
			_g_free0 (sql);
			sql = _tmp90_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		{
			ZeitgeistWhereClause* _tmp91_;
			gchar* _tmp92_;
			_tmp91_ = where;
			_tmp92_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp91_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp92_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		{
			ZeitgeistWhereClause* _tmp93_;
			gchar* _tmp94_;
			_tmp93_ = where;
			_tmp94_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp93_, NULL, "max");
			_g_free0 (sql);
			sql = _tmp94_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		{
			ZeitgeistWhereClause* _tmp95_;
			gboolean _tmp96_;
			gchar* _tmp97_;
			_tmp95_ = where;
			_tmp96_ = FALSE;
			_tmp97_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp95_, &_tmp96_, "max");
			_g_free0 (sql);
			sql = _tmp97_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			ZeitgeistWhereClause* _tmp98_;
			gboolean _tmp99_;
			gchar* _tmp100_;
			_tmp98_ = where;
			_tmp99_ = TRUE;
			_tmp100_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", _tmp98_, &_tmp99_, "max");
			_g_free0 (sql);
			sql = _tmp100_;
			break;
		}
		default:
		{
			gchar* error_message = NULL;
			gchar* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			GError* _tmp104_;
			_tmp101_ = g_strdup ("Invalid ResultType.");
			error_message = _tmp101_;
			_tmp102_ = error_message;
			g_warning ("db-reader.vala:292: %s", _tmp102_);
			_tmp103_ = error_message;
			_tmp104_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp103_);
			_inner_error_ = _tmp104_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (error_message);
		}
	}
	_tmp105_ = result_type;
	_tmp106_ = zeitgeist_result_type_is_sort_order_asc ((ZeitgeistResultType) _tmp105_);
	time_asc = _tmp106_;
	_tmp108_ = time_asc;
	if (_tmp108_) {
		_tmp107_ = "ASC";
	} else {
		_tmp107_ = "DESC";
	}
	_tmp109_ = sql;
	_tmp110_ = g_strdup_printf (" timestamp %s", _tmp107_);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_strconcat (_tmp109_, _tmp111_, NULL);
	_g_free0 (sql);
	sql = _tmp112_;
	_g_free0 (_tmp111_);
	_tmp113_ = where;
	_tmp114_ = zeitgeist_where_clause_get_is_simple (_tmp113_);
	if (_tmp114_) {
		const gchar* _tmp115_;
		gchar* _tmp116_;
		_tmp115_ = sql;
		_tmp116_ = string_replace (_tmp115_, "FROM event_view", "FROM event");
		_g_free0 (sql);
		sql = _tmp116_;
	}
	_tmp117_ = self->db;
	_tmp118_ = sql;
	_tmp120_ = sqlite3_prepare_v2 (_tmp117_, _tmp118_, -1, &_tmp119_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp119_;
	rc = _tmp120_;
	_tmp121_ = self->priv->_database;
	_tmp122_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp121_, _tmp122_, "db-reader.vala:307: SQL error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp123_ = where;
	_tmp124_ = zeitgeist_where_clause_get_bind_arguments (_tmp123_);
	_tmp125_ = _g_ptr_array_ref0 (_tmp124_);
	arguments = _tmp125_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp126_ = FALSE;
			_tmp126_ = TRUE;
			while (TRUE) {
				gint _tmp128_;
				GPtrArray* _tmp129_;
				gint _tmp130_;
				gint _tmp131_;
				sqlite3_stmt* _tmp132_;
				gint _tmp133_;
				GPtrArray* _tmp134_;
				gint _tmp135_;
				gconstpointer _tmp136_;
				gchar* _tmp137_;
				GDestroyNotify _tmp138_;
				if (!_tmp126_) {
					gint _tmp127_;
					_tmp127_ = i;
					i = _tmp127_ + 1;
				}
				_tmp126_ = FALSE;
				_tmp128_ = i;
				_tmp129_ = arguments;
				_tmp130_ = g_ptr_array_get_length (_tmp129_);
				_tmp131_ = _tmp130_;
				if (!(_tmp128_ < _tmp131_)) {
					break;
				}
				_tmp132_ = stmt;
				_tmp133_ = i;
				_tmp134_ = arguments;
				_tmp135_ = i;
				_tmp136_ = g_ptr_array_index (_tmp134_, (guint) _tmp135_);
				_tmp137_ = g_strdup ((const gchar*) _tmp136_);
				_tmp138_ = g_free;
				sqlite3_bind_text (_tmp132_, _tmp133_ + 1, _tmp137_, -1, _tmp138_);
			}
		}
	}
	_tmp139_ = g_new0 (guint32, 0);
	event_ids = _tmp139_;
	event_ids_length1 = 0;
	_event_ids_size_ = event_ids_length1;
	while (TRUE) {
		sqlite3_stmt* _tmp140_;
		gint _tmp141_;
		gint _tmp142_;
		guint32 event_id = 0U;
		sqlite3_stmt* _tmp143_;
		const gchar* _tmp144_;
		guint64 _tmp145_;
		gboolean _tmp146_ = FALSE;
		guint32* _tmp147_;
		gint _tmp147__length1;
		_tmp140_ = stmt;
		_tmp141_ = sqlite3_step (_tmp140_);
		rc = _tmp141_;
		_tmp142_ = rc;
		if (!(_tmp142_ == SQLITE_ROW)) {
			break;
		}
		_tmp143_ = stmt;
		_tmp144_ = sqlite3_column_text (_tmp143_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		_tmp145_ = uint64_parse (_tmp144_);
		event_id = (guint32) _tmp145_;
		_tmp147_ = event_ids;
		_tmp147__length1 = event_ids_length1;
		if (_tmp147__length1 == 0) {
			_tmp146_ = TRUE;
		} else {
			guint32* _tmp148_;
			gint _tmp148__length1;
			guint32* _tmp149_;
			gint _tmp149__length1;
			guint32 _tmp150_;
			guint32 _tmp151_;
			_tmp148_ = event_ids;
			_tmp148__length1 = event_ids_length1;
			_tmp149_ = event_ids;
			_tmp149__length1 = event_ids_length1;
			_tmp150_ = _tmp148_[_tmp149__length1 - 1];
			_tmp151_ = event_id;
			_tmp146_ = _tmp150_ != _tmp151_;
		}
		if (_tmp146_) {
			guint32* _tmp152_;
			gint _tmp152__length1;
			guint32 _tmp153_;
			guint32* _tmp154_;
			gint _tmp154__length1;
			guint _tmp155_;
			_tmp152_ = event_ids;
			_tmp152__length1 = event_ids_length1;
			_tmp153_ = event_id;
			_vala_array_add1 (&event_ids, &event_ids_length1, &_event_ids_size_, _tmp153_);
			_tmp154_ = event_ids;
			_tmp154__length1 = event_ids_length1;
			_tmp155_ = max_events;
			if (((guint) _tmp154__length1) == _tmp155_) {
				break;
			}
		}
	}
	_tmp157_ = rc;
	if (_tmp157_ != SQLITE_DONE) {
		gint _tmp158_;
		_tmp158_ = rc;
		_tmp156_ = _tmp158_ != SQLITE_ROW;
	} else {
		_tmp156_ = FALSE;
	}
	if (_tmp156_) {
		gchar* error_message = NULL;
		gint _tmp159_;
		sqlite3* _tmp160_;
		const gchar* _tmp161_;
		gchar* _tmp162_;
		const gchar* _tmp163_;
		ZeitgeistSQLiteDatabase* _tmp164_;
		gint _tmp165_;
		const gchar* _tmp166_;
		GError* _tmp167_;
		_tmp159_ = rc;
		_tmp160_ = self->db;
		_tmp161_ = sqlite3_errmsg (_tmp160_);
		_tmp162_ = g_strdup_printf ("Error in find_event_ids: %d, %s", _tmp159_, _tmp161_);
		error_message = _tmp162_;
		_tmp163_ = error_message;
		g_warning ("db-reader.vala:333: %s", _tmp163_);
		_tmp164_ = self->priv->_database;
		_tmp165_ = rc;
		zeitgeist_sq_lite_database_assert_not_corrupt (_tmp164_, _tmp165_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp166_ = error_message;
		_tmp167_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp166_);
		_inner_error_ = _tmp167_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (error_message);
	}
	_tmp168_ = event_ids;
	_tmp168__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp168__length1;
	}
	result = _tmp168_;
	_g_ptr_array_unref0 (arguments);
	_sqlite3_finalize0 (stmt);
	_g_free0 (where_sql);
	_g_free0 (sql);
	return result;
}


guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	guint _tmp2_;
	ZeitgeistWhereClause* _tmp3_;
	guint32* _tmp4_ = NULL;
	ZeitgeistWhereClause* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gint _tmp8_;
	guint32* _tmp9_;
	gint _tmp4__length1;
	gint __tmp4__size_;
	guint32* _tmp10_;
	gint _tmp10__length1;
	guint32* _tmp11_;
	gint _tmp11__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = time_range;
	_tmp1_ = event_templates;
	_tmp2_ = storage_state;
	_tmp3_ = zeitgeist_db_reader_get_where_clause_for_query (self, _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	where = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = where;
	_tmp6_ = max_events;
	_tmp7_ = result_type;
	_tmp9_ = zeitgeist_db_reader_find_event_ids_for_clause (self, _tmp5_, _tmp6_, _tmp7_, &_tmp8_, &_inner_error_);
	_tmp4_ = _tmp9_;
	_tmp4__length1 = _tmp8_;
	__tmp4__size_ = _tmp4__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = _tmp4_;
	_tmp10__length1 = _tmp4__length1;
	_tmp4_ = NULL;
	_tmp4__length1 = 0;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	_g_object_unref0 (where);
	return result;
}


GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	guint32* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint _tmp6_;
	guint32* _tmp7_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	GPtrArray* _tmp8_ = NULL;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp1_ = time_range;
	_tmp2_ = event_templates;
	_tmp3_ = storage_state;
	_tmp4_ = max_events;
	_tmp5_ = result_type;
	_tmp7_ = zeitgeist_db_reader_find_event_ids (self, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, NULL, &_tmp6_, &_inner_error_);
	_tmp0_ = _tmp7_;
	_tmp0__length1 = _tmp6_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = zeitgeist_db_reader_get_events (self, _tmp0_, _tmp0__length1, NULL, &_inner_error_);
	_tmp8_ = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_tmp0_ = (g_free (_tmp0_), NULL);
			return NULL;
		} else {
			_tmp0_ = (g_free (_tmp0_), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = _tmp8_;
	_tmp8_ = NULL;
	result = _tmp10_;
	_g_ptr_array_unref0 (_tmp8_);
	_tmp0_ = (g_free (_tmp0_), NULL);
	return result;
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	ZeitgeistTimeRange* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gboolean _tmp19_ = FALSE;
	guint _tmp20_;
	ZeitgeistWhereClause* tpl_conditions = NULL;
	GPtrArray* _tmp33_;
	ZeitgeistWhereClause* _tmp34_;
	ZeitgeistWhereClause* _tmp35_;
	ZeitgeistWhereClause* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = zeitgeist_time_range_get_start (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = time_range;
		_tmp6_ = zeitgeist_time_range_get_start (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("timestamp >= %" G_GINT64_FORMAT, _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, _tmp9_, NULL);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = time_range;
	_tmp11_ = zeitgeist_time_range_get_end (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp13_;
		ZeitgeistTimeRange* _tmp14_;
		gint64 _tmp15_;
		gint64 _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp13_ = where;
		_tmp14_ = time_range;
		_tmp15_ = zeitgeist_time_range_get_end (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("timestamp <= %" G_GINT64_FORMAT, _tmp16_);
		_tmp18_ = _tmp17_;
		zeitgeist_where_clause_add (_tmp13_, _tmp18_, NULL);
		_g_free0 (_tmp18_);
	}
	_tmp20_ = storage_state;
	if (_tmp20_ == ((guint) ZEITGEIST_STORAGE_STATE_AVAILABLE)) {
		_tmp19_ = TRUE;
	} else {
		guint _tmp21_;
		_tmp21_ = storage_state;
		_tmp19_ = _tmp21_ == ((guint) ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE);
	}
	if (_tmp19_) {
		ZeitgeistWhereClause* _tmp22_;
		guint _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ZeitgeistWhereClause* _tmp26_;
		_tmp22_ = where;
		_tmp23_ = storage_state;
		_tmp24_ = g_strdup_printf ("%u", _tmp23_);
		_tmp25_ = _tmp24_;
		zeitgeist_where_clause_add (_tmp22_, "(subj_storage_state=? OR subj_storage_state IS NULL)", _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = where;
		zeitgeist_where_clause_set_is_simple (_tmp26_, FALSE);
	} else {
		guint _tmp27_;
		_tmp27_ = storage_state;
		if (_tmp27_ != ((guint) ZEITGEIST_STORAGE_STATE_ANY)) {
			guint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GError* _tmp31_;
			GError* _tmp32_;
			_tmp28_ = storage_state;
			_tmp29_ = g_strdup_printf ("Unknown storage state '%u'", _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			_inner_error_ = _tmp32_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp33_ = event_templates;
	_tmp34_ = zeitgeist_db_reader_get_where_clause_from_event_templates (self, _tmp33_, &_inner_error_);
	tpl_conditions = _tmp34_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp35_ = where;
	_tmp36_ = tpl_conditions;
	zeitgeist_where_clause_extend (_tmp35_, _tmp36_);
	result = where;
	_g_object_unref0 (tpl_conditions);
	return result;
}


static void _zeitgeist_db_reader_related_uri_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL));
}


static gpointer _zeitgeist_db_reader_related_uri_dup0 (gpointer self) {
	return self ? zeitgeist_db_reader_related_uri_dup (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gboolean _vala_uint32_array_contains (guint32 * stack, int stack_length, guint32 needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint ___lambda8_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint32 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint32 _tmp3_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).counter;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).counter;
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}


static gint ____lambda8__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda8_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}


static gint ___lambda9_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	gint64 delta = 0LL;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint ____lambda9__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda9_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}


static gint ____lambda10_ (ZeitgeistDbReaderRelatedUri* a, ZeitgeistDbReaderRelatedUri* b) {
	gint result = 0;
	gint64 delta = 0LL;
	ZeitgeistDbReaderRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistDbReaderRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint _____lambda10__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ____lambda10_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}


static inline void _g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _zeitgeist_db_reader_related_uri_free0_);
}


gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error) {
	gchar** result = NULL;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (result_event_templates != NULL, NULL);
	_tmp1_ = result_type;
	if (_tmp1_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = result_type;
		_tmp0_ = _tmp2_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED);
	}
	if (_tmp0_) {
		guint32* ids = NULL;
		ZeitgeistTimeRange* _tmp3_;
		GPtrArray* _tmp4_;
		guint _tmp5_;
		gint _tmp6_;
		guint32* _tmp7_;
		gint ids_length1;
		gint _ids_size_;
		gboolean _tmp8_ = FALSE;
		GPtrArray* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		guint32* result_ids = NULL;
		gint result_ids_length1 = 0;
		gint _result_ids_size_ = 0;
		guint32* _tmp14_ = NULL;
		ZeitgeistTimeRange* _tmp15_;
		GPtrArray* _tmp16_;
		guint _tmp17_;
		gint _tmp18_;
		guint32* _tmp19_;
		gint _tmp14__length1;
		gint __tmp14__size_;
		guint32* _tmp20_;
		gint _tmp20__length1;
		guint32* pot = NULL;
		guint32* _tmp21_;
		gint _tmp21__length1;
		guint32* _tmp22_;
		gint _tmp22__length1;
		guint32* _tmp23_;
		gint pot_length1;
		gint _pot_size_;
		sqlite3_stmt* stmt = NULL;
		gchar* sql_event_ids = NULL;
		ZeitgeistSQLiteDatabase* _tmp46_;
		guint32* _tmp47_;
		gint _tmp47__length1;
		gchar* _tmp48_;
		gchar* sql = NULL;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gint rc = 0;
		sqlite3* _tmp51_;
		const gchar* _tmp52_;
		sqlite3_stmt* _tmp53_ = NULL;
		gint _tmp54_;
		ZeitgeistSQLiteDatabase* _tmp55_;
		gint _tmp56_;
		GPtrArray* temp_related_uris = NULL;
		GPtrArray* _tmp57_;
		ZeitgeistSQLiteDatabase* _tmp74_;
		gint _tmp75_;
		GHashTable* uri_counter = NULL;
		GHashFunc _tmp76_;
		GEqualFunc _tmp77_;
		GHashTable* _tmp78_;
		GList* temp_ruris = NULL;
		GList* values = NULL;
		GHashTable* _tmp174_;
		GList* _tmp175_;
		GList* _tmp178_;
		guint _tmp186_;
		gchar** results = NULL;
		GList* _tmp187_;
		guint _tmp188_;
		gchar** _tmp189_;
		gint results_length1;
		gint _results_size_;
		gint i = 0;
		GList* _tmp190_;
		gchar** _tmp199_;
		gint _tmp199__length1;
		_tmp3_ = time_range;
		_tmp4_ = event_templates;
		_tmp5_ = storage_state;
		_tmp7_ = zeitgeist_db_reader_find_event_ids (self, _tmp3_, _tmp4_, _tmp5_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp6_, &_inner_error_);
		ids = _tmp7_;
		ids_length1 = _tmp6_;
		_ids_size_ = ids_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp9_ = event_templates;
		_tmp10_ = g_ptr_array_get_length (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 0) {
			guint32* _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = ids;
			_tmp12__length1 = ids_length1;
			_tmp8_ = _tmp12__length1 == 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "No results found for the event_templates");
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp15_ = time_range;
		_tmp16_ = result_event_templates;
		_tmp17_ = storage_state;
		_tmp19_ = zeitgeist_db_reader_find_event_ids (self, _tmp15_, _tmp16_, _tmp17_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp18_, &_inner_error_);
		_tmp14_ = _tmp19_;
		_tmp14__length1 = _tmp18_;
		__tmp14__size_ = _tmp14__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp20_ = _tmp14_;
		_tmp20__length1 = _tmp14__length1;
		_tmp14_ = NULL;
		_tmp14__length1 = 0;
		result_ids = (g_free (result_ids), NULL);
		result_ids = _tmp20_;
		result_ids_length1 = _tmp20__length1;
		_result_ids_size_ = result_ids_length1;
		_tmp21_ = ids;
		_tmp21__length1 = ids_length1;
		_tmp22_ = result_ids;
		_tmp22__length1 = result_ids_length1;
		_tmp23_ = g_new0 (guint32, _tmp21__length1 + _tmp22__length1);
		pot = _tmp23_;
		pot_length1 = _tmp21__length1 + _tmp22__length1;
		_pot_size_ = pot_length1;
		{
			guint32 i = 0U;
			i = (guint32) 0;
			{
				gboolean _tmp24_ = FALSE;
				_tmp24_ = TRUE;
				while (TRUE) {
					guint32 _tmp26_;
					guint32* _tmp27_;
					gint _tmp27__length1;
					guint32* _tmp28_;
					gint _tmp28__length1;
					guint32 _tmp29_;
					guint32* _tmp30_;
					gint _tmp30__length1;
					guint32 _tmp31_;
					guint32 _tmp32_;
					guint32 _tmp33_;
					if (!_tmp24_) {
						guint32 _tmp25_;
						_tmp25_ = i;
						i = _tmp25_ + 1;
					}
					_tmp24_ = FALSE;
					_tmp26_ = i;
					_tmp27_ = ids;
					_tmp27__length1 = ids_length1;
					if (!(_tmp26_ < ((guint32) _tmp27__length1))) {
						break;
					}
					_tmp28_ = pot;
					_tmp28__length1 = pot_length1;
					_tmp29_ = i;
					_tmp30_ = ids;
					_tmp30__length1 = ids_length1;
					_tmp31_ = i;
					_tmp32_ = _tmp30_[_tmp31_];
					_tmp28_[_tmp29_] = _tmp32_;
					_tmp33_ = _tmp28_[_tmp29_];
				}
			}
		}
		{
			guint32 i = 0U;
			i = (guint32) 0;
			{
				gboolean _tmp34_ = FALSE;
				_tmp34_ = TRUE;
				while (TRUE) {
					guint32 _tmp36_;
					guint32* _tmp37_;
					gint _tmp37__length1;
					guint32* _tmp38_;
					gint _tmp38__length1;
					guint32* _tmp39_;
					gint _tmp39__length1;
					guint32 _tmp40_;
					guint32* _tmp41_;
					gint _tmp41__length1;
					guint32* _tmp42_;
					gint _tmp42__length1;
					guint32 _tmp43_;
					guint32 _tmp44_;
					guint32 _tmp45_;
					if (!_tmp34_) {
						guint32 _tmp35_;
						_tmp35_ = i;
						i = _tmp35_ + 1;
					}
					_tmp34_ = FALSE;
					_tmp36_ = i;
					_tmp37_ = result_ids;
					_tmp37__length1 = result_ids_length1;
					if (!(_tmp36_ < ((guint32) _tmp37__length1))) {
						break;
					}
					_tmp38_ = pot;
					_tmp38__length1 = pot_length1;
					_tmp39_ = ids;
					_tmp39__length1 = ids_length1;
					_tmp40_ = i;
					_tmp41_ = result_ids;
					_tmp41__length1 = result_ids_length1;
					_tmp42_ = ids;
					_tmp42__length1 = ids_length1;
					_tmp43_ = i;
					_tmp44_ = _tmp41_[_tmp42__length1 + _tmp43_];
					_tmp38_[_tmp39__length1 + _tmp40_] = _tmp44_;
					_tmp45_ = _tmp38_[_tmp39__length1 + _tmp40_];
				}
			}
		}
		_tmp46_ = self->priv->_database;
		_tmp47_ = pot;
		_tmp47__length1 = pot_length1;
		_tmp48_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp46_, _tmp47_, _tmp47__length1);
		sql_event_ids = _tmp48_;
		_tmp49_ = sql_event_ids;
		_tmp50_ = g_strdup_printf ("\n" \
"               SELECT id, timestamp, subj_uri FROM event_view \n" \
"               WHERE id IN (%s) ORDER BY timestamp ASC\n" \
"               ", _tmp49_);
		sql = _tmp50_;
		_tmp51_ = self->db;
		_tmp52_ = sql;
		_tmp54_ = sqlite3_prepare_v2 (_tmp51_, _tmp52_, -1, &_tmp53_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp53_;
		rc = _tmp54_;
		_tmp55_ = self->priv->_database;
		_tmp56_ = rc;
		zeitgeist_sq_lite_database_assert_query_success (_tmp55_, _tmp56_, "db-reader.vala:459: SQL error", SQLITE_OK, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp14_ = (g_free (_tmp14_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp14_ = (g_free (_tmp14_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp57_ = g_ptr_array_new_full ((guint) 0, _zeitgeist_db_reader_related_uri_free0_);
		temp_related_uris = _tmp57_;
		while (TRUE) {
			sqlite3_stmt* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			ZeitgeistDbReaderRelatedUri ruri = {0};
			sqlite3_stmt* _tmp61_;
			const gchar* _tmp62_;
			guint64 _tmp63_;
			sqlite3_stmt* _tmp64_;
			gint64 _tmp65_;
			sqlite3_stmt* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			ZeitgeistDbReaderRelatedUri _tmp69_ = {0};
			GPtrArray* _tmp70_;
			ZeitgeistDbReaderRelatedUri _tmp71_;
			ZeitgeistDbReaderRelatedUri _tmp72_;
			ZeitgeistDbReaderRelatedUri* _tmp73_;
			_tmp58_ = stmt;
			_tmp59_ = sqlite3_step (_tmp58_);
			rc = _tmp59_;
			_tmp60_ = rc;
			if (!(_tmp60_ == SQLITE_ROW)) {
				break;
			}
			_tmp61_ = stmt;
			_tmp62_ = sqlite3_column_text (_tmp61_, 0);
			_tmp63_ = uint64_parse (_tmp62_);
			_tmp64_ = stmt;
			_tmp65_ = sqlite3_column_int64 (_tmp64_, 1);
			_tmp66_ = stmt;
			_tmp67_ = sqlite3_column_text (_tmp66_, 2);
			_tmp68_ = g_strdup (_tmp67_);
			memset (&_tmp69_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
			_tmp69_.id = (guint32) _tmp63_;
			_tmp69_.timestamp = _tmp65_;
			_g_free0 (_tmp69_.uri);
			_tmp69_.uri = _tmp68_;
			_tmp69_.counter = (gint32) 0;
			ruri = _tmp69_;
			_tmp70_ = temp_related_uris;
			_tmp71_ = ruri;
			_tmp72_ = _tmp71_;
			_tmp73_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp72_);
			g_ptr_array_add (_tmp70_, _tmp73_);
			zeitgeist_db_reader_related_uri_destroy (&ruri);
		}
		_tmp74_ = self->priv->_database;
		_tmp75_ = rc;
		zeitgeist_sq_lite_database_assert_query_success (_tmp74_, _tmp75_, "Error in find_related_uris", SQLITE_DONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp14_ = (g_free (_tmp14_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp14_ = (g_free (_tmp14_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp76_ = g_str_hash;
		_tmp77_ = g_str_equal;
		_tmp78_ = g_hash_table_new_full (_tmp76_, _tmp77_, _g_free0_, _zeitgeist_db_reader_related_uri_free0_);
		uri_counter = _tmp78_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp79_ = FALSE;
				_tmp79_ = TRUE;
				while (TRUE) {
					gint _tmp81_;
					GPtrArray* _tmp82_;
					gint _tmp83_;
					gint _tmp84_;
					GPtrArray* window = NULL;
					GPtrArray* _tmp85_;
					gboolean count_in_window = FALSE;
					gboolean _tmp105_;
					if (!_tmp79_) {
						gint _tmp80_;
						_tmp80_ = i;
						i = _tmp80_ + 1;
					}
					_tmp79_ = FALSE;
					_tmp81_ = i;
					_tmp82_ = temp_related_uris;
					_tmp83_ = g_ptr_array_get_length (_tmp82_);
					_tmp84_ = _tmp83_;
					if (!(_tmp81_ < _tmp84_)) {
						break;
					}
					_tmp85_ = g_ptr_array_new_full ((guint) 0, NULL);
					window = _tmp85_;
					count_in_window = FALSE;
					{
						gint j = 0;
						gint _tmp86_;
						gint _tmp87_;
						_tmp86_ = i;
						_tmp87_ = MAX (0, _tmp86_ - 5);
						j = _tmp87_;
						{
							gboolean _tmp88_ = FALSE;
							_tmp88_ = TRUE;
							while (TRUE) {
								gint _tmp90_;
								gint _tmp91_;
								GPtrArray* _tmp92_;
								gint _tmp93_;
								gint _tmp94_;
								gint _tmp95_;
								GPtrArray* _tmp96_;
								GPtrArray* _tmp97_;
								gint _tmp98_;
								gconstpointer _tmp99_;
								GPtrArray* _tmp100_;
								gint _tmp101_;
								gconstpointer _tmp102_;
								guint32 _tmp103_;
								guint32* _tmp104_;
								gint _tmp104__length1;
								if (!_tmp88_) {
									gint _tmp89_;
									_tmp89_ = j;
									j = _tmp89_ + 1;
								}
								_tmp88_ = FALSE;
								_tmp90_ = j;
								_tmp91_ = i;
								_tmp92_ = temp_related_uris;
								_tmp93_ = g_ptr_array_get_length (_tmp92_);
								_tmp94_ = _tmp93_;
								_tmp95_ = MIN (_tmp91_, _tmp94_);
								if (!(_tmp90_ < _tmp95_)) {
									break;
								}
								_tmp96_ = window;
								_tmp97_ = temp_related_uris;
								_tmp98_ = j;
								_tmp99_ = g_ptr_array_index (_tmp97_, (guint) _tmp98_);
								g_ptr_array_add (_tmp96_, (ZeitgeistDbReaderRelatedUri*) _tmp99_);
								_tmp100_ = temp_related_uris;
								_tmp101_ = j;
								_tmp102_ = g_ptr_array_index (_tmp100_, (guint) _tmp101_);
								_tmp103_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp102_)).id;
								_tmp104_ = ids;
								_tmp104__length1 = ids_length1;
								if (_vala_uint32_array_contains (_tmp104_, _tmp104__length1, _tmp103_)) {
									count_in_window = TRUE;
									break;
								}
							}
						}
					}
					_tmp105_ = count_in_window;
					if (_tmp105_) {
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp106_ = FALSE;
								_tmp106_ = TRUE;
								while (TRUE) {
									gint _tmp108_;
									GPtrArray* _tmp109_;
									gint _tmp110_;
									gint _tmp111_;
									GPtrArray* _tmp112_;
									gint _tmp113_;
									gconstpointer _tmp114_;
									guint32 _tmp115_;
									guint32* _tmp116_;
									gint _tmp116__length1;
									if (!_tmp106_) {
										gint _tmp107_;
										_tmp107_ = j;
										j = _tmp107_ + 1;
									}
									_tmp106_ = FALSE;
									_tmp108_ = j;
									_tmp109_ = window;
									_tmp110_ = g_ptr_array_get_length (_tmp109_);
									_tmp111_ = _tmp110_;
									if (!(_tmp108_ < _tmp111_)) {
										break;
									}
									_tmp112_ = window;
									_tmp113_ = j;
									_tmp114_ = g_ptr_array_index (_tmp112_, (guint) _tmp113_);
									_tmp115_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp114_)).id;
									_tmp116_ = result_ids;
									_tmp116__length1 = result_ids_length1;
									if (_vala_uint32_array_contains (_tmp116_, _tmp116__length1, _tmp115_)) {
										GHashTable* _tmp117_;
										GPtrArray* _tmp118_;
										gint _tmp119_;
										gconstpointer _tmp120_;
										const gchar* _tmp121_;
										gconstpointer _tmp122_;
										GHashTable* _tmp146_;
										GPtrArray* _tmp147_;
										gint _tmp148_;
										gconstpointer _tmp149_;
										const gchar* _tmp150_;
										gconstpointer _tmp151_;
										gint32 _tmp152_;
										GHashTable* _tmp153_;
										GPtrArray* _tmp154_;
										gint _tmp155_;
										gconstpointer _tmp156_;
										const gchar* _tmp157_;
										gconstpointer _tmp158_;
										gint64 _tmp159_;
										GPtrArray* _tmp160_;
										gint _tmp161_;
										gconstpointer _tmp162_;
										gint64 _tmp163_;
										_tmp117_ = uri_counter;
										_tmp118_ = window;
										_tmp119_ = j;
										_tmp120_ = g_ptr_array_index (_tmp118_, (guint) _tmp119_);
										_tmp121_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp120_)).uri;
										_tmp122_ = g_hash_table_lookup (_tmp117_, _tmp121_);
										if (((ZeitgeistDbReaderRelatedUri*) _tmp122_) == NULL) {
											ZeitgeistDbReaderRelatedUri ruri = {0};
											GPtrArray* _tmp123_;
											gint _tmp124_;
											gconstpointer _tmp125_;
											guint32 _tmp126_;
											GPtrArray* _tmp127_;
											gint _tmp128_;
											gconstpointer _tmp129_;
											gint64 _tmp130_;
											GPtrArray* _tmp131_;
											gint _tmp132_;
											gconstpointer _tmp133_;
											const gchar* _tmp134_;
											gchar* _tmp135_;
											ZeitgeistDbReaderRelatedUri _tmp136_ = {0};
											GHashTable* _tmp137_;
											GPtrArray* _tmp138_;
											gint _tmp139_;
											gconstpointer _tmp140_;
											const gchar* _tmp141_;
											gchar* _tmp142_;
											ZeitgeistDbReaderRelatedUri _tmp143_;
											ZeitgeistDbReaderRelatedUri _tmp144_;
											ZeitgeistDbReaderRelatedUri* _tmp145_;
											_tmp123_ = window;
											_tmp124_ = j;
											_tmp125_ = g_ptr_array_index (_tmp123_, (guint) _tmp124_);
											_tmp126_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp125_)).id;
											_tmp127_ = window;
											_tmp128_ = j;
											_tmp129_ = g_ptr_array_index (_tmp127_, (guint) _tmp128_);
											_tmp130_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp129_)).timestamp;
											_tmp131_ = window;
											_tmp132_ = j;
											_tmp133_ = g_ptr_array_index (_tmp131_, (guint) _tmp132_);
											_tmp134_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp133_)).uri;
											_tmp135_ = g_strdup (_tmp134_);
											memset (&_tmp136_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
											_tmp136_.id = _tmp126_;
											_tmp136_.timestamp = _tmp130_;
											_g_free0 (_tmp136_.uri);
											_tmp136_.uri = _tmp135_;
											_tmp136_.counter = (gint32) 0;
											ruri = _tmp136_;
											_tmp137_ = uri_counter;
											_tmp138_ = window;
											_tmp139_ = j;
											_tmp140_ = g_ptr_array_index (_tmp138_, (guint) _tmp139_);
											_tmp141_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp140_)).uri;
											_tmp142_ = g_strdup (_tmp141_);
											_tmp143_ = ruri;
											_tmp144_ = _tmp143_;
											_tmp145_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp144_);
											g_hash_table_insert (_tmp137_, _tmp142_, _tmp145_);
											zeitgeist_db_reader_related_uri_destroy (&ruri);
										}
										_tmp146_ = uri_counter;
										_tmp147_ = window;
										_tmp148_ = j;
										_tmp149_ = g_ptr_array_index (_tmp147_, (guint) _tmp148_);
										_tmp150_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp149_)).uri;
										_tmp151_ = g_hash_table_lookup (_tmp146_, _tmp150_);
										_tmp152_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp151_)).counter;
										(*((ZeitgeistDbReaderRelatedUri*) _tmp151_)).counter = _tmp152_ + 1;
										_tmp153_ = uri_counter;
										_tmp154_ = window;
										_tmp155_ = j;
										_tmp156_ = g_ptr_array_index (_tmp154_, (guint) _tmp155_);
										_tmp157_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp156_)).uri;
										_tmp158_ = g_hash_table_lookup (_tmp153_, _tmp157_);
										_tmp159_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp158_)).timestamp;
										_tmp160_ = window;
										_tmp161_ = j;
										_tmp162_ = g_ptr_array_index (_tmp160_, (guint) _tmp161_);
										_tmp163_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp162_)).timestamp;
										if (_tmp159_ < _tmp163_) {
											GHashTable* _tmp164_;
											GPtrArray* _tmp165_;
											gint _tmp166_;
											gconstpointer _tmp167_;
											const gchar* _tmp168_;
											gconstpointer _tmp169_;
											GPtrArray* _tmp170_;
											gint _tmp171_;
											gconstpointer _tmp172_;
											gint64 _tmp173_;
											_tmp164_ = uri_counter;
											_tmp165_ = window;
											_tmp166_ = j;
											_tmp167_ = g_ptr_array_index (_tmp165_, (guint) _tmp166_);
											_tmp168_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp167_)).uri;
											_tmp169_ = g_hash_table_lookup (_tmp164_, _tmp168_);
											_tmp170_ = window;
											_tmp171_ = j;
											_tmp172_ = g_ptr_array_index (_tmp170_, (guint) _tmp171_);
											_tmp173_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp172_)).timestamp;
											(*((ZeitgeistDbReaderRelatedUri*) _tmp169_)).timestamp = _tmp173_;
										}
									}
								}
							}
						}
					}
					_g_ptr_array_unref0 (window);
				}
			}
		}
		temp_ruris = NULL;
		values = NULL;
		_tmp174_ = uri_counter;
		_tmp175_ = g_hash_table_get_values (_tmp174_);
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp175_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				uri = (ZeitgeistDbReaderRelatedUri*) uri_it->data;
				{
					ZeitgeistDbReaderRelatedUri* _tmp176_;
					ZeitgeistDbReaderRelatedUri* _tmp177_;
					_tmp176_ = uri;
					_tmp177_ = _zeitgeist_db_reader_related_uri_dup0 (_tmp176_);
					values = g_list_append (values, _tmp177_);
				}
			}
			_g_list_free0 (uri_collection);
		}
		values = g_list_sort (values, ____lambda8__gcompare_func);
		values = g_list_sort (values, ____lambda9__gcompare_func);
		_tmp178_ = values;
		{
			GList* ruri_collection = NULL;
			GList* ruri_it = NULL;
			ruri_collection = _tmp178_;
			for (ruri_it = ruri_collection; ruri_it != NULL; ruri_it = ruri_it->next) {
				ZeitgeistDbReaderRelatedUri _tmp179_ = {0};
				ZeitgeistDbReaderRelatedUri ruri = {0};
				zeitgeist_db_reader_related_uri_copy ((ZeitgeistDbReaderRelatedUri*) ruri_it->data, &_tmp179_);
				ruri = _tmp179_;
				{
					GList* _tmp180_;
					guint _tmp181_;
					guint _tmp182_;
					_tmp180_ = temp_ruris;
					_tmp181_ = g_list_length (_tmp180_);
					_tmp182_ = max_results;
					if (_tmp181_ < _tmp182_) {
						ZeitgeistDbReaderRelatedUri _tmp183_;
						ZeitgeistDbReaderRelatedUri _tmp184_;
						ZeitgeistDbReaderRelatedUri* _tmp185_;
						_tmp183_ = ruri;
						_tmp184_ = _tmp183_;
						_tmp185_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp184_);
						temp_ruris = g_list_append (temp_ruris, _tmp185_);
					} else {
						zeitgeist_db_reader_related_uri_destroy (&ruri);
						break;
					}
					zeitgeist_db_reader_related_uri_destroy (&ruri);
				}
			}
		}
		_tmp186_ = result_type;
		if (_tmp186_ == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
			temp_ruris = g_list_sort (temp_ruris, _____lambda10__gcompare_func);
		}
		_tmp187_ = temp_ruris;
		_tmp188_ = g_list_length (_tmp187_);
		_tmp189_ = g_new0 (gchar*, _tmp188_ + 1);
		results = _tmp189_;
		results_length1 = _tmp188_;
		_results_size_ = results_length1;
		i = 0;
		_tmp190_ = temp_ruris;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp190_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* _tmp191_;
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				_tmp191_ = _zeitgeist_db_reader_related_uri_dup0 ((ZeitgeistDbReaderRelatedUri*) uri_it->data);
				uri = _tmp191_;
				{
					gchar** _tmp192_;
					gint _tmp192__length1;
					gint _tmp193_;
					ZeitgeistDbReaderRelatedUri* _tmp194_;
					const gchar* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gint _tmp198_;
					_tmp192_ = results;
					_tmp192__length1 = results_length1;
					_tmp193_ = i;
					_tmp194_ = uri;
					_tmp195_ = (*_tmp194_).uri;
					_tmp196_ = g_strdup (_tmp195_);
					_g_free0 (_tmp192_[_tmp193_]);
					_tmp192_[_tmp193_] = _tmp196_;
					_tmp197_ = _tmp192_[_tmp193_];
					_tmp198_ = i;
					i = _tmp198_ + 1;
					_zeitgeist_db_reader_related_uri_free0 (uri);
				}
			}
		}
		_tmp199_ = results;
		_tmp199__length1 = results_length1;
		if (result_length1) {
			*result_length1 = _tmp199__length1;
		}
		result = _tmp199_;
		__g_list_free__zeitgeist_db_reader_related_uri_free0_0 (values);
		__g_list_free__zeitgeist_db_reader_related_uri_free0_0 (temp_ruris);
		_g_hash_table_unref0 (uri_counter);
		_g_ptr_array_unref0 (temp_related_uris);
		_g_free0 (sql);
		_g_free0 (sql_event_ids);
		_sqlite3_finalize0 (stmt);
		pot = (g_free (pot), NULL);
		_tmp14_ = (g_free (_tmp14_), NULL);
		result_ids = (g_free (result_ids), NULL);
		ids = (g_free (ids), NULL);
		return result;
	} else {
		GError* _tmp200_;
		_tmp200_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Unsupported RelevantResultType");
		_inner_error_ = _tmp200_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


/**
     * Clear all resources Engine is using (close database connection, etc.).
     *
     * After executing this method on an instance, no other function
     * may be called.
     */
static void zeitgeist_db_reader_real_close (ZeitgeistDbReader* self) {
	ZeitgeistSQLiteDatabase* _tmp0_;
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_close (_tmp0_);
}


void zeitgeist_db_reader_close (ZeitgeistDbReader* self) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_DB_READER_GET_CLASS (self)->close (self);
}


static gchar* zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self, const gchar* field, ZeitgeistWhereClause* where, gboolean* count_asc, const gchar* aggregation_type) {
	gchar* result = NULL;
	gchar* aggregation_sql = NULL;
	gchar* _tmp0_;
	gchar* order_sql = NULL;
	gchar* _tmp1_;
	gchar* where_sql = NULL;
	ZeitgeistWhereClause* _tmp2_;
	gchar* _tmp3_;
	gboolean* _tmp4_;
	gboolean _tmp10_ = FALSE;
	gboolean* _tmp11_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (where != NULL, NULL);
	g_return_val_if_fail (aggregation_type != NULL, NULL);
	_tmp0_ = g_strdup ("");
	aggregation_sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	order_sql = _tmp1_;
	_tmp2_ = where;
	_tmp3_ = zeitgeist_where_clause_get_sql_conditions (_tmp2_);
	where_sql = _tmp3_;
	_tmp4_ = count_asc;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gboolean* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = field;
		_tmp6_ = g_strdup_printf (", COUNT(%s) AS num_events", _tmp5_);
		_g_free0 (aggregation_sql);
		aggregation_sql = _tmp6_;
		_tmp8_ = count_asc;
		if (*_tmp8_) {
			_tmp7_ = "ASC";
		} else {
			_tmp7_ = "DESC";
		}
		_tmp9_ = g_strdup_printf ("num_events %s,", _tmp7_);
		_g_free0 (order_sql);
		order_sql = _tmp9_;
	}
	_tmp11_ = count_asc;
	if (_tmp11_ != NULL) {
		_tmp10_ = TRUE;
	} else {
		ZeitgeistWhereClause* _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = where;
		_tmp13_ = zeitgeist_where_clause_has_non_timestamp_condition (_tmp12_);
		_tmp10_ = !_tmp13_;
	}
	if (_tmp10_) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp14_ = field;
		_tmp15_ = aggregation_type;
		_tmp16_ = aggregation_sql;
		_tmp17_ = where_sql;
		_tmp18_ = field;
		_tmp19_ = field;
		_tmp20_ = order_sql;
		_tmp21_ = g_strdup_printf ("\n" \
"                SELECT id FROM event\n" \
"                NATURAL JOIN (\n" \
"                    SELECT %s,\n" \
"                    %s(timestamp) AS timestamp\n" \
"                    %s\n" \
"                    FROM event_view WHERE %s\n" \
"                    GROUP BY %s)\n" \
"                GROUP BY %s\n" \
"                ORDER BY %s \n" \
"                ", _tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
		result = _tmp21_;
		_g_free0 (where_sql);
		_g_free0 (order_sql);
		_g_free0 (aggregation_sql);
		return result;
	}
	_tmp22_ = aggregation_type;
	_tmp23_ = where_sql;
	_tmp24_ = field;
	_tmp25_ = field;
	_tmp26_ = g_strdup_printf ("\n" \
"            SELECT id, %s(timestamp) AS timestamp\n" \
"                FROM event_view WHERE %s AND %s IS NOT NULL\n" \
"            GROUP BY %s\n" \
"            ORDER BY\n" \
"            ", _tmp22_, _tmp23_, _tmp24_, _tmp25_);
	result = _tmp26_;
	_g_free0 (where_sql);
	_g_free0 (order_sql);
	_g_free0 (aggregation_sql);
	return result;
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self, GPtrArray* templates, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
	where = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ZeitgeistEvent* event_template = NULL;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_;
				ZeitgeistEvent* _tmp10_;
				ZeitgeistWhereClause* _tmp11_ = NULL;
				ZeitgeistEvent* _tmp12_;
				ZeitgeistWhereClause* _tmp13_;
				ZeitgeistWhereClause* _tmp14_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = templates;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = templates;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp9_);
				event_template = _tmp10_;
				_tmp12_ = event_template;
				_tmp13_ = zeitgeist_db_reader_get_where_clause_from_event_template (self, _tmp12_, &_inner_error_);
				_tmp11_ = _tmp13_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						return NULL;
					} else {
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp14_ = where;
				zeitgeist_where_clause_extend (_tmp14_, _tmp11_);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (event_template);
			}
		}
	}
	result = where;
	return result;
}


static ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self, ZeitgeistEvent* template, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	ZeitgeistEvent* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	ZeitgeistEvent* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	ZeitgeistEvent* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gboolean _tmp45_;
	ZeitgeistEvent* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gboolean _tmp64_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (template != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = template;
	_tmp2_ = zeitgeist_event_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((guint32) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistEvent* _tmp5_;
		guint32 _tmp6_;
		guint32 _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = template;
		_tmp6_ = zeitgeist_event_get_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, "id=?", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = template;
	_tmp11_ = zeitgeist_event_get_interpretation (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = zeitgeist_utils_is_empty_string (_tmp12_);
	if (!_tmp13_) {
		ZeitgeistEvent* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ZeitgeistWhereClause* subwhere = NULL;
		ZeitgeistEvent* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ZeitgeistSQLiteTableLookup* _tmp20_;
		ZeitgeistWhereClause* _tmp21_;
		ZeitgeistWhereClause* _tmp22_;
		gboolean _tmp23_;
		_tmp14_ = template;
		_tmp15_ = zeitgeist_event_get_interpretation (_tmp14_);
		_tmp16_ = _tmp15_;
		zeitgeist_db_reader_assert_no_wildcard (self, "interpretation", _tmp16_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp17_ = template;
		_tmp18_ = zeitgeist_event_get_interpretation (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->interpretations_table;
		_tmp21_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "interpretation", _tmp19_, _tmp20_, &_inner_error_);
		subwhere = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp22_ = subwhere;
		_tmp23_ = zeitgeist_where_clause_is_empty (_tmp22_);
		if (!_tmp23_) {
			ZeitgeistWhereClause* _tmp24_;
			ZeitgeistWhereClause* _tmp25_;
			_tmp24_ = where;
			_tmp25_ = subwhere;
			zeitgeist_where_clause_extend (_tmp24_, _tmp25_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp26_ = template;
	_tmp27_ = zeitgeist_event_get_manifestation (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = zeitgeist_utils_is_empty_string (_tmp28_);
	if (!_tmp29_) {
		ZeitgeistEvent* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		ZeitgeistWhereClause* subwhere = NULL;
		ZeitgeistEvent* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ZeitgeistSQLiteTableLookup* _tmp36_;
		ZeitgeistWhereClause* _tmp37_;
		ZeitgeistWhereClause* _tmp38_;
		gboolean _tmp39_;
		_tmp30_ = template;
		_tmp31_ = zeitgeist_event_get_interpretation (_tmp30_);
		_tmp32_ = _tmp31_;
		zeitgeist_db_reader_assert_no_wildcard (self, "manifestation", _tmp32_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp33_ = template;
		_tmp34_ = zeitgeist_event_get_manifestation (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->manifestations_table;
		_tmp37_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "manifestation", _tmp35_, _tmp36_, &_inner_error_);
		subwhere = _tmp37_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp38_ = subwhere;
		_tmp39_ = zeitgeist_where_clause_is_empty (_tmp38_);
		if (!_tmp39_) {
			ZeitgeistWhereClause* _tmp40_;
			ZeitgeistWhereClause* _tmp41_;
			_tmp40_ = where;
			_tmp41_ = subwhere;
			zeitgeist_where_clause_extend (_tmp40_, _tmp41_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp42_ = template;
	_tmp43_ = zeitgeist_event_get_actor (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = zeitgeist_utils_is_empty_string (_tmp44_);
	if (!_tmp45_) {
		gchar* val = NULL;
		ZeitgeistEvent* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gboolean like = FALSE;
		gboolean _tmp50_;
		gboolean negated = FALSE;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp46_ = template;
		_tmp47_ = zeitgeist_event_get_actor (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup (_tmp48_);
		val = _tmp49_;
		_tmp50_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp50_;
		_tmp51_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp51_;
		_tmp52_ = like;
		if (_tmp52_) {
			ZeitgeistWhereClause* _tmp53_;
			const gchar* _tmp54_;
			gboolean _tmp55_;
			_tmp53_ = where;
			_tmp54_ = val;
			_tmp55_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp53_, "actor", _tmp54_, _tmp55_);
		} else {
			ZeitgeistWhereClause* _tmp56_;
			ZeitgeistSQLiteTableLookup* _tmp57_;
			const gchar* _tmp58_;
			gint _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = where;
			_tmp57_ = self->actors_table;
			_tmp58_ = val;
			_tmp59_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp57_, _tmp58_);
			_tmp60_ = negated;
			zeitgeist_where_clause_add_match_condition (_tmp56_, "actor", _tmp59_, _tmp60_);
		}
		_g_free0 (val);
	}
	_tmp61_ = template;
	_tmp62_ = zeitgeist_event_get_origin (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = zeitgeist_utils_is_empty_string (_tmp63_);
	if (!_tmp64_) {
		gchar* val = NULL;
		ZeitgeistEvent* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gboolean like = FALSE;
		gboolean _tmp69_;
		gboolean negated = FALSE;
		gboolean _tmp70_;
		const gchar* _tmp71_;
		gboolean _tmp72_;
		_tmp65_ = template;
		_tmp66_ = zeitgeist_event_get_origin (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strdup (_tmp67_);
		val = _tmp68_;
		_tmp69_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp69_;
		_tmp70_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp70_;
		_tmp71_ = val;
		zeitgeist_db_reader_assert_no_noexpand (self, _tmp71_, "origin", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_free0 (val);
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp72_ = like;
		if (_tmp72_) {
			ZeitgeistWhereClause* _tmp73_;
			const gchar* _tmp74_;
			gboolean _tmp75_;
			_tmp73_ = where;
			_tmp74_ = val;
			_tmp75_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp73_, "origin", _tmp74_, _tmp75_);
		} else {
			ZeitgeistWhereClause* _tmp76_;
			const gchar* _tmp77_;
			gboolean _tmp78_;
			_tmp76_ = where;
			_tmp77_ = val;
			_tmp78_ = negated;
			zeitgeist_where_clause_add_text_condition_subquery (_tmp76_, "origin", _tmp77_, _tmp78_);
		}
		_g_free0 (val);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp79_ = FALSE;
			_tmp79_ = TRUE;
			while (TRUE) {
				gint _tmp81_;
				ZeitgeistEvent* _tmp82_;
				gint _tmp83_;
				ZeitgeistSubject* subject_template = NULL;
				ZeitgeistEvent* _tmp84_;
				GPtrArray* _tmp85_;
				GPtrArray* _tmp86_;
				gint _tmp87_;
				gconstpointer _tmp88_;
				ZeitgeistSubject* _tmp89_;
				ZeitgeistSubject* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				gboolean _tmp93_;
				ZeitgeistSubject* _tmp106_;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				gboolean _tmp109_;
				ZeitgeistSubject* _tmp122_;
				const gchar* _tmp123_;
				const gchar* _tmp124_;
				gboolean _tmp125_;
				ZeitgeistSubject* _tmp142_;
				const gchar* _tmp143_;
				const gchar* _tmp144_;
				gboolean _tmp145_;
				ZeitgeistSubject* _tmp160_;
				const gchar* _tmp161_;
				const gchar* _tmp162_;
				gboolean _tmp163_;
				ZeitgeistSubject* _tmp178_;
				const gchar* _tmp179_;
				const gchar* _tmp180_;
				gboolean _tmp181_;
				ZeitgeistSubject* _tmp186_;
				const gchar* _tmp187_;
				const gchar* _tmp188_;
				gboolean _tmp189_;
				ZeitgeistSubject* _tmp204_;
				const gchar* _tmp205_;
				const gchar* _tmp206_;
				gboolean _tmp207_;
				ZeitgeistSubject* _tmp222_;
				const gchar* _tmp223_;
				const gchar* _tmp224_;
				gboolean _tmp225_;
				if (!_tmp79_) {
					gint _tmp80_;
					_tmp80_ = i;
					i = _tmp80_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp81_ = i;
				_tmp82_ = template;
				_tmp83_ = zeitgeist_event_num_subjects (_tmp82_);
				if (!(_tmp81_ < _tmp83_)) {
					break;
				}
				_tmp84_ = template;
				_tmp85_ = zeitgeist_event_get_subjects (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = i;
				_tmp88_ = g_ptr_array_index (_tmp86_, (guint) _tmp87_);
				_tmp89_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp88_);
				subject_template = _tmp89_;
				_tmp90_ = subject_template;
				_tmp91_ = zeitgeist_subject_get_interpretation (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = zeitgeist_utils_is_empty_string (_tmp92_);
				if (!_tmp93_) {
					ZeitgeistEvent* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					ZeitgeistWhereClause* subwhere = NULL;
					ZeitgeistSubject* _tmp97_;
					const gchar* _tmp98_;
					const gchar* _tmp99_;
					ZeitgeistSQLiteTableLookup* _tmp100_;
					ZeitgeistWhereClause* _tmp101_;
					ZeitgeistWhereClause* _tmp102_;
					gboolean _tmp103_;
					_tmp94_ = template;
					_tmp95_ = zeitgeist_event_get_interpretation (_tmp94_);
					_tmp96_ = _tmp95_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject interpretation", _tmp96_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp97_ = subject_template;
					_tmp98_ = zeitgeist_subject_get_interpretation (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = self->interpretations_table;
					_tmp101_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_interpretation", _tmp99_, _tmp100_, &_inner_error_);
					subwhere = _tmp101_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp102_ = subwhere;
					_tmp103_ = zeitgeist_where_clause_is_empty (_tmp102_);
					if (!_tmp103_) {
						ZeitgeistWhereClause* _tmp104_;
						ZeitgeistWhereClause* _tmp105_;
						_tmp104_ = where;
						_tmp105_ = subwhere;
						zeitgeist_where_clause_extend (_tmp104_, _tmp105_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp106_ = subject_template;
				_tmp107_ = zeitgeist_subject_get_manifestation (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = zeitgeist_utils_is_empty_string (_tmp108_);
				if (!_tmp109_) {
					ZeitgeistSubject* _tmp110_;
					const gchar* _tmp111_;
					const gchar* _tmp112_;
					ZeitgeistWhereClause* subwhere = NULL;
					ZeitgeistSubject* _tmp113_;
					const gchar* _tmp114_;
					const gchar* _tmp115_;
					ZeitgeistSQLiteTableLookup* _tmp116_;
					ZeitgeistWhereClause* _tmp117_;
					ZeitgeistWhereClause* _tmp118_;
					gboolean _tmp119_;
					_tmp110_ = subject_template;
					_tmp111_ = zeitgeist_subject_get_manifestation (_tmp110_);
					_tmp112_ = _tmp111_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject manifestation", _tmp112_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp113_ = subject_template;
					_tmp114_ = zeitgeist_subject_get_manifestation (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = self->manifestations_table;
					_tmp117_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_manifestation", _tmp115_, _tmp116_, &_inner_error_);
					subwhere = _tmp117_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp118_ = subwhere;
					_tmp119_ = zeitgeist_where_clause_is_empty (_tmp118_);
					if (!_tmp119_) {
						ZeitgeistWhereClause* _tmp120_;
						ZeitgeistWhereClause* _tmp121_;
						_tmp120_ = where;
						_tmp121_ = subwhere;
						zeitgeist_where_clause_extend (_tmp120_, _tmp121_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp122_ = subject_template;
				_tmp123_ = zeitgeist_subject_get_mimetype (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp125_ = zeitgeist_utils_is_empty_string (_tmp124_);
				if (!_tmp125_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp126_;
					const gchar* _tmp127_;
					const gchar* _tmp128_;
					gchar* _tmp129_;
					gboolean like = FALSE;
					gboolean _tmp130_;
					gboolean negated = FALSE;
					gboolean _tmp131_;
					const gchar* _tmp132_;
					gboolean _tmp133_;
					_tmp126_ = subject_template;
					_tmp127_ = zeitgeist_subject_get_mimetype (_tmp126_);
					_tmp128_ = _tmp127_;
					_tmp129_ = g_strdup (_tmp128_);
					val = _tmp129_;
					_tmp130_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp130_;
					_tmp131_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp131_;
					_tmp132_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp132_, "mime-type", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp133_ = like;
					if (_tmp133_) {
						ZeitgeistWhereClause* _tmp134_;
						const gchar* _tmp135_;
						gboolean _tmp136_;
						_tmp134_ = where;
						_tmp135_ = val;
						_tmp136_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp134_, "subj_mimetype", _tmp135_, _tmp136_);
					} else {
						ZeitgeistWhereClause* _tmp137_;
						ZeitgeistSQLiteTableLookup* _tmp138_;
						const gchar* _tmp139_;
						gint _tmp140_;
						gboolean _tmp141_;
						_tmp137_ = where;
						_tmp138_ = self->mimetypes_table;
						_tmp139_ = val;
						_tmp140_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp138_, _tmp139_);
						_tmp141_ = negated;
						zeitgeist_where_clause_add_match_condition (_tmp137_, "subj_mimetype", _tmp140_, _tmp141_);
					}
					_g_free0 (val);
				}
				_tmp142_ = subject_template;
				_tmp143_ = zeitgeist_subject_get_uri (_tmp142_);
				_tmp144_ = _tmp143_;
				_tmp145_ = zeitgeist_utils_is_empty_string (_tmp144_);
				if (!_tmp145_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp146_;
					const gchar* _tmp147_;
					const gchar* _tmp148_;
					gchar* _tmp149_;
					gboolean like = FALSE;
					gboolean _tmp150_;
					gboolean negated = FALSE;
					gboolean _tmp151_;
					const gchar* _tmp152_;
					gboolean _tmp153_;
					_tmp146_ = subject_template;
					_tmp147_ = zeitgeist_subject_get_uri (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = g_strdup (_tmp148_);
					val = _tmp149_;
					_tmp150_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp150_;
					_tmp151_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp151_;
					_tmp152_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp152_, "uri", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp153_ = like;
					if (_tmp153_) {
						ZeitgeistWhereClause* _tmp154_;
						const gchar* _tmp155_;
						gboolean _tmp156_;
						_tmp154_ = where;
						_tmp155_ = val;
						_tmp156_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp154_, "subj_id", _tmp155_, _tmp156_);
					} else {
						ZeitgeistWhereClause* _tmp157_;
						const gchar* _tmp158_;
						gboolean _tmp159_;
						_tmp157_ = where;
						_tmp158_ = val;
						_tmp159_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp157_, "subj_id", _tmp158_, _tmp159_);
					}
					_g_free0 (val);
				}
				_tmp160_ = subject_template;
				_tmp161_ = zeitgeist_subject_get_origin (_tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = zeitgeist_utils_is_empty_string (_tmp162_);
				if (!_tmp163_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp164_;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
					gchar* _tmp167_;
					gboolean like = FALSE;
					gboolean _tmp168_;
					gboolean negated = FALSE;
					gboolean _tmp169_;
					const gchar* _tmp170_;
					gboolean _tmp171_;
					_tmp164_ = subject_template;
					_tmp165_ = zeitgeist_subject_get_origin (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = g_strdup (_tmp166_);
					val = _tmp167_;
					_tmp168_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp168_;
					_tmp169_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp169_;
					_tmp170_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp170_, "subject origin", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp171_ = like;
					if (_tmp171_) {
						ZeitgeistWhereClause* _tmp172_;
						const gchar* _tmp173_;
						gboolean _tmp174_;
						_tmp172_ = where;
						_tmp173_ = val;
						_tmp174_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp172_, "subj_origin", _tmp173_, _tmp174_);
					} else {
						ZeitgeistWhereClause* _tmp175_;
						const gchar* _tmp176_;
						gboolean _tmp177_;
						_tmp175_ = where;
						_tmp176_ = val;
						_tmp177_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp175_, "subj_origin", _tmp176_, _tmp177_);
					}
					_g_free0 (val);
				}
				_tmp178_ = subject_template;
				_tmp179_ = zeitgeist_subject_get_text (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = zeitgeist_utils_is_empty_string (_tmp180_);
				if (!_tmp181_) {
					ZeitgeistWhereClause* _tmp182_;
					ZeitgeistSubject* _tmp183_;
					const gchar* _tmp184_;
					const gchar* _tmp185_;
					_tmp182_ = where;
					_tmp183_ = subject_template;
					_tmp184_ = zeitgeist_subject_get_text (_tmp183_);
					_tmp185_ = _tmp184_;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp182_, "subj_text_id", _tmp185_, FALSE);
				}
				_tmp186_ = subject_template;
				_tmp187_ = zeitgeist_subject_get_current_uri (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp189_ = zeitgeist_utils_is_empty_string (_tmp188_);
				if (!_tmp189_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp190_;
					const gchar* _tmp191_;
					const gchar* _tmp192_;
					gchar* _tmp193_;
					gboolean like = FALSE;
					gboolean _tmp194_;
					gboolean negated = FALSE;
					gboolean _tmp195_;
					const gchar* _tmp196_;
					gboolean _tmp197_;
					_tmp190_ = subject_template;
					_tmp191_ = zeitgeist_subject_get_current_uri (_tmp190_);
					_tmp192_ = _tmp191_;
					_tmp193_ = g_strdup (_tmp192_);
					val = _tmp193_;
					_tmp194_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp194_;
					_tmp195_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp195_;
					_tmp196_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp196_, "current_uri", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp197_ = like;
					if (_tmp197_) {
						ZeitgeistWhereClause* _tmp198_;
						const gchar* _tmp199_;
						gboolean _tmp200_;
						_tmp198_ = where;
						_tmp199_ = val;
						_tmp200_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp198_, "subj_id_current", _tmp199_, _tmp200_);
					} else {
						ZeitgeistWhereClause* _tmp201_;
						const gchar* _tmp202_;
						gboolean _tmp203_;
						_tmp201_ = where;
						_tmp202_ = val;
						_tmp203_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp201_, "subj_id_current", _tmp202_, _tmp203_);
					}
					_g_free0 (val);
				}
				_tmp204_ = subject_template;
				_tmp205_ = zeitgeist_subject_get_current_origin (_tmp204_);
				_tmp206_ = _tmp205_;
				_tmp207_ = zeitgeist_utils_is_empty_string (_tmp206_);
				if (!_tmp207_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp208_;
					const gchar* _tmp209_;
					const gchar* _tmp210_;
					gchar* _tmp211_;
					gboolean like = FALSE;
					gboolean _tmp212_;
					gboolean negated = FALSE;
					gboolean _tmp213_;
					const gchar* _tmp214_;
					gboolean _tmp215_;
					_tmp208_ = subject_template;
					_tmp209_ = zeitgeist_subject_get_current_origin (_tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = g_strdup (_tmp210_);
					val = _tmp211_;
					_tmp212_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp212_;
					_tmp213_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp213_;
					_tmp214_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp214_, "current_origin", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp215_ = like;
					if (_tmp215_) {
						ZeitgeistWhereClause* _tmp216_;
						const gchar* _tmp217_;
						gboolean _tmp218_;
						_tmp216_ = where;
						_tmp217_ = val;
						_tmp218_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp216_, "subj_origin_current", _tmp217_, _tmp218_);
					} else {
						ZeitgeistWhereClause* _tmp219_;
						const gchar* _tmp220_;
						gboolean _tmp221_;
						_tmp219_ = where;
						_tmp220_ = val;
						_tmp221_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp219_, "subj_origin_current", _tmp220_, _tmp221_);
					}
					_g_free0 (val);
				}
				_tmp222_ = subject_template;
				_tmp223_ = zeitgeist_subject_get_storage (_tmp222_);
				_tmp224_ = _tmp223_;
				_tmp225_ = zeitgeist_utils_is_empty_string (_tmp224_);
				if (!_tmp225_) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp226_;
					const gchar* _tmp227_;
					const gchar* _tmp228_;
					gchar* _tmp229_;
					const gchar* _tmp230_;
					const gchar* _tmp231_;
					const gchar* _tmp232_;
					ZeitgeistWhereClause* _tmp233_;
					const gchar* _tmp234_;
					_tmp226_ = subject_template;
					_tmp227_ = zeitgeist_subject_get_storage (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = g_strdup (_tmp228_);
					val = _tmp229_;
					_tmp230_ = val;
					zeitgeist_db_reader_assert_no_negation (self, "subject storage", _tmp230_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp231_ = val;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject storage", _tmp231_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp232_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp232_, "subject storage", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp233_ = where;
					_tmp234_ = val;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp233_, "subj_storage_id", _tmp234_, FALSE);
					_g_free0 (val);
				}
				_g_object_unref0 (subject_template);
			}
		}
	}
	result = where;
	return result;
}


/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* error_message = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp1_ = val;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = val;
		_tmp3_ = g_str_has_prefix (_tmp2_, "!");
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = field;
	_tmp5_ = g_strdup_printf ("Field '%s' doesn't support negation", _tmp4_);
	error_message = _tmp5_;
	_tmp6_ = error_message;
	g_warning ("db-reader.vala:860: %s", _tmp6_);
	_tmp7_ = error_message;
	_tmp8_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp7_);
	_inner_error_ = _tmp8_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* error_message = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp1_ = val;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = val;
		_tmp3_ = g_str_has_prefix (_tmp2_, "+");
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = field;
	_tmp5_ = g_strdup_printf ("Field '%s' doesn't support the no-expand operator", _tmp4_);
	error_message = _tmp5_;
	_tmp6_ = error_message;
	g_warning ("db-reader.vala:876: %s", _tmp6_);
	_tmp7_ = error_message;
	_tmp8_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp7_);
	_inner_error_ = _tmp8_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


/**
     * If the value ends with the wildcard character, throw an error.
     */
void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* error_message = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp1_ = val;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = val;
		_tmp3_ = g_str_has_suffix (_tmp2_, "*");
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = field;
	_tmp5_ = g_strdup_printf ("Field '%s' doesn't support prefix search", _tmp4_);
	error_message = _tmp5_;
	_tmp6_ = error_message;
	g_warning ("db-reader.vala:891: %s", _tmp6_);
	_tmp7_ = error_message;
	_tmp8_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp7_);
	_inner_error_ = _tmp8_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	gchar* _symbol = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean negated = FALSE;
	gboolean _tmp2_;
	gboolean noexpand = FALSE;
	gboolean _tmp3_;
	GList* symbols = NULL;
	gboolean _tmp4_;
	const gchar* _tmp7_;
	ZeitgeistWhereClause* subwhere = NULL;
	gboolean _tmp8_;
	ZeitgeistWhereClause* _tmp9_;
	GList* _tmp10_;
	guint _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (lookup_table != NULL, NULL);
	_tmp0_ = symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_symbol = _tmp1_;
	_tmp2_ = zeitgeist_utils_parse_negation (&_symbol);
	negated = _tmp2_;
	_tmp3_ = zeitgeist_utils_parse_noexpand (&_symbol);
	noexpand = _tmp3_;
	_tmp4_ = noexpand;
	if (_tmp4_) {
		_g_list_free0 (symbols);
		symbols = NULL;
	} else {
		const gchar* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = _symbol;
		_tmp6_ = zeitgeist_symbol_get_all_children (_tmp5_);
		_g_list_free0 (symbols);
		symbols = _tmp6_;
	}
	_tmp7_ = _symbol;
	symbols = g_list_prepend (symbols, _tmp7_);
	_tmp8_ = negated;
	_tmp9_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, _tmp8_);
	subwhere = _tmp9_;
	_tmp10_ = symbols;
	_tmp11_ = g_list_length (_tmp10_);
	if (_tmp11_ == ((guint) 1)) {
		ZeitgeistWhereClause* _tmp12_;
		const gchar* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		_tmp12_ = subwhere;
		_tmp13_ = table_name;
		_tmp14_ = lookup_table;
		_tmp15_ = _symbol;
		_tmp16_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp14_, _tmp15_);
		zeitgeist_where_clause_add_match_condition (_tmp12_, _tmp13_, _tmp16_, FALSE);
	} else {
		gchar* sql = NULL;
		gchar* _tmp17_;
		gchar* sub_sql = NULL;
		gchar* _tmp18_;
		gboolean first = FALSE;
		GList* _tmp19_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		ZeitgeistWhereClause* _tmp34_;
		const gchar* _tmp35_;
		_tmp17_ = g_strdup ("(%s)");
		sql = _tmp17_;
		_tmp18_ = g_strdup ("");
		sub_sql = _tmp18_;
		first = TRUE;
		_tmp19_ = symbols;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp19_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				const gchar* uri = NULL;
				uri = (const gchar*) uri_it->data;
				{
					gboolean _tmp20_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					ZeitgeistSQLiteTableLookup* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp20_ = first;
					if (!_tmp20_) {
						const gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp21_ = sub_sql;
						_tmp22_ = g_strconcat (_tmp21_, " OR ", NULL);
						_g_free0 (sub_sql);
						sub_sql = _tmp22_;
					}
					_tmp23_ = sub_sql;
					_tmp24_ = table_name;
					_tmp25_ = lookup_table;
					_tmp26_ = uri;
					_tmp27_ = zeitgeist_sq_lite_table_lookup_id_try_string (_tmp25_, _tmp26_);
					_tmp28_ = g_strdup_printf ("%s = %i ", _tmp24_, _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat (_tmp23_, _tmp29_, NULL);
					_g_free0 (sub_sql);
					sub_sql = _tmp30_;
					_g_free0 (_tmp29_);
					first = FALSE;
				}
			}
		}
		_tmp31_ = sql;
		_tmp32_ = sub_sql;
		_tmp33_ = g_strdup_printf (_tmp31_, _tmp32_);
		_g_free0 (sql);
		sql = _tmp33_;
		_tmp34_ = subwhere;
		_tmp35_ = sql;
		zeitgeist_where_clause_add (_tmp34_, _tmp35_, NULL);
		_g_free0 (sub_sql);
		_g_free0 (sql);
	}
	result = subwhere;
	_g_list_free0 (symbols);
	_g_free0 (_symbol);
	return result;
}


static void zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self, const gchar* table, gint64 rowid) {
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	const gchar* _tmp0_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	gint64 _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = table;
	if (g_strcmp0 (_tmp0_, "interpretation") == 0) {
		ZeitgeistSQLiteTableLookup* _tmp1_;
		ZeitgeistSQLiteTableLookup* _tmp2_;
		_tmp1_ = self->interpretations_table;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (table_lookup);
		table_lookup = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = table;
		if (g_strcmp0 (_tmp3_, "manifestation") == 0) {
			ZeitgeistSQLiteTableLookup* _tmp4_;
			ZeitgeistSQLiteTableLookup* _tmp5_;
			_tmp4_ = self->manifestations_table;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (table_lookup);
			table_lookup = _tmp5_;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = table;
			if (g_strcmp0 (_tmp6_, "mimetype") == 0) {
				ZeitgeistSQLiteTableLookup* _tmp7_;
				ZeitgeistSQLiteTableLookup* _tmp8_;
				_tmp7_ = self->mimetypes_table;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (table_lookup);
				table_lookup = _tmp8_;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = table;
				if (g_strcmp0 (_tmp9_, "actor") == 0) {
					ZeitgeistSQLiteTableLookup* _tmp10_;
					ZeitgeistSQLiteTableLookup* _tmp11_;
					_tmp10_ = self->actors_table;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (table_lookup);
					table_lookup = _tmp11_;
				} else {
					_g_object_unref0 (table_lookup);
					return;
				}
			}
		}
	}
	_tmp12_ = table_lookup;
	_tmp13_ = rowid;
	zeitgeist_sq_lite_table_lookup_remove (_tmp12_, (gint) _tmp13_);
	_g_object_unref0 (table_lookup);
}


ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self) {
	ZeitgeistSQLiteDatabase* result;
	ZeitgeistSQLiteDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_database;
	result = _tmp0_;
	return result;
}


static void zeitgeist_db_reader_set_database (ZeitgeistDbReader* self, ZeitgeistSQLiteDatabase* value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_db_reader_get_database (self) != value) {
		ZeitgeistSQLiteDatabase* _tmp0_;
		ZeitgeistSQLiteDatabase* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_database);
		self->priv->_database = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_DATABASE_PROPERTY]);
	}
}


static void _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self) {
	zeitgeist_db_reader_delete_from_cache ((ZeitgeistDbReader*) self, table, rowid);
}


static GObject * zeitgeist_db_reader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistDbReader * self;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp21_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_db_reader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_set_deletion_callback (_tmp0_, _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->_database;
	_tmp2_ = _tmp1_->database;
	self->db = _tmp2_;
	{
		ZeitgeistSQLiteTableLookup* _tmp3_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp4_;
		ZeitgeistSQLiteTableLookup* _tmp5_;
		ZeitgeistSQLiteTableLookup* _tmp6_;
		ZeitgeistSQLiteTableLookup* _tmp7_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp8_;
		ZeitgeistSQLiteTableLookup* _tmp9_;
		ZeitgeistSQLiteTableLookup* _tmp10_;
		ZeitgeistSQLiteTableLookup* _tmp11_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp12_;
		ZeitgeistSQLiteTableLookup* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		ZeitgeistSQLiteTableLookup* _tmp15_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp16_;
		ZeitgeistSQLiteTableLookup* _tmp17_;
		ZeitgeistSQLiteTableLookup* _tmp18_;
		_tmp4_ = self->priv->_database;
		_tmp5_ = zeitgeist_sq_lite_table_lookup_new (_tmp4_, "interpretation", &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->interpretations_table);
		self->interpretations_table = _tmp6_;
		_tmp8_ = self->priv->_database;
		_tmp9_ = zeitgeist_sq_lite_table_lookup_new (_tmp8_, "manifestation", &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp3_);
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			_g_object_unref0 (_tmp3_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->manifestations_table);
		self->manifestations_table = _tmp10_;
		_tmp12_ = self->priv->_database;
		_tmp13_ = zeitgeist_sq_lite_table_lookup_new (_tmp12_, "mimetype", &_inner_error_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->mimetypes_table);
		self->mimetypes_table = _tmp14_;
		_tmp16_ = self->priv->_database;
		_tmp17_ = zeitgeist_sq_lite_table_lookup_new (_tmp16_, "actor", &_inner_error_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch1_zeitgeist_engine_error;
			}
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (self->actors_table);
		self->actors_table = _tmp18_;
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally1;
	__catch1_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = err;
		_tmp20_ = _tmp19_->message;
		g_critical ("db-reader.vala:68: TableLookup initialization failed: %s", _tmp20_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp21_ = self->priv->_database;
	zeitgeist_sq_lite_database_set_cache_size (_tmp21_, 128);
	return obj;
}


static void zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self, ZeitgeistDbReaderRelatedUri* dest) {
	guint32 _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint32 _tmp4_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).timestamp;
	(*dest).timestamp = _tmp1_;
	_tmp2_ = (*self).uri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp3_;
	_tmp4_ = (*self).counter;
	(*dest).counter = _tmp4_;
}


static void zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self) {
	_g_free0 ((*self).uri);
}


static ZeitgeistDbReaderRelatedUri* zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self) {
	ZeitgeistDbReaderRelatedUri* dup;
	dup = g_new0 (ZeitgeistDbReaderRelatedUri, 1);
	zeitgeist_db_reader_related_uri_copy (self, dup);
	return dup;
}


static void zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self) {
	zeitgeist_db_reader_related_uri_destroy (self);
	g_free (self);
}


static GType zeitgeist_db_reader_related_uri_get_type (void) {
	static volatile gsize zeitgeist_db_reader_related_uri_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_related_uri_type_id__volatile)) {
		GType zeitgeist_db_reader_related_uri_type_id;
		zeitgeist_db_reader_related_uri_type_id = g_boxed_type_register_static ("ZeitgeistDbReaderRelatedUri", (GBoxedCopyFunc) zeitgeist_db_reader_related_uri_dup, (GBoxedFreeFunc) zeitgeist_db_reader_related_uri_free);
		g_once_init_leave (&zeitgeist_db_reader_related_uri_type_id__volatile, zeitgeist_db_reader_related_uri_type_id);
	}
	return zeitgeist_db_reader_related_uri_type_id__volatile;
}


static void zeitgeist_db_reader_class_init (ZeitgeistDbReaderClass * klass) {
	zeitgeist_db_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDbReaderPrivate));
	((ZeitgeistDbReaderClass *) klass)->close = (void (*) (ZeitgeistDbReader *)) zeitgeist_db_reader_real_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_db_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_db_reader_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_db_reader_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_db_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DB_READER_DATABASE_PROPERTY, zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_DATABASE_PROPERTY] = g_param_spec_object ("database", "database", "database", ZEITGEIST_SQ_LITE_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void zeitgeist_db_reader_instance_init (ZeitgeistDbReader * self) {
	self->priv = ZEITGEIST_DB_READER_GET_PRIVATE (self);
}


static void zeitgeist_db_reader_finalize (GObject * obj) {
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	_g_object_unref0 (self->priv->_database);
	_g_object_unref0 (self->interpretations_table);
	_g_object_unref0 (self->manifestations_table);
	_g_object_unref0 (self->mimetypes_table);
	_g_object_unref0 (self->actors_table);
	G_OBJECT_CLASS (zeitgeist_db_reader_parent_class)->finalize (obj);
}


GType zeitgeist_db_reader_get_type (void) {
	static volatile gsize zeitgeist_db_reader_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDbReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_db_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDbReader), 0, (GInstanceInitFunc) zeitgeist_db_reader_instance_init, NULL };
		GType zeitgeist_db_reader_type_id;
		zeitgeist_db_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDbReader", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_db_reader_type_id__volatile, zeitgeist_db_reader_type_id);
	}
	return zeitgeist_db_reader_type_id__volatile;
}


static void _vala_zeitgeist_db_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE_PROPERTY:
		g_value_set_object (value, zeitgeist_db_reader_get_database (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_db_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE_PROPERTY:
		zeitgeist_db_reader_set_database (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



