/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMWebKitPoint.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMWebKitPointPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_WEBKIT_POINT_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_WEBKIT_POINT, WebKitDOMWebKitPointPrivate)

typedef struct _WebKitDOMWebKitPointPrivate {
    RefPtr<WebCore::WebKitPoint> coreObject;
} WebKitDOMWebKitPointPrivate;

namespace WebKit {

WebKitDOMWebKitPoint* kit(WebCore::WebKitPoint* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_WEBKIT_POINT(ret);

    return wrapWebKitPoint(obj);
}

WebCore::WebKitPoint* core(WebKitDOMWebKitPoint* request)
{
    return request ? static_cast<WebCore::WebKitPoint*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMWebKitPoint* wrapWebKitPoint(WebCore::WebKitPoint* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_WEBKIT_POINT(g_object_new(WEBKIT_TYPE_DOM_WEBKIT_POINT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMWebKitPoint, webkit_dom_webkit_point, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_X,
    PROP_Y,
};

static void webkit_dom_webkit_point_finalize(GObject* object)
{
    WebKitDOMWebKitPointPrivate* priv = WEBKIT_DOM_WEBKIT_POINT_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMWebKitPointPrivate();
    G_OBJECT_CLASS(webkit_dom_webkit_point_parent_class)->finalize(object);
}

static void webkit_dom_webkit_point_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMWebKitPoint* self = WEBKIT_DOM_WEBKIT_POINT(object);
    WebCore::WebKitPoint* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_X: {
        coreSelf->setX((g_value_get_float(value)));
        break;
    }
    case PROP_Y: {
        coreSelf->setY((g_value_get_float(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_webkit_point_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMWebKitPoint* self = WEBKIT_DOM_WEBKIT_POINT(object);
    WebCore::WebKitPoint* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_X: {
        g_value_set_float(value, coreSelf->x());
        break;
    }
    case PROP_Y: {
        g_value_set_float(value, coreSelf->y());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_webkit_point_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_webkit_point_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMWebKitPointPrivate* priv = WEBKIT_DOM_WEBKIT_POINT_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::WebKitPoint*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_webkit_point_class_init(WebKitDOMWebKitPointClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMWebKitPointPrivate));
    gobjectClass->constructor = webkit_dom_webkit_point_constructor;
    gobjectClass->finalize = webkit_dom_webkit_point_finalize;
    gobjectClass->set_property = webkit_dom_webkit_point_set_property;
    gobjectClass->get_property = webkit_dom_webkit_point_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_X,
                                    g_param_spec_float("x", /* name */
                                                           "web_kit_point_x", /* short description */
                                                           "read-write  gfloat WebKitPoint.x", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_Y,
                                    g_param_spec_float("y", /* name */
                                                           "web_kit_point_y", /* short description */
                                                           "read-write  gfloat WebKitPoint.y", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXFLOAT, /* min */
G_MAXFLOAT, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_webkit_point_init(WebKitDOMWebKitPoint* request)
{
    WebKitDOMWebKitPointPrivate* priv = WEBKIT_DOM_WEBKIT_POINT_GET_PRIVATE(request);
    new (priv) WebKitDOMWebKitPointPrivate();
}

gfloat
webkit_dom_webkit_point_get_x(WebKitDOMWebKitPoint* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(self), 0);
    WebCore::WebKitPoint* item = WebKit::core(self);
    gfloat result = item->x();
    return result;
}

void
webkit_dom_webkit_point_set_x(WebKitDOMWebKitPoint* self, gfloat value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(self));
    WebCore::WebKitPoint* item = WebKit::core(self);
    item->setX(value);
}

gfloat
webkit_dom_webkit_point_get_y(WebKitDOMWebKitPoint* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(self), 0);
    WebCore::WebKitPoint* item = WebKit::core(self);
    gfloat result = item->y();
    return result;
}

void
webkit_dom_webkit_point_set_y(WebKitDOMWebKitPoint* self, gfloat value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(self));
    WebCore::WebKitPoint* item = WebKit::core(self);
    item->setY(value);
}

