/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPerformanceEntryList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPerformanceEntryListPrivate.h"
#include "WebKitDOMPerformanceEntryPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_PERFORMANCE_ENTRY_LIST_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_PERFORMANCE_ENTRY_LIST, WebKitDOMPerformanceEntryListPrivate)

typedef struct _WebKitDOMPerformanceEntryListPrivate {
#if ENABLE(PERFORMANCE_TIMELINE)
    RefPtr<WebCore::PerformanceEntryList> coreObject;
#endif // ENABLE(PERFORMANCE_TIMELINE)
} WebKitDOMPerformanceEntryListPrivate;

#if ENABLE(PERFORMANCE_TIMELINE)

namespace WebKit {

WebKitDOMPerformanceEntryList* kit(WebCore::PerformanceEntryList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PERFORMANCE_ENTRY_LIST(ret);

    return wrapPerformanceEntryList(obj);
}

WebCore::PerformanceEntryList* core(WebKitDOMPerformanceEntryList* request)
{
    return request ? static_cast<WebCore::PerformanceEntryList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPerformanceEntryList* wrapPerformanceEntryList(WebCore::PerformanceEntryList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PERFORMANCE_ENTRY_LIST(g_object_new(WEBKIT_TYPE_DOM_PERFORMANCE_ENTRY_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(PERFORMANCE_TIMELINE)

G_DEFINE_TYPE(WebKitDOMPerformanceEntryList, webkit_dom_performance_entry_list, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_performance_entry_list_finalize(GObject* object)
{
    WebKitDOMPerformanceEntryListPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_LIST_GET_PRIVATE(object);
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(PERFORMANCE_TIMELINE)
    priv->~WebKitDOMPerformanceEntryListPrivate();
    G_OBJECT_CLASS(webkit_dom_performance_entry_list_parent_class)->finalize(object);
}

static void webkit_dom_performance_entry_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKitDOMPerformanceEntryList* self = WEBKIT_DOM_PERFORMANCE_ENTRY_LIST(object);
    WebCore::PerformanceEntryList* coreSelf = WebKit::core(self);
#endif // ENABLE(PERFORMANCE_TIMELINE)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(PERFORMANCE_TIMELINE)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_performance_entry_list_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_performance_entry_list_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(PERFORMANCE_TIMELINE)
    WebKitDOMPerformanceEntryListPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_LIST_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::PerformanceEntryList*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(PERFORMANCE_TIMELINE)
    return object;
}

static void webkit_dom_performance_entry_list_class_init(WebKitDOMPerformanceEntryListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMPerformanceEntryListPrivate));
    gobjectClass->constructor = webkit_dom_performance_entry_list_constructor;
    gobjectClass->finalize = webkit_dom_performance_entry_list_finalize;
    gobjectClass->get_property = webkit_dom_performance_entry_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "performance_entry_list_length", /* short description */
                                                           "read-only  gulong PerformanceEntryList.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_performance_entry_list_init(WebKitDOMPerformanceEntryList* request)
{
    WebKitDOMPerformanceEntryListPrivate* priv = WEBKIT_DOM_PERFORMANCE_ENTRY_LIST_GET_PRIVATE(request);
    new (priv) WebKitDOMPerformanceEntryListPrivate();
}

WebKitDOMPerformanceEntry*
webkit_dom_performance_entry_list_item(WebKitDOMPerformanceEntryList* self, gulong index)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY_LIST(self), 0);
    WebCore::PerformanceEntryList* item = WebKit::core(self);
    RefPtr<WebCore::PerformanceEntry> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return 0;
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

gulong
webkit_dom_performance_entry_list_get_length(WebKitDOMPerformanceEntryList* self)
{
#if ENABLE(PERFORMANCE_TIMELINE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_ENTRY_LIST(self), 0);
    WebCore::PerformanceEntryList* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Performance Timeline")
    return static_cast<gulong>(0);
#endif /* ENABLE(PERFORMANCE_TIMELINE) */
}

