/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLPreElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLPreElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLPreElement* kit(WebCore::HTMLPreElement* obj)
{
    return WEBKIT_DOM_HTML_PRE_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLPreElement* core(WebKitDOMHTMLPreElement* request)
{
    return request ? static_cast<WebCore::HTMLPreElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLPreElement* wrapHTMLPreElement(WebCore::HTMLPreElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_PRE_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_PRE_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLPreElement, webkit_dom_html_pre_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_WIDTH,
    PROP_WRAP,
};

static void webkit_dom_html_pre_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLPreElement* self = WEBKIT_DOM_HTML_PRE_ELEMENT(object);
    WebCore::HTMLPreElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_WIDTH: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::widthAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_WRAP: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::wrapAttr, (g_value_get_boolean(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_pre_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLPreElement* self = WEBKIT_DOM_HTML_PRE_ELEMENT(object);
    WebCore::HTMLPreElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::widthAttr));
        break;
    }
    case PROP_WRAP: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::wrapAttr));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_pre_element_class_init(WebKitDOMHTMLPreElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_pre_element_set_property;
    gobjectClass->get_property = webkit_dom_html_pre_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_pre_element_width", /* short description */
                                                           "read-write  glong HTMLPreElement.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WRAP,
                                    g_param_spec_boolean("wrap", /* name */
                                                           "html_pre_element_wrap", /* short description */
                                                           "read-write  gboolean HTMLPreElement.wrap", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_pre_element_init(WebKitDOMHTMLPreElement* request)
{
}

glong
webkit_dom_html_pre_element_get_width(WebKitDOMHTMLPreElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PRE_ELEMENT(self), 0);
    WebCore::HTMLPreElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::widthAttr);
    return result;
}

void
webkit_dom_html_pre_element_set_width(WebKitDOMHTMLPreElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_PRE_ELEMENT(self));
    WebCore::HTMLPreElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::widthAttr, value);
}

gboolean
webkit_dom_html_pre_element_get_wrap(WebKitDOMHTMLPreElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_PRE_ELEMENT(self), FALSE);
    WebCore::HTMLPreElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::wrapAttr);
    return result;
}

void
webkit_dom_html_pre_element_set_wrap(WebKitDOMHTMLPreElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_PRE_ELEMENT(self));
    WebCore::HTMLPreElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::wrapAttr, value);
}

