/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLIFrameElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMHTMLIFrameElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLIFrameElement* kit(WebCore::HTMLIFrameElement* obj)
{
    return WEBKIT_DOM_HTML_IFRAME_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLIFrameElement* core(WebKitDOMHTMLIFrameElement* request)
{
    return request ? static_cast<WebCore::HTMLIFrameElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLIFrameElement* wrapHTMLIFrameElement(WebCore::HTMLIFrameElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_IFRAME_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_IFRAME_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLIFrameElement, webkit_dom_html_iframe_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALIGN,
    PROP_FRAME_BORDER,
    PROP_HEIGHT,
    PROP_LONG_DESC,
    PROP_MARGIN_HEIGHT,
    PROP_MARGIN_WIDTH,
    PROP_NAME,
    PROP_SANDBOX,
    PROP_SEAMLESS,
    PROP_SCROLLING,
    PROP_SRC,
    PROP_SRCDOC,
    PROP_WIDTH,
    PROP_CONTENT_DOCUMENT,
    PROP_CONTENT_WINDOW,
};

static void webkit_dom_html_iframe_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLIFrameElement* self = WEBKIT_DOM_HTML_IFRAME_ELEMENT(object);
    WebCore::HTMLIFrameElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FRAME_BORDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::frameborderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::heightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_LONG_DESC: {
        coreSelf->setAttribute(WebCore::HTMLNames::longdescAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MARGIN_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::marginheightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MARGIN_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::marginwidthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SANDBOX: {
        coreSelf->setAttribute(WebCore::HTMLNames::sandboxAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SEAMLESS: {
#if ENABLE(IFRAME_SEAMLESS)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::seamlessAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Iframe Seamless")
#endif /* ENABLE(IFRAME_SEAMLESS) */
        break;
    }
    case PROP_SCROLLING: {
        coreSelf->setAttribute(WebCore::HTMLNames::scrollingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SRCDOC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcdocAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_iframe_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLIFrameElement* self = WEBKIT_DOM_HTML_IFRAME_ELEMENT(object);
    WebCore::HTMLIFrameElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_FRAME_BORDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::frameborderAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::heightAttr)));
        break;
    }
    case PROP_LONG_DESC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::longdescAttr)));
        break;
    }
    case PROP_MARGIN_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::marginheightAttr)));
        break;
    }
    case PROP_MARGIN_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::marginwidthAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_SANDBOX: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::sandboxAttr)));
        break;
    }
    case PROP_SEAMLESS: {
#if ENABLE(IFRAME_SEAMLESS)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::seamlessAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Iframe Seamless")
#endif /* ENABLE(IFRAME_SEAMLESS) */
        break;
    }
    case PROP_SCROLLING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::scrollingAttr)));
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_SRCDOC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::srcdocAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    case PROP_CONTENT_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->contentDocument();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONTENT_WINDOW: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->contentWindow();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_iframe_element_class_init(WebKitDOMHTMLIFrameElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_iframe_element_set_property;
    gobjectClass->get_property = webkit_dom_html_iframe_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "htmli_frame_element_align", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FRAME_BORDER,
                                    g_param_spec_string("frame-border", /* name */
                                                           "htmli_frame_element_frame-border", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.frame-border", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_string("height", /* name */
                                                           "htmli_frame_element_height", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LONG_DESC,
                                    g_param_spec_string("long-desc", /* name */
                                                           "htmli_frame_element_long-desc", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.long-desc", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MARGIN_HEIGHT,
                                    g_param_spec_string("margin-height", /* name */
                                                           "htmli_frame_element_margin-height", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.margin-height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MARGIN_WIDTH,
                                    g_param_spec_string("margin-width", /* name */
                                                           "htmli_frame_element_margin-width", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.margin-width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "htmli_frame_element_name", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SANDBOX,
                                    g_param_spec_string("sandbox", /* name */
                                                           "htmli_frame_element_sandbox", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.sandbox", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SEAMLESS,
                                    g_param_spec_boolean("seamless", /* name */
                                                           "htmli_frame_element_seamless", /* short description */
                                                           "read-write  gboolean HTMLIFrameElement.seamless", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLLING,
                                    g_param_spec_string("scrolling", /* name */
                                                           "htmli_frame_element_scrolling", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.scrolling", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "htmli_frame_element_src", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRCDOC,
                                    g_param_spec_string("srcdoc", /* name */
                                                           "htmli_frame_element_srcdoc", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.srcdoc", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "htmli_frame_element_width", /* short description */
                                                           "read-write  gchar* HTMLIFrameElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_DOCUMENT,
                                    g_param_spec_object("content-document", /* name */
                                                           "htmli_frame_element_content-document", /* short description */
                                                           "read-only  WebKitDOMDocument* HTMLIFrameElement.content-document", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_WINDOW,
                                    g_param_spec_object("content-window", /* name */
                                                           "htmli_frame_element_content-window", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* HTMLIFrameElement.content-window", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_iframe_element_init(WebKitDOMHTMLIFrameElement* request)
{
}

gchar*
webkit_dom_html_iframe_element_get_align(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_align(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_frame_border(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::frameborderAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_frame_border(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::frameborderAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_height(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_height(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::heightAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_long_desc(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::longdescAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_long_desc(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::longdescAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_margin_height(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::marginheightAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_margin_height(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::marginheightAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_margin_width(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::marginwidthAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_margin_width(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::marginwidthAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_name(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_iframe_element_set_name(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_sandbox(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::sandboxAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_sandbox(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::sandboxAttr, convertedValue);
}

gboolean
webkit_dom_html_iframe_element_get_seamless(WebKitDOMHTMLIFrameElement* self)
{
#if ENABLE(IFRAME_SEAMLESS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), FALSE);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::seamlessAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Iframe Seamless")
    return static_cast<gboolean>(0);
#endif /* ENABLE(IFRAME_SEAMLESS) */
}

void
webkit_dom_html_iframe_element_set_seamless(WebKitDOMHTMLIFrameElement* self, gboolean value)
{
#if ENABLE(IFRAME_SEAMLESS)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::seamlessAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Iframe Seamless")
#endif /* ENABLE(IFRAME_SEAMLESS) */
}

gchar*
webkit_dom_html_iframe_element_get_scrolling(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::scrollingAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_scrolling(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::scrollingAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_src(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_src(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_srcdoc(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::srcdocAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_srcdoc(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcdocAttr, convertedValue);
}

gchar*
webkit_dom_html_iframe_element_get_width(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_iframe_element_set_width(WebKitDOMHTMLIFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

WebKitDOMDocument*
webkit_dom_html_iframe_element_get_content_document(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->contentDocument());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_html_iframe_element_get_content_window(WebKitDOMHTMLIFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IFRAME_ELEMENT(self), 0);
    WebCore::HTMLIFrameElement* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->contentWindow());
    return WebKit::kit(gobjectResult.get());
}

