/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLDetailsElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLDetailsElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(DETAILS_ELEMENT)

namespace WebKit {

WebKitDOMHTMLDetailsElement* kit(WebCore::HTMLDetailsElement* obj)
{
    return WEBKIT_DOM_HTML_DETAILS_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLDetailsElement* core(WebKitDOMHTMLDetailsElement* request)
{
    return request ? static_cast<WebCore::HTMLDetailsElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLDetailsElement* wrapHTMLDetailsElement(WebCore::HTMLDetailsElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_DETAILS_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_DETAILS_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(DETAILS_ELEMENT)

G_DEFINE_TYPE(WebKitDOMHTMLDetailsElement, webkit_dom_html_details_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_OPEN,
};

static void webkit_dom_html_details_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(DETAILS_ELEMENT)
    WebKitDOMHTMLDetailsElement* self = WEBKIT_DOM_HTML_DETAILS_ELEMENT(object);
    WebCore::HTMLDetailsElement* coreSelf = WebKit::core(self);
#endif // ENABLE(DETAILS_ELEMENT)
    switch (propertyId) {
    case PROP_OPEN: {
#if ENABLE(DETAILS_ELEMENT)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::openAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Details Element")
#endif /* ENABLE(DETAILS_ELEMENT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_details_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(DETAILS_ELEMENT)
    WebKitDOMHTMLDetailsElement* self = WEBKIT_DOM_HTML_DETAILS_ELEMENT(object);
    WebCore::HTMLDetailsElement* coreSelf = WebKit::core(self);
#endif // ENABLE(DETAILS_ELEMENT)
    switch (propertyId) {
    case PROP_OPEN: {
#if ENABLE(DETAILS_ELEMENT)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::openAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Details Element")
#endif /* ENABLE(DETAILS_ELEMENT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_details_element_class_init(WebKitDOMHTMLDetailsElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_details_element_set_property;
    gobjectClass->get_property = webkit_dom_html_details_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_OPEN,
                                    g_param_spec_boolean("open", /* name */
                                                           "html_details_element_open", /* short description */
                                                           "read-write  gboolean HTMLDetailsElement.open", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_details_element_init(WebKitDOMHTMLDetailsElement* request)
{
}

gboolean
webkit_dom_html_details_element_get_open(WebKitDOMHTMLDetailsElement* self)
{
#if ENABLE(DETAILS_ELEMENT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DETAILS_ELEMENT(self), FALSE);
    WebCore::HTMLDetailsElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::openAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Details Element")
    return static_cast<gboolean>(0);
#endif /* ENABLE(DETAILS_ELEMENT) */
}

void
webkit_dom_html_details_element_set_open(WebKitDOMHTMLDetailsElement* self, gboolean value)
{
#if ENABLE(DETAILS_ELEMENT)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DETAILS_ELEMENT(self));
    WebCore::HTMLDetailsElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::openAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Details Element")
#endif /* ENABLE(DETAILS_ELEMENT) */
}

