/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLAreaElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLAreaElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLAreaElement* kit(WebCore::HTMLAreaElement* obj)
{
    return WEBKIT_DOM_HTML_AREA_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLAreaElement* core(WebKitDOMHTMLAreaElement* request)
{
    return request ? static_cast<WebCore::HTMLAreaElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLAreaElement* wrapHTMLAreaElement(WebCore::HTMLAreaElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_AREA_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_AREA_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLAreaElement, webkit_dom_html_area_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALT,
    PROP_COORDS,
    PROP_HREF,
    PROP_NO_HREF,
    PROP_PING,
    PROP_SHAPE,
    PROP_TARGET,
    PROP_HASH,
    PROP_HOST,
    PROP_HOSTNAME,
    PROP_PATHNAME,
    PROP_PORT,
    PROP_PROTOCOL,
    PROP_SEARCH,
};

static void webkit_dom_html_area_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAreaElement* self = WEBKIT_DOM_HTML_AREA_ELEMENT(object);
    WebCore::HTMLAreaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALT: {
        coreSelf->setAttribute(WebCore::HTMLNames::altAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_COORDS: {
        coreSelf->setAttribute(WebCore::HTMLNames::coordsAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HREF: {
        coreSelf->setAttribute(WebCore::HTMLNames::hrefAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NO_HREF: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::nohrefAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_PING: {
        coreSelf->setAttribute(WebCore::HTMLNames::pingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SHAPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::shapeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::targetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_area_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAreaElement* self = WEBKIT_DOM_HTML_AREA_ELEMENT(object);
    WebCore::HTMLAreaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::altAttr)));
        break;
    }
    case PROP_COORDS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::coordsAttr)));
        break;
    }
    case PROP_HREF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::hrefAttr)));
        break;
    }
    case PROP_NO_HREF: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::nohrefAttr));
        break;
    }
    case PROP_PING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::pingAttr)));
        break;
    }
    case PROP_SHAPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::shapeAttr)));
        break;
    }
    case PROP_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::targetAttr)));
        break;
    }
    case PROP_HASH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->hash()));
        break;
    }
    case PROP_HOST: {
        g_value_take_string(value, convertToUTF8String(coreSelf->host()));
        break;
    }
    case PROP_HOSTNAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->hostname()));
        break;
    }
    case PROP_PATHNAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->pathname()));
        break;
    }
    case PROP_PORT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->port()));
        break;
    }
    case PROP_PROTOCOL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->protocol()));
        break;
    }
    case PROP_SEARCH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->search()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_area_element_class_init(WebKitDOMHTMLAreaElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_area_element_set_property;
    gobjectClass->get_property = webkit_dom_html_area_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALT,
                                    g_param_spec_string("alt", /* name */
                                                           "html_area_element_alt", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.alt", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COORDS,
                                    g_param_spec_string("coords", /* name */
                                                           "html_area_element_coords", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.coords", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREF,
                                    g_param_spec_string("href", /* name */
                                                           "html_area_element_href", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.href", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NO_HREF,
                                    g_param_spec_boolean("no-href", /* name */
                                                           "html_area_element_no-href", /* short description */
                                                           "read-write  gboolean HTMLAreaElement.no-href", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PING,
                                    g_param_spec_string("ping", /* name */
                                                           "html_area_element_ping", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.ping", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHAPE,
                                    g_param_spec_string("shape", /* name */
                                                           "html_area_element_shape", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.shape", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_string("target", /* name */
                                                           "html_area_element_target", /* short description */
                                                           "read-write  gchar* HTMLAreaElement.target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HASH,
                                    g_param_spec_string("hash", /* name */
                                                           "html_area_element_hash", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.hash", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HOST,
                                    g_param_spec_string("host", /* name */
                                                           "html_area_element_host", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.host", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HOSTNAME,
                                    g_param_spec_string("hostname", /* name */
                                                           "html_area_element_hostname", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.hostname", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PATHNAME,
                                    g_param_spec_string("pathname", /* name */
                                                           "html_area_element_pathname", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.pathname", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PORT,
                                    g_param_spec_string("port", /* name */
                                                           "html_area_element_port", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.port", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PROTOCOL,
                                    g_param_spec_string("protocol", /* name */
                                                           "html_area_element_protocol", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.protocol", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SEARCH,
                                    g_param_spec_string("search", /* name */
                                                           "html_area_element_search", /* short description */
                                                           "read-only  gchar* HTMLAreaElement.search", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_area_element_init(WebKitDOMHTMLAreaElement* request)
{
}

gchar*
webkit_dom_html_area_element_get_alt(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}

void
webkit_dom_html_area_element_set_alt(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::altAttr, convertedValue);
}

gchar*
webkit_dom_html_area_element_get_coords(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::coordsAttr));
    return result;
}

void
webkit_dom_html_area_element_set_coords(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::coordsAttr, convertedValue);
}

gchar*
webkit_dom_html_area_element_get_href(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}

void
webkit_dom_html_area_element_set_href(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::hrefAttr, convertedValue);
}

gboolean
webkit_dom_html_area_element_get_no_href(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::nohrefAttr);
    return result;
}

void
webkit_dom_html_area_element_set_no_href(WebKitDOMHTMLAreaElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::nohrefAttr, value);
}

gchar*
webkit_dom_html_area_element_get_ping(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::pingAttr));
    return result;
}

void
webkit_dom_html_area_element_set_ping(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::pingAttr, convertedValue);
}

gchar*
webkit_dom_html_area_element_get_shape(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::shapeAttr));
    return result;
}

void
webkit_dom_html_area_element_set_shape(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::shapeAttr, convertedValue);
}

gchar*
webkit_dom_html_area_element_get_target(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}

void
webkit_dom_html_area_element_set_target(WebKitDOMHTMLAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::targetAttr, convertedValue);
}

gchar*
webkit_dom_html_area_element_get_hash(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->hash());
    return result;
}

gchar*
webkit_dom_html_area_element_get_host(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->host());
    return result;
}

gchar*
webkit_dom_html_area_element_get_hostname(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->hostname());
    return result;
}

gchar*
webkit_dom_html_area_element_get_pathname(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->pathname());
    return result;
}

gchar*
webkit_dom_html_area_element_get_port(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->port());
    return result;
}

gchar*
webkit_dom_html_area_element_get_protocol(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->protocol());
    return result;
}

gchar*
webkit_dom_html_area_element_get_search(WebKitDOMHTMLAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_AREA_ELEMENT(self), 0);
    WebCore::HTMLAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->search());
    return result;
}

