/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSInjectedScriptHost_h
#define JSInjectedScriptHost_h

#if ENABLE(INSPECTOR)

#include "InjectedScriptHost.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSInjectedScriptHost : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSInjectedScriptHost* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InjectedScriptHost> impl)
    {
        JSInjectedScriptHost* ptr = new (NotNull, JSC::allocateCell<JSInjectedScriptHost>(globalObject->globalData().heap)) JSInjectedScriptHost(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void destroy(JSC::JSCell*);
    ~JSInjectedScriptHost();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue inspect(JSC::ExecState*);
    JSC::JSValue inspectedObject(JSC::ExecState*);
    JSC::JSValue internalConstructorName(JSC::ExecState*);
    JSC::JSValue isHTMLAllCollection(JSC::ExecState*);
    JSC::JSValue type(JSC::ExecState*);
    JSC::JSValue functionDetails(JSC::ExecState*);
    JSC::JSValue getInternalProperties(JSC::ExecState*);
    JSC::JSValue getEventListeners(JSC::ExecState*);
    JSC::JSValue databaseId(JSC::ExecState*);
    JSC::JSValue storageId(JSC::ExecState*);
    JSC::JSValue evaluate(JSC::ExecState*);
    JSC::JSValue setFunctionVariableValue(JSC::ExecState*);
    InjectedScriptHost* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull() { if (m_impl) { m_impl->deref(); m_impl = 0; } }

private:
    InjectedScriptHost* m_impl;
protected:
    JSInjectedScriptHost(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<InjectedScriptHost>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

class JSInjectedScriptHostOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, InjectedScriptHost*)
{
    DEFINE_STATIC_LOCAL(JSInjectedScriptHostOwner, jsInjectedScriptHostOwner, ());
    return &jsInjectedScriptHostOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, InjectedScriptHost*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, InjectedScriptHost*);
InjectedScriptHost* toInjectedScriptHost(JSC::JSValue);

class JSInjectedScriptHostPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSInjectedScriptHostPrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInjectedScriptHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSInjectedScriptHostPrototype>(globalData.heap)) JSInjectedScriptHostPrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSInjectedScriptHostPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSInjectedScriptHostConstructor : public DOMConstructorObject {
private:
    JSInjectedScriptHostConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSInjectedScriptHostConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSInjectedScriptHostConstructor* ptr = new (NotNull, JSC::allocateCell<JSInjectedScriptHostConstructor>(*exec->heap())) JSInjectedScriptHostConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionClearConsoleMessages(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionCopyText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspectedObject(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInternalConstructorName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionIsHTMLAllCollection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionType(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionFunctionDetails(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionGetInternalProperties(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionGetEventListeners(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDatabaseId(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionStorageId(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionEvaluate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionSetFunctionVariableValue(JSC::ExecState*);
// Attributes

JSC::JSValue jsInjectedScriptHostConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(INSPECTOR)

#endif
