/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SHADOW_DOM)

#include "JSHTMLShadowElement.h"

#include "HTMLShadowElement.h"
#include "JSShadowRoot.h"
#include "ShadowRoot.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLShadowElementTableValues[] =
{
    { "resetStyleInheritance", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLShadowElementResetStyleInheritance), (intptr_t)setJSHTMLShadowElementResetStyleInheritance, NoIntrinsic },
    { "olderShadowRoot", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLShadowElementOlderShadowRoot), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLShadowElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLShadowElementTable = { 8, 7, JSHTMLShadowElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLShadowElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLShadowElementConstructorTable = { 1, 0, JSHTMLShadowElementConstructorTableValues, 0 };
const ClassInfo JSHTMLShadowElementConstructor::s_info = { "HTMLShadowElementConstructor", &Base::s_info, &JSHTMLShadowElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLShadowElementConstructor) };

JSHTMLShadowElementConstructor::JSHTMLShadowElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLShadowElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLShadowElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLShadowElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLShadowElementConstructor, JSDOMWrapper>(exec, &JSHTMLShadowElementConstructorTable, jsCast<JSHTMLShadowElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLShadowElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLShadowElementConstructor, JSDOMWrapper>(exec, &JSHTMLShadowElementConstructorTable, jsCast<JSHTMLShadowElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLShadowElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLShadowElementPrototypeTable = { 1, 0, JSHTMLShadowElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLShadowElementPrototype::s_info = { "HTMLShadowElementPrototype", &Base::s_info, &JSHTMLShadowElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLShadowElementPrototype) };

JSObject* JSHTMLShadowElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLShadowElement>(exec, globalObject);
}

const ClassInfo JSHTMLShadowElement::s_info = { "HTMLShadowElement", &Base::s_info, &JSHTMLShadowElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLShadowElement) };

JSHTMLShadowElement::JSHTMLShadowElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLShadowElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLShadowElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLShadowElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLShadowElementPrototype::create(exec->globalData(), globalObject, JSHTMLShadowElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLShadowElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLShadowElement* thisObject = jsCast<JSHTMLShadowElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLShadowElement, Base>(exec, &JSHTMLShadowElementTable, thisObject, propertyName, slot);
}

bool JSHTMLShadowElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLShadowElement* thisObject = jsCast<JSHTMLShadowElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLShadowElement, Base>(exec, &JSHTMLShadowElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLShadowElementResetStyleInheritance(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLShadowElement* castedThis = jsCast<JSHTMLShadowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLShadowElement* impl = static_cast<HTMLShadowElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->resetStyleInheritance());
    return result;
}


JSValue jsHTMLShadowElementOlderShadowRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLShadowElement* castedThis = jsCast<JSHTMLShadowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLShadowElement* impl = static_cast<HTMLShadowElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->olderShadowRoot()));
    return result;
}


JSValue jsHTMLShadowElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLShadowElement* domObject = jsCast<JSHTMLShadowElement*>(asObject(slotBase));
    return JSHTMLShadowElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLShadowElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLShadowElement* thisObject = jsCast<JSHTMLShadowElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLShadowElement, Base>(exec, propertyName, value, &JSHTMLShadowElementTable, thisObject, slot);
}

void setJSHTMLShadowElementResetStyleInheritance(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLShadowElement* castedThis = jsCast<JSHTMLShadowElement*>(thisObject);
    HTMLShadowElement* impl = static_cast<HTMLShadowElement*>(castedThis->impl());
    impl->setResetStyleInheritance(value.toBoolean(exec));
}


JSValue JSHTMLShadowElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLShadowElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SHADOW_DOM)
