/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOptGroupElement.h"

#include "HTMLNames.h"
#include "HTMLOptGroupElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOptGroupElementTableValues[] =
{
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptGroupElementDisabled), (intptr_t)setJSHTMLOptGroupElementDisabled, NoIntrinsic },
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptGroupElementLabel), (intptr_t)setJSHTMLOptGroupElementLabel, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptGroupElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptGroupElementTable = { 10, 7, JSHTMLOptGroupElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLOptGroupElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptGroupElementConstructorTable = { 1, 0, JSHTMLOptGroupElementConstructorTableValues, 0 };
const ClassInfo JSHTMLOptGroupElementConstructor::s_info = { "HTMLOptGroupElementConstructor", &Base::s_info, &JSHTMLOptGroupElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLOptGroupElementConstructor) };

JSHTMLOptGroupElementConstructor::JSHTMLOptGroupElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLOptGroupElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOptGroupElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLOptGroupElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElementConstructor, JSDOMWrapper>(exec, &JSHTMLOptGroupElementConstructorTable, jsCast<JSHTMLOptGroupElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLOptGroupElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLOptGroupElementConstructor, JSDOMWrapper>(exec, &JSHTMLOptGroupElementConstructorTable, jsCast<JSHTMLOptGroupElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptGroupElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptGroupElementPrototypeTable = { 1, 0, JSHTMLOptGroupElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLOptGroupElementPrototype::s_info = { "HTMLOptGroupElementPrototype", &Base::s_info, &JSHTMLOptGroupElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLOptGroupElementPrototype) };

JSObject* JSHTMLOptGroupElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOptGroupElement>(exec, globalObject);
}

const ClassInfo JSHTMLOptGroupElement::s_info = { "HTMLOptGroupElement", &Base::s_info, &JSHTMLOptGroupElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLOptGroupElement) };

JSHTMLOptGroupElement::JSHTMLOptGroupElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLOptGroupElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLOptGroupElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLOptGroupElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLOptGroupElementPrototype::create(exec->globalData(), globalObject, JSHTMLOptGroupElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOptGroupElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLOptGroupElement* thisObject = jsCast<JSHTMLOptGroupElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLOptGroupElement, Base>(exec, &JSHTMLOptGroupElementTable, thisObject, propertyName, slot);
}

bool JSHTMLOptGroupElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLOptGroupElement* thisObject = jsCast<JSHTMLOptGroupElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLOptGroupElement, Base>(exec, &JSHTMLOptGroupElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLOptGroupElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptGroupElement* castedThis = jsCast<JSHTMLOptGroupElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptGroupElement* impl = static_cast<HTMLOptGroupElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLOptGroupElementLabel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptGroupElement* castedThis = jsCast<JSHTMLOptGroupElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptGroupElement* impl = static_cast<HTMLOptGroupElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::labelAttr));
    return result;
}


JSValue jsHTMLOptGroupElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptGroupElement* domObject = jsCast<JSHTMLOptGroupElement*>(asObject(slotBase));
    return JSHTMLOptGroupElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLOptGroupElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLOptGroupElement* thisObject = jsCast<JSHTMLOptGroupElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLOptGroupElement, Base>(exec, propertyName, value, &JSHTMLOptGroupElementTable, thisObject, slot);
}

void setJSHTMLOptGroupElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptGroupElement* castedThis = jsCast<JSHTMLOptGroupElement*>(thisObject);
    HTMLOptGroupElement* impl = static_cast<HTMLOptGroupElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLOptGroupElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptGroupElement* castedThis = jsCast<JSHTMLOptGroupElement*>(thisObject);
    HTMLOptGroupElement* impl = static_cast<HTMLOptGroupElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::labelAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLOptGroupElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOptGroupElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
