/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPlugin.h"

#include "DOMMimeType.h"
#include "DOMPlugin.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMMimeType.h"
#include "KURL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMPluginTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginName), (intptr_t)0, NoIntrinsic },
    { "filename", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginFilename), (intptr_t)0, NoIntrinsic },
    { "description", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginDescription), (intptr_t)0, NoIntrinsic },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginTable = { 17, 15, JSDOMPluginTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMPluginConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginConstructorTable = { 1, 0, JSDOMPluginConstructorTableValues, 0 };
const ClassInfo JSDOMPluginConstructor::s_info = { "PluginConstructor", &Base::s_info, &JSDOMPluginConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMPluginConstructor) };

JSDOMPluginConstructor::JSDOMPluginConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMPluginConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMPluginPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMPluginConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMPluginConstructor, JSDOMWrapper>(exec, &JSDOMPluginConstructorTable, jsCast<JSDOMPluginConstructor*>(cell), propertyName, slot);
}

bool JSDOMPluginConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMPluginConstructor, JSDOMWrapper>(exec, &JSDOMPluginConstructorTable, jsCast<JSDOMPluginConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMPluginPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginPrototypeFunctionNamedItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPluginPrototypeTable = { 5, 3, JSDOMPluginPrototypeTableValues, 0 };
const ClassInfo JSDOMPluginPrototype::s_info = { "PluginPrototype", &Base::s_info, &JSDOMPluginPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMPluginPrototype) };

JSObject* JSDOMPluginPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPlugin>(exec, globalObject);
}

bool JSDOMPluginPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPluginPrototype* thisObject = jsCast<JSDOMPluginPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMPluginPrototypeTable, thisObject, propertyName, slot);
}

bool JSDOMPluginPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPluginPrototype* thisObject = jsCast<JSDOMPluginPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMPluginPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDOMPlugin::s_info = { "Plugin", &Base::s_info, &JSDOMPluginTable, 0 , CREATE_METHOD_TABLE(JSDOMPlugin) };

JSDOMPlugin::JSDOMPlugin(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMPlugin> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMPlugin::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMPlugin::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMPluginPrototype::create(exec->globalData(), globalObject, JSDOMPluginPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSDOMPlugin::destroy(JSC::JSCell* cell)
{
    JSDOMPlugin* thisObject = static_cast<JSDOMPlugin*>(cell);
    thisObject->JSDOMPlugin::~JSDOMPlugin();
}

JSDOMPlugin::~JSDOMPlugin()
{
    releaseImplIfNotNull();
}

bool JSDOMPlugin::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPlugin* thisObject = jsCast<JSDOMPlugin*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSDOMPlugin>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMPlugin*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPlugin*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMPlugin, Base>(exec, &JSDOMPluginTable, thisObject, propertyName, slot);
}

bool JSDOMPlugin::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPlugin* thisObject = jsCast<JSDOMPlugin*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSDOMPluginTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMPlugin*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPlugin*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMPlugin, Base>(exec, &JSDOMPluginTable, thisObject, propertyName, descriptor);
}

bool JSDOMPlugin::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSDOMPlugin* thisObject = jsCast<JSDOMPlugin*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<DOMPlugin*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<DOMPlugin*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsDOMPluginName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsDOMPluginFilename(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->filename());
    return result;
}


JSValue jsDOMPluginDescription(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->description());
    return result;
}


JSValue jsDOMPluginLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsDOMPluginConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPlugin* domObject = jsCast<JSDOMPlugin*>(asObject(slotBase));
    return JSDOMPlugin::getConstructor(exec, domObject->globalObject());
}

void JSDOMPlugin::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSDOMPlugin* thisObject = jsCast<JSDOMPlugin*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<DOMPlugin*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSDOMPlugin::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPluginConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPlugin::s_info))
        return throwVMTypeError(exec);
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPlugin::s_info);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPlugin::s_info))
        return throwVMTypeError(exec);
    JSDOMPlugin* castedThis = jsCast<JSDOMPlugin*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPlugin::s_info);
    DOMPlugin* impl = static_cast<DOMPlugin*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->namedItem(name)));
    return JSValue::encode(result);
}


JSValue JSDOMPlugin::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMPlugin* thisObj = jsCast<JSDOMPlugin*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<DOMPlugin*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSDOMPlugin* jsDOMPlugin)
{
    if (jsDOMPlugin->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMPluginOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMPlugin* jsDOMPlugin = jsCast<JSDOMPlugin*>(handle.get().asCell());
    if (!isObservable(jsDOMPlugin))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMPluginOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMPlugin* jsDOMPlugin = jsCast<JSDOMPlugin*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMPlugin->impl(), jsDOMPlugin);
    jsDOMPlugin->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMPlugin* impl)
{
    return wrap<JSDOMPlugin>(exec, globalObject, impl);
}

DOMPlugin* toDOMPlugin(JSC::JSValue value)
{
    return value.inherits(&JSDOMPlugin::s_info) ? jsCast<JSDOMPlugin*>(asObject(value))->impl() : 0;
}

}
