/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTreeWalker.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodeFilterPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTreeWalkerPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TREE_WALKER_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TREE_WALKER, WebKitDOMTreeWalkerPrivate)

typedef struct _WebKitDOMTreeWalkerPrivate {
    RefPtr<WebCore::TreeWalker> coreObject;
} WebKitDOMTreeWalkerPrivate;

namespace WebKit {

WebKitDOMTreeWalker* kit(WebCore::TreeWalker* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TREE_WALKER(ret);

    return wrapTreeWalker(obj);
}

WebCore::TreeWalker* core(WebKitDOMTreeWalker* request)
{
    return request ? static_cast<WebCore::TreeWalker*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTreeWalker* wrapTreeWalker(WebCore::TreeWalker* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TREE_WALKER(g_object_new(WEBKIT_TYPE_DOM_TREE_WALKER, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMTreeWalker, webkit_dom_tree_walker, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ROOT,
    PROP_WHAT_TO_SHOW,
    PROP_FILTER,
    PROP_EXPAND_ENTITY_REFERENCES,
    PROP_CURRENT_NODE,
};

static void webkit_dom_tree_walker_finalize(GObject* object)
{
    WebKitDOMTreeWalkerPrivate* priv = WEBKIT_DOM_TREE_WALKER_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMTreeWalkerPrivate();
    G_OBJECT_CLASS(webkit_dom_tree_walker_parent_class)->finalize(object);
}

static void webkit_dom_tree_walker_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMTreeWalker* self = WEBKIT_DOM_TREE_WALKER(object);
    WebCore::TreeWalker* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ROOT: {
        RefPtr<WebCore::Node> ptr = coreSelf->root();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WHAT_TO_SHOW: {
        g_value_set_ulong(value, coreSelf->whatToShow());
        break;
    }
    case PROP_FILTER: {
        RefPtr<WebCore::NodeFilter> ptr = coreSelf->filter();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_EXPAND_ENTITY_REFERENCES: {
        g_value_set_boolean(value, coreSelf->expandEntityReferences());
        break;
    }
    case PROP_CURRENT_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->currentNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_tree_walker_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_tree_walker_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMTreeWalkerPrivate* priv = WEBKIT_DOM_TREE_WALKER_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TreeWalker*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_tree_walker_class_init(WebKitDOMTreeWalkerClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTreeWalkerPrivate));
    gobjectClass->constructor = webkit_dom_tree_walker_constructor;
    gobjectClass->finalize = webkit_dom_tree_walker_finalize;
    gobjectClass->get_property = webkit_dom_tree_walker_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ROOT,
                                    g_param_spec_object("root", /* name */
                                                           "tree_walker_root", /* short description */
                                                           "read-only  WebKitDOMNode* TreeWalker.root", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WHAT_TO_SHOW,
                                    g_param_spec_ulong("what-to-show", /* name */
                                                           "tree_walker_what-to-show", /* short description */
                                                           "read-only  gulong TreeWalker.what-to-show", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FILTER,
                                    g_param_spec_object("filter", /* name */
                                                           "tree_walker_filter", /* short description */
                                                           "read-only  WebKitDOMNodeFilter* TreeWalker.filter", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_FILTER, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EXPAND_ENTITY_REFERENCES,
                                    g_param_spec_boolean("expand-entity-references", /* name */
                                                           "tree_walker_expand-entity-references", /* short description */
                                                           "read-only  gboolean TreeWalker.expand-entity-references", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CURRENT_NODE,
                                    g_param_spec_object("current-node", /* name */
                                                           "tree_walker_current-node", /* short description */
                                                           "read-write  WebKitDOMNode* TreeWalker.current-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_tree_walker_init(WebKitDOMTreeWalker* request)
{
    WebKitDOMTreeWalkerPrivate* priv = WEBKIT_DOM_TREE_WALKER_GET_PRIVATE(request);
    new (priv) WebKitDOMTreeWalkerPrivate();
}

WebKitDOMNode*
webkit_dom_tree_walker_parent_node(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->parentNode());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_first_child(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->firstChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_last_child(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->lastChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_previous_sibling(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->previousSibling());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_next_sibling(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->nextSibling());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_previous_node(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->previousNode());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_next_node(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->nextNode());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_tree_walker_get_root(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->root());
    return WebKit::kit(gobjectResult.get());
}

gulong
webkit_dom_tree_walker_get_what_to_show(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    gulong result = item->whatToShow();
    return result;
}

WebKitDOMNodeFilter*
webkit_dom_tree_walker_get_filter(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::NodeFilter> gobjectResult = WTF::getPtr(item->filter());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_tree_walker_get_expand_entity_references(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), FALSE);
    WebCore::TreeWalker* item = WebKit::core(self);
    gboolean result = item->expandEntityReferences();
    return result;
}

WebKitDOMNode*
webkit_dom_tree_walker_get_current_node(WebKitDOMTreeWalker* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self), 0);
    WebCore::TreeWalker* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->currentNode());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_tree_walker_set_current_node(WebKitDOMTreeWalker* self, WebKitDOMNode* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TREE_WALKER(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(value));
    g_return_if_fail(!error || !*error);
    WebCore::TreeWalker* item = WebKit::core(self);
    WebCore::Node* convertedValue = WebKit::core(value);
    WebCore::ExceptionCode ec = 0;
    item->setCurrentNode(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

