/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMAttrPrivate.h"
#include "WebKitDOMCSSStyleDeclarationPrivate.h"
#include "WebKitDOMDOMTokenListPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMElement* kit(WebCore::Element* obj)
{
    return WEBKIT_DOM_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::Element* core(WebKitDOMElement* request)
{
    return request ? static_cast<WebCore::Element*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMElement* wrapElement(WebCore::Element* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMElement, webkit_dom_element, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_TAG_NAME,
    PROP_STYLE,
    PROP_OFFSET_LEFT,
    PROP_OFFSET_TOP,
    PROP_OFFSET_WIDTH,
    PROP_OFFSET_HEIGHT,
    PROP_OFFSET_PARENT,
    PROP_CLIENT_LEFT,
    PROP_CLIENT_TOP,
    PROP_CLIENT_WIDTH,
    PROP_CLIENT_HEIGHT,
    PROP_SCROLL_LEFT,
    PROP_SCROLL_TOP,
    PROP_SCROLL_WIDTH,
    PROP_SCROLL_HEIGHT,
    PROP_CLASS_NAME,
    PROP_CLASS_LIST,
    PROP_FIRST_ELEMENT_CHILD,
    PROP_LAST_ELEMENT_CHILD,
    PROP_PREVIOUS_ELEMENT_SIBLING,
    PROP_NEXT_ELEMENT_SIBLING,
    PROP_CHILD_ELEMENT_COUNT,
    PROP_WEBKIT_REGION_OVERSET,
};

static void webkit_dom_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMElement* self = WEBKIT_DOM_ELEMENT(object);
    WebCore::Element* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_SCROLL_LEFT: {
        coreSelf->setScrollLeft((g_value_get_long(value)));
        break;
    }
    case PROP_SCROLL_TOP: {
        coreSelf->setScrollTop((g_value_get_long(value)));
        break;
    }
    case PROP_CLASS_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::classAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMElement* self = WEBKIT_DOM_ELEMENT(object);
    WebCore::Element* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TAG_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->tagName()));
        break;
    }
    case PROP_STYLE: {
        RefPtr<WebCore::CSSStyleDeclaration> ptr = coreSelf->style();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_OFFSET_LEFT: {
        g_value_set_long(value, coreSelf->offsetLeft());
        break;
    }
    case PROP_OFFSET_TOP: {
        g_value_set_long(value, coreSelf->offsetTop());
        break;
    }
    case PROP_OFFSET_WIDTH: {
        g_value_set_long(value, coreSelf->offsetWidth());
        break;
    }
    case PROP_OFFSET_HEIGHT: {
        g_value_set_long(value, coreSelf->offsetHeight());
        break;
    }
    case PROP_OFFSET_PARENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->offsetParent();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CLIENT_LEFT: {
        g_value_set_long(value, coreSelf->clientLeft());
        break;
    }
    case PROP_CLIENT_TOP: {
        g_value_set_long(value, coreSelf->clientTop());
        break;
    }
    case PROP_CLIENT_WIDTH: {
        g_value_set_long(value, coreSelf->clientWidth());
        break;
    }
    case PROP_CLIENT_HEIGHT: {
        g_value_set_long(value, coreSelf->clientHeight());
        break;
    }
    case PROP_SCROLL_LEFT: {
        g_value_set_long(value, coreSelf->scrollLeft());
        break;
    }
    case PROP_SCROLL_TOP: {
        g_value_set_long(value, coreSelf->scrollTop());
        break;
    }
    case PROP_SCROLL_WIDTH: {
        g_value_set_long(value, coreSelf->scrollWidth());
        break;
    }
    case PROP_SCROLL_HEIGHT: {
        g_value_set_long(value, coreSelf->scrollHeight());
        break;
    }
    case PROP_CLASS_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::classAttr)));
        break;
    }
    case PROP_CLASS_LIST: {
        RefPtr<WebCore::DOMTokenList> ptr = coreSelf->classList();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FIRST_ELEMENT_CHILD: {
        RefPtr<WebCore::Element> ptr = coreSelf->firstElementChild();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LAST_ELEMENT_CHILD: {
        RefPtr<WebCore::Element> ptr = coreSelf->lastElementChild();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PREVIOUS_ELEMENT_SIBLING: {
        RefPtr<WebCore::Element> ptr = coreSelf->previousElementSibling();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NEXT_ELEMENT_SIBLING: {
        RefPtr<WebCore::Element> ptr = coreSelf->nextElementSibling();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CHILD_ELEMENT_COUNT: {
        g_value_set_ulong(value, coreSelf->childElementCount());
        break;
    }
    case PROP_WEBKIT_REGION_OVERSET: {
#if ENABLE(CSS_REGIONS)
        g_value_take_string(value, convertToUTF8String(coreSelf->webkitRegionOverset()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
#endif /* ENABLE(CSS_REGIONS) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_element_class_init(WebKitDOMElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_element_set_property;
    gobjectClass->get_property = webkit_dom_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TAG_NAME,
                                    g_param_spec_string("tag-name", /* name */
                                                           "element_tag-name", /* short description */
                                                           "read-only  gchar* Element.tag-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STYLE,
                                    g_param_spec_object("style", /* name */
                                                           "element_style", /* short description */
                                                           "read-only  WebKitDOMCSSStyleDeclaration* Element.style", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_CSS_STYLE_DECLARATION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_LEFT,
                                    g_param_spec_long("offset-left", /* name */
                                                           "element_offset-left", /* short description */
                                                           "read-only  glong Element.offset-left", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_TOP,
                                    g_param_spec_long("offset-top", /* name */
                                                           "element_offset-top", /* short description */
                                                           "read-only  glong Element.offset-top", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_WIDTH,
                                    g_param_spec_long("offset-width", /* name */
                                                           "element_offset-width", /* short description */
                                                           "read-only  glong Element.offset-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_HEIGHT,
                                    g_param_spec_long("offset-height", /* name */
                                                           "element_offset-height", /* short description */
                                                           "read-only  glong Element.offset-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSET_PARENT,
                                    g_param_spec_object("offset-parent", /* name */
                                                           "element_offset-parent", /* short description */
                                                           "read-only  WebKitDOMElement* Element.offset-parent", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_LEFT,
                                    g_param_spec_long("client-left", /* name */
                                                           "element_client-left", /* short description */
                                                           "read-only  glong Element.client-left", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_TOP,
                                    g_param_spec_long("client-top", /* name */
                                                           "element_client-top", /* short description */
                                                           "read-only  glong Element.client-top", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_WIDTH,
                                    g_param_spec_long("client-width", /* name */
                                                           "element_client-width", /* short description */
                                                           "read-only  glong Element.client-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_HEIGHT,
                                    g_param_spec_long("client-height", /* name */
                                                           "element_client-height", /* short description */
                                                           "read-only  glong Element.client-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_LEFT,
                                    g_param_spec_long("scroll-left", /* name */
                                                           "element_scroll-left", /* short description */
                                                           "read-write  glong Element.scroll-left", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_TOP,
                                    g_param_spec_long("scroll-top", /* name */
                                                           "element_scroll-top", /* short description */
                                                           "read-write  glong Element.scroll-top", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_WIDTH,
                                    g_param_spec_long("scroll-width", /* name */
                                                           "element_scroll-width", /* short description */
                                                           "read-only  glong Element.scroll-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_HEIGHT,
                                    g_param_spec_long("scroll-height", /* name */
                                                           "element_scroll-height", /* short description */
                                                           "read-only  glong Element.scroll-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLASS_NAME,
                                    g_param_spec_string("class-name", /* name */
                                                           "element_class-name", /* short description */
                                                           "read-write  gchar* Element.class-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLASS_LIST,
                                    g_param_spec_object("class-list", /* name */
                                                           "element_class-list", /* short description */
                                                           "read-only  WebKitDOMDOMTokenList* Element.class-list", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_TOKEN_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FIRST_ELEMENT_CHILD,
                                    g_param_spec_object("first-element-child", /* name */
                                                           "element_first-element-child", /* short description */
                                                           "read-only  WebKitDOMElement* Element.first-element-child", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LAST_ELEMENT_CHILD,
                                    g_param_spec_object("last-element-child", /* name */
                                                           "element_last-element-child", /* short description */
                                                           "read-only  WebKitDOMElement* Element.last-element-child", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PREVIOUS_ELEMENT_SIBLING,
                                    g_param_spec_object("previous-element-sibling", /* name */
                                                           "element_previous-element-sibling", /* short description */
                                                           "read-only  WebKitDOMElement* Element.previous-element-sibling", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NEXT_ELEMENT_SIBLING,
                                    g_param_spec_object("next-element-sibling", /* name */
                                                           "element_next-element-sibling", /* short description */
                                                           "read-only  WebKitDOMElement* Element.next-element-sibling", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHILD_ELEMENT_COUNT,
                                    g_param_spec_ulong("child-element-count", /* name */
                                                           "element_child-element-count", /* short description */
                                                           "read-only  gulong Element.child-element-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_REGION_OVERSET,
                                    g_param_spec_string("webkit-region-overset", /* name */
                                                           "element_webkit-region-overset", /* short description */
                                                           "read-only  gchar* Element.webkit-region-overset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_element_init(WebKitDOMElement* request)
{
}

gchar*
webkit_dom_element_get_attribute(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    gchar* result = convertToUTF8String(item->getAttribute(convertedName));
    return result;
}

void
webkit_dom_element_set_attribute(WebKitDOMElement* self, const gchar* name, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(name);
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setAttribute(convertedName, convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_element_remove_attribute(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(name);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    item->removeAttribute(convertedName);
}

WebKitDOMAttr*
webkit_dom_element_get_attribute_node(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->getAttributeNode(convertedName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_element_set_attribute_node(WebKitDOMElement* self, WebKitDOMAttr* newAttr, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(newAttr), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Element* item = WebKit::core(self);
    WebCore::Attr* convertedNewAttr = WebKit::core(newAttr);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->setAttributeNode(convertedNewAttr, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_element_remove_attribute_node(WebKitDOMElement* self, WebKitDOMAttr* oldAttr, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(oldAttr), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Element* item = WebKit::core(self);
    WebCore::Attr* convertedOldAttr = WebKit::core(oldAttr);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->removeAttributeNode(convertedOldAttr, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_element_get_elements_by_tag_name(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagName(convertedName));
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_element_get_attribute_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(localName, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    gchar* result = convertToUTF8String(item->getAttributeNS(convertedNamespaceURI, convertedLocalName));
    return result;
}

void
webkit_dom_element_set_attribute_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* qualifiedName, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(namespaceURI);
    g_return_if_fail(qualifiedName);
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedQualifiedName = WTF::String::fromUTF8(qualifiedName);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setAttributeNS(convertedNamespaceURI, convertedQualifiedName, convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_element_remove_attribute_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(namespaceURI);
    g_return_if_fail(localName);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    item->removeAttributeNS(convertedNamespaceURI, convertedLocalName);
}

WebKitDOMNodeList*
webkit_dom_element_get_elements_by_tag_name_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(localName, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagNameNS(convertedNamespaceURI, convertedLocalName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_element_get_attribute_node_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(localName, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->getAttributeNodeNS(convertedNamespaceURI, convertedLocalName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_element_set_attribute_node_ns(WebKitDOMElement* self, WebKitDOMAttr* newAttr, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(newAttr), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Element* item = WebKit::core(self);
    WebCore::Attr* convertedNewAttr = WebKit::core(newAttr);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->setAttributeNodeNS(convertedNewAttr, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_element_has_attribute(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), FALSE);
    g_return_val_if_fail(name, FALSE);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    gboolean result = item->hasAttribute(convertedName);
    return result;
}

gboolean
webkit_dom_element_has_attribute_ns(WebKitDOMElement* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), FALSE);
    g_return_val_if_fail(namespaceURI, FALSE);
    g_return_val_if_fail(localName, FALSE);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    gboolean result = item->hasAttributeNS(convertedNamespaceURI, convertedLocalName);
    return result;
}

void
webkit_dom_element_focus(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->focus();
}

void
webkit_dom_element_blur(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->blur();
}

void
webkit_dom_element_scroll_into_view(WebKitDOMElement* self, gboolean alignWithTop)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->scrollIntoView(alignWithTop);
}

void
webkit_dom_element_scroll_into_view_if_needed(WebKitDOMElement* self, gboolean centerIfNeeded)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->scrollIntoViewIfNeeded(centerIfNeeded);
}

void
webkit_dom_element_scroll_by_lines(WebKitDOMElement* self, glong lines)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->scrollByLines(lines);
}

void
webkit_dom_element_scroll_by_pages(WebKitDOMElement* self, glong pages)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->scrollByPages(pages);
}

WebKitDOMNodeList*
webkit_dom_element_get_elements_by_class_name(WebKitDOMElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByClassName(convertedName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_element_query_selector(WebKitDOMElement* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->querySelector(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_element_query_selector_all(WebKitDOMElement* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->querySelectorAll(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_element_webkit_matches_selector(WebKitDOMElement* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), FALSE);
    g_return_val_if_fail(selectors, FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->webkitMatchesSelector(convertedSelectors, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void
webkit_dom_element_remove(WebKitDOMElement* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::Element* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->remove(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_element_webkit_request_full_screen(WebKitDOMElement* self, gushort flags)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->webkitRequestFullScreen(flags);
}

void
webkit_dom_element_webkit_request_fullscreen(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->webkitRequestFullscreen();
}

void
webkit_dom_element_webkit_request_pointer_lock(WebKitDOMElement* self)
{
#if ENABLE(POINTER_LOCK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->webkitRequestPointerLock();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
#endif /* ENABLE(POINTER_LOCK) */
}

gchar*
webkit_dom_element_get_tag_name(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->tagName());
    return result;
}

WebKitDOMCSSStyleDeclaration*
webkit_dom_element_get_style(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::CSSStyleDeclaration> gobjectResult = WTF::getPtr(item->style());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_element_get_offset_left(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->offsetLeft();
    return result;
}

glong
webkit_dom_element_get_offset_top(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->offsetTop();
    return result;
}

glong
webkit_dom_element_get_offset_width(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->offsetWidth();
    return result;
}

glong
webkit_dom_element_get_offset_height(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->offsetHeight();
    return result;
}

WebKitDOMElement*
webkit_dom_element_get_offset_parent(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->offsetParent());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_element_get_client_left(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->clientLeft();
    return result;
}

glong
webkit_dom_element_get_client_top(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->clientTop();
    return result;
}

glong
webkit_dom_element_get_client_width(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->clientWidth();
    return result;
}

glong
webkit_dom_element_get_client_height(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->clientHeight();
    return result;
}

glong
webkit_dom_element_get_scroll_left(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->scrollLeft();
    return result;
}

void
webkit_dom_element_set_scroll_left(WebKitDOMElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->setScrollLeft(value);
}

glong
webkit_dom_element_get_scroll_top(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->scrollTop();
    return result;
}

void
webkit_dom_element_set_scroll_top(WebKitDOMElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    WebCore::Element* item = WebKit::core(self);
    item->setScrollTop(value);
}

glong
webkit_dom_element_get_scroll_width(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->scrollWidth();
    return result;
}

glong
webkit_dom_element_get_scroll_height(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    glong result = item->scrollHeight();
    return result;
}

gchar*
webkit_dom_element_get_class_name(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::classAttr));
    return result;
}

void
webkit_dom_element_set_class_name(WebKitDOMElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::Element* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::classAttr, convertedValue);
}

WebKitDOMDOMTokenList*
webkit_dom_element_get_class_list(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::DOMTokenList> gobjectResult = WTF::getPtr(item->classList());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_element_get_first_element_child(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->firstElementChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_element_get_last_element_child(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->lastElementChild());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_element_get_previous_element_sibling(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->previousElementSibling());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_element_get_next_element_sibling(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->nextElementSibling());
    return WebKit::kit(gobjectResult.get());
}

gulong
webkit_dom_element_get_child_element_count(WebKitDOMElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    gulong result = item->childElementCount();
    return result;
}

gchar*
webkit_dom_element_get_webkit_region_overset(WebKitDOMElement* self)
{
#if ENABLE(CSS_REGIONS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(self), 0);
    WebCore::Element* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->webkitRegionOverset());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
    return 0;
#endif /* ENABLE(CSS_REGIONS) */
}

