/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDocumentType.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentTypePrivate.h"
#include "WebKitDOMNamedNodeMapPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMDocumentType* kit(WebCore::DocumentType* obj)
{
    return WEBKIT_DOM_DOCUMENT_TYPE(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::DocumentType* core(WebKitDOMDocumentType* request)
{
    return request ? static_cast<WebCore::DocumentType*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDocumentType* wrapDocumentType(WebCore::DocumentType* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOCUMENT_TYPE(g_object_new(WEBKIT_TYPE_DOM_DOCUMENT_TYPE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDocumentType, webkit_dom_document_type, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_NAME,
    PROP_ENTITIES,
    PROP_NOTATIONS,
    PROP_PUBLIC_ID,
    PROP_SYSTEM_ID,
    PROP_INTERNAL_SUBSET,
};

static void webkit_dom_document_type_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDocumentType* self = WEBKIT_DOM_DOCUMENT_TYPE(object);
    WebCore::DocumentType* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
        break;
    }
    case PROP_ENTITIES: {
        RefPtr<WebCore::NamedNodeMap> ptr = coreSelf->entities();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NOTATIONS: {
        RefPtr<WebCore::NamedNodeMap> ptr = coreSelf->notations();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PUBLIC_ID: {
        g_value_take_string(value, convertToUTF8String(coreSelf->publicId()));
        break;
    }
    case PROP_SYSTEM_ID: {
        g_value_take_string(value, convertToUTF8String(coreSelf->systemId()));
        break;
    }
    case PROP_INTERNAL_SUBSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->internalSubset()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_document_type_class_init(WebKitDOMDocumentTypeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_document_type_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "document_type_name", /* short description */
                                                           "read-only  gchar* DocumentType.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENTITIES,
                                    g_param_spec_object("entities", /* name */
                                                           "document_type_entities", /* short description */
                                                           "read-only  WebKitDOMNamedNodeMap* DocumentType.entities", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NAMED_NODE_MAP, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NOTATIONS,
                                    g_param_spec_object("notations", /* name */
                                                           "document_type_notations", /* short description */
                                                           "read-only  WebKitDOMNamedNodeMap* DocumentType.notations", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NAMED_NODE_MAP, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PUBLIC_ID,
                                    g_param_spec_string("public-id", /* name */
                                                           "document_type_public-id", /* short description */
                                                           "read-only  gchar* DocumentType.public-id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SYSTEM_ID,
                                    g_param_spec_string("system-id", /* name */
                                                           "document_type_system-id", /* short description */
                                                           "read-only  gchar* DocumentType.system-id", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INTERNAL_SUBSET,
                                    g_param_spec_string("internal-subset", /* name */
                                                           "document_type_internal-subset", /* short description */
                                                           "read-only  gchar* DocumentType.internal-subset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_document_type_init(WebKitDOMDocumentType* request)
{
}

void
webkit_dom_document_type_remove(WebKitDOMDocumentType* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self));
    g_return_if_fail(!error || !*error);
    WebCore::DocumentType* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->remove(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_document_type_get_name(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

WebKitDOMNamedNodeMap*
webkit_dom_document_type_get_entities(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    RefPtr<WebCore::NamedNodeMap> gobjectResult = WTF::getPtr(item->entities());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNamedNodeMap*
webkit_dom_document_type_get_notations(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    RefPtr<WebCore::NamedNodeMap> gobjectResult = WTF::getPtr(item->notations());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_document_type_get_public_id(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->publicId());
    return result;
}

gchar*
webkit_dom_document_type_get_system_id(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->systemId());
    return result;
}

gchar*
webkit_dom_document_type_get_internal_subset(WebKitDOMDocumentType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_TYPE(self), 0);
    WebCore::DocumentType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->internalSubset());
    return result;
}

