/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDocumentFragment.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentFragmentPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMDocumentFragment* kit(WebCore::DocumentFragment* obj)
{
    return WEBKIT_DOM_DOCUMENT_FRAGMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::DocumentFragment* core(WebKitDOMDocumentFragment* request)
{
    return request ? static_cast<WebCore::DocumentFragment*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDocumentFragment* wrapDocumentFragment(WebCore::DocumentFragment* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOCUMENT_FRAGMENT(g_object_new(WEBKIT_TYPE_DOM_DOCUMENT_FRAGMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDocumentFragment, webkit_dom_document_fragment, WEBKIT_TYPE_DOM_NODE)

static void webkit_dom_document_fragment_class_init(WebKitDOMDocumentFragmentClass* requestClass)
{
}

static void webkit_dom_document_fragment_init(WebKitDOMDocumentFragment* request)
{
}

WebKitDOMElement*
webkit_dom_document_fragment_query_selector(WebKitDOMDocumentFragment* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_FRAGMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DocumentFragment* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->querySelector(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_document_fragment_query_selector_all(WebKitDOMDocumentFragment* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT_FRAGMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DocumentFragment* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->querySelectorAll(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

