/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSWorker.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "Worker.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWorkerTableValues[] =
{
    { "onmessage", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerOnmessage), (intptr_t)setJSWorkerOnmessage, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerTable = { 4, 3, JSWorkerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWorkerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerConstructorTable = { 1, 0, JSWorkerConstructorTableValues, 0 };
const ClassInfo JSWorkerConstructor::s_info = { "WorkerConstructor", &Base::s_info, &JSWorkerConstructorTable, 0, CREATE_METHOD_TABLE(JSWorkerConstructor) };

JSWorkerConstructor::JSWorkerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWorkerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWorkerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSWorkerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWorkerConstructor, JSDOMWrapper>(exec, &JSWorkerConstructorTable, jsCast<JSWorkerConstructor*>(cell), propertyName, slot);
}

bool JSWorkerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWorkerConstructor, JSDOMWrapper>(exec, &JSWorkerConstructorTable, jsCast<JSWorkerConstructor*>(object), propertyName, descriptor);
}

ConstructType JSWorkerConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSWorker;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSWorkerPrototypeTableValues[] =
{
    { "postMessage", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerPrototypeFunctionPostMessage), (intptr_t)2, NoIntrinsic },
    { "terminate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerPrototypeFunctionTerminate), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerPrototypeTable = { 5, 3, JSWorkerPrototypeTableValues, 0 };
const ClassInfo JSWorkerPrototype::s_info = { "WorkerPrototype", &Base::s_info, &JSWorkerPrototypeTable, 0, CREATE_METHOD_TABLE(JSWorkerPrototype) };

JSObject* JSWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorker>(exec, globalObject);
}

bool JSWorkerPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerPrototype* thisObject = jsCast<JSWorkerPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWorkerPrototypeTable, thisObject, propertyName, slot);
}

bool JSWorkerPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerPrototype* thisObject = jsCast<JSWorkerPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWorkerPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWorker::s_info = { "Worker", &Base::s_info, &JSWorkerTable, 0 , CREATE_METHOD_TABLE(JSWorker) };

JSWorker::JSWorker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Worker> impl)
    : JSAbstractWorker(structure, globalObject, impl)
{
}

void JSWorker::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWorkerPrototype::create(exec->globalData(), globalObject, JSWorkerPrototype::createStructure(exec->globalData(), globalObject, JSAbstractWorkerPrototype::self(exec, globalObject)));
}

bool JSWorker::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorker* thisObject = jsCast<JSWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWorker, Base>(exec, &JSWorkerTable, thisObject, propertyName, slot);
}

bool JSWorker::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorker* thisObject = jsCast<JSWorker*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWorker, Base>(exec, &JSWorkerTable, thisObject, propertyName, descriptor);
}

JSValue jsWorkerOnmessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorker* castedThis = jsCast<JSWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Worker* impl = static_cast<Worker*>(castedThis->impl());
    if (EventListener* listener = impl->onmessage()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsWorkerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorker* domObject = jsCast<JSWorker*>(asObject(slotBase));
    return JSWorker::getConstructor(exec, domObject->globalObject());
}

void JSWorker::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWorker* thisObject = jsCast<JSWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWorker, Base>(exec, propertyName, value, &JSWorkerTable, thisObject, slot);
}

void setJSWorkerOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSWorker* castedThis = jsCast<JSWorker*>(thisObject);
    Worker* impl = static_cast<Worker*>(castedThis->impl());
    impl->setOnmessage(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSWorker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWorkerPrototypeFunctionPostMessage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWorker::s_info))
        return throwVMTypeError(exec);
    JSWorker* castedThis = jsCast<JSWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorker::s_info);
    return JSValue::encode(castedThis->postMessage(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerPrototypeFunctionTerminate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWorker::s_info))
        return throwVMTypeError(exec);
    JSWorker* castedThis = jsCast<JSWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorker::s_info);
    Worker* impl = static_cast<Worker*>(castedThis->impl());
    impl->terminate();
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSWorker* jsWorker)
{
    if (jsWorker->hasCustomProperties())
        return true;
    return false;
}

bool JSWorkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWorker* jsWorker = jsCast<JSWorker*>(handle.get().asCell());
    if (jsWorker->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsWorker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWorkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWorker* jsWorker = jsCast<JSWorker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWorker->impl(), jsWorker);
    jsWorker->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Worker* impl)
{
    return wrap<JSWorker>(exec, globalObject, impl);
}

Worker* toWorker(JSC::JSValue value)
{
    return value.inherits(&JSWorker::s_info) ? jsCast<JSWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
