/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLAreaElement.h"

#include "HTMLAreaElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAreaElementTableValues[] =
{
    { "alt", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementAlt), (intptr_t)setJSHTMLAreaElementAlt, NoIntrinsic },
    { "coords", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementCoords), (intptr_t)setJSHTMLAreaElementCoords, NoIntrinsic },
    { "href", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementHref), (intptr_t)setJSHTMLAreaElementHref, NoIntrinsic },
    { "noHref", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementNoHref), (intptr_t)setJSHTMLAreaElementNoHref, NoIntrinsic },
    { "ping", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementPing), (intptr_t)setJSHTMLAreaElementPing, NoIntrinsic },
    { "shape", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementShape), (intptr_t)setJSHTMLAreaElementShape, NoIntrinsic },
    { "target", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementTarget), (intptr_t)setJSHTMLAreaElementTarget, NoIntrinsic },
    { "hash", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementHash), (intptr_t)0, NoIntrinsic },
    { "host", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementHost), (intptr_t)0, NoIntrinsic },
    { "hostname", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementHostname), (intptr_t)0, NoIntrinsic },
    { "pathname", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementPathname), (intptr_t)0, NoIntrinsic },
    { "port", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementPort), (intptr_t)0, NoIntrinsic },
    { "protocol", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementProtocol), (intptr_t)0, NoIntrinsic },
    { "search", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementSearch), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAreaElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAreaElementTable = { 37, 31, JSHTMLAreaElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLAreaElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAreaElementConstructorTable = { 1, 0, JSHTMLAreaElementConstructorTableValues, 0 };
const ClassInfo JSHTMLAreaElementConstructor::s_info = { "HTMLAreaElementConstructor", &Base::s_info, &JSHTMLAreaElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLAreaElementConstructor) };

JSHTMLAreaElementConstructor::JSHTMLAreaElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLAreaElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLAreaElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLAreaElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAreaElementConstructor, JSDOMWrapper>(exec, &JSHTMLAreaElementConstructorTable, jsCast<JSHTMLAreaElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLAreaElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLAreaElementConstructor, JSDOMWrapper>(exec, &JSHTMLAreaElementConstructorTable, jsCast<JSHTMLAreaElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAreaElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAreaElementPrototypeTable = { 1, 0, JSHTMLAreaElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLAreaElementPrototype::s_info = { "HTMLAreaElementPrototype", &Base::s_info, &JSHTMLAreaElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLAreaElementPrototype) };

JSObject* JSHTMLAreaElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLAreaElement>(exec, globalObject);
}

const ClassInfo JSHTMLAreaElement::s_info = { "HTMLAreaElement", &Base::s_info, &JSHTMLAreaElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLAreaElement) };

JSHTMLAreaElement::JSHTMLAreaElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLAreaElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLAreaElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLAreaElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLAreaElementPrototype::create(exec->globalData(), globalObject, JSHTMLAreaElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLAreaElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLAreaElement* thisObject = jsCast<JSHTMLAreaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLAreaElement, Base>(exec, &JSHTMLAreaElementTable, thisObject, propertyName, slot);
}

bool JSHTMLAreaElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLAreaElement* thisObject = jsCast<JSHTMLAreaElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLAreaElement, Base>(exec, &JSHTMLAreaElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLAreaElementAlt(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}


JSValue jsHTMLAreaElementCoords(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::coordsAttr));
    return result;
}


JSValue jsHTMLAreaElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}


JSValue jsHTMLAreaElementNoHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::nohrefAttr));
    return result;
}


JSValue jsHTMLAreaElementPing(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::pingAttr));
    return result;
}


JSValue jsHTMLAreaElementShape(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::shapeAttr));
    return result;
}


JSValue jsHTMLAreaElementTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}


JSValue jsHTMLAreaElementHash(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->hash());
    return result;
}


JSValue jsHTMLAreaElementHost(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->host());
    return result;
}


JSValue jsHTMLAreaElementHostname(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->hostname());
    return result;
}


JSValue jsHTMLAreaElementPathname(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->pathname());
    return result;
}


JSValue jsHTMLAreaElementPort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->port());
    return result;
}


JSValue jsHTMLAreaElementProtocol(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->protocol());
    return result;
}


JSValue jsHTMLAreaElementSearch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->search());
    return result;
}


JSValue jsHTMLAreaElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAreaElement* domObject = jsCast<JSHTMLAreaElement*>(asObject(slotBase));
    return JSHTMLAreaElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLAreaElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLAreaElement* thisObject = jsCast<JSHTMLAreaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLAreaElement, Base>(exec, propertyName, value, &JSHTMLAreaElementTable, thisObject, slot);
}

void setJSHTMLAreaElementAlt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::altAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAreaElementCoords(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::coordsAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAreaElementHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::hrefAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAreaElementNoHref(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::nohrefAttr, value.toBoolean(exec));
}


void setJSHTMLAreaElementPing(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::pingAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAreaElementShape(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::shapeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLAreaElementTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAreaElement* castedThis = jsCast<JSHTMLAreaElement*>(thisObject);
    HTMLAreaElement* impl = static_cast<HTMLAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::targetAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLAreaElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAreaElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
