#define IN_TP_QT_HEADER
#include "TelepathyQt/call-content-media-description.h"

namespace Tp
{
namespace Client
{

CallContentMediaDescriptionInterface::CallContentMediaDescriptionInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentMediaDescriptionInterface::CallContentMediaDescriptionInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentMediaDescriptionInterface::CallContentMediaDescriptionInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void CallContentMediaDescriptionInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentMediaDescriptionInterfaceRTCPExtendedReportsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::CallContentMediaDescriptionInterfaceRTCPFeedbackInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentMediaDescriptionInterfaceRTCPFeedbackInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface(const Tp::Client::CallContentMediaDescriptionInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallContentMediaDescriptionInterfaceRTPHeaderExtensionsInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
