/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStringList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGStringListTableValues[] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStringListNumberOfItems), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStringListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStringListTable = { 4, 3, JSSVGStringListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGStringListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStringListConstructorTable = { 1, 0, JSSVGStringListConstructorTableValues, 0 };
const ClassInfo JSSVGStringListConstructor::s_info = { "SVGStringListConstructor", &Base::s_info, &JSSVGStringListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGStringListConstructor) };

JSSVGStringListConstructor::JSSVGStringListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGStringListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGStringListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGStringListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStringListConstructor, JSDOMWrapper>(exec, &JSSVGStringListConstructorTable, jsCast<JSSVGStringListConstructor*>(cell), propertyName, slot);
}

bool JSSVGStringListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStringListConstructor, JSDOMWrapper>(exec, &JSSVGStringListConstructorTable, jsCast<JSSVGStringListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGStringListPrototypeTableValues[] =
{
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "initialize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionInitialize), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "insertItemBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionInsertItemBefore), (intptr_t)2, NoIntrinsic },
    { "replaceItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionReplaceItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "appendItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGStringListPrototypeFunctionAppendItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGStringListPrototypeTable = { 18, 15, JSSVGStringListPrototypeTableValues, 0 };
const ClassInfo JSSVGStringListPrototype::s_info = { "SVGStringListPrototype", &Base::s_info, &JSSVGStringListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGStringListPrototype) };

JSObject* JSSVGStringListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStringList>(exec, globalObject);
}

bool JSSVGStringListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStringListPrototype* thisObject = jsCast<JSSVGStringListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGStringListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGStringListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStringListPrototype* thisObject = jsCast<JSSVGStringListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGStringListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGStringList::s_info = { "SVGStringList", &Base::s_info, &JSSVGStringListTable, 0 , CREATE_METHOD_TABLE(JSSVGStringList) };

JSSVGStringList::JSSVGStringList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStaticListPropertyTearOff<SVGStringList> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGStringList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGStringList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGStringListPrototype::create(exec->globalData(), globalObject, JSSVGStringListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGStringList::destroy(JSC::JSCell* cell)
{
    JSSVGStringList* thisObject = static_cast<JSSVGStringList*>(cell);
    thisObject->JSSVGStringList::~JSSVGStringList();
}

JSSVGStringList::~JSSVGStringList()
{
    releaseImplIfNotNull();
}

bool JSSVGStringList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGStringList* thisObject = jsCast<JSSVGStringList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGStringList, Base>(exec, &JSSVGStringListTable, thisObject, propertyName, slot);
}

bool JSSVGStringList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGStringList* thisObject = jsCast<JSSVGStringList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGStringList, Base>(exec, &JSSVGStringListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGStringListNumberOfItems(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JSValue result =  jsNumber(castedThis->impl()->numberOfItems());
    return result;
}


JSValue jsSVGStringListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGStringList* domObject = jsCast<JSSVGStringList*>(asObject(slotBase));
    return JSSVGStringList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGStringList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGStringListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& item(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->initialize(item, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->getItem(index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& item(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->insertItemBefore(item, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& item(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->replaceItem(item, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->removeItem(index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGStringListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGStringList::s_info))
        return throwVMTypeError(exec);
    JSSVGStringList* castedThis = jsCast<JSSVGStringList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGStringList::s_info);
    SVGStaticListPropertyTearOff<SVGStringList> * impl = static_cast<SVGStaticListPropertyTearOff<SVGStringList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& item(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->appendItem(item, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGStringList* jsSVGStringList)
{
    if (jsSVGStringList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGStringListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGStringList* jsSVGStringList = jsCast<JSSVGStringList*>(handle.get().asCell());
    if (!isObservable(jsSVGStringList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGStringListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGStringList* jsSVGStringList = jsCast<JSSVGStringList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGStringList->impl(), jsSVGStringList);
    jsSVGStringList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGStaticListPropertyTearOff<SVGStringList> * impl)
{
    return wrap<JSSVGStringList>(exec, globalObject, impl);
}

SVGStaticListPropertyTearOff<SVGStringList> * toSVGStringList(JSC::JSValue value)
{
    return value.inherits(&JSSVGStringList::s_info) ? jsCast<JSSVGStringList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
