/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMallocStatistics.h"

#include "MallocStatistics.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMallocStatisticsTableValues[] =
{
    { "reservedVMBytes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsReservedVMBytes), (intptr_t)0, NoIntrinsic },
    { "committedVMBytes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsCommittedVMBytes), (intptr_t)0, NoIntrinsic },
    { "freeListBytes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsFreeListBytes), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMallocStatisticsTable = { 8, 7, JSMallocStatisticsTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSMallocStatisticsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMallocStatisticsPrototypeTable = { 1, 0, JSMallocStatisticsPrototypeTableValues, 0 };
const ClassInfo JSMallocStatisticsPrototype::s_info = { "MallocStatisticsPrototype", &Base::s_info, &JSMallocStatisticsPrototypeTable, 0, CREATE_METHOD_TABLE(JSMallocStatisticsPrototype) };

JSObject* JSMallocStatisticsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMallocStatistics>(exec, globalObject);
}

const ClassInfo JSMallocStatistics::s_info = { "MallocStatistics", &Base::s_info, &JSMallocStatisticsTable, 0 , CREATE_METHOD_TABLE(JSMallocStatistics) };

JSMallocStatistics::JSMallocStatistics(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MallocStatistics> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMallocStatistics::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMallocStatistics::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMallocStatisticsPrototype::create(exec->globalData(), globalObject, JSMallocStatisticsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSMallocStatistics::destroy(JSC::JSCell* cell)
{
    JSMallocStatistics* thisObject = static_cast<JSMallocStatistics*>(cell);
    thisObject->JSMallocStatistics::~JSMallocStatistics();
}

JSMallocStatistics::~JSMallocStatistics()
{
    releaseImplIfNotNull();
}

bool JSMallocStatistics::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMallocStatistics* thisObject = jsCast<JSMallocStatistics*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMallocStatistics, Base>(exec, &JSMallocStatisticsTable, thisObject, propertyName, slot);
}

bool JSMallocStatistics::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMallocStatistics* thisObject = jsCast<JSMallocStatistics*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMallocStatistics, Base>(exec, &JSMallocStatisticsTable, thisObject, propertyName, descriptor);
}

JSValue jsMallocStatisticsReservedVMBytes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMallocStatistics* castedThis = jsCast<JSMallocStatistics*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MallocStatistics* impl = static_cast<MallocStatistics*>(castedThis->impl());
    JSValue result = jsNumber(impl->reservedVMBytes());
    return result;
}


JSValue jsMallocStatisticsCommittedVMBytes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMallocStatistics* castedThis = jsCast<JSMallocStatistics*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MallocStatistics* impl = static_cast<MallocStatistics*>(castedThis->impl());
    JSValue result = jsNumber(impl->committedVMBytes());
    return result;
}


JSValue jsMallocStatisticsFreeListBytes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMallocStatistics* castedThis = jsCast<JSMallocStatistics*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MallocStatistics* impl = static_cast<MallocStatistics*>(castedThis->impl());
    JSValue result = jsNumber(impl->freeListBytes());
    return result;
}


static inline bool isObservable(JSMallocStatistics* jsMallocStatistics)
{
    if (jsMallocStatistics->hasCustomProperties())
        return true;
    return false;
}

bool JSMallocStatisticsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMallocStatistics* jsMallocStatistics = jsCast<JSMallocStatistics*>(handle.get().asCell());
    if (!isObservable(jsMallocStatistics))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMallocStatisticsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMallocStatistics* jsMallocStatistics = jsCast<JSMallocStatistics*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMallocStatistics->impl(), jsMallocStatistics);
    jsMallocStatistics->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MallocStatistics* impl)
{
    return wrap<JSMallocStatistics>(exec, globalObject, impl);
}

MallocStatistics* toMallocStatistics(JSC::JSValue value)
{
    return value.inherits(&JSMallocStatistics::s_info) ? jsCast<JSMallocStatistics*>(asObject(value))->impl() : 0;
}

}
