/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGViewSpec.h"

#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGElement.h"
#include "JSSVGTransformList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGTransformList.h"
#include "SVGViewSpec.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGViewSpecTableValues[] =
{
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransform), (intptr_t)0, NoIntrinsic },
    { "viewTarget", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTarget), (intptr_t)0, NoIntrinsic },
    { "viewBoxString", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBoxString), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatioString", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatioString), (intptr_t)0, NoIntrinsic },
    { "transformString", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecTransformString), (intptr_t)0, NoIntrinsic },
    { "viewTargetString", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewTargetString), (intptr_t)0, NoIntrinsic },
    { "zoomAndPan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecZoomAndPan), (intptr_t)setJSSVGViewSpecZoomAndPan, NoIntrinsic },
    { "viewBox", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecViewBox), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGViewSpecConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGViewSpecTable = { 33, 31, JSSVGViewSpecTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGViewSpecConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGViewSpecConstructorTable = { 1, 0, JSSVGViewSpecConstructorTableValues, 0 };
const ClassInfo JSSVGViewSpecConstructor::s_info = { "SVGViewSpecConstructor", &Base::s_info, &JSSVGViewSpecConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGViewSpecConstructor) };

JSSVGViewSpecConstructor::JSSVGViewSpecConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGViewSpecConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGViewSpecPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGViewSpecConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGViewSpecConstructor, JSDOMWrapper>(exec, &JSSVGViewSpecConstructorTable, jsCast<JSSVGViewSpecConstructor*>(cell), propertyName, slot);
}

bool JSSVGViewSpecConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGViewSpecConstructor, JSDOMWrapper>(exec, &JSSVGViewSpecConstructorTable, jsCast<JSSVGViewSpecConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGViewSpecPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGViewSpecPrototypeTable = { 1, 0, JSSVGViewSpecPrototypeTableValues, 0 };
const ClassInfo JSSVGViewSpecPrototype::s_info = { "SVGViewSpecPrototype", &Base::s_info, &JSSVGViewSpecPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGViewSpecPrototype) };

JSObject* JSSVGViewSpecPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGViewSpec>(exec, globalObject);
}

const ClassInfo JSSVGViewSpec::s_info = { "SVGViewSpec", &Base::s_info, &JSSVGViewSpecTable, 0 , CREATE_METHOD_TABLE(JSSVGViewSpec) };

JSSVGViewSpec::JSSVGViewSpec(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGViewSpec> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGViewSpec::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGViewSpec::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGViewSpecPrototype::create(exec->globalData(), globalObject, JSSVGViewSpecPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGViewSpec::destroy(JSC::JSCell* cell)
{
    JSSVGViewSpec* thisObject = static_cast<JSSVGViewSpec*>(cell);
    thisObject->JSSVGViewSpec::~JSSVGViewSpec();
}

JSSVGViewSpec::~JSSVGViewSpec()
{
    releaseImplIfNotNull();
}

bool JSSVGViewSpec::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGViewSpec* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGViewSpec, Base>(exec, &JSSVGViewSpecTable, thisObject, propertyName, slot);
}

bool JSSVGViewSpec::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGViewSpec* thisObject = jsCast<JSSVGViewSpec*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGViewSpec, Base>(exec, &JSSVGViewSpecTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGViewSpecTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGTransformListPropertyTearOff*>(impl->transform())));
    return result;
}


JSValue jsSVGViewSpecViewTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGElement*>(impl->viewTarget())));
    return result;
}


JSValue jsSVGViewSpecViewBoxString(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->viewBoxString());
    return result;
}


JSValue jsSVGViewSpecPreserveAspectRatioString(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->preserveAspectRatioString());
    return result;
}


JSValue jsSVGViewSpecTransformString(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->transformString());
    return result;
}


JSValue jsSVGViewSpecViewTargetString(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->viewTargetString());
    return result;
}


JSValue jsSVGViewSpecZoomAndPan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    JSValue result = jsNumber(impl->zoomAndPan());
    return result;
}


JSValue jsSVGViewSpecViewBox(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = impl->viewBoxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGViewSpecPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGViewSpecConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGViewSpec* domObject = jsCast<JSSVGViewSpec*>(asObject(slotBase));
    return JSSVGViewSpec::getConstructor(exec, domObject->globalObject());
}

void JSSVGViewSpec::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGViewSpec* thisObject = jsCast<JSSVGViewSpec*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGViewSpec, Base>(exec, propertyName, value, &JSSVGViewSpecTable, thisObject, slot);
}

void setJSSVGViewSpecZoomAndPan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGViewSpec* castedThis = jsCast<JSSVGViewSpec*>(thisObject);
    SVGViewSpec* impl = static_cast<SVGViewSpec*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setZoomAndPan(value.toUInt32(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGViewSpec::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGViewSpecConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGViewSpec* jsSVGViewSpec)
{
    if (jsSVGViewSpec->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGViewSpecOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGViewSpec* jsSVGViewSpec = jsCast<JSSVGViewSpec*>(handle.get().asCell());
    if (!isObservable(jsSVGViewSpec))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGViewSpecOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGViewSpec* jsSVGViewSpec = jsCast<JSSVGViewSpec*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGViewSpec->impl(), jsSVGViewSpec);
    jsSVGViewSpec->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGViewSpec* impl)
{
    return wrap<JSSVGViewSpec>(exec, globalObject, impl);
}

SVGViewSpec* toSVGViewSpec(JSC::JSValue value)
{
    return value.inherits(&JSSVGViewSpec::s_info) ? jsCast<JSSVGViewSpec*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
