/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureFloat.h"

#include "OESTextureFloat.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSOESTextureFloatPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOESTextureFloatPrototypeTable = { 1, 0, JSOESTextureFloatPrototypeTableValues, 0 };
const ClassInfo JSOESTextureFloatPrototype::s_info = { "OESTextureFloatPrototype", &Base::s_info, &JSOESTextureFloatPrototypeTable, 0, CREATE_METHOD_TABLE(JSOESTextureFloatPrototype) };

JSObject* JSOESTextureFloatPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOESTextureFloat>(exec, globalObject);
}

const ClassInfo JSOESTextureFloat::s_info = { "OESTextureFloat", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSOESTextureFloat) };

JSOESTextureFloat::JSOESTextureFloat(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OESTextureFloat> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSOESTextureFloat::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSOESTextureFloat::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOESTextureFloatPrototype::create(exec->globalData(), globalObject, JSOESTextureFloatPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSOESTextureFloat::destroy(JSC::JSCell* cell)
{
    JSOESTextureFloat* thisObject = static_cast<JSOESTextureFloat*>(cell);
    thisObject->JSOESTextureFloat::~JSOESTextureFloat();
}

JSOESTextureFloat::~JSOESTextureFloat()
{
    releaseImplIfNotNull();
}

static inline bool isObservable(JSOESTextureFloat* jsOESTextureFloat)
{
    if (jsOESTextureFloat->hasCustomProperties())
        return true;
    return false;
}

bool JSOESTextureFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSOESTextureFloat* jsOESTextureFloat = jsCast<JSOESTextureFloat*>(handle.get().asCell());
    if (!isObservable(jsOESTextureFloat))
        return false;
    WebGLRenderingContext* root = jsOESTextureFloat->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSOESTextureFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSOESTextureFloat* jsOESTextureFloat = jsCast<JSOESTextureFloat*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESTextureFloat->impl(), jsOESTextureFloat);
    jsOESTextureFloat->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, OESTextureFloat* impl)
{
    return wrap<JSOESTextureFloat>(exec, globalObject, impl);
}

OESTextureFloat* toOESTextureFloat(JSC::JSValue value)
{
    return value.inherits(&JSOESTextureFloat::s_info) ? jsCast<JSOESTextureFloat*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
