/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"

        #include <wx/animate.h>

        #include <wx/animdecod.h>
        #include <wx/animate.h>
        
        #include <wx/stream.h>
        #include <wx/gdicmn.h>
        #include <wx/image.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxAnimation_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if animation data is present.");

extern "C" {static PyObject *meth_wxAnimation_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAnimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAnimation, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_IsCompatibleWith, "IsCompatibleWith(ci) -> bool\n"
"\n"
"Returns true if animation can be used with controls of the given type.");

extern "C" {static PyObject *meth_wxAnimation_IsCompatibleWith(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_IsCompatibleWith(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxClassInfo* ci;
        const  ::wxAnimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ci,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxAnimation, &sipCpp, sipType_wxClassInfo, &ci))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsCompatibleWith(ci);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_IsCompatibleWith, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_GetDelay, "GetDelay(frame) -> int\n"
"\n"
"Returns the delay for the i-th frame in milliseconds.");

extern "C" {static PyObject *meth_wxAnimation_GetDelay(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_GetDelay(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        uint frame;
        const  ::wxAnimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_frame,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxAnimation, &sipCpp, &frame))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDelay(frame);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_GetDelay, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_GetFrameCount, "GetFrameCount() -> unsignedint\n"
"\n"
"Returns the number of frames for this animation.");

extern "C" {static PyObject *meth_wxAnimation_GetFrameCount(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_GetFrameCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAnimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAnimation, &sipCpp))
        {
            uint sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFrameCount();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_GetFrameCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_GetFrame, "GetFrame(frame) -> wx.Image\n"
"\n"
"Returns the i-th frame as a wxImage.");

extern "C" {static PyObject *meth_wxAnimation_GetFrame(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_GetFrame(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        uint frame;
        const  ::wxAnimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_frame,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxAnimation, &sipCpp, &frame))
        {
             ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxImage(sipCpp->GetFrame(frame));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxImage,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_GetFrame, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_GetSize, "GetSize() -> wx.Size\n"
"\n"
"Returns the size of the animation.");

extern "C" {static PyObject *meth_wxAnimation_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAnimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAnimation, &sipCpp))
        {
             ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxSize,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_LoadFile, "LoadFile(name, type=ANIMATION_TYPE_ANY) -> bool\n"
"\n"
"Loads an animation from a file.");

extern "C" {static PyObject *meth_wxAnimation_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxAnimationType type = wxANIMATION_TYPE_ANY;
         ::wxAnimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxAnimation, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxAnimationType, &type))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*name,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_Load, "Load(stream, type=ANIMATION_TYPE_ANY) -> bool\n"
"\n"
"Loads an animation from the given stream.");

extern "C" {static PyObject *meth_wxAnimation_Load(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_Load(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream* stream;
        int streamState = 0;
         ::wxAnimationType type = wxANIMATION_TYPE_ANY;
         ::wxAnimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxAnimation, &sipCpp, sipType_wxInputStream, &stream, &streamState, sipType_wxAnimationType, &type))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Load(*stream,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream,sipType_wxInputStream,streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_Load, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_GetHandlers, "GetHandlers() -> AnimationDecoderList\n"
"\n"
"Returns the list of animation decoders used by the generic animation\n"
"and wxGenericAnimationCtrl.");

extern "C" {static PyObject *meth_wxAnimation_GetHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_GetHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxAnimationDecoderList*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = & ::wxAnimation::GetHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxAnimationDecoderList,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_GetHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_AddHandler, "AddHandler(handler)\n"
"\n"
"Add a new decoder to the list of animation decoders.");

extern "C" {static PyObject *meth_wxAnimation_AddHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_AddHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAnimationDecoder* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_wxAnimationDecoder, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxAnimation::AddHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_AddHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_InsertHandler, "InsertHandler(handler)\n"
"\n"
"Insert a new decoder to the front of the list of animation decoders.");

extern "C" {static PyObject *meth_wxAnimation_InsertHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_InsertHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAnimationDecoder* handler;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_wxAnimationDecoder, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxAnimation::InsertHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_InsertHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_FindHandler, "FindHandler(animType) -> AnimationDecoder\n"
"\n"
"Search for an animation decoder by type.");

extern "C" {static PyObject *meth_wxAnimation_FindHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_FindHandler(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxAnimationType animType;

        static const char *sipKwdList[] = {
            sipName_animType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_wxAnimationType, &animType))
        {
            const  ::wxAnimationDecoder*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxAnimation::FindHandler(animType);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxAnimationDecoder *>(sipRes),sipType_wxAnimationDecoder,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_FindHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_InitStandardHandlers, "InitStandardHandlers()\n"
"\n"
"Load the stock animation decoders (currently GIF and ANI) into the\n"
"list of decoders.");

extern "C" {static PyObject *meth_wxAnimation_InitStandardHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_InitStandardHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxAnimation::InitStandardHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_InitStandardHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimation_CleanUpHandlers, "CleanUpHandlers()\n"
"\n"
"Clear out the animation decoder list.");

extern "C" {static PyObject *meth_wxAnimation_CleanUpHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxAnimation_CleanUpHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxAnimation::CleanUpHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Animation, sipName_CleanUpHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxAnimation(void *, const sipTypeDef *);}
static void *cast_wxAnimation(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxAnimation *sipCpp = reinterpret_cast< ::wxAnimation *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAnimation(void *, int);}
static void release_wxAnimation(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAnimation *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxAnimation(Py_ssize_t);}
static void *array_wxAnimation(Py_ssize_t sipNrElem)
{
    return new  ::wxAnimation[sipNrElem];
}


extern "C" {static void assign_wxAnimation(void *, SIP_SSIZE_T, void *);}
static void assign_wxAnimation(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAnimation *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAnimation *>(sipSrc);
}


extern "C" {static void *copy_wxAnimation(const void *, SIP_SSIZE_T);}
static void *copy_wxAnimation(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAnimation(reinterpret_cast<const  ::wxAnimation *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAnimation(sipSimpleWrapper *);}
static void dealloc_wxAnimation(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAnimation(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAnimation(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAnimation(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAnimation *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAnimation();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxAnimationType type = wxANIMATION_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxString,&name, &nameState, sipType_wxAnimationType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAnimation(*name,type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxAnimation* other;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxAnimation, &other))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAnimation(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxAnimation[] = {{39, 0, 1}};


static PyMethodDef methods_wxAnimation[] = {
    {SIP_MLNAME_CAST(sipName_AddHandler), SIP_MLMETH_CAST(meth_wxAnimation_AddHandler), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_AddHandler)},
    {SIP_MLNAME_CAST(sipName_CleanUpHandlers), meth_wxAnimation_CleanUpHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_CleanUpHandlers)},
    {SIP_MLNAME_CAST(sipName_FindHandler), SIP_MLMETH_CAST(meth_wxAnimation_FindHandler), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_FindHandler)},
    {SIP_MLNAME_CAST(sipName_GetDelay), SIP_MLMETH_CAST(meth_wxAnimation_GetDelay), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_GetDelay)},
    {SIP_MLNAME_CAST(sipName_GetFrame), SIP_MLMETH_CAST(meth_wxAnimation_GetFrame), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_GetFrame)},
    {SIP_MLNAME_CAST(sipName_GetFrameCount), meth_wxAnimation_GetFrameCount, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_GetFrameCount)},
    {SIP_MLNAME_CAST(sipName_GetHandlers), meth_wxAnimation_GetHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_GetHandlers)},
    {SIP_MLNAME_CAST(sipName_GetSize), meth_wxAnimation_GetSize, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_GetSize)},
    {SIP_MLNAME_CAST(sipName_InitStandardHandlers), meth_wxAnimation_InitStandardHandlers, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_InitStandardHandlers)},
    {SIP_MLNAME_CAST(sipName_InsertHandler), SIP_MLMETH_CAST(meth_wxAnimation_InsertHandler), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_InsertHandler)},
    {SIP_MLNAME_CAST(sipName_IsCompatibleWith), SIP_MLMETH_CAST(meth_wxAnimation_IsCompatibleWith), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_IsCompatibleWith)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxAnimation_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAnimation_IsOk)},
    {SIP_MLNAME_CAST(sipName_Load), SIP_MLMETH_CAST(meth_wxAnimation_Load), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_Load)},
    {SIP_MLNAME_CAST(sipName_LoadFile), SIP_MLMETH_CAST(meth_wxAnimation_LoadFile), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxAnimation_LoadFile)}
};

sipVariableDef variables_wxAnimation[] = {
    {PropertyVariable, sipName_Size, &methods_wxAnimation[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FrameCount, &methods_wxAnimation[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxAnimation, "Animation()\n"
"Animation(name, type=ANIMATION_TYPE_ANY)\n"
"Animation(other)\n"
"\n"
"The wxAnimation class handles the interface between the animation\n"
"control and the details of the animation image or data.");


sipClassTypeDef sipTypeDef__adv_wxAnimation = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxAnimation,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Animation,
        {0, 0, 1},
        14, methods_wxAnimation,
        0, SIP_NULLPTR,
        2, variables_wxAnimation,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAnimation,
    -1,
    -1,
    supers_wxAnimation,
    SIP_NULLPTR,
    init_type_wxAnimation,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxAnimation,
    assign_wxAnimation,
    array_wxAnimation,
    copy_wxAnimation,
    release_wxAnimation,
    cast_wxAnimation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
