/*
    image.h - Part of psiconv, a PSION 5 file formats converter
    Copyright (c) 2003-2014  Frodo Looijaard <frodo@frodo.looijaard.name>
                                                                                
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
                                                                                
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
                                                                                
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* This file contains definitions used internally by
   generate_image.c and parse_image.c */

#include "config.h"
#include "compat.h"

#include <psiconv/image.h>

#define PALET_NONE_LEN 0

psiconv_pixel_floats_t psiconv_palet_none =
  {
    PALET_NONE_LEN,
    NULL,
    NULL,
    NULL
  };

#define PALET_COLOR_4_LEN 16
static float palet_color_4_red[PALET_COLOR_4_LEN] =
                   { 0x00/255.0, 0x55/255.0, 0x80/255.0, 0x80/255.0, /* 0x00 */
                     0x00/255.0, 0xff/255.0, 0x00/255.0, 0xff/255.0, /* 0x04 */
                     0xff/255.0, 0x00/255.0, 0x00/255.0, 0x80/255.0, /* 0x08 */
                     0x00/255.0, 0x00/255.0, 0xaa/255.0, 0xff/255.0  /* 0x0c */
		   };

static float palet_color_4_green[PALET_COLOR_4_LEN] =
                   { 0x00/255.0, 0x55/255.0, 0x00/255.0, 0x80/255.0, /* 0x00 */
                     0x80/255.0, 0x00/255.0, 0xff/255.0, 0xff/255.0, /* 0x04 */
                     0x00/255.0, 0xff/255.0, 0xff/255.0, 0x00/255.0, /* 0x08 */
                     0x00/255.0, 0x80/255.0, 0xaa/255.0, 0xff/255.0  /* 0x0c */
		   };

static float palet_color_4_blue[PALET_COLOR_4_LEN] =
                   { 0x00/255.0, 0x55/255.0, 0x00/255.0, 0x00/255.0, /* 0x00 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x04 */
                     0xff/255.0, 0x00/255.0, 0xff/255.0, 0x80/255.0, /* 0x08 */
                     0x80/255.0, 0x80/255.0, 0xaa/255.0, 0xff/255.0  /* 0x0c */
		   };

psiconv_pixel_floats_t psiconv_palet_color_4 =
  {
    PALET_COLOR_4_LEN,
    palet_color_4_red,
    palet_color_4_green,
    palet_color_4_blue,
  };

#define PALET_COLOR_8_LEN 256
static float palet_color_8_red[PALET_COLOR_8_LEN] =
                   { 0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x00 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x04 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x08 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x0c */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x10 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x14 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x18 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x1c */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x20 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x24 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x28 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x2c */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x30 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x34 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x38 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x3c */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x40 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x44 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x48 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x4c */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x50 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x54 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x58 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x5c */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x60 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x64 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x68 */
                     0x11/255.0, 0x22/255.0, 0x44/255.0, 0x55/255.0, /* 0x6c */
                     0x77/255.0, 0x11/255.0, 0x22/255.0, 0x44/255.0, /* 0x70 */
                     0x55/255.0, 0x77/255.0, 0x00/255.0, 0x00/255.0, /* 0x74 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x78 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x7c */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x80 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x84 */
                     0x00/255.0, 0x00/255.0, 0x88/255.0, 0xaa/255.0, /* 0x88 */
                     0xbb/255.0, 0xdd/255.0, 0xee/255.0, 0x88/255.0, /* 0x8c */
                     0xaa/255.0, 0xbb/255.0, 0xdd/255.0, 0xee/255.0, /* 0x90 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0x94 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0x98 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0x9c */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xa0 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xa4 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xa8 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xac */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xb0 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xb4 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xb8 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xbc */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xc0 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xc4 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xc8 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xcc */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xd0 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xd4 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xd8 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xdc */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xe0 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xe4 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xe8 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xec */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0, /* 0xf0 */
                     0x00/255.0, 0x33/255.0, 0x66/255.0, 0x99/255.0, /* 0xf4 */
                     0xcc/255.0, 0xff/255.0, 0x00/255.0, 0x33/255.0, /* 0xf8 */
                     0x66/255.0, 0x99/255.0, 0xcc/255.0, 0xff/255.0  /* 0xfc */
		   };

static float palet_color_8_green[PALET_COLOR_8_LEN] =
                   { 0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x00 */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0x04 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x08 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x0c */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0x10 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x14 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0x18 */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0x1c */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0x20 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x24 */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0x28 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x2c */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x30 */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0x34 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x38 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0x3c */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0x40 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0x44 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x48 */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0x4c */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x50 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x54 */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0x58 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x5c */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0x60 */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0x64 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0x68 */
                     0x11/255.0, 0x22/255.0, 0x44/255.0, 0x55/255.0, /* 0x6c */
                     0x77/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x70 */
                     0x00/255.0, 0x00/255.0, 0x11/255.0, 0x22/255.0, /* 0x74 */
                     0x44/255.0, 0x55/255.0, 0x77/255.0, 0x00/255.0, /* 0x78 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x7c */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x80 */
                     0x00/255.0, 0x88/255.0, 0xaa/255.0, 0xbb/255.0, /* 0x84 */
                     0xdd/255.0, 0xee/255.0, 0x00/255.0, 0x00/255.0, /* 0x88 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x88/255.0, /* 0x8c */
                     0xaa/255.0, 0xbb/255.0, 0xdd/255.0, 0xee/255.0, /* 0x90 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x94 */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0x98 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x9c */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0xa0 */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0xa4 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xa8 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xac */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0xb0 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xb4 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0xb8 */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0xbc */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0xc0 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0xc4 */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0xc8 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xcc */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xd0 */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0xd4 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xd8 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0xdc */
                     0x00/255.0, 0x00/255.0, 0x33/255.0, 0x33/255.0, /* 0xe0 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0xe4 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0xe8 */
                     0x66/255.0, 0x66/255.0, 0x99/255.0, 0x99/255.0, /* 0xec */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xf0 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xf4 */
                     0xcc/255.0, 0xcc/255.0, 0xff/255.0, 0xff/255.0, /* 0xf8 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xfc */
		   };

static float palet_color_8_blue[PALET_COLOR_8_LEN] =
                   { 0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x00 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x04 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x08 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x0c */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x10 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x14 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x18 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x1c */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x20 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x24 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x28 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x2c */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x30 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x34 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x38 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x3c */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x40 */
                     0x33/255.0, 0x33/255.0, 0x33/255.0, 0x33/255.0, /* 0x44 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x48 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x4c */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x50 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x54 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x58 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x5c */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x60 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x64 */
                     0x66/255.0, 0x66/255.0, 0x66/255.0, 0x66/255.0, /* 0x68 */
                     0x11/255.0, 0x22/255.0, 0x44/255.0, 0x55/255.0, /* 0x6c */
                     0x77/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x70 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x74 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x11/255.0, /* 0x78 */
                     0x22/255.0, 0x44/255.0, 0x55/255.0, 0x77/255.0, /* 0x7c */
                     0x88/255.0, 0xaa/255.0, 0xbb/255.0, 0xdd/255.0, /* 0x80 */
                     0xee/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x84 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x00/255.0, /* 0x88 */
                     0x00/255.0, 0x00/255.0, 0x00/255.0, 0x88/255.0, /* 0x8c */
                     0xaa/255.0, 0xbb/255.0, 0xdd/255.0, 0xee/255.0, /* 0x90 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x94 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x98 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0x9c */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xa0 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xa4 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xa8 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xac */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xb0 */
                     0x99/255.0, 0x99/255.0, 0x99/255.0, 0x99/255.0, /* 0xb4 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xb8 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xbc */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xc0 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xc4 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xc8 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xcc */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xd0 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xd4 */
                     0xcc/255.0, 0xcc/255.0, 0xcc/255.0, 0xcc/255.0, /* 0xd8 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xdc */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xe0 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xe4 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xe8 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xec */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xf0 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xf4 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xf8 */
                     0xff/255.0, 0xff/255.0, 0xff/255.0, 0xff/255.0, /* 0xfc */
		   };

psiconv_pixel_floats_t psiconv_palet_color_8 =
  {
    PALET_COLOR_8_LEN,
    palet_color_8_red,
    palet_color_8_green,
    palet_color_8_blue,
  };

