/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.44 from the
 * contents of SEC.xs. Do not edit this file, edit SEC.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SEC.xs"

#define XS_Id "$Id: SEC.xs 1975 2024-04-22 14:41:36Z willem $"


#if 0
  "Skipped embedded POD."
#endif
#line 39 "SEC.xs"


#ifdef __cplusplus
extern "C" {
#endif

#define PERL_NO_GET_CONTEXT
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>

#include <openssl/opensslv.h>

#ifdef OPENSSL_VERSION_NUMBER
#define OPENSSL_RELEASE	( OPENSSL_VERSION_NUMBER>>4 )	/* 0xMMmm0000 */
#else
#define OPENSSL_RELEASE	( OPENSSL_VERSION_MAJOR<<24 | OPENSSL_VERSION_MINOR<<16 )
#endif

#if (OPENSSL_RELEASE < 0x03000000)
#define API_1_1_1
#include <openssl/dsa.h>
#include <openssl/ecdsa.h>
#include <openssl/rsa.h>
#else
#include <openssl/core_names.h>
#include <openssl/param_build.h>
static OSSL_LIB_CTX *libctx = NULL;
#endif

#include <openssl/bn.h>
#include <openssl/err.h>
#include <openssl/evp.h>

#ifdef __cplusplus
}
#endif


#ifdef OPENSSL_NO_DSA
#define NO_DSA
#endif

#ifdef OPENSSL_NO_RSA
#define NO_RSA
#endif

#ifdef OPENSSL_NO_EC
#define NO_ECDSA
#define NO_EdDSA
#endif

#ifdef OPENSSL_NO_ECX
#define NO_EdDSA
#endif

#ifdef OPENSSL_NO_SM3
#define NO_SM3
#endif


#if (OPENSSL_RELEASE < 0x01000100)
#error	ancient libcrypto version
#include OPENSSL_VERSION_TEXT /* in error log; by any means, however reprehensible! */
#endif


#if (OPENSSL_RELEASE < 0x03040000)
#define EOL 20260409
#endif

#if (OPENSSL_RELEASE < 0x03030000)
#undef  EOL
#define EOL 20251123
#endif

#if (OPENSSL_RELEASE < 0x03020000)
#undef  EOL
#define EOL 20250314
#endif

#if (OPENSSL_RELEASE < 0x03010000)
#undef  EOL
#define EOL 20260907
#endif

#if (OPENSSL_RELEASE < 0x03000000)
#undef  EOL
#define EOL 20230911
#define NO_SM3
#ifndef NID_ED25519
#define NO_EdDSA
#endif
#endif


#if (OPENSSL_RELEASE < 0x01010000)
#define EVP_MD_CTX_new()	EVP_MD_CTX_create()
#define EVP_MD_CTX_free(ctx)	EVP_MD_CTX_destroy((ctx))

int DSA_set0_pqg(DSA *d, BIGNUM *p, BIGNUM *q, BIGNUM *g)
{
	d->p = p;
	d->q = q;
	d->g = g;
	return 1;
}

int DSA_set0_key(DSA *d, BIGNUM *pub_key, BIGNUM *priv_key)
{
	d->priv_key = priv_key;
	d->pub_key  = pub_key;
	return 1;
}

int RSA_set0_key(RSA *r, BIGNUM *n, BIGNUM *e, BIGNUM *d)
{
	r->n = n;
	r->e = e;
	r->d = d;
	return 1;
}

int RSA_set0_factors(RSA *r, BIGNUM *p, BIGNUM *q)
{
	r->p = p;
	r->q = q;
	return 1;
}
#endif


#if (OPENSSL_RELEASE < 0x01010100)
int EVP_DigestSign(EVP_MD_CTX *ctx,
		unsigned char *sig, size_t *sig_len,
		const unsigned char *data, size_t data_len)
{
	EVP_DigestUpdate( ctx, data, data_len );
	return EVP_DigestSignFinal( ctx, sig, sig_len );
}

int EVP_DigestVerify(EVP_MD_CTX *ctx,
		const unsigned char *sig, size_t sig_len,
		const unsigned char *data, size_t data_len)
{
	EVP_DigestUpdate( ctx, data, data_len );
	return EVP_DigestVerifyFinal( ctx, sig, sig_len );
}
#endif


#ifdef OPENSSL_IS_BORINGSSL
#undef  EOL
#define NO_DSA
#endif

#ifdef LIBRESSL_VERSION_NUMBER
#undef  EOL
#define NO_DSA
#endif


#define SV2BN(sv)	BN_bin2bn( (unsigned char*) SvPVX(sv), SvCUR(sv), NULL )
#define UNDEF		newSVpvn("",0)
#define UNUSED(sv)	sv=sv;

#define checkerr(arg)	checkret( (arg), __LINE__ )
void checkret(const int ret, int line)
{
	if ( ret <= 0 ) croak( "libcrypto error (%s line %d)", __FILE__, line );
}


#ifdef EVP_PKEY_PUBLIC_KEY
int EVP_PKEY_fromparams(EVP_PKEY_CTX *ctx, EVP_PKEY **ppkey, int selection, OSSL_PARAM_BLD *bld)
{
	int retval;
	OSSL_PARAM *params = OSSL_PARAM_BLD_to_param(bld);
	checkerr( EVP_PKEY_fromdata_init(ctx) );
	retval = EVP_PKEY_fromdata( ctx, ppkey, selection, params );
	OSSL_PARAM_free(params);
	return retval;
}
#endif


#ifdef EOL
char* selecttxt(int d1, int d2, char *txt)
{	/* select text based on ISO date comparison */
	return ( d1 > d2 ) ? txt : "";
}
#endif


#line 213 "SEC.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 357 "SEC.c"

XS_EUPXS(XS_Net__DNS__SEC__libcrypto_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_VERSION)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "void");
    {
	SV *	RETVAL;
#line 240 "SEC.xs"
	char *v = SvEND( newSVpv(XS_Id, 17) );
#ifdef EOL
	time_t today = time( NULL );
	char buf[10];
	char *txt;
#endif
#line 374 "SEC.c"
#line 247 "SEC.xs"
#ifdef EOL
	strftime( buf, sizeof buf, "%Y%m%d", gmtime(&today) );
	txt = selecttxt( EOL, atoi(buf), "" );	/* get 100% coverage by calling this twice */
	txt = selecttxt( atoi(buf), EOL, "	[UNSUPPORTED]" );
	RETVAL = newSVpvf( "%s	%s%s", v-5, OPENSSL_VERSION_TEXT, txt );
#else
	RETVAL = newSVpvf( "%s	%s", v-5, OPENSSL_VERSION_TEXT );
#endif
#line 384 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_PKEY *	RETVAL;

	RETVAL = EVP_PKEY_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sign)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "message, pkey, md=NULL");
    {
	SV *	RETVAL;
	SV *	message = ST(0)
;
	EVP_PKEY *	pkey;
	const EVP_MD *	md;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_sign",
			"pkey", "EVP_PKEYPtr",
			refstr, ST(1)
		);
	}
;

	if (items < 3)
	    md = NULL;
	else {
	    if (SvROK(ST(2)) && sv_derived_from(ST(2), "const EVP_MDPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(2)));
		md = INT2PTR(const EVP_MD *,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Net::DNS::SEC::libcrypto::EVP_sign",
			    "md", "const EVP_MDPtr",
			    refstr, ST(2)
		    );
	    }
;
	}
#line 267 "SEC.xs"
#define msgbuf (unsigned char*) SvPVX(message)
#define msglen SvCUR(message)
	EVP_MD_CTX *ctx = EVP_MD_CTX_new();
	unsigned char sigbuf[512];		/* RFC3110(2) */
	STRLEN buflen = sizeof(sigbuf);
	int error;
#line 464 "SEC.c"
#line 274 "SEC.xs"
	checkerr( EVP_DigestSignInit( ctx, NULL, md, NULL, pkey ) );
	error = EVP_DigestSign( ctx, sigbuf, &buflen, msgbuf, msglen );
	EVP_MD_CTX_free(ctx);
	EVP_PKEY_free(pkey);
	checkerr(error);
	RETVAL = newSVpvn( (char*)sigbuf, buflen );
#line 472 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_verify)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "message, signature, pkey, md=NULL");
    {
	int	RETVAL;
	dXSTARG;
	SV *	message = ST(0)
;
	SV *	signature = ST(1)
;
	EVP_PKEY *	pkey;
	const EVP_MD *	md;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "EVP_PKEYPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    pkey = INT2PTR(EVP_PKEY *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_verify",
			"pkey", "EVP_PKEYPtr",
			refstr, ST(2)
		);
	}
;

	if (items < 4)
	    md = NULL;
	else {
	    if (SvROK(ST(3)) && sv_derived_from(ST(3), "const EVP_MDPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(3)));
		md = INT2PTR(const EVP_MD *,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(3)) ? "" : SvOK(ST(3)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Net::DNS::SEC::libcrypto::EVP_verify",
			    "md", "const EVP_MDPtr",
			    refstr, ST(3)
		    );
	    }
;
	}
#line 286 "SEC.xs"
#define sigbuf (unsigned char*) SvPVX(signature)
#define siglen SvCUR(signature)
	EVP_MD_CTX *ctx = EVP_MD_CTX_new();
#line 531 "SEC.c"
#line 290 "SEC.xs"
	checkerr( EVP_DigestVerifyInit( ctx, NULL, md, NULL, pkey ) );
	RETVAL = EVP_DigestVerify( ctx, sigbuf, siglen, msgbuf, msglen );
	EVP_MD_CTX_free(ctx);
	EVP_PKEY_free(pkey);
#line 537 "SEC.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	EVP_MD_CTX *	RETVAL;

	RETVAL = EVP_MD_CTX_new();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_MD_CTXPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	EVP_MD_CTX *	ctx;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_MD_CTX_free",
			"ctx", "EVP_MD_CTXPtr",
			refstr, ST(0)
		);
	}
;

	EVP_MD_CTX_free(ctx);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestInit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestInit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, type");
    {
	EVP_MD_CTX *	ctx;
	const EVP_MD *	type;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_DigestInit",
			"ctx", "EVP_MD_CTXPtr",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "const EVP_MDPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    type = INT2PTR(const EVP_MD *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_DigestInit",
			"type", "const EVP_MDPtr",
			refstr, ST(1)
		);
	}
;
#line 307 "SEC.xs"
	checkerr( EVP_DigestInit( ctx, type ) );
#line 634 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctx, message");
    {
	EVP_MD_CTX *	ctx;
	SV *	message = ST(1)
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_DigestUpdate",
			"ctx", "EVP_MD_CTXPtr",
			refstr, ST(0)
		);
	}
;
#line 312 "SEC.xs"
	checkerr( EVP_DigestUpdate( ctx, msgbuf, msglen ) );
#line 666 "SEC.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ctx");
    {
	SV *	RETVAL;
	EVP_MD_CTX *	ctx;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "EVP_MD_CTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ctx = INT2PTR(EVP_MD_CTX *,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Net::DNS::SEC::libcrypto::EVP_DigestFinal",
			"ctx", "EVP_MD_CTXPtr",
			refstr, ST(0)
		);
	}
;
#line 317 "SEC.xs"
	unsigned char digest[EVP_MAX_MD_SIZE];
	unsigned int size = sizeof(digest);
#line 698 "SEC.c"
#line 320 "SEC.xs"
	checkerr( EVP_DigestFinal( ctx, digest, &size ) );
	RETVAL = newSVpvn( (char*)digest, size );
#line 702 "SEC.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_md5); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_md5)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_md5();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha1)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha1();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha224); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha224)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha224();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha256); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha256)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha256();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha384); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha384)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha384();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha512); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sha512)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sha512();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifndef NO_SM3
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sm3); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_sm3)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const EVP_MD *	RETVAL;

	RETVAL = EVP_sm3();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "const EVP_MDPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_DSA
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_DSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_DSA)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "p_SV, q_SV, g_SV, y_SV, x_SV=UNDEF");
    {
	EVP_PKEY *	RETVAL;
	SV *	p_SV = ST(0)
;
	SV *	q_SV = ST(1)
;
	SV *	g_SV = ST(2)
;
	SV *	y_SV = ST(3)
;
	SV *	x_SV;

	if (items < 5)
	    x_SV = UNDEF;
	else {
	    x_SV = ST(4)
;
	}
#line 359 "SEC.xs"
#ifdef API_1_1_1
	DSA *dsa = DSA_new();
#else
	EVP_PKEY_CTX *ctx = EVP_PKEY_CTX_new_from_name( libctx, "DSA", NULL );
	OSSL_PARAM_BLD *bld = OSSL_PARAM_BLD_new();
	BIGNUM *p, *q, *g, *x, *y;
#endif
#line 896 "SEC.c"
#line 367 "SEC.xs"
#ifdef API_1_1_1
	RETVAL = EVP_PKEY_new();
	checkerr( DSA_set0_pqg( dsa, SV2BN(p_SV), SV2BN(q_SV), SV2BN(g_SV) ) );
	checkerr( DSA_set0_key( dsa, SV2BN(y_SV), SV2BN(x_SV) ) );
	checkerr( EVP_PKEY_assign( RETVAL, EVP_PKEY_DSA, (char*)dsa ) );
#else
	RETVAL = NULL;
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_FFC_P, p=SV2BN(p_SV) ) );
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_FFC_Q, q=SV2BN(q_SV) ) );
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_FFC_G, g=SV2BN(g_SV) ) );
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_PUB_KEY, y=SV2BN(y_SV) ) );
	if ( SvCUR(x_SV) > 0 ) {
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_PRIV_KEY, x=SV2BN(x_SV) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_KEYPAIR, bld ) );
		BN_free(x);
	} else {
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_PUBLIC_KEY, bld ) );
	}
	OSSL_PARAM_BLD_free(bld);
	EVP_PKEY_CTX_free(ctx);
	BN_free(p);
	BN_free(q);
	BN_free(g);
	BN_free(y);
#endif
#line 923 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_RSA
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_RSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_RSA)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 8)
       croak_xs_usage(cv,  "n_SV, e_SV, d_SV=UNDEF, p1_SV=UNDEF, p2_SV=UNDEF, e1_SV=UNDEF, e2_SV=UNDEF, c_SV=UNDEF");
    {
	EVP_PKEY *	RETVAL;
	SV *	n_SV = ST(0)
;
	SV *	e_SV = ST(1)
;
	SV *	d_SV;
	SV *	p1_SV;
	SV *	p2_SV;
	SV *	e1_SV;
	SV *	e2_SV;
	SV *	c_SV;

	if (items < 3)
	    d_SV = UNDEF;
	else {
	    d_SV = ST(2)
;
	}

	if (items < 4)
	    p1_SV = UNDEF;
	else {
	    p1_SV = ST(3)
;
	}

	if (items < 5)
	    p2_SV = UNDEF;
	else {
	    p2_SV = ST(4)
;
	}

	if (items < 6)
	    e1_SV = UNDEF;
	else {
	    e1_SV = ST(5)
;
	}

	if (items < 7)
	    e2_SV = UNDEF;
	else {
	    e2_SV = ST(6)
;
	}

	if (items < 8)
	    c_SV = UNDEF;
	else {
	    c_SV = ST(7)
;
	}
#line 405 "SEC.xs"
#ifdef API_1_1_1
	RSA *rsa = RSA_new();
#else
	EVP_PKEY_CTX *ctx = EVP_PKEY_CTX_new_from_name( libctx, "RSA", NULL );
	OSSL_PARAM_BLD *bld = OSSL_PARAM_BLD_new();
	BIGNUM *n, *e, *d, *p1, *p2, *e1, *e2, *c;
#endif
#line 1007 "SEC.c"
#line 413 "SEC.xs"
#ifdef API_1_1_1
	RETVAL = EVP_PKEY_new();
	checkerr( RSA_set0_factors( rsa, SV2BN(p1_SV), SV2BN(p2_SV) ) );
	checkerr( RSA_set0_key( rsa, SV2BN(n_SV), SV2BN(e_SV), SV2BN(d_SV) ) );
	checkerr( EVP_PKEY_assign( RETVAL, EVP_PKEY_RSA, (char*)rsa ) );
	UNUSED(e1_SV); UNUSED(e2_SV); UNUSED(c_SV);	/* suppress unused variable warnings */
#else
	RETVAL = NULL;
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_N, n=SV2BN(n_SV) ) );
	checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_E, e=SV2BN(e_SV) ) );
	if ( SvCUR(d_SV) > 0 ) {
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_D, d=SV2BN(d_SV) ) );
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_FACTOR1, p1=SV2BN(p1_SV) ) );
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_FACTOR2, p2=SV2BN(p2_SV) ) );
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_EXPONENT1, e1=SV2BN(e1_SV) ) );
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_EXPONENT2, e2=SV2BN(e2_SV) ) );
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_RSA_COEFFICIENT1, c=SV2BN(c_SV) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_KEYPAIR, bld ) );
		BN_free(d);
		BN_free(p1);
		BN_free(p2);
		BN_free(e1);
		BN_free(e2);
		BN_free(c);
	} else {
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_PUBLIC_KEY, bld ) );
	}
	OSSL_PARAM_BLD_free(bld);
	EVP_PKEY_CTX_free(ctx);
	BN_free(n);
	BN_free(e);
#endif
#line 1041 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_ECDSA
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_ECDSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_ECDSA)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "curve, qx_SV, qy_SV=UNDEF");
    {
	EVP_PKEY *	RETVAL;
	SV *	curve = ST(0)
;
	SV *	qx_SV = ST(1)
;
	SV *	qy_SV;

	if (items < 3)
	    qy_SV = UNDEF;
	else {
	    qy_SV = ST(2)
;
	}
#line 458 "SEC.xs"
#ifdef API_1_1_1
	EC_KEY *eckey = NULL;
	BIGNUM *qx, *qy;
#else
	EVP_PKEY_CTX *ctx = EVP_PKEY_CTX_new_from_name( libctx, "EC", NULL );
	OSSL_PARAM_BLD *bld = OSSL_PARAM_BLD_new();
	SV *ksv = newSVpvn("\4",1);
	BIGNUM *qx;
#endif
	char *name = SvPVX(curve);
#line 1088 "SEC.c"
#line 469 "SEC.xs"
#ifdef API_1_1_1
	RETVAL = EVP_PKEY_new();
	if ( strcmp(name,"P-256") == 0 ) eckey = EC_KEY_new_by_curve_name(NID_X9_62_prime256v1);
	if ( strcmp(name,"P-384") == 0 ) eckey = EC_KEY_new_by_curve_name(NID_secp384r1);
	if ( SvCUR(qy_SV) > 0 ) {
		checkerr( EC_KEY_set_public_key_affine_coordinates( eckey, qx=SV2BN(qx_SV), qy=SV2BN(qy_SV) ) );
		BN_free(qx);
		BN_free(qy);
	} else {
		checkerr( EC_KEY_set_private_key( eckey, qx=SV2BN(qx_SV) ) );
		BN_clear_free(qx);
	}
	checkerr( EVP_PKEY_assign( RETVAL, EVP_PKEY_EC, (char*)eckey ) );
#else
	RETVAL = NULL;
	checkerr( OSSL_PARAM_BLD_push_utf8_string( bld, OSSL_PKEY_PARAM_GROUP_NAME, name, 0 ) );
	if ( SvCUR(qy_SV) > 0 ) {
		sv_catpvn_nomg(ksv, SvPVX(qx_SV), SvCUR(qx_SV));
		sv_catpvn_nomg(ksv, SvPVX(qy_SV), SvCUR(qy_SV));
		checkerr( OSSL_PARAM_BLD_push_octet_string( bld, OSSL_PKEY_PARAM_PUB_KEY, SvPVX(ksv), SvCUR(ksv) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_PUBLIC_KEY, bld ) );
	} else {
		checkerr( OSSL_PARAM_BLD_push_BN( bld, OSSL_PKEY_PARAM_PRIV_KEY, qx=SV2BN(qx_SV) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_KEYPAIR, bld ) );
		BN_clear_free(qx);
	}
	OSSL_PARAM_BLD_free(bld);
	EVP_PKEY_CTX_free(ctx);
#endif
#line 1119 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifndef NO_EdDSA
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_EdDSA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_EdDSA)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "curve, public, private=NULL");
    {
	EVP_PKEY *	RETVAL;
	SV *	curve = ST(0)
;
	SV *	public = ST(1)
;
	SV *	private;

	if (items < 3)
	    private = NULL;
	else {
	    private = ST(2)
;
	}
#line 511 "SEC.xs"
#ifdef API_1_1_1
	char *name = SvPVX(curve);
	int nid = 0;
#else
	OSSL_PARAM_BLD *bld = OSSL_PARAM_BLD_new();
	EVP_PKEY_CTX *ctx = EVP_PKEY_CTX_new_from_name( libctx, SvPVX(curve), NULL );
#endif
#line 1163 "SEC.c"
#line 519 "SEC.xs"
	RETVAL = NULL;
#ifdef API_1_1_1
	if ( strcmp(name,"ED25519") == 0 ) nid = NID_ED25519;
#ifdef NID_ED448		/* not yet implemented in BoringSSL & LibreSSL */
	if ( strcmp(name,"ED448") == 0 )   nid = NID_ED448;
#endif
	if ( private == NULL ) {
		RETVAL = EVP_PKEY_new_raw_public_key( nid, NULL, (unsigned char*) SvPVX(public), SvCUR(public) );
	} else {
		RETVAL = EVP_PKEY_new_raw_private_key( nid, NULL, (unsigned char*) SvPVX(private), SvCUR(private) );
	}
#else
	if ( private == NULL ) {
		checkerr( OSSL_PARAM_BLD_push_octet_string( bld, OSSL_PKEY_PARAM_PUB_KEY, SvPVX(public), SvCUR(public) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_PUBLIC_KEY, bld ) );
	} else {
		checkerr( OSSL_PARAM_BLD_push_octet_string( bld, OSSL_PKEY_PARAM_PRIV_KEY, SvPVX(private), SvCUR(private) ) );
		checkerr( EVP_PKEY_fromparams( ctx, &RETVAL, EVP_PKEY_KEYPAIR, bld ) );
	}
	OSSL_PARAM_BLD_free(bld);
	EVP_PKEY_CTX_free(ctx);
#endif
#line 1187 "SEC.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "EVP_PKEYPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Net__DNS__SEC__libcrypto_checkerr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_checkerr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ret");
    {
	int	ret = (int)SvIV(ST(0))
;

	checkerr(ret);
    }
    XSRETURN_EMPTY;
}

#ifdef croak_memory_wrap
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_croak_memory_wrap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_croak_memory_wrap)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	croak_memory_wrap();
    }
    XSRETURN_EMPTY;
}

#endif
#ifdef DEBUG
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Net__DNS__SEC__libcrypto_ERR_print_errors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Net__DNS__SEC__libcrypto_ERR_print_errors)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "filename");
    {
	SV *	filename = ST(0)
;
#line 564 "SEC.xs"
	BIO *bio = BIO_new_file( SvPVX(filename), "w" );
	ERR_print_errors(bio);
	BIO_free(bio);
#line 1250 "SEC.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Net__DNS__SEC); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Net__DNS__SEC)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::VERSION", XS_Net__DNS__SEC__libcrypto_VERSION, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sign", XS_Net__DNS__SEC__libcrypto_EVP_sign, file, "$$;$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_verify", XS_Net__DNS__SEC__libcrypto_EVP_verify, file, "$$$;$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_MD_CTX_new", XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_new, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_MD_CTX_free", XS_Net__DNS__SEC__libcrypto_EVP_MD_CTX_free, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestInit", XS_Net__DNS__SEC__libcrypto_EVP_DigestInit, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestUpdate", XS_Net__DNS__SEC__libcrypto_EVP_DigestUpdate, file, "$$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_DigestFinal", XS_Net__DNS__SEC__libcrypto_EVP_DigestFinal, file, "$");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_md5", XS_Net__DNS__SEC__libcrypto_EVP_md5, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha1", XS_Net__DNS__SEC__libcrypto_EVP_sha1, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha224", XS_Net__DNS__SEC__libcrypto_EVP_sha224, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha256", XS_Net__DNS__SEC__libcrypto_EVP_sha256, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha384", XS_Net__DNS__SEC__libcrypto_EVP_sha384, file, "");
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sha512", XS_Net__DNS__SEC__libcrypto_EVP_sha512, file, "");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_sm3", XS_Net__DNS__SEC__libcrypto_EVP_sm3, file, "");
#endif
#if XSubPPtmpAAAB
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_DSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_DSA, file, "$$$$;$");
#endif
#if XSubPPtmpAAAC
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_RSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_RSA, file, "$$;$$$$$$");
#endif
#if XSubPPtmpAAAD
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_ECDSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_ECDSA, file, "$$;$");
#endif
#if XSubPPtmpAAAE
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::EVP_PKEY_new_EdDSA", XS_Net__DNS__SEC__libcrypto_EVP_PKEY_new_EdDSA, file, "$$;$");
#endif
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::checkerr", XS_Net__DNS__SEC__libcrypto_checkerr, file, "$");
#if XSubPPtmpAAAF
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::croak_memory_wrap", XS_Net__DNS__SEC__libcrypto_croak_memory_wrap, file, "");
#endif
#if XSubPPtmpAAAG
        (void)newXSproto_portable("Net::DNS::SEC::libcrypto::ERR_print_errors", XS_Net__DNS__SEC__libcrypto_ERR_print_errors, file, "$");
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#line 1338 "SEC.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

