; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instsimplify < %s -S | FileCheck %s

define <4 x i1> @vec_reverse_known_bits(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reverse_known_bits(
; CHECK-NEXT:    ret <4 x i1> splat (i1 true)
;
  %x = or <4 x i8> %xx, <i8 128, i8 128, i8 128, i8 128>
  %rev = call <4 x i8> @llvm.vector.reverse(<4 x i8> %x)
  %r = icmp slt <4 x i8> %rev, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @vec_reverse_known_bits_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reverse_known_bits_fail(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 -128, i8 -128, i8 -128, i8 127>
; CHECK-NEXT:    [[REV:%.*]] = call <4 x i8> @llvm.vector.reverse.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp slt <4 x i8> [[REV]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %x = or <4 x i8> %xx, <i8 128, i8 128, i8 128, i8 127>
  %rev = call <4 x i8> @llvm.vector.reverse(<4 x i8> %x)
  %r = icmp slt <4 x i8> %rev, zeroinitializer
  ret <4 x i1> %r
}

define i1 @vec_reverse_known_bits_demanded(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reverse_known_bits_demanded(
; CHECK-NEXT:    ret i1 true
;
  %x = or <4 x i8> %xx, <i8 127, i8 55, i8 128, i8 123>
  %rev = call <4 x i8> @llvm.vector.reverse(<4 x i8> %x)
  %ele = extractelement <4 x i8> %rev, i64 1
  %r = icmp slt i8 %ele, 0
  ret i1 %r
}

define i1 @vec_reverse_known_bits_demanded_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reverse_known_bits_demanded_fail(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 127, i8 55, i8 -128, i8 123>
; CHECK-NEXT:    [[REV:%.*]] = call <4 x i8> @llvm.vector.reverse.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[ELE:%.*]] = extractelement <4 x i8> [[REV]], i64 2
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[ELE]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = or <4 x i8> %xx, <i8 127, i8 55, i8 128, i8 123>
  %rev = call <4 x i8> @llvm.vector.reverse(<4 x i8> %x)
  %ele = extractelement <4 x i8> %rev, i64 2
  %r = icmp slt i8 %ele, 0
  ret i1 %r
}
