; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=instcombine -o - %s | FileCheck %s
target datalayout = "e-p:32:32:32-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v24:32:32-v32:32:32-v64:64:64-v128:128:128-a0:0:64"

define internal <2 x i32> @func_v2i32(<2 x i32> %v) noinline nounwind {
; CHECK-LABEL: define internal <2 x i32> @func_v2i32
; CHECK-SAME: (<2 x i32> [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i32> [[V]]
;
entry:
  ret <2 x i32> %v
}

define internal <2 x float> @func_v2f32(<2 x float> %v) noinline nounwind {
; CHECK-LABEL: define internal <2 x float> @func_v2f32
; CHECK-SAME: (<2 x float> [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x float> [[V]]
;
entry:
  ret <2 x float> %v
}

define internal <4 x float> @func_v4f32(<4 x float> %v) noinline nounwind {
; CHECK-LABEL: define internal <4 x float> @func_v4f32
; CHECK-SAME: (<4 x float> [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <4 x float> [[V]]
;
entry:
  ret <4 x float> %v
}

define internal i32 @func_i32(i32 %v) noinline nounwind {
; CHECK-LABEL: define internal i32 @func_i32
; CHECK-SAME: (i32 [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[V]]
;
entry:
  ret i32 %v
}

define internal i64 @func_i64(i64 %v) noinline nounwind {
; CHECK-LABEL: define internal i64 @func_i64
; CHECK-SAME: (i64 [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i64 [[V]]
;
entry:
  ret i64 %v
}

define internal <2 x i64> @func_v2i64(<2 x i64> %v) noinline nounwind {
; CHECK-LABEL: define internal <2 x i64> @func_v2i64
; CHECK-SAME: (<2 x i64> [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i64> [[V]]
;
entry:
  ret <2 x i64> %v
}

define internal <2 x ptr> @func_v2i32p(<2 x ptr> %v) noinline nounwind {
; CHECK-LABEL: define internal <2 x ptr> @func_v2i32p
; CHECK-SAME: (<2 x ptr> [[V:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x ptr> [[V]]
;
entry:
  ret <2 x ptr> %v
}

; Valid cases, only bitcast for argument / return type and call underlying function

; Test cast between scalars with same bit sizes
; Sizes match, should only bitcast
define void @bitcast_scalar(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_scalar
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @func_i32(i32 [[TMP1]]) #[[ATTR1]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load float, ptr %source, align 8
  %call = call float @func_i32(float %tmp) nounwind
  store float %call, ptr %dest, align 8
  ret void
}

; Test cast between vectors with same number of elements and bit sizes
; Sizes match, should only bitcast
define void @bitcast_vector(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x i32> @func_v2i32(<2 x i32> [[TMP1]]) #[[ATTR1]]
; CHECK-NEXT:    store <2 x i32> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <2 x float>, ptr %source, align 8
  %call = call <2 x float> @func_v2i32(<2 x float> %tmp) nounwind
  store <2 x float> %call, ptr %dest, align 8
  ret void
}

; Test cast from vector to scalar with same number of bits
; Sizes match, should only bitcast
define void @bitcast_vector_scalar_same_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector_scalar_same_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call i64 @func_i64(i64 [[TMP1]]) #[[ATTR1]]
; CHECK-NEXT:    store i64 [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <2 x float>, ptr %source, align 8
  %call = call <2 x float> @func_i64(<2 x float> %tmp) nounwind
  store <2 x float> %call, ptr %dest, align 8
  ret void
}

; Test cast from scalar to vector with same number of bits
define void @bitcast_scalar_vector_same_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_scalar_vector_same_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x float>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @func_v2f32(<2 x float> [[TMP1]]) #[[ATTR1]]
; CHECK-NEXT:    store <2 x float> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load i64, ptr %source, align 8
  %call = call i64 @func_v2f32(i64 %tmp) nounwind
  store i64 %call, ptr %dest, align 8
  ret void
}

; Test cast between vectors of pointers
define void @bitcast_vector_ptrs_same_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector_ptrs_same_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load <2 x ptr>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x ptr> @func_v2i32p(<2 x ptr> [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store <2 x ptr> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <2 x ptr>, ptr %source, align 8
  %call = call <2 x ptr> @func_v2i32p(<2 x ptr> %tmp) nounwind
  store <2 x ptr> %call, ptr %dest, align 8
  ret void
}

; Invalid cases:

; Test cast between scalars with different bit sizes
define void @bitcast_mismatch_scalar_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_mismatch_scalar_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load float, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call float @func_i64(float [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store float [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load float, ptr %source, align 8
  %call = call float @func_i64(float %tmp) nounwind
  store float %call, ptr %dest, align 8
  ret void
}

; Test cast between vectors with different bit sizes but the
; same number of elements
define void @bitcast_mismatch_vector_element_and_bit_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_mismatch_vector_element_and_bit_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load <2 x float>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <2 x float> @func_v2i64(<2 x float> [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store <2 x float> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <2 x float>, ptr %source, align 8
  %call = call <2 x float> @func_v2i64(<2 x float> %tmp) nounwind
  store <2 x float> %call, ptr %dest, align 8
  ret void
}

; Test cast between vectors with same number of bits and different
; numbers of elements
define void @bitcast_vector_mismatched_number_elements(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector_mismatched_number_elements
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load <4 x float>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <4 x float> @func_v2i32(<4 x float> [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store <4 x float> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <4 x float>, ptr %source, align 8
  %call = call <4 x float> @func_v2i32(<4 x float> %tmp) nounwind
  store <4 x float> %call, ptr %dest, align 8
  ret void
}

; Test cast between vector and scalar with different number of bits
define void @bitcast_vector_scalar_mismatched_bit_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector_scalar_mismatched_bit_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load <4 x float>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <4 x float> @func_i64(<4 x float> [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store <4 x float> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <4 x float>, ptr %source, align 8
  %call = call <4 x float> @func_i64(<4 x float> %tmp) nounwind
  store <4 x float> %call, ptr %dest, align 8
  ret void
}

; Test cast between vector of pointers and scalar with different number of bits
define void @bitcast_vector_ptrs_scalar_mismatched_bit_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_vector_ptrs_scalar_mismatched_bit_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load <4 x ptr>, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call <4 x ptr> @func_i64(<4 x ptr> [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store <4 x ptr> [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load <4 x ptr>, ptr %source, align 8
  %call = call <4 x ptr> @func_i64(<4 x ptr> %tmp) nounwind
  store <4 x ptr> %call, ptr %dest, align 8
  ret void
}

; Test cast from scalar to vector of pointers with same number of bits
; We don't know the pointer size at this point, so this can't be done
define void @bitcast_scalar_vector_ptrs_same_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_scalar_vector_ptrs_same_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load i64, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call i64 @func_v2i32p(i64 [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store i64 [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load i64, ptr %source, align 8
  %call = call i64 @func_v2i32p(i64 %tmp) nounwind
  store i64 %call, ptr %dest, align 8
  ret void
}

; Test cast between scalar and vector with different number of bits
define void @bitcast_scalar_vector_mismatched_bit_size(ptr noalias %source, ptr noalias %dest) nounwind {
; CHECK-LABEL: define void @bitcast_scalar_vector_mismatched_bit_size
; CHECK-SAME: (ptr noalias [[SOURCE:%.*]], ptr noalias [[DEST:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = load i64, ptr [[SOURCE]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = call i64 @func_v4f32(i64 [[TMP]]) #[[ATTR1]]
; CHECK-NEXT:    store i64 [[CALL]], ptr [[DEST]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %tmp = load i64, ptr %source, align 8
  %call = call i64 @func_v4f32(i64 %tmp) nounwind
  store i64 %call, ptr %dest, align 8
  ret void
}

