/* main.c generated by valac 0.15.1, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus-xkb - IBus XKB
 *
 * Copyright(c) 2012 Takao Fujiwara <takao.fujiwara1@gmail.com>
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright (c) 2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibusxkbxml.h>
#include <ibus.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DUMMY_ENGINE (dummy_engine_get_type ())
#define DUMMY_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUMMY_ENGINE, DummyEngine))
#define DUMMY_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUMMY_ENGINE, DummyEngineClass))
#define IS_DUMMY_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUMMY_ENGINE))
#define IS_DUMMY_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUMMY_ENGINE))
#define DUMMY_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUMMY_ENGINE, DummyEngineClass))

typedef struct _DummyEngine DummyEngine;
typedef struct _DummyEngineClass DummyEngineClass;
typedef struct _DummyEnginePrivate DummyEnginePrivate;
typedef struct _Block1Data Block1Data;

struct _DummyEngine {
	IBusEngineSimple parent_instance;
	DummyEnginePrivate * priv;
};

struct _DummyEngineClass {
	IBusEngineSimpleClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	IBusBus* bus;
	gint id;
};


static gpointer dummy_engine_parent_class = NULL;

void print_xml (const gchar* layout, const gchar* layout_desc, const gchar* variant, const gchar* variant_desc, const gchar* lang);
void print_component (void);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType dummy_engine_get_type (void) G_GNUC_CONST;
enum  {
	DUMMY_ENGINE_DUMMY_PROPERTY
};
DummyEngine* dummy_engine_new (void);
DummyEngine* dummy_engine_construct (GType object_type);
gint _vala_main (gchar** args, int args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda2_ (IBusBus* bus);
static void ___lambda2__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static IBusEngine* __lambda3_ (Block1Data* _data1_, IBusFactory* factory, const gchar* name);
static IBusEngine* ___lambda3__ibus_factory_create_engine (IBusFactory* _sender, const gchar* engine_name, gpointer self);


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


void print_xml (const gchar* layout, const gchar* layout_desc, const gchar* variant, const gchar* variant_desc, const gchar* lang) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* name;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* keymap;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* desc;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* symbol;
	const gchar* _tmp15_;
	const gchar* _tmp19_;
	const gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_ = NULL;
	gchar* engine;
	g_return_if_fail (layout != NULL);
	g_return_if_fail (layout_desc != NULL);
	g_return_if_fail (lang != NULL);
	_tmp0_ = variant;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = layout;
	_tmp6_ = _tmp2_;
	_tmp7_ = lang;
	_tmp8_ = g_strdup_printf ("xkb:%s:%s:%s", _tmp5_, _tmp6_, _tmp7_);
	name = _tmp8_;
	_tmp9_ = layout;
	_tmp10_ = g_strdup (_tmp9_);
	keymap = _tmp10_;
	_tmp11_ = layout_desc;
	_tmp12_ = g_strdup (_tmp11_);
	desc = _tmp12_;
	_tmp13_ = lang;
	_tmp14_ = g_strdup (_tmp13_);
	symbol = _tmp14_;
	_tmp15_ = variant;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		_tmp16_ = layout;
		_tmp17_ = variant;
		_tmp18_ = g_strdup_printf ("%s(%s)", _tmp16_, _tmp17_);
		_g_free0 (keymap);
		keymap = _tmp18_;
	}
	_tmp19_ = variant_desc;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = variant_desc;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (desc);
		desc = _tmp21_;
	}
	_tmp22_ = desc;
	_tmp23_ = string_replace (_tmp22_, "<", "&lt;");
	_tmp24_ = _tmp23_;
	_tmp25_ = string_replace (_tmp24_, ">", "&gt;");
	_g_free0 (desc);
	desc = _tmp25_;
	_g_free0 (_tmp24_);
	_tmp26_ = lang;
	_tmp27_ = strlen (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 2) {
		const gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		_tmp29_ = lang;
		_tmp30_ = string_slice (_tmp29_, (glong) 0, (glong) 2);
		_g_free0 (symbol);
		symbol = _tmp30_;
	}
	_tmp31_ = name;
	_tmp32_ = lang;
	_tmp33_ = keymap;
	_tmp34_ = desc;
	_tmp35_ = desc;
	_tmp36_ = symbol;
	_tmp37_ = g_strdup_printf ("\n" \
"              <engine>\n" \
"                        <name>%s</name>\n" \
"                        <language>%s</language>\n" \
"                        <license>GPL</license>\n" \
"                        <author>Peng Huang &lt;shawn.p.huang@gmail.com" \
"&gt;</author>\n" \
"                        <layout>%s</layout>\n" \
"                        <longname>%s</longname>\n" \
"                        <description>%s</description>\n" \
"                        <icon>ibus-keyboard</icon>\n" \
"                        <symbol>%s</symbol>\n" \
"                        <rank>%d</rank>\n" \
"              </engine>", _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, 99);
	engine = _tmp37_;
	g_print ("%s", engine);
	_g_free0 (engine);
	_g_free0 (symbol);
	_g_free0 (desc);
	_g_free0 (keymap);
	_g_free0 (name);
	_g_free0 (_tmp2_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


void print_component (void) {
	IBusXKBConfigRegistry* _tmp0_;
	IBusXKBConfigRegistry* _tmp1_;
	IBusXKBConfigRegistry* registry;
	IBusXKBConfigRegistry* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* layouts;
	GList* variants = NULL;
	GList* langs = NULL;
	gchar* layout_desc = NULL;
	static const char header[] = "<engines>";
	static const char footer[] = "\n</engines>";
	_tmp0_ = ibus_xkb_config_registry_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	registry = _tmp1_;
	_tmp2_ = registry;
	_tmp3_ = ibus_xkb_config_registry_layout_list_get_layouts (_tmp2_);
	layouts = _tmp3_;
	g_print ("%s", header);
	{
		GList* _tmp4_;
		GList* l;
		_tmp4_ = layouts;
		l = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				GList* _tmp9_;
				IBusXKBConfigRegistry* _tmp10_;
				GList* _tmp11_;
				gconstpointer _tmp12_;
				GList* _tmp13_ = NULL;
				IBusXKBConfigRegistry* _tmp14_;
				GList* _tmp15_;
				gconstpointer _tmp16_;
				GList* _tmp17_ = NULL;
				IBusXKBConfigRegistry* _tmp18_;
				GList* _tmp19_;
				gconstpointer _tmp20_;
				gchar* _tmp21_ = NULL;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					GList* _tmp7_;
					GList* _tmp8_;
					_tmp7_ = l;
					_tmp8_ = _tmp7_->next;
					l = _tmp8_;
				}
				_tmp5_ = FALSE;
				_tmp9_ = l;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = registry;
				_tmp11_ = l;
				_tmp12_ = _tmp11_->data;
				_tmp13_ = ibus_xkb_config_registry_layout_list_get_variants (_tmp10_, (const gchar*) _tmp12_);
				_g_list_free0 (variants);
				variants = _tmp13_;
				_tmp14_ = registry;
				_tmp15_ = l;
				_tmp16_ = _tmp15_->data;
				_tmp17_ = ibus_xkb_config_registry_layout_lang_get_langs (_tmp14_, (const gchar*) _tmp16_);
				_g_list_free0 (langs);
				langs = _tmp17_;
				_tmp18_ = registry;
				_tmp19_ = l;
				_tmp20_ = _tmp19_->data;
				_tmp21_ = ibus_xkb_config_registry_layout_desc_get_desc (_tmp18_, (const gchar*) _tmp20_);
				_g_free0 (layout_desc);
				layout_desc = _tmp21_;
				{
					GList* _tmp22_;
					GList* lg;
					_tmp22_ = langs;
					lg = _tmp22_;
					{
						gboolean _tmp23_;
						_tmp23_ = TRUE;
						while (TRUE) {
							gboolean _tmp24_;
							GList* _tmp27_;
							GList* _tmp28_;
							gconstpointer _tmp29_;
							const gchar* _tmp30_;
							GList* _tmp31_;
							gconstpointer _tmp32_;
							_tmp24_ = _tmp23_;
							if (!_tmp24_) {
								GList* _tmp25_;
								GList* _tmp26_;
								_tmp25_ = lg;
								_tmp26_ = _tmp25_->next;
								lg = _tmp26_;
							}
							_tmp23_ = FALSE;
							_tmp27_ = lg;
							if (!(_tmp27_ != NULL)) {
								break;
							}
							_tmp28_ = l;
							_tmp29_ = _tmp28_->data;
							_tmp30_ = layout_desc;
							_tmp31_ = lg;
							_tmp32_ = _tmp31_->data;
							print_xml ((const gchar*) _tmp29_, _tmp30_, NULL, NULL, (const gchar*) _tmp32_);
						}
					}
				}
				{
					GList* _tmp33_;
					GList* v;
					_tmp33_ = variants;
					v = _tmp33_;
					{
						gboolean _tmp34_;
						_tmp34_ = TRUE;
						while (TRUE) {
							gboolean _tmp35_;
							GList* _tmp38_;
							GList* _tmp39_;
							gconstpointer _tmp40_;
							GList* _tmp41_;
							gconstpointer _tmp42_;
							gchar* _tmp43_ = NULL;
							gchar* l_v;
							GList* l_v_langs;
							IBusXKBConfigRegistry* _tmp44_;
							const gchar* _tmp45_;
							GList* _tmp46_ = NULL;
							GList* _l_v_langs;
							GList* _tmp47_;
							GList* _tmp48_;
							_tmp35_ = _tmp34_;
							if (!_tmp35_) {
								GList* _tmp36_;
								GList* _tmp37_;
								_tmp36_ = v;
								_tmp37_ = _tmp36_->next;
								v = _tmp37_;
							}
							_tmp34_ = FALSE;
							_tmp38_ = v;
							if (!(_tmp38_ != NULL)) {
								break;
							}
							_tmp39_ = l;
							_tmp40_ = _tmp39_->data;
							_tmp41_ = v;
							_tmp42_ = _tmp41_->data;
							_tmp43_ = g_strdup_printf ("%s(%s)", (const gchar*) _tmp40_, (const gchar*) _tmp42_);
							l_v = _tmp43_;
							l_v_langs = NULL;
							_tmp44_ = registry;
							_tmp45_ = l_v;
							_tmp46_ = ibus_xkb_config_registry_layout_lang_get_langs (_tmp44_, _tmp45_);
							_l_v_langs = _tmp46_;
							_tmp47_ = _l_v_langs;
							l_v_langs = _tmp47_;
							_tmp48_ = l_v_langs;
							if (_tmp48_ == NULL) {
								GList* _tmp49_;
								_tmp49_ = langs;
								l_v_langs = _tmp49_;
							}
							{
								GList* _tmp50_;
								GList* lg;
								_tmp50_ = l_v_langs;
								lg = _tmp50_;
								{
									gboolean _tmp51_;
									_tmp51_ = TRUE;
									while (TRUE) {
										gboolean _tmp52_;
										GList* _tmp55_;
										GList* _tmp56_;
										gconstpointer _tmp57_;
										const gchar* _tmp58_;
										GList* _tmp59_;
										gconstpointer _tmp60_;
										IBusXKBConfigRegistry* _tmp61_;
										const gchar* _tmp62_;
										gchar* _tmp63_ = NULL;
										gchar* _tmp64_;
										GList* _tmp65_;
										gconstpointer _tmp66_;
										_tmp52_ = _tmp51_;
										if (!_tmp52_) {
											GList* _tmp53_;
											GList* _tmp54_;
											_tmp53_ = lg;
											_tmp54_ = _tmp53_->next;
											lg = _tmp54_;
										}
										_tmp51_ = FALSE;
										_tmp55_ = lg;
										if (!(_tmp55_ != NULL)) {
											break;
										}
										_tmp56_ = l;
										_tmp57_ = _tmp56_->data;
										_tmp58_ = layout_desc;
										_tmp59_ = v;
										_tmp60_ = _tmp59_->data;
										_tmp61_ = registry;
										_tmp62_ = l_v;
										_tmp63_ = ibus_xkb_config_registry_variant_desc_get_desc (_tmp61_, _tmp62_);
										_tmp64_ = _tmp63_;
										_tmp65_ = lg;
										_tmp66_ = _tmp65_->data;
										print_xml ((const gchar*) _tmp57_, _tmp58_, (const gchar*) _tmp60_, _tmp64_, (const gchar*) _tmp66_);
										_g_free0 (_tmp64_);
									}
								}
							}
							__g_list_free__g_free0_0 (_l_v_langs);
							_g_free0 (l_v);
						}
					}
				}
			}
		}
	}
	g_print ("%s", footer);
	_g_free0 (layout_desc);
	_g_list_free0 (langs);
	_g_list_free0 (variants);
	_g_list_free0 (layouts);
	_g_object_unref0 (registry);
}


DummyEngine* dummy_engine_construct (GType object_type) {
	DummyEngine * self = NULL;
	self = (DummyEngine*) g_object_new (object_type, NULL);
	return self;
}


DummyEngine* dummy_engine_new (void) {
	return dummy_engine_construct (TYPE_DUMMY_ENGINE);
}


static void dummy_engine_class_init (DummyEngineClass * klass) {
	dummy_engine_parent_class = g_type_class_peek_parent (klass);
}


static void dummy_engine_instance_init (DummyEngine * self) {
}


GType dummy_engine_get_type (void) {
	static volatile gsize dummy_engine_type_id__volatile = 0;
	if (g_once_init_enter (&dummy_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DummyEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dummy_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DummyEngine), 0, (GInstanceInitFunc) dummy_engine_instance_init, NULL };
		GType dummy_engine_type_id;
		dummy_engine_type_id = g_type_register_static (ibus_engine_simple_get_type (), "DummyEngine", &g_define_type_info, 0);
		g_once_init_leave (&dummy_engine_type_id__volatile, dummy_engine_type_id);
	}
	return dummy_engine_type_id__volatile;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->bus);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (IBusBus* bus) {
	g_return_if_fail (bus != NULL);
	g_debug ("main.vala:137: bus disconnected");
	ibus_quit ();
}


static void ___lambda2__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda2_ (_sender);
}


static IBusEngine* __lambda3_ (Block1Data* _data1_, IBusFactory* factory, const gchar* name) {
	IBusEngine* result = NULL;
	static const char path[] = "/org/freedesktop/IBus/engine/xkb/%d";
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	IBusBus* _tmp5_;
	GDBusConnection* _tmp6_ = NULL;
	IBusEngine* _tmp7_;
	IBusEngine* _tmp8_;
	IBusEngine* _tmp9_;
	IBusEngine* engine;
	g_return_val_if_fail (factory != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = _data1_->id;
	_data1_->id = _tmp1_ + 1;
	_tmp2_ = _data1_->id;
	_tmp3_ = g_strdup_printf (path, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data1_->bus;
	_tmp6_ = ibus_bus_get_connection (_tmp5_);
	_tmp7_ = ibus_engine_new_with_type (ibus_engine_simple_get_type (), _tmp0_, _tmp4_, _tmp6_);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp4_);
	engine = _tmp9_;
	result = engine;
	return result;
}


static IBusEngine* ___lambda3__ibus_factory_create_engine (IBusFactory* _sender, const gchar* engine_name, gpointer self) {
	IBusEngine* result;
	result = __lambda3_ (self, _sender, engine_name);
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Block1Data* _data1_;
	gchar** _tmp0_;
	gint _tmp0__length1;
	IBusBus* _tmp7_;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	gboolean _tmp10_ = FALSE;
	guint flags;
	IBusBus* _tmp11_;
	guint _tmp12_;
	guint32 _tmp13_ = 0U;
	guint retval;
	guint _tmp14_;
	IBusBus* _tmp15_;
	IBusBus* _tmp16_;
	GDBusConnection* _tmp17_ = NULL;
	IBusFactory* _tmp18_;
	IBusFactory* _tmp19_;
	IBusFactory* factory;
	IBusFactory* _tmp20_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	ibus_init ();
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	if (_tmp0__length1 >= 2) {
		gboolean _tmp1_ = FALSE;
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gboolean _tmp6_;
		_tmp2_ = args;
		_tmp2__length1 = args_length1;
		_tmp3_ = _tmp2_[1];
		if (g_strcmp0 (_tmp3_, "--xml") == 0) {
			_tmp1_ = TRUE;
		} else {
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
			_tmp4_ = args;
			_tmp4__length1 = args_length1;
			_tmp5_ = _tmp4_[1];
			_tmp1_ = g_strcmp0 (_tmp5_, "-x") == 0;
		}
		_tmp6_ = _tmp1_;
		if (_tmp6_) {
			print_component ();
			result = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
	}
	_tmp7_ = ibus_bus_new ();
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_data1_->bus = _tmp8_;
	_tmp9_ = _data1_->bus;
	_tmp10_ = ibus_bus_is_connected (_tmp9_);
	if (!_tmp10_) {
		g_warning ("main.vala:122: ibus-daemon does not exist.");
		result = 1;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	flags = (guint) (IBUS_BUS_NAME_FLAG_REPLACE_EXISTING | IBUS_BUS_NAME_FLAG_ALLOW_REPLACEMENT);
	_tmp11_ = _data1_->bus;
	_tmp12_ = flags;
	_tmp13_ = ibus_bus_request_name (_tmp11_, "org.freedesktop.IBus.XKB", (guint32) _tmp12_);
	retval = (guint) _tmp13_;
	_tmp14_ = retval;
	if (_tmp14_ == ((guint) 0)) {
		g_warning ("main.vala:132: Registry bus name org.freedesktop.IBus.XKB failed!");
		result = 1;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp15_ = _data1_->bus;
	g_signal_connect (_tmp15_, "disconnected", (GCallback) ___lambda2__ibus_bus_disconnected, NULL);
	_tmp16_ = _data1_->bus;
	_tmp17_ = ibus_bus_get_connection (_tmp16_);
	_tmp18_ = ibus_factory_new (_tmp17_);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	factory = _tmp19_;
	_data1_->id = 0;
	_tmp20_ = factory;
	g_signal_connect_data (_tmp20_, "create-engine", (GCallback) ___lambda3__ibus_factory_create_engine, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



