/* gitg-repository-list-box.c generated by valac 0.34.7, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012-2016 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <time.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <ide.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_SELECTION_MODE (gitg_selection_mode_get_type ())

#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_bookmark_file_free0(var) ((var == NULL) ? NULL : (var = (g_bookmark_file_free (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block18Data Block18Data;
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_tree_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_tree_entry_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

typedef enum  {
	GITG_SELECTION_MODE_NORMAL,
	GITG_SELECTION_MODE_SELECTION
} GitgSelectionMode;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
	gboolean _bookmarks_from_recent_files;
	GFile* d_location;
	guint d_save_repository_bookmarks_id;
	GBookmarkFile* d_bookmark_file;
};

struct _Block18Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GFile* workdir;
	GitgRepositoryListBoxRow* row;
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	GitgProgressBin* d_progress_bin;
	GtkLabel* d_repository_label;
	GtkLabel* d_description_label;
	GtkLabel* d_branch_label;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GtkBox* d_languages_box;
	GitgSelectionMode d_mode;
	gchar* d_dirname;
	gchar* d_branch_name;
	gboolean _selected;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static gpointer gitg_repository_list_box_row_parent_class = NULL;

GType gitg_selection_mode_get_type (void) G_GNUC_CONST;
GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE,
	GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES,
	GITG_REPOSITORY_LIST_BOX_LOCATION,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION
};
static gboolean gitg_repository_list_box_save_repository_bookmarks (GitgRepositoryListBox* self);
static void gitg_repository_list_box_copy_bookmarks_from_recent_files (GitgRepositoryListBox* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
static void gitg_repository_list_box_save_repository_bookmarks_timeout (GitgRepositoryListBox* self);
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event);
GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value);
GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST;
void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_populate_bookmarks (GitgRepositoryListBox* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository, GDateTime* visited);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
GFile* gitg_repository_list_box_get_location (GitgRepositoryListBox* self);
static void gitg_repository_list_box_add_repository_to_bookmarks (GitgRepositoryListBox* self, const gchar* uri, GDateTime* visited);
static gboolean _gitg_repository_list_box_save_repository_bookmarks_gsource_func (gpointer self);
void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository);
void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_connect_repository_row (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row);
GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location);
gchar* gitg_utils_replace_home_dir_with_tilde (GFile* file);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (GitgRepository* repository, const gchar* dirname);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, GitgRepository* repository, const gchar* dirname);
void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void ___lambda71_ (GitgRepositoryListBox* self);
static void ____lambda71__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda72_ (Block18Data* _data18_);
static void ____lambda72__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
gboolean gitg_repository_list_box_get_bookmarks_from_recent_files (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_bookmarks_from_recent_files (GitgRepositoryListBox* self, gboolean value);
void gitg_repository_list_box_set_location (GitgRepositoryListBox* self, GFile* value);
GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1);
static void _vala_array_add14 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value);
gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING
};
static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
static void _vala_GgitOId_free (GgitOId* self);
gpointer gitg_repository_lookup (GitgRepository* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GgitOId* id, GError** error);
gchar* gitg_repository_get_name (GitgRepository* self);
GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value);
gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_selection_mode_get_type (void) {
	static volatile gsize gitg_selection_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
		g_once_init_leave (&gitg_selection_mode_type_id__volatile, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 308 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 328 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 335 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 342 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 351 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_copy_bookmarks_from_recent_files (GitgRepositoryListBox* self) {
	GtkRecentManager* manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 308 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 308 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	manager = _tmp1_;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = manager;
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	items = _tmp3_;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = items;
#line 380 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 388 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 395 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gchar* uri = NULL;
				GtkRecentInfo* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				GBookmarkFile* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GtkRecentInfo* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GBookmarkFile* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GtkRecentInfo* _tmp17_ = NULL;
				gsize _tmp18_;
				gchar** _tmp19_ = NULL;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				GBookmarkFile* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				GtkRecentInfo* _tmp23_ = NULL;
				gulong _tmp24_ = 0UL;
				gchar* app_name = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* app_exec = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 313 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (!_tmp7_) {
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_gtk_recent_info_unref0 (item);
#line 315 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					continue;
#line 434 "gitg-repository-list-box.c"
				}
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = item;
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				uri = _tmp10_;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = self->priv->d_bookmark_file;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = uri;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp13_ = item;
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp14_ = gtk_recent_info_get_mime_type (_tmp13_);
#line 320 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				g_bookmark_file_set_mime_type (_tmp11_, _tmp12_, _tmp14_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp15_ = self->priv->d_bookmark_file;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp16_ = uri;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp17_ = item;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp19_ = gtk_recent_info_get_groups (_tmp17_, &_tmp18_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp20_ = _tmp19_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp20__length1 = _tmp18_;
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				g_bookmark_file_set_groups (_tmp15_, _tmp16_, _tmp20_, _tmp18_);
#line 321 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp21_ = self->priv->d_bookmark_file;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp22_ = uri;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp23_ = item;
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp24_ = gtk_recent_info_get_modified (_tmp23_);
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				g_bookmark_file_set_visited (_tmp21_, _tmp22_, (time_t) _tmp24_);
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp25_ = g_get_application_name ();
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 324 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				app_name = _tmp26_;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp27_ = g_get_prgname ();
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp28_ = g_strjoin (" ", _tmp27_, "%f", NULL);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				app_exec = _tmp28_;
#line 492 "gitg-repository-list-box.c"
				{
					GBookmarkFile* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp29_ = self->priv->d_bookmark_file;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp30_ = uri;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp31_ = app_name;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp32_ = app_exec;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_bookmark_file_set_app_info (_tmp29_, _tmp30_, _tmp31_, _tmp32_, 1, (time_t) -1, &_inner_error_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 510 "gitg-repository-list-box.c"
						goto __catch62_g_error;
					}
				}
				goto __finally62;
				__catch62_g_error:
				{
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_inner_error_ = NULL;
#line 521 "gitg-repository-list-box.c"
				}
				__finally62:
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (app_exec);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (app_name);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_gtk_recent_info_unref0 (item);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					__g_list_free__gtk_recent_info_unref0_0 (items);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (manager);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					return;
#line 544 "gitg-repository-list-box.c"
				}
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (app_exec);
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (app_name);
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (uri);
#line 311 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 554 "gitg-repository-list-box.c"
			}
		}
	}
#line 330 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_save_repository_bookmarks_timeout (self);
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (items);
#line 306 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (manager);
#line 564 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GitgRepositoryListBox * self;
	gboolean result = FALSE;
	GdkEvent* ev = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = event;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	ev = (GdkEvent*) _tmp0_;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = ev;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gdk_event_triggers_context_menu (_tmp2_);
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_) {
#line 592 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp4_ = 0;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->_mode;
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ == GITG_SELECTION_MODE_NORMAL;
#line 598 "gitg-repository-list-box.c"
	} else {
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 602 "gitg-repository-list-box.c"
	}
#line 337 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 606 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* row = NULL;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkListBoxRow* _tmp7_ = NULL;
		GitgRepositoryListBoxRow* _tmp8_ = NULL;
		GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 339 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = event;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_->y;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) _tmp6_);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW) ? ((GitgRepositoryListBoxRow*) _tmp7_) : NULL);
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		row = _tmp8_;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = row;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ != NULL) {
#line 629 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp10_ = NULL;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = row;
#line 345 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_selected (_tmp10_, TRUE);
#line 635 "gitg-repository-list-box.c"
		}
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		result = TRUE;
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (row);
#line 348 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 643 "gitg-repository-list-box.c"
	}
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = event;
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp11_);
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp12_;
#line 351 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 653 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgSelectionMode _tmp2_ = 0;
	GitgRepositoryListBoxRow* _tmp7_ = NULL;
	GitgRepository* _tmp8_ = NULL;
	GitgRepository* _tmp9_ = NULL;
#line 354 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 354 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 356 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->_mode;
#line 358 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ == GITG_SELECTION_MODE_SELECTION) {
#line 680 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = r;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = r;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 360 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (_tmp3_, !_tmp6_);
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (r);
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 699 "gitg-repository-list-box.c"
	}
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = r;
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = gitg_repository_list_box_row_get_repository (_tmp7_);
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 364 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp9_ != NULL) {
#line 709 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		GitgRepository* _tmp12_ = NULL;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = r;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = gitg_repository_list_box_row_get_repository (_tmp10_);
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_;
#line 366 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp12_);
#line 721 "gitg-repository-list-box.c"
	}
#line 354 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 725 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 741 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 751 "gitg-repository-list-box.c"
	} else {
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 757 "gitg-repository-list-box.c"
	}
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 393 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 391 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 765 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 785 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 801 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 819 "gitg-repository-list-box.c"
	} else {
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 823 "gitg-repository-list-box.c"
	}
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 398 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 829 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 401 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = b;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = a;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp6_;
#line 403 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 866 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_populate_bookmarks (GitgRepositoryListBox* self) {
	gchar** uris = NULL;
	GBookmarkFile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint uris_length1 = 0;
	gint _uris_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GError * _inner_error_ = NULL;
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_bookmark_file;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_bookmark_file_get_uris (_tmp0_, &_tmp1_);
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	uris = _tmp2_;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	uris_length1 = _tmp1_;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_uris_size_ = uris_length1;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = uris;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3__length1 = uris_length1;
#line 896 "gitg-repository-list-box.c"
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		uri_collection = _tmp3_;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		uri_collection_length1 = _tmp3__length1;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		for (uri_it = 0; uri_it < _tmp3__length1; uri_it = uri_it + 1) {
#line 908 "gitg-repository-list-box.c"
			gchar* _tmp4_ = NULL;
			gchar* uri = NULL;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = g_strdup (uri_collection[uri_it]);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			uri = _tmp4_;
#line 915 "gitg-repository-list-box.c"
			{
				GFile* repo_file = NULL;
				const gchar* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				GitgRepository* repo = NULL;
				GDateTime* visited = NULL;
				GitgRepository* _tmp22_ = NULL;
				GDateTime* _tmp23_ = NULL;
				GitgRepositoryListBoxRow* _tmp24_ = NULL;
				GitgRepositoryListBoxRow* _tmp25_ = NULL;
				{
					gboolean _tmp5_ = FALSE;
					GBookmarkFile* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp6_ = self->priv->d_bookmark_file;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = uri;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = g_bookmark_file_has_group (_tmp6_, _tmp7_, "gitg", &_inner_error_);
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp5_ = _tmp8_;
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 941 "gitg-repository-list-box.c"
						goto __catch63_g_error;
					}
#line 413 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (!_tmp5_) {
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_g_free0 (uri);
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						continue;
#line 950 "gitg-repository-list-box.c"
					}
				}
				goto __finally63;
				__catch63_g_error:
				{
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_inner_error_ = NULL;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					continue;
#line 964 "gitg-repository-list-box.c"
				}
				__finally63:
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					return;
#line 979 "gitg-repository-list-box.c"
				}
#line 419 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = uri;
#line 419 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 419 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				repo_file = _tmp10_;
#line 987 "gitg-repository-list-box.c"
				{
					GitgRepository* _tmp11_ = NULL;
					GFile* _tmp12_ = NULL;
					GitgRepository* _tmp13_ = NULL;
					GitgRepository* _tmp14_ = NULL;
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp12_ = repo_file;
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = gitg_repository_new (_tmp12_, NULL, &_inner_error_);
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp11_ = _tmp13_;
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1001 "gitg-repository-list-box.c"
						goto __catch64_g_error;
					}
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _tmp11_;
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp11_ = NULL;
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 424 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					repo = _tmp14_;
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp11_);
#line 1014 "gitg-repository-list-box.c"
				}
				goto __finally64;
				__catch64_g_error:
				{
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_inner_error_ = NULL;
#line 1023 "gitg-repository-list-box.c"
					{
						GBookmarkFile* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
#line 430 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp15_ = self->priv->d_bookmark_file;
#line 430 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp16_ = uri;
#line 430 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						g_bookmark_file_remove_item (_tmp15_, _tmp16_, &_inner_error_);
#line 430 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1035 "gitg-repository-list-box.c"
							goto __catch65_g_error;
						}
					}
					goto __finally65;
					__catch65_g_error:
					{
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 1046 "gitg-repository-list-box.c"
					}
					__finally65:
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_g_free0 (uri);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 428 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 1065 "gitg-repository-list-box.c"
					}
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					continue;
#line 1075 "gitg-repository-list-box.c"
				}
				__finally64:
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 422 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					return;
#line 1094 "gitg-repository-list-box.c"
				}
#line 436 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				visited = NULL;
#line 1098 "gitg-repository-list-box.c"
				{
					time_t _tmp17_ = 0;
					GBookmarkFile* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					time_t _tmp20_ = 0;
					GDateTime* _tmp21_ = NULL;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp18_ = self->priv->d_bookmark_file;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp19_ = uri;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp20_ = g_bookmark_file_get_visited (_tmp18_, _tmp19_, &_inner_error_);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp17_ = _tmp20_;
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "gitg-repository-list-box.c"
						goto __catch66_g_error;
					}
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp21_ = g_date_time_new_from_unix_utc ((gint64) _tmp17_);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_date_time_unref0 (visited);
#line 440 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					visited = _tmp21_;
#line 1124 "gitg-repository-list-box.c"
				}
				goto __finally66;
				__catch66_g_error:
				{
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_inner_error_ = NULL;
#line 1133 "gitg-repository-list-box.c"
				}
				__finally66:
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_date_time_unref0 (visited);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_free0 (uri);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					g_clear_error (&_inner_error_);
#line 438 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					return;
#line 1154 "gitg-repository-list-box.c"
				}
#line 443 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp22_ = repo;
#line 443 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp23_ = visited;
#line 443 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp24_ = gitg_repository_list_box_add_repository (self, _tmp22_, _tmp23_);
#line 443 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp25_ = _tmp24_;
#line 443 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp25_);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_date_time_unref0 (visited);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (repo);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (repo_file);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (uri);
#line 1174 "gitg-repository-list-box.c"
			}
		}
	}
#line 406 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
#line 1180 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 447 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 447 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 449 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 1196 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1204 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 1208 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 453 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 455 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 1255 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 457 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 458 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 1270 "gitg-repository-list-box.c"
				}
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 1274 "gitg-repository-list-box.c"
			}
		}
#line 451 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 1279 "gitg-repository-list-box.c"
	}
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 462 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1285 "gitg-repository-list-box.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1412 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1413 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1297 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_save_repository_bookmarks (GitgRepositoryListBox* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 465 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 467 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_save_repository_bookmarks_id = (guint) 0;
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gitg_repository_list_box_get_location (self);
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 469 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ == NULL) {
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		result = FALSE;
#line 471 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 1320 "gitg-repository-list-box.c"
	}
	{
		GFile* dir = NULL;
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = gitg_repository_list_box_get_location (self);
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = _tmp2_;
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = g_file_get_parent (_tmp3_);
#line 476 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		dir = _tmp4_;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = dir;
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error_);
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (dir);
#line 1344 "gitg-repository-list-box.c"
			goto __catch67_g_error;
		}
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (dir);
#line 1349 "gitg-repository-list-box.c"
	}
	goto __finally67;
	__catch67_g_error:
	{
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1358 "gitg-repository-list-box.c"
	}
	__finally67:
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1363 "gitg-repository-list-box.c"
		gboolean _tmp6_ = FALSE;
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 474 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return _tmp6_;
#line 1371 "gitg-repository-list-box.c"
	}
	{
		GBookmarkFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = self->priv->d_bookmark_file;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = gitg_repository_list_box_get_location (self);
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = _tmp8_;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = g_file_get_path (_tmp9_);
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = _tmp10_;
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_bookmark_file_to_file (_tmp7_, _tmp11_, &_inner_error_);
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp11_);
#line 482 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1395 "gitg-repository-list-box.c"
			goto __catch68_g_error;
		}
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = stderr;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = e;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = _tmp13_->message;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = string_to_string (_tmp14_);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = g_strconcat ("Failed to save repository bookmarks: ", _tmp15_, "\n", NULL);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = _tmp16_;
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		fprintf (_tmp12_, "%s", _tmp17_);
#line 486 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp17_);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 1431 "gitg-repository-list-box.c"
	}
	__finally68:
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1436 "gitg-repository-list-box.c"
		gboolean _tmp18_ = FALSE;
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 480 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return _tmp18_;
#line 1444 "gitg-repository-list-box.c"
	}
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 489 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1450 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_bookmarks (GitgRepositoryListBox* self, const gchar* uri, GDateTime* visited) {
	GBookmarkFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GBookmarkFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	time_t _tmp7_ = 0;
	GDateTime* _tmp8_ = NULL;
	GBookmarkFile* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* app_name = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* app_exec = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 494 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_bookmark_file;
#line 494 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = uri;
#line 494 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_bookmark_file_set_mime_type (_tmp0_, _tmp1_, "inode/directory");
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_bookmark_file;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = uri;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("gitg");
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_new0 (gchar*, 1 + 1);
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_[0] = _tmp4_;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6__length1 = 1;
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_bookmark_file_set_groups (_tmp2_, _tmp3_, _tmp6_, 1);
#line 495 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = visited;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp8_ == NULL) {
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = (time_t) -1;
#line 1508 "gitg-repository-list-box.c"
	} else {
		GDateTime* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = visited;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = g_date_time_to_unix (_tmp9_);
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = (time_t) _tmp10_;
#line 1518 "gitg-repository-list-box.c"
	}
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = self->priv->d_bookmark_file;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = uri;
#line 496 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_bookmark_file_set_visited (_tmp11_, _tmp12_, _tmp7_);
#line 498 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp13_ = g_get_application_name ();
#line 498 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 498 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	app_name = _tmp14_;
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = g_get_prgname ();
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = g_strjoin (" ", _tmp15_, "%f", NULL);
#line 499 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	app_exec = _tmp16_;
#line 1538 "gitg-repository-list-box.c"
	{
		GBookmarkFile* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = self->priv->d_bookmark_file;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp18_ = uri;
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_bookmark_file_set_app_info (_tmp17_, _tmp18_, app_name, app_exec, 1, (time_t) -1, &_inner_error_);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1550 "gitg-repository-list-box.c"
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1561 "gitg-repository-list-box.c"
	}
	__finally69:
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (app_exec);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (app_name);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 501 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1576 "gitg-repository-list-box.c"
	}
#line 503 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_save_repository_bookmarks_timeout (self);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (app_exec);
#line 492 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (app_name);
#line 1584 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_save_repository_bookmarks_gsource_func (gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_save_repository_bookmarks ((GitgRepositoryListBox*) self);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1593 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_save_repository_bookmarks_timeout (GitgRepositoryListBox* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 506 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_save_repository_bookmarks_id;
#line 508 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 510 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1608 "gitg-repository-list-box.c"
	}
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _gitg_repository_list_box_save_repository_bookmarks_gsource_func, g_object_ref (self), g_object_unref);
#line 513 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_save_repository_bookmarks_id = _tmp1_;
#line 1614 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository) {
	GitgRepository* _tmp0_ = NULL;
#line 516 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 516 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != NULL) {
#line 1628 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GitgRepositoryListBoxRow* _tmp13_ = NULL;
		GitgRepository* _tmp14_ = NULL;
		GitgRepositoryListBoxRow* _tmp15_ = NULL;
		GitgRepositoryListBoxRow* _tmp16_ = NULL;
#line 520 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = repository;
#line 520 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 520 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp2_;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_location ((GgitRepository*) _tmp3_);
#line 521 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp4_;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = workdir;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp6_ != NULL) {
#line 1660 "gitg-repository-list-box.c"
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = workdir;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_file_get_uri (_tmp7_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp8_;
#line 1671 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = repo_file;
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp10_;
#line 1683 "gitg-repository-list-box.c"
		}
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = g_strdup (_tmp5_);
#line 523 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp11_;
#line 524 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = uri;
#line 524 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_bookmarks (self, _tmp12_, NULL);
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = row;
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = repository;
#line 526 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp13_, _tmp14_);
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = row;
#line 527 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (_tmp15_, FALSE);
#line 529 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = row;
#line 529 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_connect_repository_row (self, _tmp16_);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp5_);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 518 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 1715 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp17_ = NULL;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = row;
#line 533 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp17_);
#line 1722 "gitg-repository-list-box.c"
	}
}


GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GitgRepositoryListBoxRow* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 537 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = location;
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_file_get_parent (_tmp0_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gitg_utils_replace_home_dir_with_tilde (_tmp2_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = _tmp3_;
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_row_new (NULL, _tmp4_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp5_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp4_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 539 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	row = _tmp6_;
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = location;
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_file_get_basename (_tmp7_);
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository_name (row, _tmp9_);
#line 540 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp9_);
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = _ ("Cloning…");
#line 541 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (row, _tmp10_);
#line 543 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (row, TRUE);
#line 544 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) row);
#line 546 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) row);
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 547 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1791 "gitg-repository-list-box.c"
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return _data18_;
#line 1800 "gitg-repository-list-box.c"
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 1809 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data18_->self;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data18_->workdir);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data18_->row);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block18Data, _data18_);
#line 1821 "gitg-repository-list-box.c"
	}
}


static void ___lambda71_ (GitgRepositoryListBox* self) {
#line 560 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject*) self, "has-selection");
#line 1829 "gitg-repository-list-box.c"
}


static void ____lambda71__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 559 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	___lambda71_ ((GitgRepositoryListBox*) self);
#line 1836 "gitg-repository-list-box.c"
}


static void ___lambda72_ (Block18Data* _data18_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data18_->self;
#line 1846 "gitg-repository-list-box.c"
	{
		GBookmarkFile* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = self->priv->d_bookmark_file;
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _data18_->workdir;
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = g_file_get_uri (_tmp1_);
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = _tmp2_;
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_bookmark_file_remove_item (_tmp0_, _tmp3_, &_inner_error_);
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp3_);
#line 566 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1866 "gitg-repository-list-box.c"
			goto __catch70_g_error;
		}
	}
	goto __finally70;
	__catch70_g_error:
	{
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1877 "gitg-repository-list-box.c"
	}
	__finally70:
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 564 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1888 "gitg-repository-list-box.c"
	}
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = _data18_->row;
#line 569 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp4_);
#line 1894 "gitg-repository-list-box.c"
}


static void ____lambda72__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	___lambda72_ (self);
#line 1901 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_connect_repository_row (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row) {
	Block18Data* _data18_;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepository* repository = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GitgRepository* _tmp4_ = NULL;
	GitgRepository* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GitgRepository* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_->_ref_count_ = 1;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_->self = g_object_ref (self);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data18_->row);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_->row = _tmp1_;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _data18_->row;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gitg_repository_list_box_row_get_repository (_tmp2_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = _tmp3_;
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 552 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	repository = _tmp5_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = repository;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp7_, "workdir", &_tmp8_, NULL);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = _tmp9_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = _tmp10_ != NULL;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp10_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp11_) {
#line 1964 "gitg-repository-list-box.c"
		GitgRepository* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = repository;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp12_, "workdir", &_tmp13_, NULL);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = _tmp13_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp6_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp14_;
#line 1978 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = repository;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = ggit_repository_get_location ((GgitRepository*) _tmp15_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = _tmp16_;
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp6_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp17_;
#line 1993 "gitg-repository-list-box.c"
	}
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp18_ = _g_object_ref0 (_tmp6_);
#line 553 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_->workdir = _tmp18_;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp19_ = _data18_->workdir;
#line 555 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp19_ != NULL) {
#line 2003 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp20_ = NULL;
		GitgRepositoryListBoxRow* _tmp21_ = NULL;
		GitgRepositoryListBoxRow* _tmp22_ = NULL;
		GitgRepositoryListBoxRow* _tmp23_ = NULL;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = _data18_->row;
#line 557 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp20_, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 559 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp21_ = _data18_->row;
#line 559 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_connect_object ((GObject*) _tmp21_, "notify::selected", (GCallback) ____lambda71__g_object_notify, self, 0);
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp22_ = _data18_->row;
#line 563 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_connect_data (_tmp22_, "request-remove", (GCallback) ____lambda72__gitg_repository_list_box_row_request_remove, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp23_ = _data18_->row;
#line 572 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (_tmp23_, TRUE);
#line 2024 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp24_ = NULL;
#line 576 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp24_ = _data18_->row;
#line 576 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (_tmp24_, FALSE);
#line 2031 "gitg-repository-list-box.c"
	}
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (repository);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	block18_data_unref (_data18_);
#line 550 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_data18_ = NULL;
#line 2041 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 2048 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository, GDateTime* visited) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* f = NULL;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GDateTime* _tmp38_ = NULL;
	GDateTime* _tmp39_ = NULL;
	GitgRepositoryListBoxRow* _tmp43_ = NULL;
	GFile* _tmp44_ = NULL;
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 581 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 583 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	row = _tmp1_;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 2094 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 2108 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 2123 "gitg-repository-list-box.c"
	}
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 585 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	f = _tmp14_;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = row;
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 2133 "gitg-repository-list-box.c"
		GFile* _tmp16_ = NULL;
		GitgRepository* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gchar* dirname = NULL;
		GFile* _tmp28_ = NULL;
		GFile* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GitgRepository* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GitgRepositoryListBoxRow* _tmp34_ = NULL;
		GitgRepositoryListBoxRow* _tmp35_ = NULL;
		GitgRepositoryListBoxRow* _tmp36_ = NULL;
		GitgRepositoryListBoxRow* _tmp37_ = NULL;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp17_ = repository;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp17_, "workdir", &_tmp18_, NULL);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp19_ = _tmp18_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = _tmp19_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp21_ = _tmp20_ != NULL;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp20_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp21_) {
#line 2165 "gitg-repository-list-box.c"
			GitgRepository* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			GFile* _tmp24_ = NULL;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = repository;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_get ((GgitRepository*) _tmp22_, "workdir", &_tmp23_, NULL);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp16_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = _tmp24_;
#line 2179 "gitg-repository-list-box.c"
		} else {
			GitgRepository* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp26_ = ggit_repository_get_location ((GgitRepository*) _tmp25_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp16_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = _tmp27_;
#line 2194 "gitg-repository-list-box.c"
		}
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp28_ = g_file_get_parent (_tmp16_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp29_ = _tmp28_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = gitg_utils_replace_home_dir_with_tilde (_tmp29_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp31_ = _tmp30_;
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp29_);
#line 589 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		dirname = _tmp31_;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = repository;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = dirname;
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = gitg_repository_list_box_row_new (_tmp32_, _tmp33_);
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp34_);
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (row);
#line 590 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		row = _tmp34_;
#line 591 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp35_ = row;
#line 591 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp35_);
#line 593 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp36_ = row;
#line 593 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_connect_repository_row (self, _tmp36_);
#line 595 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp37_ = row;
#line 595 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (dirname);
#line 587 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp16_);
#line 2236 "gitg-repository-list-box.c"
	}
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp39_ = visited;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp39_ != NULL) {
#line 2242 "gitg-repository-list-box.c"
		GDateTime* _tmp40_ = NULL;
		GDateTime* _tmp41_ = NULL;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp40_ = visited;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp41_ = _g_date_time_ref0 (_tmp40_);
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp38_);
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _tmp41_;
#line 2253 "gitg-repository-list-box.c"
	} else {
		GDateTime* _tmp42_ = NULL;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp42_ = g_date_time_new_now_local ();
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp38_);
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _tmp42_;
#line 2262 "gitg-repository-list-box.c"
	}
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp43_ = row;
#line 598 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (_tmp43_, _tmp38_);
#line 599 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp44_ = f;
#line 601 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp44_ != NULL) {
#line 2274 "gitg-repository-list-box.c"
		GFile* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		GDateTime* _tmp48_ = NULL;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp45_ = f;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp46_ = g_file_get_uri (_tmp45_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp47_ = _tmp46_;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = visited;
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_bookmarks (self, _tmp47_, _tmp48_);
#line 603 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp47_);
#line 2291 "gitg-repository-list-box.c"
	}
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (_tmp38_);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (f);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 606 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2303 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 647 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 649 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 651 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 2322 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2332 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 2339 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_mode;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2354 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_mode = _tmp0_;
#line 261 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2368 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_bookmarks_from_recent_files (GitgRepositoryListBox* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_bookmarks_from_recent_files;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2383 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_bookmarks_from_recent_files (GitgRepositoryListBox* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_bookmarks_from_recent_files = _tmp0_;
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "bookmarks-from-recent-files");
#line 2397 "gitg-repository-list-box.c"
}


GFile* gitg_repository_list_box_get_location (GitgRepositoryListBox* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_location;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 273 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2412 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_location (GitgRepositoryListBox* self, GFile* value) {
	guint _tmp0_ = 0U;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GBookmarkFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_save_repository_bookmarks_id;
#line 278 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2428 "gitg-repository-list-box.c"
		guint _tmp1_ = 0U;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = self->priv->d_save_repository_bookmarks_id;
#line 280 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_source_remove (_tmp1_);
#line 281 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_save_repository_bookmarks (self);
#line 2436 "gitg-repository-list-box.c"
	}
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = value;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_location);
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_location = _tmp3_;
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_bookmark_file_new ();
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
#line 285 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_bookmark_file = _tmp4_;
#line 2452 "gitg-repository-list-box.c"
	{
		GBookmarkFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_bookmark_file;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = value;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = g_file_get_path (_tmp6_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _tmp7_;
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_bookmark_file_load_from_file (_tmp5_, _tmp8_, &_inner_error_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp8_);
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 289 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 2474 "gitg-repository-list-box.c"
				goto __catch71_g_file_error;
			}
			goto __catch71_g_error;
		}
	}
	goto __finally71;
	__catch71_g_file_error:
	{
		GError* e = NULL;
		gboolean _tmp9_ = FALSE;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = self->priv->_bookmarks_from_recent_files;
#line 293 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_) {
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_copy_bookmarks_from_recent_files (self);
#line 2495 "gitg-repository-list-box.c"
		}
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 2499 "gitg-repository-list-box.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		FILE* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = stderr;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = e;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_->message;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = string_to_string (_tmp12_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = g_strconcat ("Failed to read repository bookmarks: ", _tmp13_, "\n", NULL);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = _tmp14_;
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		fprintf (_tmp10_, "%s", _tmp15_);
#line 301 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp15_);
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 2533 "gitg-repository-list-box.c"
	}
	__finally71:
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 287 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2544 "gitg-repository-list-box.c"
	}
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "location");
#line 2548 "gitg-repository-list-box.c"
}


static void _vala_array_add14 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if ((*length) == (*size)) {
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
#line 2559 "gitg-repository-list-box.c"
	}
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[(*length)++] = value;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[*length] = NULL;
#line 2565 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1) {
	GitgRepositoryListBoxRow** result;
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GList* _tmp1_ = NULL;
	GitgRepositoryListBoxRow** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 611 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	ret = _tmp0_;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	ret_length1 = 0;
#line 613 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_ret_size_ = ret_length1;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 2590 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp1_;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2598 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 2602 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = row;
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 617 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp3_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = r;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = _tmp5_;
#line 619 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp6_) {
#line 2624 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GitgRepositoryListBoxRow* _tmp8_ = NULL;
					GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = ret;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7__length1 = ret_length1;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = r;
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 621 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_vala_array_add14 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 2639 "gitg-repository-list-box.c"
				}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2643 "gitg-repository-list-box.c"
			}
		}
#line 615 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2648 "gitg-repository-list-box.c"
	}
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = ret;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10__length1 = ret_length1;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (result_length1) {
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		*result_length1 = _tmp10__length1;
#line 2658 "gitg-repository-list-box.c"
	}
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp10_;
#line 625 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2664 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 631 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 2675 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp0_;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2683 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 2687 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 635 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = row;
#line 635 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 635 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp2_;
#line 637 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = r;
#line 637 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
#line 637 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 637 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp5_) {
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					result = TRUE;
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (r);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_list_free0 (row_collection);
#line 639 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					return result;
#line 2717 "gitg-repository-list-box.c"
				}
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2721 "gitg-repository-list-box.c"
			}
		}
#line 633 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2726 "gitg-repository-list-box.c"
	}
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 643 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2732 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 2751 "gitg-repository-list-box.c"
	} else {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 2757 "gitg-repository-list-box.c"
	}
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 2763 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 2770 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2779 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2788 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
	GBookmarkFile* _tmp0_ = NULL;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 372 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 373 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 375 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 377 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_bookmark_file_new ();
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
#line 379 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_bookmark_file = _tmp0_;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 2821 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_branch_name;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ == NULL) {
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 2836 "gitg-repository-list-box.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_branch_name;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 2843 "gitg-repository-list-box.c"
	}
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_) {
#line 2847 "gitg-repository-list-box.c"
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_branch_label;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _ ("at %s");
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_dirname;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp6_;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_label_set_label (_tmp3_, _tmp7_);
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp7_);
#line 2867 "gitg-repository-list-box.c"
	} else {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = self->priv->d_dirname;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ == NULL) {
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = TRUE;
#line 2877 "gitg-repository-list-box.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = self->priv->d_dirname;
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
#line 2884 "gitg-repository-list-box.c"
		}
#line 156 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp8_) {
#line 2888 "gitg-repository-list-box.c"
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = self->priv->d_branch_label;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = self->priv->d_branch_name;
#line 158 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp11_, _tmp12_);
#line 2897 "gitg-repository-list-box.c"
		} else {
			GtkLabel* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = self->priv->d_branch_label;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = _ ("%s at %s");
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp15_ = self->priv->d_branch_name;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = self->priv->d_dirname;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = g_strdup_printf (_tmp14_, _tmp15_, _tmp16_);
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = _tmp17_;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp13_, _tmp18_);
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp18_);
#line 2921 "gitg-repository-list-box.c"
		}
	}
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 2930 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_update_repository_data (GitgRepositoryListBoxRow* self) {
	gchar* head_name = NULL;
	gchar* _tmp0_ = NULL;
	gchar* head_description = NULL;
	gchar* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	gchar* _tmp68_ = NULL;
	GitgRepository* _tmp69_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	GtkLabel* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GError * _inner_error_ = NULL;
#line 167 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_strdup ("");
#line 169 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	head_name = _tmp0_;
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup ("");
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	head_description = _tmp1_;
#line 172 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 172 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2962 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GgitObject* _tmp11_ = NULL;
			GitgRef* _tmp12_ = NULL;
			GgitObject* _tmp13_ = NULL;
			GgitCommit* commit = NULL;
			GgitObject* _tmp14_ = NULL;
			GgitTree* tree = NULL;
			GgitCommit* _tmp15_ = NULL;
			GgitTree* _tmp16_ = NULL;
			GgitOId* entry_id = NULL;
			GgitOId* _tmp34_ = NULL;
#line 176 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 176 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 176 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 176 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2991 "gitg-repository-list-box.c"
				goto __catch72_g_error;
			}
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp10_;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = head;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = ggit_ref_lookup ((GgitRef*) _tmp12_, &_inner_error_);
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp13_;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 3022 "gitg-repository-list-box.c"
				goto __catch72_g_error;
			}
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = _tmp11_;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = NULL;
#line 179 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			commit = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, ggit_commit_get_type (), GgitCommit);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp15_ = commit;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = ggit_commit_get_tree (_tmp15_);
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			tree = _tmp16_;
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			entry_id = NULL;
#line 3039 "gitg-repository-list-box.c"
			{
				gint i = 0;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				i = 0;
#line 3044 "gitg-repository-list-box.c"
				{
					gboolean _tmp17_ = FALSE;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp17_ = TRUE;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					while (TRUE) {
#line 3051 "gitg-repository-list-box.c"
						gint _tmp19_ = 0;
						GgitTree* _tmp20_ = NULL;
						guint _tmp21_ = 0U;
						GgitTreeEntry* entry = NULL;
						GgitTree* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						GgitTreeEntry* _tmp24_ = NULL;
						gchar* name = NULL;
						GgitTreeEntry* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
						const gchar* _tmp29_ = NULL;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						if (!_tmp17_) {
#line 3067 "gitg-repository-list-box.c"
							gint _tmp18_ = 0;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp18_ = i;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							i = _tmp18_ + 1;
#line 3073 "gitg-repository-list-box.c"
						}
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp17_ = FALSE;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp19_ = i;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp20_ = tree;
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp21_ = ggit_tree_size (_tmp20_);
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						if (!(((guint) _tmp19_) < _tmp21_)) {
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							break;
#line 3087 "gitg-repository-list-box.c"
						}
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp22_ = tree;
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp23_ = i;
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp24_ = ggit_tree_get (_tmp22_, (guint) _tmp23_);
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						entry = _tmp24_;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp25_ = entry;
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp26_ = ggit_tree_entry_get_name (_tmp25_);
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp27_ = g_strdup (_tmp26_);
#line 187 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						name = _tmp27_;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp29_ = name;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						if (_tmp29_ != NULL) {
#line 3109 "gitg-repository-list-box.c"
							const gchar* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp30_ = name;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp31_ = g_str_has_suffix (_tmp30_, ".doap");
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp28_ = _tmp31_;
#line 3118 "gitg-repository-list-box.c"
						} else {
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp28_ = FALSE;
#line 3122 "gitg-repository-list-box.c"
						}
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						if (_tmp28_) {
#line 3126 "gitg-repository-list-box.c"
							GgitTreeEntry* _tmp32_ = NULL;
							GgitOId* _tmp33_ = NULL;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp32_ = entry;
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp33_ = ggit_tree_entry_get_id (_tmp32_);
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							__vala_GgitOId_free0 (entry_id);
#line 191 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							entry_id = _tmp33_;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_g_free0 (name);
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_ggit_tree_entry_unref0 (entry);
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							break;
#line 3143 "gitg-repository-list-box.c"
						}
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_g_free0 (name);
#line 184 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_ggit_tree_entry_unref0 (entry);
#line 3149 "gitg-repository-list-box.c"
					}
				}
			}
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp34_ = entry_id;
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp34_ != NULL) {
#line 3157 "gitg-repository-list-box.c"
				GgitBlob* blob = NULL;
				GitgRepository* _tmp35_ = NULL;
				GgitOId* _tmp36_ = NULL;
				gpointer _tmp37_ = NULL;
				guint8* content = NULL;
				GgitBlob* _tmp38_ = NULL;
				gsize _tmp39_;
				guint8* _tmp40_ = NULL;
				gint content_length1 = 0;
				gint _content_size_ = 0;
				IdeDoap* doap = NULL;
				IdeDoap* _tmp41_ = NULL;
				IdeDoap* _tmp42_ = NULL;
				guint8* _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				IdeDoap* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				IdeDoap* _tmp47_ = NULL;
				gchar** _tmp48_ = NULL;
				gchar** _tmp49_ = NULL;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp35_ = self->priv->d_repository;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp36_ = entry_id;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp37_ = gitg_repository_lookup (_tmp35_, ggit_blob_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp36_, &_inner_error_);
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				blob = (GgitBlob*) _tmp37_;
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					__vala_GgitOId_free0 (entry_id);
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (tree);
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (commit);
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp11_);
#line 198 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (head);
#line 3199 "gitg-repository-list-box.c"
					goto __catch72_g_error;
				}
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp38_ = blob;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp40_ = ggit_blob_get_raw_content (_tmp38_, &_tmp39_);
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				content = _tmp40_;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				content_length1 = _tmp39_;
#line 200 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_content_size_ = content_length1;
#line 201 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp41_ = ide_doap_new ();
#line 201 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				doap = _tmp41_;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp42_ = doap;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp43_ = content;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp43__length1 = content_length1;
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				ide_doap_load_from_data (_tmp42_, (const gchar*) _tmp43_, (gsize) -1, &_inner_error_);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (doap);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (blob);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					__vala_GgitOId_free0 (entry_id);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (tree);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (commit);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp11_);
#line 202 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (head);
#line 3240 "gitg-repository-list-box.c"
					goto __catch72_g_error;
				}
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp44_ = doap;
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp45_ = ide_doap_get_shortdesc (_tmp44_);
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp46_ = g_strdup (_tmp45_);
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_free0 (head_description);
#line 204 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				head_description = _tmp46_;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp47_ = doap;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp49_ = _tmp48_ = ide_doap_get_languages (_tmp47_);
#line 3257 "gitg-repository-list-box.c"
				{
					gchar** lang_collection = NULL;
					gint lang_collection_length1 = 0;
					gint _lang_collection_size_ = 0;
					gint lang_it = 0;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					lang_collection = _tmp49_;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					lang_collection_length1 = _vala_array_length (_tmp48_);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
					for (lang_it = 0; lang_it < _vala_array_length (_tmp48_); lang_it = lang_it + 1) {
#line 3269 "gitg-repository-list-box.c"
						gchar* _tmp50_ = NULL;
						gchar* lang = NULL;
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp50_ = g_strdup (lang_collection[lang_it]);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
						lang = _tmp50_;
#line 3276 "gitg-repository-list-box.c"
						{
							GtkFrame* frame = NULL;
							GtkFrame* _tmp51_ = NULL;
							GtkFrame* _tmp52_ = NULL;
							GtkFrame* _tmp53_ = NULL;
							GtkStyleContext* _tmp54_ = NULL;
							GtkFrame* _tmp55_ = NULL;
							GtkLabel* label = NULL;
							const gchar* _tmp56_ = NULL;
							GtkLabel* _tmp57_ = NULL;
							PangoAttrList* attr_list = NULL;
							PangoAttrList* _tmp58_ = NULL;
							PangoAttrList* _tmp59_ = NULL;
							PangoAttribute* _tmp60_ = NULL;
							GtkLabel* _tmp61_ = NULL;
							PangoAttrList* _tmp62_ = NULL;
							GtkLabel* _tmp63_ = NULL;
							GtkFrame* _tmp64_ = NULL;
							GtkLabel* _tmp65_ = NULL;
							GtkBox* _tmp66_ = NULL;
							GtkFrame* _tmp67_ = NULL;
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp51_ = (GtkFrame*) gtk_frame_new (NULL);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							g_object_ref_sink (_tmp51_);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							frame = _tmp51_;
#line 209 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp52_ = frame;
#line 209 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_frame_set_shadow_type (_tmp52_, GTK_SHADOW_NONE);
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp53_ = frame;
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp54_ = gtk_widget_get_style_context ((GtkWidget*) _tmp53_);
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_style_context_add_class (_tmp54_, "language-frame");
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp55_ = frame;
#line 211 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_widget_show ((GtkWidget*) _tmp55_);
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp56_ = lang;
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp57_ = (GtkLabel*) gtk_label_new (_tmp56_);
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							g_object_ref_sink (_tmp57_);
#line 213 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							label = _tmp57_;
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp58_ = pango_attr_list_new ();
#line 214 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							attr_list = _tmp58_;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp59_ = attr_list;
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp60_ = pango_attr_scale_new (PANGO_SCALE_SMALL);
#line 215 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							pango_attr_list_insert (_tmp59_, _tmp60_);
#line 216 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp61_ = label;
#line 216 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp62_ = attr_list;
#line 216 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_label_set_attributes (_tmp61_, _tmp62_);
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp63_ = label;
#line 217 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_widget_show ((GtkWidget*) _tmp63_);
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp64_ = frame;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp65_ = label;
#line 219 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp66_ = self->priv->d_languages_box;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp67_ = frame;
#line 220 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_pango_attr_list_unref0 (attr_list);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (label);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (frame);
#line 206 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
							_g_free0 (lang);
#line 3366 "gitg-repository-list-box.c"
						}
					}
				}
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (doap);
#line 196 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (blob);
#line 3374 "gitg-repository-list-box.c"
			}
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			__vala_GgitOId_free0 (entry_id);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (tree);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (commit);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp11_);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 3386 "gitg-repository-list-box.c"
		}
		goto __finally72;
		__catch72_g_error:
		{
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 3395 "gitg-repository-list-box.c"
		}
		__finally72:
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_description);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 3410 "gitg-repository-list-box.c"
		}
	}
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp69_ = self->priv->d_repository;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp69_ != NULL) {
#line 3417 "gitg-repository-list-box.c"
		GitgRepository* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp70_ = self->priv->d_repository;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp71_ = gitg_repository_get_name (_tmp70_);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp72_ = _tmp71_;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp68_);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp68_ = _tmp72_;
#line 3431 "gitg-repository-list-box.c"
	} else {
		gchar* _tmp73_ = NULL;
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp73_ = g_strdup ("");
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp68_);
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp68_ = _tmp73_;
#line 3440 "gitg-repository-list-box.c"
	}
#line 226 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository_name (self, _tmp68_);
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp74_ = self->priv->d_description_label;
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp75_ = head_description;
#line 228 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_label (_tmp74_, _tmp75_);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp76_ = self->priv->d_description_label;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp77_ = head_description;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp76_, g_strcmp0 (_tmp77_, "") != 0);
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp78_ = head_name;
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, _tmp78_);
#line 167 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp68_);
#line 167 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (head_description);
#line 167 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (head_name);
#line 3466 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, GitgRepository* repository, const gchar* dirname) {
	GitgRepositoryListBoxRow * self = NULL;
	GitgRepository* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (dirname != NULL, NULL);
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = dirname;
#line 257 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository", _tmp0_, "dirname", _tmp1_, NULL);
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 3484 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (GitgRepository* repository, const gchar* dirname) {
#line 255 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, repository, dirname);
#line 3491 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 66 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3506 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
	GitgSelectionMode _tmp1_ = 0;
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 70 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != _tmp1_) {
#line 3521 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp2_ = 0;
		GtkRevealer* _tmp3_ = NULL;
		GitgSelectionMode _tmp4_ = 0;
		GtkCheckButton* _tmp5_ = NULL;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = value;
#line 72 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		self->priv->d_mode = _tmp2_;
#line 74 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_remove_revealer;
#line 74 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_mode;
#line 74 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_revealer_set_reveal_child (_tmp3_, _tmp4_ == GITG_SELECTION_MODE_SELECTION);
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_remove_check_button;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
#line 3540 "gitg-repository-list-box.c"
	}
#line 68 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 3544 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_selected;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3559 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_selected = _tmp0_;
#line 83 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "selected");
#line 3573 "gitg-repository-list-box.c"
}


GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 97 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3588 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 98 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 101 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_repository_data (self);
#line 98 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 3609 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp2_;
#line 107 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3630 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 3647 "gitg-repository-list-box.c"
}


GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3662 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 114 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 3681 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 120 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 3698 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 125 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3716 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_label (_tmp0_, _tmp1_);
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 3733 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 131 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_dirname;
#line 131 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 131 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3748 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_dirname = _tmp1_;
#line 135 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "dirname");
#line 3769 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_name;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 141 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3784 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 142 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 144 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_branch_name = _tmp1_;
#line 145 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 142 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 3805 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3820 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 237 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 239 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 241 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (!_tmp1_) {
#line 3837 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GitgProgressBin* _tmp4_ = NULL;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 243 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 244 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 244 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_progress_bin;
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp4_, (gdouble) 0);
#line 3853 "gitg-repository-list-box.c"
	} else {
		GtkSpinner* _tmp5_ = NULL;
		GtkSpinner* _tmp6_ = NULL;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_spinner;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp5_);
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_spinner;
#line 250 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp6_);
#line 3865 "gitg-repository-list-box.c"
	}
#line 237 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3869 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_ = NULL;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3890 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME, g_param_spec_string ("dirname", "dirname", "dirname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-repository-list-box-row.ui");
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_description_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_description_label));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_languages_box", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_languages_box));
#line 3950 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3969 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 38 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 42 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_description_label);
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 50 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 52 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_check_button);
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_revealer);
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_languages_box);
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 62 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 4003 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_dirname (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4078 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4084 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_dirname (self, g_value_get_string (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4154 "gitg-repository-list-box.c"
		default:
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4160 "gitg-repository-list-box.c"
	}
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*)(GtkWidget*, GdkEventButton*)) gitg_repository_list_box_real_button_press_event;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkListBoxClass *) klass)->row_activated = (void (*)(GtkListBox*, GtkListBoxRow*)) gitg_repository_list_box_real_row_activated;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES, g_param_spec_boolean ("bookmarks-from-recent-files", "bookmarks-from-recent-files", "bookmarks-from-recent-files", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_LOCATION, g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 4194 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 263 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_bookmarks_from_recent_files = TRUE;
#line 4203 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
	guint _tmp0_ = 0U;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_save_repository_bookmarks_id;
#line 384 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 4216 "gitg-repository-list-box.c"
		guint _tmp1_ = 0U;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = self->priv->d_save_repository_bookmarks_id;
#line 386 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_source_remove (_tmp1_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_save_repository_bookmarks (self);
#line 4224 "gitg-repository-list-box.c"
	}
#line 30 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_location);
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	_g_bookmark_file_free0 (self->priv->d_bookmark_file);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 4234 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_bookmarks_from_recent_files (self));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_LOCATION:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_get_location (self));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4279 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4285 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_BOOKMARKS_FROM_RECENT_FILES:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_bookmarks_from_recent_files (self, g_value_get_boolean (value));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_LOCATION:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_location (self, g_value_get_object (value));
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4313 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/dev/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 4319 "gitg-repository-list-box.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



