/* libedataserver-1.2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "E", gir_namespace = "EDataServer", gir_version = "1.2", lower_case_cprefix = "e_")]
namespace E {
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Compact]
	[Version (since = "3.6")]
	public class AsyncClosure {
		public static void callback (GLib.Object object, GLib.AsyncResult result, void* closure);
		public void free ();
		public unowned GLib.AsyncResult wait ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_client_get_type ()")]
	[Version (since = "3.2")]
	public abstract class Client : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Client ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public void cancel_all ();
		public bool check_capability (string capability);
		public bool check_refresh_supported ();
		[Version (since = "3.16")]
		public string dup_bus_name ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static GLib.Error error_create (E.ClientError code, string custom_msg);
		public static GLib.Quark error_quark ();
		public static unowned string error_to_string (E.ClientError code);
		public virtual async bool get_backend_property (string prop_name, GLib.Cancellable? cancellable, out string prop_value) throws GLib.Error;
		public virtual bool get_backend_property_sync (string prop_name, out string prop_value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.SList<string> get_capabilities ();
		public unowned E.Source get_source ();
		public bool is_online ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2.")]
		public bool is_opened ();
		public bool is_readonly ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual async bool open (bool only_if_exists, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual bool open_sync (bool only_if_exists, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.8")]
		public GLib.MainContext ref_main_context ();
		public virtual async bool refresh (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool refresh_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.6", since = "3.2")]
		public virtual async bool remove (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.6", since = "3.2")]
		public virtual bool remove_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual async bool retrieve_capabilities (GLib.Cancellable? cancellable, out string capabilities) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual bool retrieve_capabilities_sync (out string capabilities, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public async bool retrieve_properties (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.16")]
		public virtual bool retrieve_properties_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual async bool set_backend_property (string prop_name, string prop_value, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual bool set_backend_property_sync (string prop_name, string prop_value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public void set_bus_name (string bus_name);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public virtual void unwrap_dbus_error (GLib.Error dbus_error) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static GLib.SList<GLib.Object> util_copy_object_slist (GLib.SList<GLib.Object>? copy_to, GLib.SList<GLib.Object> objects);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static GLib.SList<string> util_copy_string_slist (GLib.SList<string>? copy_to, GLib.SList<string> strings);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static void util_free_object_slist (GLib.SList<GLib.Object> objects);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static void util_free_string_slist (GLib.SList<string> strings);
		public static GLib.SList<string> util_parse_comma_strings (string strings);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static string[] util_slist_to_strv (GLib.SList<string> strings);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static GLib.SList<string> util_strv_to_slist (string strv);
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
		public static bool util_unwrap_dbus_error (GLib.Error dbus_error, out GLib.Error client_error, E.ClientErrorsList known_errors, uint known_errors_count, GLib.Quark known_errors_domain, bool fail_when_none_matched);
		[Version (since = "3.16")]
		public async bool wait_for_connected (uint32 timeout_seconds, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.16")]
		public bool wait_for_connected_sync (uint32 timeout_seconds, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void* capabilities { get; }
		[NoAccessorMethod]
		public GLib.MainContext main_context { owned get; }
		[NoAccessorMethod]
		public bool online { get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "3.8")]
		public virtual bool opened { get; }
		[NoAccessorMethod]
		public bool readonly { get; }
		public E.Source source { get; construct; }
		public virtual signal void backend_died ();
		public virtual signal void backend_error (string error_msg);
		public virtual signal void backend_property_changed (string prop_name, string prop_value);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", ref_function = "e_collator_ref", type_id = "e_collator_get_type ()", unref_function = "e_collator_unref")]
	[Compact]
	[Version (since = "3.12")]
	public class Collator {
		[CCode (has_construct_function = false)]
		public Collator (string locale) throws GLib.Error;
		public bool collate (string? str_a, string? str_b, out int result) throws GLib.Error;
		public string generate_key (string str) throws GLib.Error;
		public string generate_key_for_index (int index);
		public int get_index (string str);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_index_labels (out int n_labels, out int underflow, out int inflow, out int overflow);
		[CCode (has_construct_function = false)]
		public Collator.interpret_country (string locale, out string country_code) throws GLib.Error;
		public E.Collator @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_extension_get_type ()")]
	[Version (since = "3.4")]
	public abstract class Extension : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Extension ();
		public unowned E.Extensible get_extensible ();
		public E.Extensible extensible { get; construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Compact]
	[Version (since = "1.12")]
	public class Flag {
		public void clear ();
		public void free ();
		public bool is_set ();
		public void @set ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "1.12")]
		public bool timed_wait (GLib.TimeVal abs_time);
		public void wait ();
		[Version (since = "3.8")]
		public bool wait_until (int64 end_time);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Compact]
	public class MemChunk {
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_module_get_type ()")]
	[Version (since = "3.4")]
	public class Module : GLib.TypeModule, GLib.TypePlugin {
		[CCode (has_construct_function = false)]
		public Module (string filename);
		public unowned string get_filename ();
		public static GLib.List<weak E.Module> load_all_in_directory (string dirname);
		[Version (since = "3.16")]
		public static E.Module load_file (string filename);
		public string filename { get; construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "e_named_parameters_get_type ()")]
	[Compact]
	[Version (since = "3.8")]
	public class NamedParameters {
		[CCode (has_construct_function = false)]
		public NamedParameters ();
		public void assign (E.NamedParameters? from);
		public void clear ();
		[Version (since = "3.18")]
		public uint count ();
		[Version (since = "3.18")]
		public bool exists (global::string name);
		public void free ();
		public unowned global::string @get (global::string name);
		[Version (since = "3.18")]
		public global::string get_name (int index);
		[Version (since = "3.16")]
		public E.NamedParameters new_clone ();
		public void @set (global::string name, global::string? value);
		[CCode (has_construct_function = false)]
		[Version (since = "3.18")]
		public NamedParameters.string (global::string str);
		[CCode (has_construct_function = false)]
		public NamedParameters.strv (global::string strv);
		public bool test (global::string name, global::string value, bool case_sensitively);
		[Version (since = "3.18")]
		public global::string to_string ();
		[CCode (array_length = false, array_null_terminated = true)]
		public global::string[] to_strv ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Compact]
	[Version (since = "3.2")]
	public class OperationPool {
		public void free ();
		public void push (void* opdata);
		public void release_opid (uint32 opid);
		public uint32 reserve_opid ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_soup_auth_bearer_get_type ()")]
	[Version (since = "3.10")]
	public class SoupAuthBearer : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected SoupAuthBearer ();
		[Version (since = "3.24")]
		public bool is_expired ();
		public void set_access_token (string access_token, int expires_in_seconds);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_get_type ()")]
	[Version (since = "3.6")]
	public class Source : GLib.Object, GLib.Initable, GLib.ProxyResolver {
		[CCode (has_construct_function = false)]
		public Source (GLib.DBusObject? dbus_object, GLib.MainContext? main_context) throws GLib.Error;
		public int compare_by_display_name (E.Source source2);
		public bool credentials_google_get_access_token_sync (E.NamedParameters credentials, string out_access_token, int out_expires_in_seconds, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static bool credentials_google_is_supported ();
		public static bool credentials_google_util_extract_from_credentials (E.NamedParameters credentials, string out_access_token, int out_expires_in_seconds);
		public bool credentials_google_util_generate_secret_uid (string out_uid);
		[Version (since = "3.12")]
		public async bool delete_password (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.12")]
		public bool delete_password_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string dup_display_name ();
		public string dup_parent ();
		[Version (since = "3.12")]
		public string dup_secret_label ();
		public string dup_uid ();
		[Version (since = "3.16")]
		public void emit_credentials_required (E.SourceCredentialsReason reason, string certificate_pem, GLib.TlsCertificateFlags certificate_errors, GLib.Error? op_error);
		public bool equal (E.Source source2);
		[Version (since = "3.16")]
		public E.SourceConnectionStatus get_connection_status ();
		public unowned string get_display_name ();
		public bool get_enabled ();
		public unowned E.SourceExtension get_extension (string extension_name);
		[Version (since = "3.16")]
		public async bool get_last_credentials_required_arguments (GLib.Cancellable? cancellable, out E.SourceCredentialsReason out_reason, out string out_certificate_pem, out GLib.TlsCertificateFlags out_certificate_errors, out GLib.Error out_op_error) throws GLib.Error;
		[Version (since = "3.16")]
		public bool get_last_credentials_required_arguments_sync (out E.SourceCredentialsReason out_reason, out string out_certificate_pem, out GLib.TlsCertificateFlags out_certificate_errors, out GLib.Error out_op_error, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.8")]
		public virtual async bool get_oauth2_access_token (GLib.Cancellable? cancellable, out string out_access_token, out int out_expires_in) throws GLib.Error;
		[Version (since = "3.8")]
		public virtual bool get_oauth2_access_token_sync (GLib.Cancellable? cancellable, out string out_access_token, out int out_expires_in) throws GLib.Error;
		public unowned string get_parent ();
		public bool get_remote_creatable ();
		public bool get_remote_deletable ();
		public bool get_removable ();
		public unowned string get_uid ();
		public bool get_writable ();
		public bool has_extension (string extension_name);
		public uint hash ();
		[Version (since = "3.16")]
		public async bool invoke_authenticate (E.NamedParameters? credentials, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual bool invoke_authenticate_impl (void* dbus_source, string arg_credentials, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public bool invoke_authenticate_sync (E.NamedParameters? credentials, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public async bool invoke_credentials_required (E.SourceCredentialsReason reason, string certificate_pem, GLib.TlsCertificateFlags certificate_errors, GLib.Error? op_error, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual bool invoke_credentials_required_impl (void* dbus_source, string arg_reason, string arg_certificate_pem, string arg_certificate_errors, string arg_dbus_error_name, string arg_dbus_error_message, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public bool invoke_credentials_required_sync (E.SourceCredentialsReason reason, string certificate_pem, GLib.TlsCertificateFlags certificate_errors, GLib.Error? op_error, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.12")]
		public async bool lookup_password (GLib.Cancellable? cancellable, out string out_password) throws GLib.Error;
		[Version (since = "3.12")]
		public bool lookup_password_sync (GLib.Cancellable? cancellable, out string out_password) throws GLib.Error;
		public async bool mail_signature_load (int io_priority, GLib.Cancellable? cancellable, out string contents, out size_t length) throws GLib.Error;
		public bool mail_signature_load_sync (out string contents, out size_t length, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool mail_signature_replace (string contents, size_t length, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool mail_signature_replace_sync (string contents, size_t length, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool mail_signature_symlink (string symlink_target, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool mail_signature_symlink_sync (string symlink_target, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static string parameter_to_key (string param_name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.12")]
		public async string[] proxy_lookup (string uri, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.12")]
		public string[] proxy_lookup_sync (string uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.DBusObject ref_dbus_object ();
		public GLib.MainContext ref_main_context ();
		public uint refresh_add_timeout (GLib.MainContext? context, owned E.SourceRefreshFunc callback);
		public void refresh_force_timeout ();
		public bool refresh_remove_timeout (uint refresh_timeout_id);
		public uint refresh_remove_timeouts_by_data (void* user_data);
		public virtual async bool remote_create (E.Source scratch_source, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool remote_create_sync (E.Source scratch_source, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool remote_delete (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool remote_delete_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool remove (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool remove_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.16")]
		public void set_connection_status (E.SourceConnectionStatus connection_status);
		public void set_display_name (string display_name);
		public void set_enabled (bool enabled);
		public void set_parent (string? parent);
		[Version (since = "3.12")]
		public async bool store_password (string password, bool permanently, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.12")]
		public bool store_password_sync (string password, bool permanently, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string to_string (size_t? length);
		[Version (since = "3.18")]
		public async bool unset_last_credentials_required_arguments (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual bool unset_last_credentials_required_arguments_impl (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.18")]
		public bool unset_last_credentials_required_arguments_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Source.with_uid (string uid, GLib.MainContext? main_context) throws GLib.Error;
		public virtual async bool write (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool write_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public E.SourceConnectionStatus connection_status { get; }
		public string display_name { get; set construct; }
		public bool enabled { get; set construct; }
		[NoAccessorMethod]
		public GLib.MainContext main_context { owned get; construct; }
		public string parent { get; set; }
		public bool remote_creatable { get; }
		public bool remote_deletable { get; }
		public bool removable { get; }
		public string uid { get; construct; }
		public bool writable { get; }
		public virtual signal void authenticate (E.NamedParameters credentials);
		[HasEmitter]
		public virtual signal void changed ();
		public virtual signal void credentials_required (E.SourceCredentialsReason reason, string certificate_pem, GLib.TlsCertificateFlags certificate_errors, GLib.Error op_error);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_address_book_get_type ()")]
	[Version (since = "3.6")]
	public class SourceAddressBook : E.SourceBackend {
		[CCode (has_construct_function = false)]
		protected SourceAddressBook ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_alarms_get_type ()")]
	[Version (since = "3.6")]
	public class SourceAlarms : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceAlarms ();
		public string dup_last_notified ();
		public bool get_include_me ();
		public unowned string get_last_notified ();
		public void set_include_me (bool include_me);
		public void set_last_notified (string? last_notified);
		public bool include_me { get; set construct; }
		public string last_notified { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_authentication_get_type ()")]
	[Version (since = "3.6")]
	public class SourceAuthentication : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceAuthentication ();
		[Version (since = "3.16")]
		public string dup_credential_name ();
		public string dup_host ();
		public string dup_method ();
		[Version (since = "3.12")]
		public string dup_proxy_uid ();
		public string dup_user ();
		[Version (since = "3.16")]
		public unowned string get_credential_name ();
		public unowned string get_host ();
		public unowned string get_method ();
		public uint16 get_port ();
		[Version (since = "3.12")]
		public unowned string get_proxy_uid ();
		[Version (since = "3.10")]
		public bool get_remember_password ();
		public unowned string get_user ();
		[Version (since = "3.8")]
		public GLib.SocketConnectable ref_connectable ();
		public bool required ();
		[Version (since = "3.16")]
		public void set_credential_name (string? credential_name);
		public void set_host (string? host);
		public void set_method (string? method);
		public void set_port (uint16 port);
		[Version (since = "3.12")]
		public void set_proxy_uid (string proxy_uid);
		[Version (since = "3.10")]
		public void set_remember_password (bool remember_password);
		public void set_user (string? user);
		[NoAccessorMethod]
		public GLib.SocketConnectable connectable { owned get; }
		public string credential_name { get; set construct; }
		public string host { get; set construct; }
		public string method { get; set construct; }
		public uint port { get; set construct; }
		public string proxy_uid { get; set construct; }
		public bool remember_password { get; set construct; }
		public string user { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_autocomplete_get_type ()")]
	[Version (since = "3.6")]
	public class SourceAutocomplete : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceAutocomplete ();
		public bool get_include_me ();
		public void set_include_me (bool include_me);
		public bool include_me { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_backend_get_type ()")]
	[Version (since = "3.6")]
	public abstract class SourceBackend : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceBackend ();
		public string dup_backend_name ();
		public unowned string get_backend_name ();
		public void set_backend_name (string? backend_name);
		public string backend_name { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_calendar_get_type ()")]
	[Version (since = "3.6")]
	public class SourceCalendar : E.SourceSelectable {
		[CCode (has_construct_function = false)]
		protected SourceCalendar ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_camel_get_type ()")]
	[Version (since = "3.6")]
	public abstract class SourceCamel : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceCamel ();
		public static GLib.Type generate_subtype (string protocol, GLib.Type settings_type);
		public static unowned string get_extension_name (string protocol);
		public static unowned string get_type_name (string protocol);
		public static void register_types ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_collection_get_type ()")]
	[Version (since = "3.6")]
	public class SourceCollection : E.SourceBackend {
		[CCode (has_construct_function = false)]
		protected SourceCollection ();
		public string dup_identity ();
		public bool get_calendar_enabled ();
		public bool get_contacts_enabled ();
		public unowned string get_identity ();
		public bool get_mail_enabled ();
		public void set_calendar_enabled (bool calendar_enabled);
		public void set_contacts_enabled (bool contacts_enabled);
		public void set_identity (string? identity);
		public void set_mail_enabled (bool mail_enabled);
		public bool calendar_enabled { get; set construct; }
		public bool contacts_enabled { get; set construct; }
		public string identity { get; set construct; }
		public bool mail_enabled { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_contacts_get_type ()")]
	public class SourceContacts : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceContacts ();
		public bool get_include_me ();
		public void set_include_me (bool include_me);
		public bool include_me { get; set; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_credentials_provider_get_type ()")]
	[Version (since = "3.16")]
	public class SourceCredentialsProvider : GLib.Object, E.Extensible {
		[CCode (has_construct_function = false)]
		public SourceCredentialsProvider (E.SourceRegistry registry);
		public bool can_prompt (E.Source source);
		public bool can_store (E.Source source);
		public async bool @delete (E.Source source, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool delete_sync (E.Source source, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool lookup (E.Source source, GLib.Cancellable? cancellable, out E.NamedParameters out_credentials) throws GLib.Error;
		public bool lookup_sync (E.Source source, GLib.Cancellable? cancellable, out E.NamedParameters out_credentials) throws GLib.Error;
		public E.Source ref_credentials_source (E.Source source);
		public GLib.Object ref_registry ();
		public virtual E.Source ref_source (string uid);
		public bool register_impl (E.SourceCredentialsProviderImpl provider_impl);
		public async bool store (E.Source source, E.NamedParameters credentials, bool permanently, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool store_sync (E.Source source, E.NamedParameters credentials, bool permanently, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void unregister_impl (E.SourceCredentialsProviderImpl provider_impl);
		[NoAccessorMethod]
		public GLib.Object registry { owned get; construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_credentials_provider_impl_get_type ()")]
	[Version (since = "3.16")]
	public abstract class SourceCredentialsProviderImpl : E.Extension {
		[CCode (has_construct_function = false)]
		protected SourceCredentialsProviderImpl ();
		public virtual bool can_process (E.Source source);
		public virtual bool can_prompt ();
		public virtual bool can_store ();
		public virtual bool delete_sync (E.Source source, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void* get_provider ();
		public virtual bool lookup_sync (E.Source source, GLib.Cancellable? cancellable, out E.NamedParameters out_credentials) throws GLib.Error;
		public virtual bool store_sync (E.Source source, E.NamedParameters credentials, bool permanently, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_credentials_provider_impl_google_get_type ()")]
	[Version (since = "3.20")]
	public class SourceCredentialsProviderImplGoogle : E.SourceCredentialsProviderImpl {
		[CCode (has_construct_function = false)]
		protected SourceCredentialsProviderImplGoogle ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_credentials_provider_impl_password_get_type ()")]
	[Version (since = "3.16")]
	public class SourceCredentialsProviderImplPassword : E.SourceCredentialsProviderImpl {
		[CCode (has_construct_function = false)]
		protected SourceCredentialsProviderImplPassword ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_extension_get_type ()")]
	[Version (since = "3.6")]
	public abstract class SourceExtension : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceExtension ();
		[Version (deprecated = true, deprecated_since = "3.8", since = "3.6")]
		public unowned E.Source get_source ();
		[Version (since = "3.18")]
		public void property_lock ();
		[Version (since = "3.18")]
		public void property_unlock ();
		[Version (since = "3.8")]
		public E.Source ref_source ();
		public E.Source source { get; construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_goa_get_type ()")]
	[Version (since = "3.6")]
	public class SourceGoa : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceGoa ();
		public string dup_account_id ();
		[Version (since = "3.8")]
		public string dup_calendar_url ();
		[Version (since = "3.8")]
		public string dup_contacts_url ();
		public unowned string get_account_id ();
		[Version (since = "3.8")]
		public unowned string get_calendar_url ();
		[Version (since = "3.8")]
		public unowned string get_contacts_url ();
		public void set_account_id (string? account_id);
		[Version (since = "3.8")]
		public void set_calendar_url (string? calendar_url);
		[Version (since = "3.8")]
		public void set_contacts_url (string? contacts_url);
		public string account_id { get; set construct; }
		public string calendar_url { get; set construct; }
		public string contacts_url { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_ldap_get_type ()")]
	public class SourceLDAP : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceLDAP ();
		public string dup_filter ();
		public string dup_root_dn ();
		public E.SourceLDAPAuthentication get_authentication ();
		public bool get_can_browse ();
		public unowned string get_filter ();
		public uint get_limit ();
		public unowned string get_root_dn ();
		public E.SourceLDAPScope get_scope ();
		public E.SourceLDAPSecurity get_security ();
		public void set_authentication (E.SourceLDAPAuthentication authentication);
		public void set_can_browse (bool can_browse);
		public void set_filter (string filter);
		public void set_limit (uint limit);
		public void set_root_dn (string root_dn);
		public void set_scope (E.SourceLDAPScope scope);
		public void set_security (E.SourceLDAPSecurity security);
		public E.SourceLDAPAuthentication authentication { get; set; }
		public bool can_browse { get; set construct; }
		public string filter { get; set construct; }
		public uint limit { get; set construct; }
		public string root_dn { get; set construct; }
		public E.SourceLDAPScope scope { get; set construct; }
		public E.SourceLDAPSecurity security { get; set; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_local_get_type ()")]
	public class SourceLocal : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceLocal ();
		public GLib.File dup_custom_file ();
		public unowned GLib.File get_custom_file ();
		public void set_custom_file (GLib.File custom_file);
		public GLib.File custom_file { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mdn_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMDN : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceMDN ();
		public E.MdnResponsePolicy get_response_policy ();
		public void set_response_policy (E.MdnResponsePolicy response_policy);
		public E.MdnResponsePolicy response_policy { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_account_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailAccount : E.SourceBackend {
		[CCode (has_construct_function = false)]
		protected SourceMailAccount ();
		[Version (since = "3.16")]
		public string dup_archive_folder ();
		public string dup_identity_uid ();
		[Version (since = "3.16")]
		public unowned string get_archive_folder ();
		public unowned string get_identity_uid ();
		[Version (since = "3.20")]
		public bool get_needs_initial_setup ();
		[Version (since = "3.16")]
		public void set_archive_folder (string? archive_folder);
		public void set_identity_uid (string? identity_uid);
		[Version (since = "3.20")]
		public void set_needs_initial_setup (bool needs_initial_setup);
		public string archive_folder { get; set construct; }
		public string identity_uid { get; set construct; }
		public bool needs_initial_setup { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_composition_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailComposition : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceMailComposition ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] dup_bcc ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] dup_cc ();
		public string dup_drafts_folder ();
		public string dup_templates_folder ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_bcc ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_cc ();
		public unowned string get_drafts_folder ();
		[Version (since = "3.20")]
		public E.SourceMailCompositionReplyStyle get_reply_style ();
		public bool get_sign_imip ();
		public unowned string get_templates_folder ();
		public void set_bcc (string? bcc);
		public void set_cc (string? cc);
		public void set_drafts_folder (string? drafts_folder);
		[Version (since = "3.20")]
		public void set_reply_style (E.SourceMailCompositionReplyStyle reply_style);
		public void set_sign_imip (bool sign_imip);
		public void set_templates_folder (string? templates_folder);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] bcc { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] cc { get; set construct; }
		public string drafts_folder { get; set construct; }
		public E.SourceMailCompositionReplyStyle reply_style { get; set construct; }
		public bool sign_imip { get; set construct; }
		public string templates_folder { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_identity_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailIdentity : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceMailIdentity ();
		public string dup_address ();
		public string dup_name ();
		public string dup_organization ();
		public string dup_reply_to ();
		public string dup_signature_uid ();
		public unowned string get_address ();
		public unowned string get_name ();
		public unowned string get_organization ();
		public unowned string get_reply_to ();
		public unowned string get_signature_uid ();
		public void set_address (string? address);
		public void set_name (string? name);
		public void set_organization (string? organization);
		public void set_reply_to (string? reply_to);
		public void set_signature_uid (string? signature_uid);
		public string address { get; set construct; }
		public string name { get; set construct; }
		public string organization { get; set construct; }
		public string reply_to { get; set construct; }
		public string signature_uid { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_signature_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailSignature : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceMailSignature ();
		public string dup_mime_type ();
		public unowned GLib.File get_file ();
		public unowned string get_mime_type ();
		public void set_mime_type (string? mime_type);
		public GLib.File file { get; }
		public string mime_type { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_submission_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailSubmission : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceMailSubmission ();
		public string dup_sent_folder ();
		public string dup_transport_uid ();
		[Version (since = "3.8")]
		public bool get_replies_to_origin_folder ();
		public unowned string get_sent_folder ();
		public unowned string get_transport_uid ();
		[Version (since = "3.8")]
		public void set_replies_to_origin_folder (bool replies_to_origin_folder);
		public void set_sent_folder (string? sent_folder);
		public void set_transport_uid (string? transport_uid);
		public bool replies_to_origin_folder { get; set construct; }
		public string sent_folder { get; set construct; }
		public string transport_uid { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_mail_transport_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMailTransport : E.SourceBackend {
		[CCode (has_construct_function = false)]
		protected SourceMailTransport ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_memo_list_get_type ()")]
	[Version (since = "3.6")]
	public class SourceMemoList : E.SourceSelectable {
		[CCode (has_construct_function = false)]
		protected SourceMemoList ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_offline_get_type ()")]
	[Version (since = "3.6")]
	public class SourceOffline : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceOffline ();
		public bool get_stay_synchronized ();
		public void set_stay_synchronized (bool stay_synchronized);
		public bool stay_synchronized { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", lower_case_csuffix = "source_openpgp", type_id = "e_source_openpgp_get_type ()")]
	[Version (since = "3.6")]
	public class SourceOpenPGP : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceOpenPGP ();
		public string dup_key_id ();
		public string dup_signing_algorithm ();
		public bool get_always_trust ();
		[Version (since = "3.18")]
		public bool get_encrypt_by_default ();
		public bool get_encrypt_to_self ();
		public unowned string get_key_id ();
		[Version (since = "3.20")]
		public bool get_prefer_inline ();
		public bool get_sign_by_default ();
		public unowned string get_signing_algorithm ();
		public void set_always_trust (bool always_trust);
		[Version (since = "3.18")]
		public void set_encrypt_by_default (bool encrypt_by_default);
		public void set_encrypt_to_self (bool encrypt_to_self);
		public void set_key_id (string key_id);
		[Version (since = "3.20")]
		public void set_prefer_inline (bool prefer_inline);
		public void set_sign_by_default (bool sign_by_default);
		public void set_signing_algorithm (string signing_algorithm);
		public bool always_trust { get; set construct; }
		public bool encrypt_by_default { get; set construct; }
		public bool encrypt_to_self { get; set construct; }
		public string key_id { get; set construct; }
		public bool prefer_inline { get; set construct; }
		public bool sign_by_default { get; set construct; }
		public string signing_algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_proxy_get_type ()")]
	[Version (since = "3.12")]
	public class SourceProxy : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceProxy ();
		public string dup_autoconfig_url ();
		public string dup_ftp_host ();
		public string dup_http_auth_password ();
		public string dup_http_auth_user ();
		public string dup_http_host ();
		public string dup_https_host ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] dup_ignore_hosts ();
		public string dup_socks_host ();
		public unowned string get_autoconfig_url ();
		public unowned string get_ftp_host ();
		public uint16 get_ftp_port ();
		public unowned string get_http_auth_password ();
		public unowned string get_http_auth_user ();
		public unowned string get_http_host ();
		public uint16 get_http_port ();
		public bool get_http_use_auth ();
		public unowned string get_https_host ();
		public uint16 get_https_port ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_ignore_hosts ();
		public E.ProxyMethod get_method ();
		public unowned string get_socks_host ();
		public uint16 get_socks_port ();
		public void set_autoconfig_url (string autoconfig_url);
		public void set_ftp_host (string ftp_host);
		public void set_ftp_port (uint16 ftp_port);
		public void set_http_auth_password (string http_auth_password);
		public void set_http_auth_user (string http_auth_user);
		public void set_http_host (string http_host);
		public void set_http_port (uint16 http_port);
		public void set_http_use_auth (bool http_use_auth);
		public void set_https_host (string https_host);
		public void set_https_port (uint16 https_port);
		public void set_ignore_hosts (string ignore_hosts);
		public void set_method (E.ProxyMethod method);
		public void set_socks_host (string socks_host);
		public void set_socks_port (uint16 socks_port);
		public string autoconfig_url { get; set construct; }
		public string ftp_host { get; set construct; }
		public uint ftp_port { get; set construct; }
		public string http_auth_password { get; set construct; }
		public string http_auth_user { get; set construct; }
		public string http_host { get; set construct; }
		public uint http_port { get; set construct; }
		public bool http_use_auth { get; set construct; }
		public string https_host { get; set construct; }
		public uint https_port { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] ignore_hosts { get; set construct; }
		public E.ProxyMethod method { get; set construct; }
		public string socks_host { get; set construct; }
		public uint socks_port { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_refresh_get_type ()")]
	[Version (since = "3.6")]
	public class SourceRefresh : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceRefresh ();
		public bool get_enabled ();
		public uint get_interval_minutes ();
		public void set_enabled (bool enabled);
		public void set_interval_minutes (uint interval_minutes);
		public bool enabled { get; set construct; }
		public uint interval_minutes { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_registry_get_type ()")]
	[Version (since = "3.6")]
	public class SourceRegistry : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cname = "e_source_registry_new", has_construct_function = false)]
		public async SourceRegistry (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.8")]
		public bool check_enabled (E.Source source);
		public async bool commit_source (E.Source source, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool commit_source_sync (E.Source source, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool create_sources (GLib.List<E.Source> list_of_sources, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool create_sources_sync (GLib.List<E.Source> list_of_sources, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void debug_dump (string? extension_name);
		[Version (since = "3.16")]
		public static bool debug_enabled ();
		[Version (since = "3.8")]
		public string dup_unique_display_name (E.Source source, string? extension_name);
		public E.Source find_extension (E.Source source, string extension_name);
		public static void free_display_tree (GLib.Node display_tree);
		[Version (since = "3.10")]
		public GLib.List<E.Source> list_enabled (string? extension_name);
		public GLib.List<E.Source> list_sources (string? extension_name);
		public E.Source ref_builtin_address_book ();
		public E.Source ref_builtin_calendar ();
		public E.Source ref_builtin_mail_account ();
		public E.Source ref_builtin_memo_list ();
		[Version (since = "3.12")]
		public E.Source ref_builtin_proxy ();
		public E.Source ref_builtin_task_list ();
		public E.Source ref_default_address_book ();
		public E.Source ref_default_calendar ();
		public E.Source ref_default_for_extension_name (string extension_name);
		public E.Source ref_default_mail_account ();
		public E.Source ref_default_mail_identity ();
		public E.Source ref_default_memo_list ();
		public E.Source ref_default_task_list ();
		public E.Source ref_source (string uid);
		public void set_default_address_book (E.Source? default_source);
		public void set_default_calendar (E.Source? default_source);
		public void set_default_for_extension_name (string extension_name, E.Source? default_source);
		public void set_default_mail_account (E.Source? default_source);
		public void set_default_mail_identity (E.Source? default_source);
		public void set_default_memo_list (E.Source? default_source);
		public void set_default_task_list (E.Source? default_source);
		[CCode (has_construct_function = false)]
		public SourceRegistry.sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public E.Source default_address_book { owned get; set; }
		[NoAccessorMethod]
		public E.Source default_calendar { owned get; set; }
		[NoAccessorMethod]
		public E.Source default_mail_account { owned get; set; }
		[NoAccessorMethod]
		public E.Source default_mail_identity { owned get; set; }
		[NoAccessorMethod]
		public E.Source default_memo_list { owned get; set; }
		[NoAccessorMethod]
		public E.Source default_task_list { owned get; set; }
		public virtual signal void credentials_required (E.Source source, E.SourceCredentialsReason reason, string certificate_pem, GLib.TlsCertificateFlags certificate_errors, GLib.Error op_error);
		public virtual signal void source_added (E.Source source);
		public virtual signal void source_changed (E.Source source);
		public virtual signal void source_disabled (E.Source source);
		public virtual signal void source_enabled (E.Source source);
		public virtual signal void source_removed (E.Source source);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_resource_get_type ()")]
	[Version (since = "3.6")]
	public class SourceResource : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceResource ();
		public string dup_identity ();
		public unowned string get_identity ();
		public void set_identity (string? identity);
		public string identity { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_revision_guards_get_type ()")]
	[Version (since = "3.8")]
	public class SourceRevisionGuards : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceRevisionGuards ();
		public bool get_enabled ();
		public void set_enabled (bool enabled);
		public bool enabled { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_smime_get_type ()")]
	[Version (since = "3.6")]
	public class SourceSMIME : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceSMIME ();
		public string dup_encryption_certificate ();
		public string dup_signing_algorithm ();
		public string dup_signing_certificate ();
		public bool get_encrypt_by_default ();
		public bool get_encrypt_to_self ();
		public unowned string get_encryption_certificate ();
		public bool get_sign_by_default ();
		public unowned string get_signing_algorithm ();
		public unowned string get_signing_certificate ();
		public void set_encrypt_by_default (bool encrypt_by_default);
		public void set_encrypt_to_self (bool encrypt_to_self);
		public void set_encryption_certificate (string? encryption_certificate);
		public void set_sign_by_default (bool sign_by_default);
		public void set_signing_algorithm (string? signing_algorithm);
		public void set_signing_certificate (string? signing_certificate);
		public bool encrypt_by_default { get; set construct; }
		public bool encrypt_to_self { get; set construct; }
		public string encryption_certificate { get; set construct; }
		public bool sign_by_default { get; set construct; }
		public string signing_algorithm { get; set construct; }
		public string signing_certificate { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_security_get_type ()")]
	[Version (since = "3.6")]
	public class SourceSecurity : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceSecurity ();
		public string dup_method ();
		public unowned string get_method ();
		public bool get_secure ();
		public void set_method (string? method);
		public void set_secure (bool secure);
		public string method { get; set construct; }
		public bool secure { get; set; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_selectable_get_type ()")]
	[Version (since = "3.6")]
	public abstract class SourceSelectable : E.SourceBackend {
		[CCode (has_construct_function = false)]
		protected SourceSelectable ();
		public string dup_color ();
		public unowned string get_color ();
		public bool get_selected ();
		public void set_color (string? color);
		public void set_selected (bool selected);
		public string color { get; set construct; }
		public bool selected { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_task_list_get_type ()")]
	[Version (since = "3.6")]
	public class SourceTaskList : E.SourceSelectable {
		[CCode (has_construct_function = false)]
		protected SourceTaskList ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_uoa_get_type ()")]
	[Version (since = "3.8")]
	public class SourceUoa : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceUoa ();
		public uint get_account_id ();
		public void set_account_id (uint account_id);
		public uint account_id { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_weather_get_type ()")]
	public class SourceWeather : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceWeather ();
		public string dup_location ();
		public unowned string get_location ();
		public E.SourceWeatherUnits get_units ();
		public void set_location (string location);
		public void set_units (E.SourceWeatherUnits units);
		public string location { get; set construct; }
		public E.SourceWeatherUnits units { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_id = "e_source_webdav_get_type ()")]
	[Version (since = "3.6")]
	public class SourceWebdav : E.SourceExtension {
		[CCode (has_construct_function = false)]
		protected SourceWebdav ();
		public string dup_display_name ();
		public string dup_email_address ();
		public string dup_resource_path ();
		public string dup_resource_query ();
		public Soup.URI dup_soup_uri ();
		[Version (since = "3.8")]
		public string dup_ssl_trust ();
		public bool get_avoid_ifmatch ();
		public bool get_calendar_auto_schedule ();
		public unowned string get_display_name ();
		public unowned string get_email_address ();
		public unowned string get_resource_path ();
		public unowned string get_resource_query ();
		[Version (since = "3.8")]
		public unowned string get_ssl_trust ();
		public void set_avoid_ifmatch (bool avoid_ifmatch);
		public void set_calendar_auto_schedule (bool calendar_auto_schedule);
		public void set_display_name (string? display_name);
		public void set_email_address (string? email_address);
		public void set_resource_path (string? resource_path);
		public void set_resource_query (string? resource_query);
		public void set_soup_uri (Soup.URI soup_uri);
		[Version (since = "3.8")]
		public void set_ssl_trust (string? ssl_trust);
		[Version (since = "3.8")]
		public void unset_temporary_ssl_trust ();
		[Version (since = "3.16")]
		public void update_ssl_trust (string host, GLib.TlsCertificate cert, E.TrustPromptResponse response);
		public E.TrustPromptResponse verify_ssl_trust (string host, GLib.TlsCertificate cert, GLib.TlsCertificateFlags cert_errors);
		public bool avoid_ifmatch { get; set construct; }
		public bool calendar_auto_schedule { get; set construct; }
		public string display_name { get; set construct; }
		public string email_address { get; set construct; }
		public string resource_path { get; set construct; }
		public string resource_query { get; set construct; }
		[NoAccessorMethod]
		public Soup.URI soup_uri { owned get; set; }
		public string ssl_trust { get; set construct; }
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Compact]
	public class XmlHash {
		[CCode (cname = "e_xmlhash_add")]
		public static void xmlhash_add (E.XmlHash hash, string key, string data);
		[CCode (cname = "e_xmlhash_compare")]
		public static E.XmlHashStatus xmlhash_compare (E.XmlHash hash, string key, string compare_data);
		[CCode (cname = "e_xmlhash_destroy")]
		public static void xmlhash_destroy (E.XmlHash hash);
		[CCode (cname = "e_xmlhash_foreach_key")]
		public static void xmlhash_foreach_key (E.XmlHash hash, [CCode (scope = "async")] E.XmlHashFunc func);
		[CCode (cname = "e_xmlhash_foreach_key_remove")]
		public static void xmlhash_foreach_key_remove (E.XmlHash hash, [CCode (scope = "async")] E.XmlHashRemoveFunc func);
		[CCode (cname = "e_xmlhash_new")]
		public static E.XmlHash xmlhash_new (string filename);
		[CCode (cname = "e_xmlhash_remove")]
		public static void xmlhash_remove (E.XmlHash hash, string key);
		[CCode (cname = "e_xmlhash_write")]
		public static void xmlhash_write (E.XmlHash hash);
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", type_cname = "EExtensibleInterface", type_id = "e_extensible_get_type ()")]
	public interface Extensible : GLib.Object {
		[Version (since = "3.4")]
		public GLib.List<weak E.Extension> list_extensions (GLib.Type extension_type);
		[Version (since = "3.4")]
		public void load_extensions ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.2")]
	public struct ClientErrorsList {
		public weak string name;
		public int err_code;
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	public struct FreeFormExpSymbol {
		public weak string names;
		public weak string hint;
		public weak E.FreeFormExpBuildSexpFunc build_sexp;
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_type_id = false)]
	public struct WebDAVDiscoveredSource {
		public weak string href;
		public uint32 supports;
		public weak string display_name;
		public weak string description;
		public weak string color;
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_CLIENT_ERROR_", has_type_id = false)]
	[Version (since = "3.2")]
	public enum ClientError {
		INVALID_ARG,
		BUSY,
		SOURCE_NOT_LOADED,
		SOURCE_ALREADY_LOADED,
		AUTHENTICATION_FAILED,
		AUTHENTICATION_REQUIRED,
		REPOSITORY_OFFLINE,
		OFFLINE_UNAVAILABLE,
		PERMISSION_DENIED,
		CANCELLED,
		COULD_NOT_CANCEL,
		NOT_SUPPORTED,
		TLS_NOT_AVAILABLE,
		UNSUPPORTED_AUTHENTICATION_METHOD,
		SEARCH_SIZE_LIMIT_EXCEEDED,
		SEARCH_TIME_LIMIT_EXCEEDED,
		INVALID_QUERY,
		QUERY_REFUSED,
		DBUS_ERROR,
		OTHER_ERROR,
		NOT_OPENED,
		OUT_OF_SYNC
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_MDN_RESPONSE_POLICY_", type_id = "e_mdn_response_policy_get_type ()")]
	[Version (since = "3.6")]
	public enum MdnResponsePolicy {
		NEVER,
		ALWAYS,
		ASK
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_PROXY_METHOD_", type_id = "e_proxy_method_get_type ()")]
	[Version (since = "3.12")]
	public enum ProxyMethod {
		DEFAULT,
		MANUAL,
		AUTO,
		NONE
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_AUTHENTICATION_", type_id = "e_source_authentication_result_get_type ()")]
	[Version (since = "3.6")]
	public enum SourceAuthenticationResult {
		ERROR,
		ERROR_SSL_FAILED,
		ACCEPTED,
		REJECTED,
		REQUIRED
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_CONNECTION_STATUS_", type_id = "e_source_connection_status_get_type ()")]
	[Version (since = "3.16")]
	public enum SourceConnectionStatus {
		DISCONNECTED,
		AWAITING_CREDENTIALS,
		SSL_FAILED,
		CONNECTING,
		CONNECTED
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_CREDENTIALS_REASON_", type_id = "e_source_credentials_reason_get_type ()")]
	[Version (since = "3.16")]
	public enum SourceCredentialsReason {
		UNKNOWN,
		REQUIRED,
		REJECTED,
		SSL_FAILED,
		ERROR
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_LDAP_AUTHENTICATION_", type_id = "e_source_ldap_authentication_get_type ()")]
	[Version (since = "3.18")]
	public enum SourceLDAPAuthentication {
		NONE,
		EMAIL,
		BINDDN
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_LDAP_SCOPE_", type_id = "e_source_ldap_scope_get_type ()")]
	[Version (since = "3.18")]
	public enum SourceLDAPScope {
		ONELEVEL,
		SUBTREE
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_LDAP_SECURITY_", type_id = "e_source_ldap_security_get_type ()")]
	[Version (since = "3.18")]
	public enum SourceLDAPSecurity {
		NONE,
		LDAPS,
		STARTTLS
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_MAIL_COMPOSITION_REPLY_STYLE_", type_id = "e_source_mail_composition_reply_style_get_type ()")]
	[Version (since = "3.20")]
	public enum SourceMailCompositionReplyStyle {
		DEFAULT,
		QUOTED,
		DO_NOT_QUOTE,
		ATTACH,
		OUTLOOK
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_SOURCE_WEATHER_UNITS_", type_id = "e_source_weather_units_get_type ()")]
	[Version (since = "3.18")]
	public enum SourceWeatherUnits {
		FAHRENHEIT,
		CENTIGRADE,
		KELVIN
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_TIME_PARSE_", has_type_id = false)]
	public enum TimeParseStatus {
		OK,
		NONE,
		INVALID
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_TRUST_PROMPT_RESPONSE_", type_id = "e_trust_prompt_response_get_type ()")]
	[Version (since = "3.8")]
	public enum TrustPromptResponse {
		UNKNOWN,
		REJECT,
		ACCEPT,
		ACCEPT_TEMPORARILY,
		REJECT_TEMPORARILY
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_WEBDAV_DISCOVER_SUPPORTS_", has_type_id = false)]
	[Flags]
	public enum WebDAVDiscoverSupports {
		NONE,
		CONTACTS,
		EVENTS,
		MEMOS,
		TASKS
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_XMLHASH_STATUS_", has_type_id = false)]
	public enum XmlHashStatus {
		SAME,
		DIFFERENT,
		NOT_FOUND
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_XML_HASH_TYPE_", has_type_id = false)]
	public enum XmlHashType {
		OBJECT_UID,
		PROPERTY
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cprefix = "E_COLLATOR_ERROR_")]
	public errordomain CollatorError {
		OPEN,
		CONVERSION,
		INVALID_LOCALE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libedataserver/libedataserver.h", has_target = false)]
	public delegate string FreeFormExpBuildSexpFunc (string word, string options, string hint);
	[CCode (cheader_filename = "libedataserver/libedataserver.h", instance_pos = 1.9)]
	[Version (since = "3.6")]
	public delegate void SourceRefreshFunc (E.Source source);
	[CCode (cheader_filename = "libedataserver/libedataserver.h", instance_pos = 1.9)]
	[Version (since = "3.4")]
	public delegate void TypeFunc (GLib.Type type);
	[CCode (cheader_filename = "libedataserver/libedataserver.h", instance_pos = 2.9)]
	public delegate void XmlHashFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver/libedataserver.h", instance_pos = 2.9)]
	public delegate bool XmlHashRemoveFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_DEBUG_LOG_DOMAIN_CAL_QUERIES")]
	[Version (since = "2.32")]
	public const string DEBUG_LOG_DOMAIN_CAL_QUERIES;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_DEBUG_LOG_DOMAIN_GLOG")]
	[Version (since = "2.32")]
	public const string DEBUG_LOG_DOMAIN_GLOG;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_DEBUG_LOG_DOMAIN_USER")]
	[Version (since = "2.32")]
	public const string DEBUG_LOG_DOMAIN_USER;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_GOOGLE_SECRET_ACCESS_TOKEN")]
	public const string GOOGLE_SECRET_ACCESS_TOKEN;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_GOOGLE_SECRET_EXPIRES_AFTER")]
	public const string GOOGLE_SECRET_EXPIRES_AFTER;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_GOOGLE_SECRET_REFRESH_TOKEN")]
	public const string GOOGLE_SECRET_REFRESH_TOKEN;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_CREDENTIAL_GOOGLE_SECRET")]
	public const string SOURCE_CREDENTIAL_GOOGLE_SECRET;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_CREDENTIAL_PASSWORD")]
	[Version (since = "3.16")]
	public const string SOURCE_CREDENTIAL_PASSWORD;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_CREDENTIAL_SSL_TRUST")]
	[Version (since = "3.16")]
	public const string SOURCE_CREDENTIAL_SSL_TRUST;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_CREDENTIAL_USERNAME")]
	[Version (since = "3.16")]
	public const string SOURCE_CREDENTIAL_USERNAME;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_ADDRESS_BOOK")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_ADDRESS_BOOK;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_ALARMS")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_ALARMS;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_AUTHENTICATION")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_AUTHENTICATION;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_AUTOCOMPLETE")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_AUTOCOMPLETE;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_CALENDAR")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_CALENDAR;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_COLLECTION")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_COLLECTION;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_CONTACTS_BACKEND")]
	public const string SOURCE_EXTENSION_CONTACTS_BACKEND;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_GOA")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_GOA;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_LDAP_BACKEND")]
	public const string SOURCE_EXTENSION_LDAP_BACKEND;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_LOCAL_BACKEND")]
	public const string SOURCE_EXTENSION_LOCAL_BACKEND;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_ACCOUNT")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_ACCOUNT;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_COMPOSITION")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_COMPOSITION;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_IDENTITY")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_IDENTITY;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_SIGNATURE")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_SIGNATURE;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_SUBMISSION")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_SUBMISSION;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MAIL_TRANSPORT")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MAIL_TRANSPORT;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MDN")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MDN;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_MEMO_LIST")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_MEMO_LIST;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_OFFLINE")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_OFFLINE;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_OPENPGP")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_OPENPGP;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_PROXY")]
	[Version (since = "3.12")]
	public const string SOURCE_EXTENSION_PROXY;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_REFRESH")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_REFRESH;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_RESOURCE")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_RESOURCE;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_REVISION_GUARDS")]
	[Version (since = "3.8")]
	public const string SOURCE_EXTENSION_REVISION_GUARDS;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_SECURITY")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_SECURITY;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_SMIME")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_SMIME;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_TASK_LIST")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_TASK_LIST;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_UOA")]
	[Version (since = "3.8")]
	public const string SOURCE_EXTENSION_UOA;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_WEATHER_BACKEND")]
	public const string SOURCE_EXTENSION_WEATHER_BACKEND;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_EXTENSION_WEBDAV_BACKEND")]
	[Version (since = "3.6")]
	public const string SOURCE_EXTENSION_WEBDAV_BACKEND;
	[CCode (cheader_filename = "libedataserver/libedataserver.h", cname = "E_SOURCE_PARAM_SETTING")]
	[Version (since = "3.6")]
	public const int SOURCE_PARAM_SETTING;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property (void* source, string source_property, void* target, string target_property, GLib.BindingFlags flags);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property_full (GLib.Object source, string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.BindingTransformFunc? transform_to, owned GLib.BindingTransformFunc? transform_from);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static unowned GLib.Binding binding_bind_property_with_closures (GLib.Object source, string source_property, GLib.Object target, string target_property, GLib.BindingFlags flags, GLib.Closure transform_to, GLib.Closure transform_from);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static bool binding_transform_enum_nick_to_value (GLib.Binding binding, GLib.Value source_value, GLib.Value target_value, void* not_used);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static bool binding_transform_enum_value_to_nick (GLib.Binding binding, GLib.Value source_value, GLib.Value target_value, void* not_used);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void categories_add (string category, string unused, string icon_file, bool searchable);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static string categories_dup_icon_file_for (string category);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static GLib.List<string> categories_dup_list ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static bool categories_exist (string category);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.16")]
	public static unowned string categories_get_icon_file_for (string category);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.16")]
	public static GLib.List<weak string> categories_get_list ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static bool categories_is_searchable (string category);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.24")]
	public static void categories_register_change_listener ([CCode (scope = "async")] GLib.Callback listener);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void categories_remove (string category);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void categories_set_icon_file_for (string category, string icon_file);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.24")]
	public static void categories_unregister_change_listener ([CCode (scope = "async")] GLib.Callback listener);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.0")]
	public static int data_server_util_get_dbus_call_timeout ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.0")]
	public static void data_server_util_set_dbus_call_timeout (int timeout_msec);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static void debug_log_clear ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static void debug_log_disable_domains (string domains, int n_domains);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static bool debug_log_dump (string filename) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static bool debug_log_dump_to_dated_file () throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static void debug_log_enable_domains (string domains, int n_domains);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static int debug_log_get_max_lines ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static bool debug_log_is_domain_enabled (string domain);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static bool debug_log_load_configuration (string filename) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static void debug_log_set_max_lines (int num_lines);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.8")]
	public static bool enum_from_string (GLib.Type enum_type, string string, int enum_value);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.8")]
	public static unowned string enum_to_string (GLib.Type enum_type, int enum_value);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.6")]
	public static async bool file_recursive_delete (GLib.File file, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.6")]
	public static bool file_recursive_delete_sync (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void filename_make_safe (string string);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static string filename_mkdir_encoded (string basepath, string fileprefix, string filename, int fileindex);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static string free_form_exp_to_sexp (string free_form_exp, E.FreeFormExpSymbol symbols);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static unowned string get_user_cache_dir ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static unowned string get_user_config_dir ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static unowned string get_user_data_dir ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void localtime_with_offset (long tt, [CCode (type = "tm*")] Posix.tm tm, int offset);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void* memchunk_alloc (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void* memchunk_alloc0 (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void memchunk_clean (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void memchunk_destroy (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void memchunk_empty (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void memchunk_free (E.MemChunk memchunk, void* mem);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static long mktime_utc ([CCode (type = "tm*")] Posix.tm tm);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.8")]
	public static void queue_transfer (GLib.Queue src_queue, GLib.Queue dst_queue);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static bool secret_store_delete_sync (string uid, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static bool secret_store_lookup_sync (string uid, out string out_secret, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static bool secret_store_store_sync (string uid, string secret, string label, bool permanently, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static void soup_ssl_trust_connect (Soup.Message soup_message, E.Source source);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static size_t strftime (string string, size_t max, string fmt, [CCode (type = "const tm*")] Posix.tm tm);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void time_format_date_and_time ([CCode (type = "tm*")] Posix.tm date_tm, bool use_24_hour_format, bool show_midnight, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void time_format_time ([CCode (type = "tm*")] Posix.tm date_tm, bool use_24_hour_format, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.22")]
	public static string time_get_d_fmt_with_4digit_year ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static E.TimeParseStatus time_parse_date (string value, [CCode (type = "tm*")] Posix.tm result);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static E.TimeParseStatus time_parse_date_and_time (string value, [CCode (type = "tm*")] Posix.tm result);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.22")]
	public static E.TimeParseStatus time_parse_date_and_time_ex (string value, [CCode (type = "tm*")] Posix.tm result, bool two_digit_year);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.22")]
	public static E.TimeParseStatus time_parse_date_ex (string value, [CCode (type = "tm*")] Posix.tm result, bool two_digit_year);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static E.TimeParseStatus time_parse_time (string value, [CCode (type = "tm*")] Posix.tm result);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.12")]
	public static uint timeout_add_seconds_with_name (int priority, uint interval, string? name, owned GLib.SourceFunc function);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.12")]
	public static uint timeout_add_with_name (int priority, uint interval, string? name, owned GLib.SourceFunc function);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static void type_traverse (GLib.Type parent_type, E.TypeFunc func);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static string uid_new ();
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static size_t utf8_strftime (string string, size_t max, string fmt, [CCode (type = "const tm*")] Posix.tm tm);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.4")]
	public static GLib.SList<GLib.Object> util_copy_object_slist (GLib.SList<GLib.Object>? copy_to, GLib.SList<GLib.Object> objects);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.4")]
	public static GLib.SList<string> util_copy_string_slist (GLib.SList<string>? copy_to, GLib.SList<string> strings);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.0")]
	public static unowned string util_ensure_gdbus_string (string str, string gdbus_str);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.6")]
	public static void util_free_nullable_object_slist (GLib.SList<GLib.Object> objects);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.4")]
	public static void util_free_object_slist (GLib.SList<GLib.Object> objects);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (deprecated = true, deprecated_since = "3.8", since = "3.4")]
	public static void util_free_string_slist (GLib.SList<string> strings);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static string util_get_source_full_name (void* registry, void* source);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static bool util_get_source_oauth2_access_token_sync (void* source, E.NamedParameters credentials, out string out_access_token, out int out_expires_in_seconds, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.32")]
	public static uint64 util_gthread_id (GLib.Thread thread);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.16")]
	public static void util_safe_free_string (string str);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static string[] util_slist_to_strv (GLib.SList<string> strings);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.6")]
	public static string util_strdup_strip (string? string);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static string util_strstrcase (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.12")]
	public static bool util_strv_equal (void* v1, void* v2);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.4")]
	public static GLib.SList<string> util_strv_to_slist (string strv);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static string util_unicode_get_utf8 (string text, unichar @out);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.6")]
	public static string util_utf8_data_make_valid (string data, size_t data_bytes);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.0")]
	public static string util_utf8_make_valid (string str);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.8")]
	public static string util_utf8_normalize (string str);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "2.28")]
	public static string util_utf8_remove_accents (string str);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static int util_utf8_strcasecmp (string s1, string s2);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static unowned string util_utf8_strstrcase (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static unowned string util_utf8_strstrcasedecomp (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.10")]
	public static void weak_ref_free (GLib.WeakRef weak_ref);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static void webdav_discover_free_discovered_sources (GLib.SList<E.WebDAVDiscoveredSource> discovered_sources);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static async bool webdav_discover_sources (E.Source source, string? url_use_path, uint32 only_supports, E.NamedParameters? credentials, GLib.Cancellable? cancellable, out string out_certificate_pem, out GLib.TlsCertificateFlags out_certificate_errors, out GLib.SList<E.WebDAVDiscoveredSource> out_discovered_sources, out GLib.SList<string> out_calendar_user_addresses) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	[Version (since = "3.18")]
	public static bool webdav_discover_sources_sync (E.Source source, string? url_use_path, uint32 only_supports, E.NamedParameters? credentials, out string out_certificate_pem, out GLib.TlsCertificateFlags out_certificate_errors, out GLib.SList<E.WebDAVDiscoveredSource> out_discovered_sources, out GLib.SList<string> out_calendar_user_addresses, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static void xml_destroy_hash (GLib.HashTable<string,string> hash);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static Xml.Doc* xml_from_hash (GLib.HashTable<string,string> hash, E.XmlHashType type, string root_name);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static Xml.Node* xml_get_child_by_name ([CCode (type = "const xmlNode*")] Xml.Node* parent, [CCode (type = "const xmlChar*")] string child_name);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static Xml.Doc* xml_parse_file (string filename);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static int xml_save_file (string filename, [CCode (type = "xmlDocPtr")] Xml.Doc* doc);
	[CCode (cheader_filename = "libedataserver/libedataserver.h")]
	public static GLib.HashTable<string,string> xml_to_hash (Xml.Doc doc, E.XmlHashType type);
}
