/* MediaButton.c generated by valac 0.38.7, the Vala compiler
 * generated from MediaButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "CbMedia.h"
#include <gio/gio.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_MEDIA_BUTTON (media_button_get_type ())
#define MEDIA_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_BUTTON, MediaButton))
#define MEDIA_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_BUTTON, MediaButtonClass))
#define IS_MEDIA_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_BUTTON))
#define IS_MEDIA_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_BUTTON))
#define MEDIA_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_BUTTON, MediaButtonClass))

typedef struct _MediaButton MediaButton;
typedef struct _MediaButtonClass MediaButtonClass;
typedef struct _MediaButtonPrivate MediaButtonPrivate;
enum  {
	MEDIA_BUTTON_0_PROPERTY,
	MEDIA_BUTTON_MEDIA_PROPERTY,
	MEDIA_BUTTON_NUM_PROPERTIES
};
static GParamSpec* media_button_properties[MEDIA_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block52Data Block52Data;
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
enum  {
	MEDIA_BUTTON_CLICKED_SIGNAL,
	MEDIA_BUTTON_NUM_SIGNALS
};
static guint media_button_signals[MEDIA_BUTTON_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MediaButton {
	GtkWidget parent_instance;
	MediaButtonPrivate * priv;
	GtkWindow* window;
};

struct _MediaButtonClass {
	GtkWidgetClass parent_class;
};

struct _MediaButtonPrivate {
	GdkWindow* event_window;
	CbMedia* _media;
	GMenu* menu_model;
	GtkMenu* menu;
	GSimpleActionGroup* actions;
	PangoLayout* layout;
	GtkGestureMultiPress* press_gesture;
	gboolean restrict_height;
	gint64 fade_start_time;
	gdouble media_alpha;
};

struct _Block52Data {
	int _ref_count_;
	MediaButton* self;
	gchar* url;
};


static gpointer media_button_parent_class = NULL;
static cairo_surface_t** media_button_play_icons;
static gint media_button_play_icons_length1;
static cairo_surface_t** media_button_play_icons = NULL;
static gint media_button_play_icons_length1 = 0;
static gint _media_button_play_icons_size_ = 0;

GType media_button_get_type (void) G_GNUC_CONST;
#define MEDIA_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_BUTTON, MediaButtonPrivate))
static void media_button_media_progress_cb (MediaButton* self);
static void _media_button_media_progress_cb_cb_media_progress (CbMedia* _sender, gpointer self);
#define MEDIA_BUTTON_PLAY_ICON_SIZE 32
#define MEDIA_BUTTON_MAX_HEIGHT 200
#define MEDIA_BUTTON_MIN_HEIGHT 40
#define MEDIA_BUTTON_MIN_WIDTH 40
static void media_button_copy_url_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_copy_url_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void media_button_open_in_browser_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_open_in_browser_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void media_button_save_as_activated (MediaButton* self, GSimpleAction* a, GVariant* v);
static void _media_button_save_as_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MediaButton* media_button_new (CbMedia* media, gboolean restrict_height);
MediaButton* media_button_construct (GType object_type, CbMedia* media, gboolean restrict_height);
void media_button_set_media (MediaButton* self, CbMedia* value);
static void media_button_gesture_released_cb (MediaButton* self, gint n_press, gdouble x, gdouble y);
static void _media_button_gesture_released_cb_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
static void media_button_gesture_pressed_cb (MediaButton* self, gint n_press, gdouble x, gdouble y);
static void _media_button_gesture_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
static void media_button_start_fade (MediaButton* self);
static gboolean media_button_fade_in_cb (MediaButton* self, GtkWidget* widget, GdkFrameClock* frame_clock);
#define TRANSITION_DURATION (200 * 1000)
gdouble ease_out_cubic (gdouble t);
CbMedia* media_button_get_media (MediaButton* self);
static gboolean _media_button_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void media_button_get_draw_size (MediaButton* self, gint* width, gint* height, gdouble* scale);
static gboolean media_button_real_draw (GtkWidget* base, cairo_t* ct);
gchar* utils_get_media_display_name (CbMedia* media);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for);
void utils_download_file (const gchar* url, GOutputStream* out_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
static void ____lambda29_ (Block52Data* _data52_);
static void _____lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GtkSizeRequestMode media_button_real_get_request_mode (GtkWidget* base);
static void media_button_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void media_button_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural);
static void media_button_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum, gint* natural);
static void media_button_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void media_button_real_realize (GtkWidget* base);
static void media_button_real_unrealize (GtkWidget* base);
static void media_button_real_map (GtkWidget* base);
static void media_button_real_unmap (GtkWidget* base);
static void media_button_real_size_allocate (GtkWidget* base, GtkAllocation* alloc);
static gboolean media_button_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* evt);
static gboolean media_button_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* evt);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static gboolean media_button_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static void g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * media_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void media_button_finalize (GObject * obj);
static void _vala_media_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_media_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry MEDIA_BUTTON_action_entries[3] = {{"copy-url", _media_button_copy_url_activated_gsimple_action_activate_callback}, {"open-in-browser", _media_button_open_in_browser_activated_gsimple_action_activate_callback}, {"save-as", _media_button_save_as_activated_gsimple_action_activate_callback}};

static void _media_button_media_progress_cb_cb_media_progress (CbMedia* _sender, gpointer self) {
	media_button_media_progress_cb ((MediaButton*) self);
}


static void _media_button_copy_url_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_copy_url_activated ((MediaButton*) self, action, parameter);
}


static void _media_button_open_in_browser_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_open_in_browser_activated ((MediaButton*) self, action, parameter);
}


static void _media_button_save_as_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	media_button_save_as_activated ((MediaButton*) self, action, parameter);
}


static void _media_button_gesture_released_cb_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	media_button_gesture_released_cb ((MediaButton*) self, p0, p1, p2);
}


static void _media_button_gesture_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	media_button_gesture_pressed_cb ((MediaButton*) self, p0, p1, p2);
}


MediaButton* media_button_construct (GType object_type, CbMedia* media, gboolean restrict_height) {
	MediaButton * self = NULL;
	CbMedia* _tmp0_;
	gboolean _tmp1_;
	GtkStyleContext* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GMenu* _tmp8_;
	PangoLayout* _tmp9_;
	GtkGestureMultiPress* _tmp10_;
	GtkGestureMultiPress* _tmp11_;
	GtkGestureMultiPress* _tmp12_;
	GtkGestureMultiPress* _tmp13_;
	GtkGestureMultiPress* _tmp14_;
	GtkGestureMultiPress* _tmp15_;
	g_return_val_if_fail ((media == NULL) || CB_IS_MEDIA (media), NULL);
	self = (MediaButton*) gtk_widget_new (object_type, NULL);
	_tmp0_ = media;
	media_button_set_media (self, _tmp0_);
	_tmp1_ = restrict_height;
	self->priv->restrict_height = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "inline-media");
	_tmp3_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp3_;
	_tmp4_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_action_map_get_type (), GActionMap), MEDIA_BUTTON_action_entries, G_N_ELEMENTS (MEDIA_BUTTON_action_entries), self);
	_tmp5_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "media", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_action_group_get_type (), GActionGroup));
	_tmp6_ = g_menu_new ();
	_g_object_unref0 (self->priv->menu_model);
	self->priv->menu_model = _tmp6_;
	_tmp7_ = self->priv->menu_model;
	g_menu_append (_tmp7_, _ ("Open in Browser"), "media.open-in-browser");
	_tmp8_ = self->priv->menu_model;
	g_menu_append (_tmp8_, _ ("Save as…"), "media.save-as");
	_tmp9_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "0%");
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp9_;
	_tmp10_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->press_gesture);
	self->priv->press_gesture = _tmp10_;
	_tmp11_ = self->priv->press_gesture;
	gtk_gesture_single_set_exclusive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_gesture_single_get_type (), GtkGestureSingle), TRUE);
	_tmp12_ = self->priv->press_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp13_ = self->priv->press_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_CAPTURE);
	_tmp14_ = self->priv->press_gesture;
	g_signal_connect_object (_tmp14_, "released", (GCallback) _media_button_gesture_released_cb_gtk_gesture_multi_press_released, self, 0);
	_tmp15_ = self->priv->press_gesture;
	g_signal_connect_object (_tmp15_, "pressed", (GCallback) _media_button_gesture_pressed_cb_gtk_gesture_multi_press_pressed, self, 0);
	return self;
}


MediaButton* media_button_new (CbMedia* media, gboolean restrict_height) {
	return media_button_construct (TYPE_MEDIA_BUTTON, media, restrict_height);
}


static void media_button_media_progress_cb (MediaButton* self) {
	CbMedia* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->_media;
	_tmp1_ = _tmp0_->loaded;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		CbMedia* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->priv->_media;
		_tmp4_ = _tmp3_->invalid;
		if (!_tmp4_) {
			CbMedia* _tmp5_;
			cairo_surface_t* _tmp6_;
			_tmp5_ = self->priv->_media;
			_tmp6_ = _tmp5_->surface;
			_tmp2_ = _tmp6_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			media_button_start_fade (self);
		} else {
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
		}
		gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static gboolean media_button_fade_in_cb (MediaButton* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint64 now = 0LL;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	gdouble t = 0.0;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	g_return_val_if_fail (IS_MEDIA_BUTTON (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		self->priv->media_alpha = 1.0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp1_ = frame_clock;
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	now = _tmp2_;
	t = 1.0;
	_tmp3_ = now;
	_tmp4_ = self->priv->fade_start_time;
	if (_tmp3_ < (_tmp4_ + TRANSITION_DURATION)) {
		gint64 _tmp5_;
		gint64 _tmp6_;
		_tmp5_ = now;
		_tmp6_ = self->priv->fade_start_time;
		t = (_tmp5_ - _tmp6_) / ((gdouble) TRANSITION_DURATION);
	}
	_tmp7_ = t;
	_tmp8_ = ease_out_cubic (_tmp7_);
	t = _tmp8_;
	_tmp9_ = t;
	self->priv->media_alpha = _tmp9_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = t;
	if (_tmp10_ >= 1.0) {
		self->priv->media_alpha = 1.0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean _media_button_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = media_button_fade_in_cb ((MediaButton*) self, widget, frame_clock);
	return result;
}


static void media_button_start_fade (MediaButton* self) {
	CbMedia* _tmp0_;
	CbMedia* _tmp1_;
	CbMedia* _tmp2_;
	CbMedia* _tmp3_;
	cairo_surface_t* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	GdkFrameClock* _tmp12_;
	gint64 _tmp13_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp0_ = media_button_get_media (self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "this.media != null");
	_tmp2_ = media_button_get_media (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->surface;
	_vala_assert (_tmp4_ != NULL, "this.media.surface != null");
	_tmp7_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp8_;
		_tmp8_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = !_tmp8_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		GtkSettings* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = gtk_settings_get_default ();
		g_object_get (_tmp9_, "gtk-enable-animations", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp5_ = !_tmp11_;
	}
	if (_tmp5_) {
		self->priv->media_alpha = 1.0;
		return;
	}
	_tmp12_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = gdk_frame_clock_get_frame_time (_tmp12_);
	self->priv->fade_start_time = _tmp13_;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _media_button_fade_in_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}


static void media_button_get_draw_size (MediaButton* self, gint* width, gint* height, gdouble* scale) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gdouble _vala_scale = 0.0;
	gboolean _tmp0_ = FALSE;
	CbMedia* _tmp1_;
	gint _tmp2_;
	gint _tmp5_;
	gint _tmp6_;
	gdouble scale_x = 0.0;
	gint _tmp7_;
	CbMedia* _tmp8_;
	gint _tmp9_;
	gdouble scale_y = 0.0;
	gint _tmp10_;
	CbMedia* _tmp11_;
	gint _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	CbMedia* _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_;
	CbMedia* _tmp20_;
	gint _tmp21_;
	gdouble _tmp22_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp1_ = self->priv->_media;
	_tmp2_ = _tmp1_->width;
	if (_tmp2_ == -1) {
		CbMedia* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->_media;
		_tmp4_ = _tmp3_->height;
		_tmp0_ = _tmp4_ == -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_vala_width = 0;
		_vala_height = 0;
		_vala_scale = 0.0;
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		if (scale) {
			*scale = _vala_scale;
		}
		return;
	}
	_tmp5_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_vala_width = _tmp5_;
	_tmp6_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_vala_height = _tmp6_;
	_tmp7_ = _vala_width;
	_tmp8_ = self->priv->_media;
	_tmp9_ = _tmp8_->width;
	scale_x = ((gdouble) _tmp7_) / _tmp9_;
	_tmp10_ = _vala_height;
	_tmp11_ = self->priv->_media;
	_tmp12_ = _tmp11_->height;
	scale_y = ((gdouble) _tmp10_) / _tmp12_;
	_tmp13_ = scale_x;
	_tmp14_ = scale_y;
	_tmp15_ = MIN (_tmp13_, _tmp14_);
	_tmp16_ = MIN (_tmp15_, 1.0);
	_vala_scale = _tmp16_;
	_tmp17_ = self->priv->_media;
	_tmp18_ = _tmp17_->width;
	_tmp19_ = _vala_scale;
	_vala_width = (gint) (_tmp18_ * _tmp19_);
	_tmp20_ = self->priv->_media;
	_tmp21_ = _tmp20_->height;
	_tmp22_ = _vala_scale;
	_vala_height = (gint) (_tmp21_ * _tmp22_);
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	if (scale) {
		*scale = _vala_scale;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean media_button_real_draw (GtkWidget* base, cairo_t* ct) {
	MediaButton * self;
	gboolean result = FALSE;
	gint widget_width = 0;
	gint _tmp0_;
	gint widget_height = 0;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	CbMedia* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp1_;
	_tmp4_ = self->priv->_media;
	if (_tmp4_ != NULL) {
		CbMedia* _tmp5_;
		cairo_surface_t* _tmp6_;
		_tmp5_ = self->priv->_media;
		_tmp6_ = _tmp5_->surface;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		CbMedia* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = self->priv->_media;
		_tmp8_ = _tmp7_->loaded;
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint draw_width = 0;
		gint draw_height = 0;
		gdouble scale = 0.0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gdouble _tmp11_ = 0.0;
		gint draw_x = 0;
		gint _tmp12_;
		gint _tmp13_;
		cairo_t* _tmp14_;
		cairo_t* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		cairo_t* _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		cairo_t* _tmp21_;
		CbMedia* _tmp22_;
		CbMedia* _tmp23_;
		cairo_surface_t* _tmp24_;
		gint _tmp25_;
		gdouble _tmp26_;
		cairo_t* _tmp27_;
		gdouble _tmp28_;
		cairo_t* _tmp29_;
		cairo_t* _tmp30_;
		CbMedia* _tmp31_;
		gboolean _tmp32_;
		GtkStyleContext* sc = NULL;
		GtkStyleContext* _tmp49_;
		GtkStyleContext* _tmp50_;
		GtkStyleContext* _tmp51_;
		cairo_t* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		GtkStyleContext* _tmp56_;
		cairo_t* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gboolean _tmp61_;
		media_button_get_draw_size (self, &_tmp9_, &_tmp10_, &_tmp11_);
		draw_width = _tmp9_;
		draw_height = _tmp10_;
		scale = _tmp11_;
		_tmp12_ = widget_width;
		_tmp13_ = draw_width;
		draw_x = (_tmp12_ / 2) - (_tmp13_ / 2);
		_tmp14_ = ct;
		cairo_save (_tmp14_);
		_tmp15_ = ct;
		_tmp16_ = widget_width;
		_tmp17_ = widget_height;
		cairo_rectangle (_tmp15_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp16_, (gdouble) _tmp17_);
		_tmp18_ = ct;
		_tmp19_ = scale;
		_tmp20_ = scale;
		cairo_scale (_tmp18_, _tmp19_, _tmp20_);
		_tmp21_ = ct;
		_tmp22_ = media_button_get_media (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_->surface;
		_tmp25_ = draw_x;
		_tmp26_ = scale;
		cairo_set_source_surface (_tmp21_, _tmp24_, _tmp25_ / _tmp26_, (gdouble) 0);
		_tmp27_ = ct;
		_tmp28_ = self->priv->media_alpha;
		cairo_paint_with_alpha (_tmp27_, _tmp28_);
		_tmp29_ = ct;
		cairo_restore (_tmp29_);
		_tmp30_ = ct;
		cairo_new_path (_tmp30_);
		_tmp31_ = self->priv->_media;
		_tmp32_ = cb_media_is_video (_tmp31_);
		if (_tmp32_) {
			gint x = 0;
			gint _tmp33_;
			gint y = 0;
			gint _tmp34_;
			cairo_t* _tmp35_;
			cairo_t* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			cairo_t* _tmp39_;
			cairo_surface_t** _tmp40_;
			gint _tmp40__length1;
			gint _tmp41_;
			cairo_surface_t* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			cairo_t* _tmp45_;
			gdouble _tmp46_;
			cairo_t* _tmp47_;
			cairo_t* _tmp48_;
			_tmp33_ = widget_width;
			x = (_tmp33_ / 2) - (MEDIA_BUTTON_PLAY_ICON_SIZE / 2);
			_tmp34_ = widget_height;
			y = (_tmp34_ / 2) - (MEDIA_BUTTON_PLAY_ICON_SIZE / 2);
			_tmp35_ = ct;
			cairo_save (_tmp35_);
			_tmp36_ = ct;
			_tmp37_ = x;
			_tmp38_ = y;
			cairo_rectangle (_tmp36_, (gdouble) _tmp37_, (gdouble) _tmp38_, (gdouble) MEDIA_BUTTON_PLAY_ICON_SIZE, (gdouble) MEDIA_BUTTON_PLAY_ICON_SIZE);
			_tmp39_ = ct;
			_tmp40_ = media_button_play_icons;
			_tmp40__length1 = media_button_play_icons_length1;
			_tmp41_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_tmp42_ = _tmp40_[_tmp41_ - 1];
			_tmp43_ = x;
			_tmp44_ = y;
			cairo_set_source_surface (_tmp39_, _tmp42_, (gdouble) _tmp43_, (gdouble) _tmp44_);
			_tmp45_ = ct;
			_tmp46_ = self->priv->media_alpha;
			cairo_paint_with_alpha (_tmp45_, _tmp46_);
			_tmp47_ = ct;
			cairo_restore (_tmp47_);
			_tmp48_ = ct;
			cairo_new_path (_tmp48_);
		}
		_tmp49_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp50_ = _g_object_ref0 (_tmp49_);
		sc = _tmp50_;
		_tmp51_ = sc;
		_tmp52_ = ct;
		_tmp53_ = draw_x;
		_tmp54_ = draw_width;
		_tmp55_ = draw_height;
		gtk_render_background (_tmp51_, _tmp52_, (gdouble) _tmp53_, (gdouble) 0, (gdouble) _tmp54_, (gdouble) _tmp55_);
		_tmp56_ = sc;
		_tmp57_ = ct;
		_tmp58_ = draw_x;
		_tmp59_ = draw_width;
		_tmp60_ = draw_height;
		gtk_render_frame (_tmp56_, _tmp57_, (gdouble) _tmp58_, (gdouble) 0, (gdouble) _tmp59_, (gdouble) _tmp60_);
		_tmp61_ = gtk_widget_has_visible_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		if (_tmp61_) {
			GtkStyleContext* _tmp62_;
			cairo_t* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			_tmp62_ = sc;
			_tmp63_ = ct;
			_tmp64_ = draw_x;
			_tmp65_ = draw_width;
			_tmp66_ = draw_height;
			gtk_render_focus (_tmp62_, _tmp63_, (gdouble) (_tmp64_ + 2), (gdouble) 2, (gdouble) (_tmp65_ - 4), (gdouble) (_tmp66_ - 4));
		}
		_g_object_unref0 (sc);
	} else {
		GtkStyleContext* sc = NULL;
		GtkStyleContext* _tmp67_;
		GtkStyleContext* _tmp68_;
		gdouble layout_x = 0.0;
		gdouble layout_y = 0.0;
		gint layout_w = 0;
		gint layout_h = 0;
		PangoLayout* _tmp69_;
		CbMedia* _tmp70_;
		gdouble _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		PangoLayout* _tmp74_;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		gint _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		GtkStyleContext* _tmp81_;
		cairo_t* _tmp82_;
		gdouble _tmp83_;
		gdouble _tmp84_;
		PangoLayout* _tmp85_;
		_tmp67_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp68_ = _g_object_ref0 (_tmp67_);
		sc = _tmp68_;
		_tmp69_ = self->priv->layout;
		_tmp70_ = self->priv->_media;
		_tmp71_ = _tmp70_->percent_loaded;
		_tmp72_ = g_strdup_printf ("%d%%", (gint) (_tmp71_ * 100));
		_tmp73_ = _tmp72_;
		pango_layout_set_text (_tmp69_, _tmp73_, -1);
		_g_free0 (_tmp73_);
		_tmp74_ = self->priv->layout;
		pango_layout_get_size (_tmp74_, &_tmp75_, &_tmp76_);
		layout_w = _tmp75_;
		layout_h = _tmp76_;
		_tmp77_ = widget_width;
		_tmp78_ = layout_w;
		layout_x = (_tmp77_ / 2.0) - ((_tmp78_ / PANGO_SCALE) / 2.0);
		_tmp79_ = widget_height;
		_tmp80_ = layout_h;
		layout_y = (_tmp79_ / 2.0) - ((_tmp80_ / PANGO_SCALE) / 2.0);
		_tmp81_ = sc;
		_tmp82_ = ct;
		_tmp83_ = layout_x;
		_tmp84_ = layout_y;
		_tmp85_ = self->priv->layout;
		gtk_render_layout (_tmp81_, _tmp82_, _tmp83_, _tmp84_, _tmp85_);
		_g_object_unref0 (sc);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static void media_button_copy_url_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	GtkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	CbMedia* _tmp3_;
	CbMedia* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_clipboard_get_for_display (_tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = media_button_get_media (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->url;
	gtk_clipboard_set_text (clipboard, _tmp5_, -1);
	_g_object_unref0 (clipboard);
}


static void media_button_open_in_browser_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	{
		const gchar* _tmp0_ = NULL;
		CbMedia* _tmp1_;
		CbMedia* _tmp2_;
		const gchar* _tmp3_;
		GdkScreen* _tmp7_;
		guint32 _tmp8_;
		_tmp1_ = media_button_get_media (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_->target_url;
		_tmp0_ = _tmp3_;
		if (_tmp0_ == NULL) {
			CbMedia* _tmp4_;
			CbMedia* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = media_button_get_media (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_->url;
			_tmp0_ = _tmp6_;
		}
		_tmp7_ = gdk_screen_get_default ();
		_tmp8_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp7_, _tmp0_, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch55_g_error;
		}
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("MediaButton.vala:261: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally55:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block52Data* block52_data_ref (Block52Data* _data52_) {
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}


static void block52_data_unref (void * _userdata_) {
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		MediaButton* self;
		self = _data52_->self;
		_g_free0 (_data52_->url);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}


static void ____lambda29_ (Block52Data* _data52_) {
	MediaButton* self;
	const gchar* _tmp0_;
	self = _data52_->self;
	_tmp0_ = _data52_->url;
	g_debug ("MediaButton.vala:295: Download of %s finished", _tmp0_);
}


static void _____lambda29__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda29_ (self);
	block52_data_unref (self);
}


static void media_button_save_as_activated (MediaButton* self, GSimpleAction* a, GVariant* v) {
	gchar* title = NULL;
	CbMedia* _tmp0_;
	gboolean _tmp1_;
	GtkFileChooserNative* filechooser = NULL;
	const gchar* _tmp4_;
	GtkWindow* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	CbMedia* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkFileChooserNative* _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->priv->_media;
	_tmp1_ = cb_media_is_video (_tmp0_);
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("Save Video"));
		_g_free0 (title);
		title = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Save Image"));
		_g_free0 (title);
		title = _tmp3_;
	}
	_tmp4_ = title;
	_tmp5_ = self->window;
	_tmp6_ = gtk_file_chooser_native_new (_tmp4_, _tmp5_, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Save"), _ ("Cancel"));
	filechooser = _tmp6_;
	_tmp7_ = filechooser;
	_tmp8_ = self->priv->_media;
	_tmp9_ = utils_get_media_display_name (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = filechooser;
	_tmp12_ = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GTK_TYPE_NATIVE_DIALOG, GtkNativeDialog));
	if (_tmp12_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		Block52Data* _data52_;
		GFile* file = NULL;
		GtkFileChooserNative* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		const gchar* _tmp18_ = NULL;
		CbMedia* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		GtkFileChooserNative* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GOutputStream* out_stream = NULL;
		GOutputStream* _tmp37_;
		_data52_ = g_slice_new0 (Block52Data);
		_data52_->_ref_count_ = 1;
		_data52_->self = g_object_ref (self);
		_tmp13_ = filechooser;
		_tmp14_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		_tmp15_ = _tmp14_;
		_tmp16_ = g_file_new_for_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		file = _tmp17_;
		_tmp19_ = self->priv->_media;
		_tmp20_ = _tmp19_->target_url;
		_tmp18_ = _tmp20_;
		if (_tmp18_ == NULL) {
			CbMedia* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = self->priv->_media;
			_tmp22_ = _tmp21_->url;
			_tmp18_ = _tmp22_;
		}
		_tmp23_ = g_strdup (_tmp18_);
		_data52_->url = _tmp23_;
		_tmp24_ = _data52_->url;
		_tmp25_ = filechooser;
		_tmp26_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		_tmp27_ = _tmp26_;
		g_debug ("MediaButton.vala:283: Downloading %s to %s", _tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
		out_stream = NULL;
		{
			GFileOutputStream* _tmp28_ = NULL;
			GFile* _tmp29_;
			GFileOutputStream* _tmp30_;
			GFileOutputStream* _tmp31_;
			_tmp29_ = file;
			_tmp30_ = g_file_create (_tmp29_, 0, NULL, &_inner_error_);
			_tmp28_ = _tmp30_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch56_g_error;
			}
			_tmp31_ = _tmp28_;
			_tmp28_ = NULL;
			_g_object_unref0 (out_stream);
			out_stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_output_stream_get_type (), GOutputStream);
			_g_object_unref0 (_tmp28_);
		}
		goto __finally56;
		__catch56_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			GtkWindow* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			_tmp34_ = self->window;
			utils_show_error_dialog (_tmp33_, _tmp34_);
			_tmp35_ = e;
			_tmp36_ = _tmp35_->message;
			g_warning ("MediaButton.vala:290: %s", _tmp36_);
			_g_error_free0 (e);
		}
		__finally56:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (out_stream);
			_g_object_unref0 (file);
			block52_data_unref (_data52_);
			_data52_ = NULL;
			_g_object_unref0 (filechooser);
			_g_free0 (title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp37_ = out_stream;
		if (_tmp37_ != NULL) {
			const gchar* _tmp38_;
			GOutputStream* _tmp39_;
			_tmp38_ = _data52_->url;
			_tmp39_ = out_stream;
			utils_download_file (_tmp38_, _tmp39_, _____lambda29__gasync_ready_callback, block52_data_ref (_data52_));
		}
		_g_object_unref0 (out_stream);
		_g_object_unref0 (file);
		block52_data_unref (_data52_);
		_data52_ = NULL;
	}
	_g_object_unref0 (filechooser);
	_g_free0 (title);
}


static GtkSizeRequestMode media_button_real_get_request_mode (GtkWidget* base) {
	MediaButton * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void media_button_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MediaButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_height = 0;
	gboolean _tmp0_ = FALSE;
	CbMedia* _tmp1_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp1_ = self->priv->_media;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CbMedia* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->_media;
		_tmp3_ = _tmp2_->height;
		_tmp0_ = _tmp3_ == -1;
	}
	if (_tmp0_) {
		media_height = 1;
	} else {
		CbMedia* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->_media;
		_tmp5_ = _tmp4_->height;
		media_height = _tmp5_;
	}
	_tmp6_ = media_height;
	_tmp7_ = MIN (_tmp6_, MEDIA_BUTTON_MAX_HEIGHT);
	_vala_minimum = _tmp7_;
	_tmp8_ = media_height;
	_vala_natural = _tmp8_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void media_button_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural) {
	MediaButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	gint media_height = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CbMedia* _tmp2_;
	gdouble width_ratio = 0.0;
	gint _tmp11_;
	gint _tmp12_;
	gint height = 0;
	gint _tmp13_;
	gint _tmp14_;
	gdouble _tmp15_;
	gint _tmp16_;
	gboolean _tmp17_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp2_ = self->priv->_media;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		CbMedia* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->_media;
		_tmp4_ = _tmp3_->width;
		_tmp1_ = _tmp4_ == -1;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		CbMedia* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->_media;
		_tmp6_ = _tmp5_->height;
		_tmp0_ = _tmp6_ == -1;
	}
	if (_tmp0_) {
		media_width = MEDIA_BUTTON_MIN_WIDTH;
		media_height = MEDIA_BUTTON_MAX_HEIGHT;
	} else {
		CbMedia* _tmp7_;
		gint _tmp8_;
		CbMedia* _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->_media;
		_tmp8_ = _tmp7_->width;
		media_width = _tmp8_;
		_tmp9_ = self->priv->_media;
		_tmp10_ = _tmp9_->height;
		media_height = _tmp10_;
	}
	_tmp11_ = width;
	_tmp12_ = media_width;
	width_ratio = ((gdouble) _tmp11_) / ((gdouble) _tmp12_);
	_tmp13_ = media_height;
	_tmp14_ = media_height;
	_tmp15_ = width_ratio;
	_tmp16_ = MIN (_tmp13_, (gint) (_tmp14_ * _tmp15_));
	height = _tmp16_;
	_tmp17_ = self->priv->restrict_height;
	if (_tmp17_) {
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = media_height;
		_tmp19_ = MIN (_tmp18_, MEDIA_BUTTON_MAX_HEIGHT);
		_vala_minimum = _tmp19_;
		_tmp20_ = _vala_minimum;
		_vala_natural = _tmp20_;
	} else {
		gint _tmp21_;
		gint _tmp22_;
		_tmp21_ = height;
		_vala_minimum = _tmp21_;
		_tmp22_ = height;
		_vala_natural = _tmp22_;
	}
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void media_button_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum, gint* natural) {
	MediaButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	gint media_height = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CbMedia* _tmp2_;
	gdouble height_ratio = 0.0;
	gint _tmp11_;
	gint _tmp12_;
	gint width = 0;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp2_ = self->priv->_media;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		CbMedia* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->_media;
		_tmp4_ = _tmp3_->width;
		_tmp1_ = _tmp4_ == -1;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		CbMedia* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->_media;
		_tmp6_ = _tmp5_->height;
		_tmp0_ = _tmp6_ == -1;
	}
	if (_tmp0_) {
		media_width = MEDIA_BUTTON_MIN_WIDTH;
		media_height = MEDIA_BUTTON_MAX_HEIGHT;
	} else {
		CbMedia* _tmp7_;
		gint _tmp8_;
		CbMedia* _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->_media;
		_tmp8_ = _tmp7_->width;
		media_width = _tmp8_;
		_tmp9_ = self->priv->_media;
		_tmp10_ = _tmp9_->height;
		media_height = _tmp10_;
	}
	_tmp11_ = height;
	_tmp12_ = media_height;
	height_ratio = ((gdouble) _tmp11_) / ((gdouble) _tmp12_);
	_tmp13_ = media_width;
	_tmp14_ = media_width;
	_tmp15_ = MIN (_tmp13_, (gint) (_tmp14_ * height_ratio));
	width = _tmp15_;
	_tmp16_ = media_width;
	_tmp17_ = MIN (_tmp16_, MEDIA_BUTTON_MIN_WIDTH);
	_vala_minimum = _tmp17_;
	_vala_natural = width;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void media_button_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MediaButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	gboolean _tmp0_ = FALSE;
	CbMedia* _tmp1_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp1_ = self->priv->_media;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CbMedia* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->_media;
		_tmp3_ = _tmp2_->width;
		_tmp0_ = _tmp3_ == -1;
	}
	if (_tmp0_) {
		media_width = 1;
	} else {
		CbMedia* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->_media;
		_tmp5_ = _tmp4_->width;
		media_width = _tmp5_;
	}
	_tmp6_ = media_width;
	_tmp7_ = MIN (_tmp6_, MEDIA_BUTTON_MIN_WIDTH);
	_vala_minimum = _tmp7_;
	_tmp8_ = media_width;
	_vala_natural = _tmp8_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void media_button_real_realize (GtkWidget* base) {
	MediaButton * self;
	gint draw_width = 0;
	gint draw_height = 0;
	gdouble scale = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	GdkWindowAttr attr = {0};
	GdkWindowAttr _tmp3_ = {0};
	GdkVisual* _tmp4_;
	gint _tmp5_;
	GdkWindowAttributesType attr_mask = 0;
	GdkWindow* window = NULL;
	GdkWindow* _tmp6_;
	GdkWindow* _tmp7_;
	GdkWindow* _tmp8_;
	GdkWindowAttr _tmp9_;
	GdkWindow* _tmp10_;
	GdkWindow* _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	gtk_widget_set_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	media_button_get_draw_size (self, &_tmp0_, &_tmp1_, &_tmp2_);
	draw_width = _tmp0_;
	draw_height = _tmp1_;
	scale = _tmp2_;
	attr = _tmp3_;
	attr.x = 0;
	attr.y = 0;
	attr.width = draw_width;
	attr.height = draw_height;
	attr.window_type = GDK_WINDOW_CHILD;
	_tmp4_ = gtk_widget_get_visual (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	attr.visual = _tmp4_;
	attr.wclass = GDK_INPUT_ONLY;
	_tmp5_ = gtk_widget_get_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	attr.event_mask = ((((_tmp5_ | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_TOUCH_MASK) | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK;
	attr_mask = GDK_WA_X | GDK_WA_Y;
	_tmp6_ = gtk_widget_get_parent_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = _g_object_ref0 (_tmp6_);
	window = _tmp7_;
	_tmp8_ = _g_object_ref0 (window);
	gtk_widget_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_);
	g_object_ref (G_TYPE_CHECK_INSTANCE_CAST (window, G_TYPE_OBJECT, GObject));
	_tmp9_ = attr;
	_tmp10_ = gdk_window_new (window, &_tmp9_, attr_mask);
	_g_object_unref0 (self->priv->event_window);
	self->priv->event_window = _tmp10_;
	_tmp11_ = self->priv->event_window;
	gtk_widget_register_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_);
	_g_object_unref0 (window);
}


static void media_button_real_unrealize (GtkWidget* base) {
	MediaButton * self;
	GdkWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp0_ = self->priv->event_window;
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		GdkWindow* _tmp3_;
		_tmp1_ = self->priv->event_window;
		gtk_widget_unregister_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp1_);
		_tmp2_ = self->priv->event_window;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		gdk_window_destroy (_tmp3_);
		_g_object_unref0 (self->priv->event_window);
		self->priv->event_window = NULL;
	}
	GTK_WIDGET_CLASS (media_button_parent_class)->unrealize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void media_button_real_map (GtkWidget* base) {
	MediaButton * self;
	GdkWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	GTK_WIDGET_CLASS (media_button_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->event_window;
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_;
		_tmp1_ = self->priv->event_window;
		gdk_window_show (_tmp1_);
	}
}


static void media_button_real_unmap (GtkWidget* base) {
	MediaButton * self;
	GdkWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp0_ = self->priv->event_window;
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_;
		_tmp1_ = self->priv->event_window;
		gdk_window_hide (_tmp1_);
	}
	GTK_WIDGET_CLASS (media_button_parent_class)->unmap (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void media_button_real_size_allocate (GtkWidget* base, GtkAllocation* alloc) {
	MediaButton * self;
	GtkAllocation _tmp0_;
	gint draw_width = 0;
	gint draw_height = 0;
	gdouble scale = 0.0;
	gboolean _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_if_fail (alloc != NULL);
	_tmp0_ = *alloc;
	GTK_WIDGET_CLASS (media_button_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	_tmp1_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gdouble _tmp4_ = 0.0;
		gint draw_x = 0;
		GtkAllocation _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GdkWindow* _tmp8_;
		GtkAllocation _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GtkAllocation _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		media_button_get_draw_size (self, &_tmp2_, &_tmp3_, &_tmp4_);
		draw_width = _tmp2_;
		draw_height = _tmp3_;
		scale = _tmp4_;
		_tmp5_ = *alloc;
		_tmp6_ = _tmp5_.width;
		_tmp7_ = draw_width;
		draw_x = (_tmp6_ / 2) - (_tmp7_ / 2);
		_tmp8_ = self->priv->event_window;
		_tmp9_ = *alloc;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = draw_x;
		_tmp12_ = *alloc;
		_tmp13_ = _tmp12_.y;
		_tmp14_ = draw_width;
		_tmp15_ = draw_height;
		gdk_window_move_resize (_tmp8_, _tmp10_ + _tmp11_, _tmp13_, _tmp14_, _tmp15_);
	}
}


static gboolean media_button_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* evt) {
	MediaButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventCrossing* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->window;
	_tmp3_ = self->priv->event_window;
	if (_tmp2_ == _tmp3_) {
		GdkEventCrossing* _tmp4_;
		GdkNotifyType _tmp5_;
		_tmp4_ = evt;
		_tmp5_ = _tmp4_->detail;
		_tmp0_ = _tmp5_ != GDK_NOTIFY_INFERIOR;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStateFlags _tmp6_;
		_tmp6_ = gtk_widget_get_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_widget_set_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp6_ | GTK_STATE_FLAG_PRELIGHT, TRUE);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean media_button_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* evt) {
	MediaButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventCrossing* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->window;
	_tmp3_ = self->priv->event_window;
	if (_tmp2_ == _tmp3_) {
		GdkEventCrossing* _tmp4_;
		GdkNotifyType _tmp5_;
		_tmp4_ = evt;
		_tmp5_ = _tmp4_->detail;
		_tmp0_ = _tmp5_ != GDK_NOTIFY_INFERIOR;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStateFlags _tmp6_;
		_tmp6_ = gtk_widget_get_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_widget_set_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp6_ & (~GTK_STATE_FLAG_PRELIGHT), TRUE);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEvent_copy0 (gpointer self) {
	return self ? _vala_GdkEvent_copy (self) : NULL;
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static void _vala_GdkEventSequence_free (GdkEventSequence* self) {
	g_boxed_free (gdk_event_sequence_get_type (), self);
}


static void media_button_gesture_pressed_cb (MediaButton* self, gint n_press, gdouble x, gdouble y) {
	GdkEventSequence* sequence = NULL;
	GtkGestureMultiPress* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEvent* event = NULL;
	GtkGestureMultiPress* _tmp2_;
	GdkEventSequence* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEvent* _tmp5_;
	guint button = 0U;
	GtkGestureMultiPress* _tmp6_;
	guint _tmp7_;
	CbMedia* _tmp8_;
	GdkEvent* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp0_ = self->priv->press_gesture;
	_tmp1_ = gtk_gesture_single_get_current_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle));
	sequence = _tmp1_;
	_tmp2_ = self->priv->press_gesture;
	_tmp3_ = sequence;
	_tmp4_ = gtk_gesture_get_last_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_gesture_get_type (), GtkGesture), _tmp3_);
	_tmp5_ = __vala_GdkEvent_copy0 (_tmp4_);
	event = _tmp5_;
	_tmp6_ = self->priv->press_gesture;
	_tmp7_ = gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_gesture_single_get_type (), GtkGestureSingle));
	button = _tmp7_;
	_tmp8_ = self->priv->_media;
	if (_tmp8_ == NULL) {
		__vala_GdkEvent_free0 (event);
		__vala_GdkEventSequence_free0 (sequence);
		return;
	}
	_tmp9_ = event;
	_tmp10_ = gdk_event_triggers_context_menu (_tmp9_);
	if (_tmp10_) {
		GtkGestureMultiPress* _tmp11_;
		GtkMenu* _tmp12_;
		GtkMenu* _tmp16_;
		GtkMenu* _tmp17_;
		guint _tmp18_;
		guint32 _tmp19_;
		_tmp11_ = self->priv->press_gesture;
		gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
		_tmp12_ = self->priv->menu;
		if (_tmp12_ == NULL) {
			GMenu* _tmp13_;
			GtkMenu* _tmp14_;
			GtkMenu* _tmp15_;
			_tmp13_ = self->priv->menu_model;
			_tmp14_ = (GtkMenu*) gtk_menu_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_model_get_type (), GMenuModel));
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (self->priv->menu);
			self->priv->menu = _tmp14_;
			_tmp15_ = self->priv->menu;
			gtk_menu_attach_to_widget (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL);
		}
		_tmp16_ = self->priv->menu;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = self->priv->menu;
		_tmp18_ = button;
		_tmp19_ = gtk_get_current_event_time ();
		gtk_menu_popup (_tmp17_, NULL, NULL, NULL, NULL, _tmp18_, _tmp19_);
	}
	__vala_GdkEvent_free0 (event);
	__vala_GdkEventSequence_free0 (sequence);
}


static void media_button_gesture_released_cb (MediaButton* self, gint n_press, gdouble x, gdouble y) {
	GdkEventSequence* sequence = NULL;
	GtkGestureMultiPress* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEvent* event = NULL;
	GtkGestureMultiPress* _tmp2_;
	GdkEventSequence* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEvent* _tmp5_;
	guint button = 0U;
	GtkGestureMultiPress* _tmp6_;
	guint _tmp7_;
	gboolean _tmp8_ = FALSE;
	CbMedia* _tmp9_;
	guint _tmp11_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp0_ = self->priv->press_gesture;
	_tmp1_ = gtk_gesture_single_get_current_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle));
	sequence = _tmp1_;
	_tmp2_ = self->priv->press_gesture;
	_tmp3_ = sequence;
	_tmp4_ = gtk_gesture_get_last_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_gesture_get_type (), GtkGesture), _tmp3_);
	_tmp5_ = __vala_GdkEvent_copy0 (_tmp4_);
	event = _tmp5_;
	_tmp6_ = self->priv->press_gesture;
	_tmp7_ = gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_gesture_single_get_type (), GtkGestureSingle));
	button = _tmp7_;
	_tmp9_ = self->priv->_media;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GdkEvent* _tmp10_;
		_tmp10_ = event;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		__vala_GdkEvent_free0 (event);
		__vala_GdkEventSequence_free0 (sequence);
		return;
	}
	_tmp11_ = button;
	if (_tmp11_ == ((guint) GDK_BUTTON_PRIMARY)) {
		GtkGestureMultiPress* _tmp12_;
		gdouble px = 0.0;
		gdouble _tmp13_;
		gint _tmp14_;
		gdouble py = 0.0;
		gdouble _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		_tmp12_ = self->priv->press_gesture;
		gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
		_tmp13_ = x;
		_tmp14_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		px = _tmp13_ / ((gdouble) _tmp14_);
		_tmp15_ = y;
		_tmp16_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		py = _tmp15_ / ((gdouble) _tmp16_);
		_tmp17_ = px;
		_tmp18_ = py;
		g_signal_emit (self, media_button_signals[MEDIA_BUTTON_CLICKED_SIGNAL], 0, self, _tmp17_, _tmp18_);
	}
	__vala_GdkEvent_free0 (event);
	__vala_GdkEventSequence_free0 (sequence);
}


static gboolean media_button_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MediaButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_BUTTON, MediaButton);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Return)) {
		_tmp0_ = TRUE;
	} else {
		GdkEventKey* _tmp3_;
		guint _tmp4_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->keyval;
		_tmp0_ = _tmp4_ == ((guint) GDK_KEY_KP_Enter);
	}
	if (_tmp0_) {
		g_signal_emit (self, media_button_signals[MEDIA_BUTTON_CLICKED_SIGNAL], 0, self, 0.5, 0.5);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


CbMedia* media_button_get_media (MediaButton* self) {
	CbMedia* result;
	CbMedia* _tmp0_;
	g_return_val_if_fail (IS_MEDIA_BUTTON (self), NULL);
	_tmp0_ = self->priv->_media;
	result = _tmp0_;
	return result;
}


void media_button_set_media (MediaButton* self, CbMedia* value) {
	CbMedia* _tmp0_;
	CbMedia* _tmp3_;
	CbMedia* _tmp4_;
	CbMedia* _tmp5_;
	gboolean _tmp16_ = FALSE;
	CbMedia* _tmp17_;
	g_return_if_fail (IS_MEDIA_BUTTON (self));
	_tmp0_ = self->priv->_media;
	if (_tmp0_ != NULL) {
		CbMedia* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_media;
		g_signal_parse_name ("progress", CB_TYPE_MEDIA, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_button_media_progress_cb_cb_media_progress, self);
	}
	_tmp3_ = value;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_media);
	self->priv->_media = _tmp4_;
	_tmp5_ = value;
	if (_tmp5_ != NULL) {
		CbMedia* _tmp6_;
		CbMedia* _tmp7_;
		gboolean _tmp8_;
		gboolean is_m3u8 = FALSE;
		CbMedia* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
		GSimpleActionGroup* _tmp13_;
		GAction* _tmp14_;
		gboolean _tmp15_;
		_tmp6_ = media_button_get_media (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->loaded;
		if (!_tmp8_) {
			CbMedia* _tmp9_;
			_tmp9_ = self->priv->_media;
			g_signal_connect_object (_tmp9_, "progress", (GCallback) _media_button_media_progress_cb_cb_media_progress, self, 0);
		} else {
			self->priv->media_alpha = 1.0;
		}
		_tmp10_ = self->priv->_media;
		_tmp11_ = _tmp10_->url;
		_tmp12_ = g_str_has_suffix (_tmp11_, ".m3u8");
		is_m3u8 = _tmp12_;
		_tmp13_ = self->priv->actions;
		_tmp14_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_action_map_get_type (), GActionMap), "save-as");
		_tmp15_ = is_m3u8;
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_simple_action_get_type (), GSimpleAction), !_tmp15_);
	}
	_tmp17_ = value;
	if (_tmp17_ != NULL) {
		gboolean _tmp18_ = FALSE;
		CbMedia* _tmp19_;
		CbMediaType _tmp20_;
		_tmp19_ = value;
		_tmp20_ = _tmp19_->type;
		if (_tmp20_ == CB_MEDIA_TYPE_IMAGE) {
			_tmp18_ = TRUE;
		} else {
			CbMedia* _tmp21_;
			CbMediaType _tmp22_;
			_tmp21_ = value;
			_tmp22_ = _tmp21_->type;
			_tmp18_ = _tmp22_ == CB_MEDIA_TYPE_GIF;
		}
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GMenu* _tmp23_;
		_tmp23_ = self->priv->menu_model;
		g_menu_append (_tmp23_, _ ("Copy URL"), "media.copy-url");
	}
	g_object_notify_by_pspec ((GObject *) self, media_button_properties[MEDIA_BUTTON_MEDIA_PROPERTY]);
}


static void g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE) (gpointer data1, gpointer arg_1, gdouble arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_double (param_values + 2), g_value_get_double (param_values + 3), data2);
}


static GObject * media_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MediaButton * self;
	parent_class = G_OBJECT_CLASS (media_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_BUTTON, MediaButton);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	return obj;
}


static void media_button_class_init (MediaButtonClass * klass) {
	GError * _inner_error_ = NULL;
	media_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaButtonPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) media_button_real_draw;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) media_button_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget *, gint*, gint*)) media_button_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) media_button_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget *, gint, gint*, gint*)) media_button_real_get_preferred_width_for_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) media_button_real_get_preferred_width;
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget *)) media_button_real_realize;
	((GtkWidgetClass *) klass)->unrealize = (void (*) (GtkWidget *)) media_button_real_unrealize;
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget *)) media_button_real_map;
	((GtkWidgetClass *) klass)->unmap = (void (*) (GtkWidget *)) media_button_real_unmap;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) media_button_real_size_allocate;
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget *, GdkEventCrossing*)) media_button_real_enter_notify_event;
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget *, GdkEventCrossing*)) media_button_real_leave_notify_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) media_button_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_media_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_media_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = media_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = media_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_BUTTON_MEDIA_PROPERTY, media_button_properties[MEDIA_BUTTON_MEDIA_PROPERTY] = g_param_spec_object ("media", "media", "media", CB_TYPE_MEDIA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	media_button_signals[MEDIA_BUTTON_CLICKED_SIGNAL] = g_signal_new ("clicked", TYPE_MEDIA_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE, G_TYPE_NONE, 3, TYPE_MEDIA_BUTTON, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		cairo_surface_t** _tmp6_;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/play.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch57_g_error;
		}
		_tmp3_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/play@2.png", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch57_g_error;
		}
		_tmp4_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp2_, 2, NULL);
		_tmp6_ = g_new0 (cairo_surface_t*, 2 + 1);
		_tmp6_[0] = _tmp4_;
		_tmp6_[1] = _tmp5_;
		media_button_play_icons = (_vala_array_free (media_button_play_icons, media_button_play_icons_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		media_button_play_icons = _tmp6_;
		media_button_play_icons_length1 = 2;
		_media_button_play_icons_size_ = media_button_play_icons_length1;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MediaButton.vala:79: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally57:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void media_button_instance_init (MediaButton * self) {
	self->priv = MEDIA_BUTTON_GET_PRIVATE (self);
	self->priv->event_window = NULL;
	self->priv->_media = NULL;
	self->priv->menu = NULL;
	self->priv->restrict_height = FALSE;
	self->priv->media_alpha = 0.0;
}


static void media_button_finalize (GObject * obj) {
	MediaButton * self;
	CbMedia* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_BUTTON, MediaButton);
	_tmp0_ = self->priv->_media;
	if (_tmp0_ != NULL) {
		CbMedia* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_media;
		g_signal_parse_name ("progress", CB_TYPE_MEDIA, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _media_button_media_progress_cb_cb_media_progress, self);
	}
	_g_object_unref0 (self->priv->event_window);
	_g_object_unref0 (self->priv->_media);
	_g_object_unref0 (self->priv->menu_model);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->press_gesture);
	G_OBJECT_CLASS (media_button_parent_class)->finalize (obj);
}


GType media_button_get_type (void) {
	static volatile gsize media_button_type_id__volatile = 0;
	if (g_once_init_enter (&media_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaButton), 0, (GInstanceInitFunc) media_button_instance_init, NULL };
		GType media_button_type_id;
		media_button_type_id = g_type_register_static (gtk_widget_get_type (), "MediaButton", &g_define_type_info, 0);
		g_once_init_leave (&media_button_type_id__volatile, media_button_type_id);
	}
	return media_button_type_id__volatile;
}


static void _vala_media_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MediaButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_BUTTON, MediaButton);
	switch (property_id) {
		case MEDIA_BUTTON_MEDIA_PROPERTY:
		g_value_set_object (value, media_button_get_media (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_media_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MediaButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_BUTTON, MediaButton);
	switch (property_id) {
		case MEDIA_BUTTON_MEDIA_PROPERTY:
		media_button_set_media (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



