/* Account.c generated by valac 0.36.4, the Vala compiler
 * generated from Account.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <cairo.h>
#include "CbMessageReceiver.h"
#include <sqlite3.h>
#include <gio/gio.h>
#include "CbTypes.h"
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include "CbTextTransform.h"
#include <glib/gstdio.h>
#include <libsoup/soup.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "CbTweet.h"


#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_USER_EVENT_RECEIVER (user_event_receiver_get_type ())
#define USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiver))
#define USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))
#define IS_USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_EVENT_RECEIVER))
#define IS_USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_EVENT_RECEIVER))
#define USER_EVENT_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))

typedef struct _UserEventReceiver UserEventReceiver;
typedef struct _UserEventReceiverClass UserEventReceiverClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _Block3Data Block3Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _AccountQueryUserInfoByScreenNameData AccountQueryUserInfoByScreenNameData;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block4Data Block4Data;
typedef struct _AccountInitInformationData AccountInitInformationData;
typedef struct _AccountLoadIdArrayData AccountLoadIdArrayData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _AccountUpdateAvatarData AccountUpdateAvatarData;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
enum  {
	ACCOUNT_INFO_CHANGED_SIGNAL,
	ACCOUNT_LAST_SIGNAL
};
static guint account_signals[ACCOUNT_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _AccountPrivate {
	cairo_surface_t* _avatar_small;
	cairo_surface_t* _avatar;
	UserEventReceiver* event_receiver;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block3Data {
	int _ref_count_;
	Account* self;
	CbTextEntity* urls;
	gint urls_length1;
	gint _urls_size_;
	gpointer _async_data_;
};

struct _AccountQueryUserInfoByScreenNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* self;
	gchar* screen_name;
	Block3Data* _data3_;
	OAuthProxy* _tmp0_;
	RestProxyCall* call;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	const gchar* _tmp5_;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	JsonNode* root_node;
	JsonNode* _tmp15_;
	RestProxyCall* _tmp16_;
	JsonNode* _tmp17_;
	JsonNode* _tmp18_;
	GError* e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	gboolean values_changed;
	JsonObject* root;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	gint64 _tmp25_;
	const gchar* _tmp26_;
	JsonObject* _tmp27_;
	const gchar* _tmp28_;
	JsonObject* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	JsonObject* _tmp33_;
	const gchar* _tmp34_;
	gchar* old_screen_name;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	JsonObject* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	JsonArray* desc_urls;
	JsonObject* _tmp42_;
	JsonObject* _tmp43_;
	JsonObject* _tmp44_;
	JsonArray* _tmp45_;
	JsonArray* _tmp46_;
	JsonArray* _tmp47_;
	guint _tmp48_;
	CbTextEntity* _tmp49_;
	JsonArray* _tmp50_;
	JsonObject* _tmp51_;
	const gchar* _tmp52_;
	CbTextEntity* _tmp53_;
	gint _tmp53__length1;
	gchar* _tmp54_;
	JsonObject* _tmp55_;
	gboolean _tmp56_;
	JsonObject* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	JsonObject* _tmp60_;
	JsonObject* _tmp61_;
	gboolean _tmp62_;
	JsonObject* _tmp63_;
	JsonObject* _tmp64_;
	JsonObject* _tmp65_;
	JsonArray* _tmp66_;
	JsonObject* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* avatar_url;
	JsonObject* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gboolean _tmp74_;
	const gchar* _tmp75_;
	gboolean _tmp76_;
	gboolean _tmp77_;
	SqlDatabase* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	cairo_surface_t* _tmp81_;
	cairo_surface_t* _tmp82_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	Account* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _AccountInitInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* self;
	Block4Data* _data4_;
	Collect* _tmp0_;
};

struct _AccountLoadIdArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* self;
	Collect* collect_obj;
	gchar* function;
	gboolean direct;
	JsonArray* result;
	RestProxyCall* call;
	OAuthProxy* _tmp0_;
	RestProxyCall* _tmp1_;
	RestProxyCall* _tmp2_;
	const gchar* _tmp3_;
	RestProxyCall* _tmp4_;
	JsonNode* root;
	JsonNode* _tmp5_;
	RestProxyCall* _tmp6_;
	JsonNode* _tmp7_;
	JsonNode* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	Collect* _tmp11_;
	gboolean _tmp12_;
	JsonNode* _tmp13_;
	JsonArray* _tmp14_;
	JsonArray* _tmp15_;
	JsonNode* _tmp16_;
	JsonObject* _tmp17_;
	JsonArray* _tmp18_;
	JsonArray* _tmp19_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	Account* self;
	gchar* dest_path;
	gchar* big_dest;
	gchar* url;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	SoupMessage* msg;
};

struct _AccountUpdateAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Account* self;
	gchar* url;
	gboolean result;
	Block5Data* _data5_;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	Block6Data* _data6_;
	const gchar* _tmp31_;
	SoupMessage* _tmp32_;
	SoupSession* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessage* _tmp35_;
};


static gpointer account_parent_class = NULL;
static GPtrArray* account_accounts;
static GPtrArray* account_accounts = NULL;
extern gboolean STRESSTEST;
extern SoupSession* SOUP_SESSION;
extern SqlDatabase* corebird_db;

GType account_get_type (void) G_GNUC_CONST;
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType user_event_receiver_get_type (void) G_GNUC_CONST;
#define ACCOUNT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT, AccountPrivate))
enum  {
	ACCOUNT_DUMMY_PROPERTY,
	ACCOUNT_AVATAR_SMALL,
	ACCOUNT_AVATAR
};
#define ACCOUNT_DUMMY "screen_name"
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
static void _g_object_unref0_ (gpointer var);
UserEventReceiver* user_event_receiver_new (Account* account);
UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account);
NotificationManager* notification_manager_new (Account* account);
NotificationManager* notification_manager_construct (GType object_type, Account* account);
void account_init_database (Account* self);
gchar* dirs_config (const gchar* path);
#define SQL_ACCOUNTS_INIT_FILE "/org/baedert/corebird/sql/accounts/Create.%d.sql"
#define SQL_ACCOUNTS_SQL_VERSION 3
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version);
static void account_load_filters (Account* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean ___lambda9_ (Account* self, gchar** vals, int vals_length1);
static gboolean ____lambda9__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void account_uninit (Account* self);
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
void account_load_avatar (Account* self);
cairo_surface_t* load_surface (const gchar* path);
void account_set_avatar_small (Account* self, cairo_surface_t* value);
void account_set_avatar (Account* self, cairo_surface_t* value);
cairo_surface_t* account_get_avatar (Account* self);
cairo_surface_t* account_get_avatar_small (Account* self);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
void write_surface (cairo_surface_t* surface, const gchar* path);
static void account_query_user_info_by_screen_name_data_free (gpointer _data);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static gboolean account_query_user_info_by_screen_name_co (AccountQueryUserInfoByScreenNameData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length);
static void block3_data_unref (void * _userdata_);
static void account_query_user_info_by_screen_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
static void __lambda11_ (Block3Data* _data3_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda11__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void account_update_avatar (Account* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean account_update_avatar_finish (Account* self, GAsyncResult* _res_);
void account_save_info (Account* self);
static void account_init_information_data_free (gpointer _data);
void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_init_information_finish (Account* self, GAsyncResult* _res_);
static gboolean account_init_information_co (AccountInitInformationData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda10_ (Block4Data* _data4_);
static void ___lambda10__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static void __lambda13_ (Block4Data* _data4_);
void collect_emit (Collect* self, GError* _error_);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_load_id_array (Account* self, Collect* collect_obj, const gchar* function, gboolean direct, GAsyncReadyCallback _callback_, gpointer _user_data_);
static JsonArray* account_load_id_array_finish (Account* self, GAsyncResult* _res_);
static void __lambda14_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
void account_set_disabled_rts (Account* self, JsonArray* disabled_rts_array);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
void account_set_blocked (Account* self, JsonArray* blocked_array);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda16_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
void account_set_muted (Account* self, JsonArray* muted_array);
static void ___lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_load_id_array_data_free (gpointer _data);
static gboolean account_load_id_array_co (AccountLoadIdArrayData* _data_);
static void account_load_id_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void account_update_avatar_data_free (gpointer _data);
static gboolean account_update_avatar_co (AccountUpdateAvatarData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda12_ (Block6Data* _data6_, SoupSession* _s, SoupMessage* _msg);
static guint8* _vala_array_dup1 (guint8* self, int length);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void ____lambda12__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
static gboolean __lambda8_ (Account* self, gchar** cols, int cols_length1);
static gboolean ___lambda8__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void account_add_filter (Account* self, CbFilter* f);
gboolean account_filter_matches (Account* self, CbTweet* t);
void account_set_friends (Account* self, JsonArray* friends_array);
gboolean account_follows_id (Account* self, gint64 user_id);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
static gint64* _vala_array_dup2 (gint64* self, int length);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
static gint64* _vala_array_dup3 (gint64* self, int length);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
static gint64* _vala_array_dup4 (gint64* self, int length);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
static gint64* _vala_array_dup5 (gint64* self, int length);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
gboolean account_is_blocked (Account* self, gint64 user_id);
gboolean account_is_muted (Account* self, gint64 user_id);
Account* account_get_nth (guint index);
static void account_lookup_accounts (void);
guint account_get_n (void);
static gboolean __lambda137_ (gchar** vals, int vals_length1);
static gboolean ___lambda137__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void account_add_account (Account* acc);
void account_remove_account (const gchar* screen_name);
Account* account_query_account (const gchar* screen_name);
Account* account_query_account_by_id (gint64 id);
static void g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void account_finalize (GObject * obj);
static void _vala_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name) {
	Account * self = NULL;
	gint64 _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GPtrArray* _tmp5_;
	UserEventReceiver* _tmp6_;
	NotificationManager* _tmp7_;
	g_return_val_if_fail (screen_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (Account*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	self->id = _tmp0_;
	_tmp1_ = screen_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->screen_name);
	self->screen_name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->name);
	self->name = _tmp4_;
	_tmp5_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->filters);
	self->filters = _tmp5_;
	_tmp6_ = user_event_receiver_new (self);
	_g_object_unref0 (self->priv->event_receiver);
	self->priv->event_receiver = _tmp6_;
	_tmp7_ = notification_manager_new (self);
	_g_object_unref0 (self->notifications);
	self->notifications = _tmp7_;
	return self;
}


Account* account_new (gint64 id, const gchar* screen_name, const gchar* name) {
	return account_construct (TYPE_ACCOUNT, id, screen_name, name);
}


/**
   * Initializes the database. All account databases are VersionedDatabases
   * and are stored in accounts/ID.db.
   *
   */
void account_init_database (Account* self) {
	SqlDatabase* _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SqlDatabase* _tmp8_;
	CbUserCounter* _tmp9_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->db;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("accounts/", _tmp3_, ".db", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = dirs_config (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = sql_database_new (_tmp7_, SQL_ACCOUNTS_INIT_FILE, SQL_ACCOUNTS_SQL_VERSION);
	_g_object_unref0 (self->db);
	self->db = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp9_ = cb_user_counter_new ();
	_g_object_unref0 (self->user_counter);
	self->user_counter = _tmp9_;
	account_load_filters (self);
}


/**
   * Initializes the RestProxy object.
   *
   * @param load_secrets If set to true, the token and token_secret will be loaded
   *                     from the account's database.
   * @param force        If set to true, we will simply force to create a new
   *                     RestProxy object.
   */
static gboolean ___lambda9_ (Account* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	OAuthProxy* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	OAuthProxy* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	CbUserStream* _tmp6_;
	OAuthProxy* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	OAuthProxy* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	_tmp0_ = self->proxy;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[0];
	oauth_proxy_set_token (_tmp0_, _tmp2_);
	_tmp3_ = self->proxy;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	oauth_proxy_set_token_secret (_tmp3_, _tmp5_);
	_tmp6_ = self->user_stream;
	_tmp7_ = self->proxy;
	_tmp8_ = oauth_proxy_get_token (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->proxy;
	_tmp11_ = oauth_proxy_get_token_secret (_tmp10_);
	_tmp12_ = _tmp11_;
	cb_user_stream_set_proxy_data (_tmp6_, _tmp9_, _tmp12_);
	result = FALSE;
	return result;
}


static gboolean ____lambda9__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = ___lambda9_ ((Account*) self, vals, vals_length1);
	return result;
}


void account_init_proxy (Account* self, gboolean load_secrets, gboolean force) {
	gboolean _tmp0_ = FALSE;
	OAuthProxy* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	OAuthProxy* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	CbUserStream* _tmp10_;
	CbUserStream* _tmp11_;
	UserEventReceiver* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->proxy;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = force;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = settings_get_consumer_key ();
	_tmp4_ = _tmp3_;
	_tmp5_ = settings_get_consumer_secret ();
	_tmp6_ = _tmp5_;
	_tmp7_ = (OAuthProxy*) oauth_proxy_new (_tmp4_, _tmp6_, "https://api.twitter.com/", FALSE);
	_g_object_unref0 (self->proxy);
	self->proxy = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp8_ = self->screen_name;
	_tmp9_ = STRESSTEST;
	_tmp10_ = cb_user_stream_new (_tmp8_, _tmp9_);
	_g_object_unref0 (self->user_stream);
	self->user_stream = _tmp10_;
	_tmp11_ = self->user_stream;
	_tmp12_ = self->priv->event_receiver;
	cb_user_stream_register (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, CB_TYPE_MESSAGE_RECEIVER, CbMessageReceiver));
	_tmp13_ = load_secrets;
	if (_tmp13_) {
		gint n_rows = 0;
		SqlDatabase* _tmp14_;
		SqlSelectStatement* _tmp15_;
		SqlSelectStatement* _tmp16_;
		SqlSelectStatement* _tmp17_;
		SqlSelectStatement* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		account_init_database (self);
		_tmp14_ = self->db;
		_tmp15_ = sql_database_select (_tmp14_, "common");
		_tmp16_ = _tmp15_;
		_tmp17_ = sql_select_statement_cols (_tmp16_, "token", "token_secret", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = sql_select_statement_run (_tmp18_, ____lambda9__sql_select_callback, self);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		n_rows = _tmp20_;
		_tmp21_ = n_rows;
		if (_tmp21_ < 1) {
			const gchar* _tmp22_;
			_tmp22_ = self->screen_name;
			g_critical ("Account.vala:97: Could not load token{_secret} for user %s", _tmp22_);
		}
	}
}


void account_uninit (Account* self) {
	CbUserCounter* _tmp0_;
	SqlDatabase* _tmp1_;
	sqlite3* _tmp2_;
	CbUserStream* _tmp3_;
	UserEventReceiver* _tmp4_;
	CbUserStream* _tmp5_;
	g_return_if_fail (IS_ACCOUNT (self));
	_g_object_unref0 (self->proxy);
	self->proxy = NULL;
	_tmp0_ = self->user_counter;
	_tmp1_ = self->db;
	_tmp2_ = sql_database_get_sqlite_db (_tmp1_);
	cb_user_counter_save (_tmp0_, _tmp2_);
	_tmp3_ = self->user_stream;
	_tmp4_ = self->priv->event_receiver;
	cb_user_stream_unregister (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CB_TYPE_MESSAGE_RECEIVER, CbMessageReceiver));
	_tmp5_ = self->user_stream;
	cb_user_stream_stop (_tmp5_);
	_g_object_unref0 (self->user_stream);
	self->user_stream = NULL;
}


/**
   * Loads the small and normally sized avatars from disk.
   * Normal: accounts/ID.png
   * Small:  accounts/ID_small.png
   */
void account_load_avatar (Account* self) {
	gchar* small_path = NULL;
	gint64 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* path = NULL;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	cairo_surface_t* _tmp20_;
	cairo_surface_t* _tmp21_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("accounts/", _tmp2_, "_small.png", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = dirs_config (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	small_path = _tmp6_;
	_tmp7_ = self->id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("accounts/", _tmp9_, ".png", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = dirs_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	path = _tmp13_;
	_tmp14_ = load_surface (small_path);
	_tmp15_ = _tmp14_;
	account_set_avatar_small (self, _tmp15_);
	_cairo_surface_destroy0 (_tmp15_);
	_tmp16_ = load_surface (path);
	_tmp17_ = _tmp16_;
	account_set_avatar (self, _tmp17_);
	_cairo_surface_destroy0 (_tmp17_);
	_tmp18_ = self->screen_name;
	_tmp19_ = self->name;
	_tmp20_ = self->priv->_avatar;
	_tmp21_ = self->priv->_avatar_small;
	g_signal_emit (self, account_signals[ACCOUNT_INFO_CHANGED_SIGNAL], 0, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
	_g_free0 (path);
	_g_free0 (small_path);
}


void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar) {
	gchar* path = NULL;
	gint64 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* small_path = NULL;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	cairo_surface_t* avatar = NULL;
	cairo_surface_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* avatar_small = NULL;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (new_avatar != NULL);
	_tmp0_ = self->id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("accounts/", _tmp2_, ".png", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = dirs_config (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	path = _tmp6_;
	_tmp7_ = self->id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("accounts/", _tmp9_, "_small.png", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = dirs_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	small_path = _tmp13_;
	_tmp14_ = new_avatar;
	_tmp15_ = scale_surface ((cairo_surface_t*) _tmp14_, 48, 48);
	avatar = _tmp15_;
	_tmp16_ = new_avatar;
	_tmp17_ = scale_surface ((cairo_surface_t*) _tmp16_, 24, 24);
	avatar_small = _tmp17_;
	write_surface (avatar, path);
	write_surface (avatar_small, small_path);
	account_set_avatar (self, avatar);
	account_set_avatar_small (self, avatar_small);
	_cairo_surface_destroy0 (avatar_small);
	_cairo_surface_destroy0 (avatar);
	_g_free0 (small_path);
	_g_free0 (path);
}


static void account_query_user_info_by_screen_name_data_free (gpointer _data) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->screen_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountQueryUserInfoByScreenNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	Account* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (AccountQueryUserInfoByScreenNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_query_user_info_by_screen_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = screen_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->screen_name);
	_data_->screen_name = _tmp2_;
	account_query_user_info_by_screen_name_co (_data_);
}


void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


/**
   * Download the appropriate user info from the Twitter server,
   * updating the local information stored in this class' local variables
   * and the information stored in the account's database file.
   *
   * @param screen_name The screen name to use for the API call or null in
   *                    which case the ID will be used.
   */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Account* self;
		self = _data3_->self;
		_data3_->urls = (_vala_CbTextEntity_array_free (_data3_->urls, _data3_->urls_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void account_query_user_info_by_screen_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	account_query_user_info_by_screen_name_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda11_ (Block3Data* _data3_, JsonArray* arr, guint index, JsonNode* node) {
	Account* self;
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonArray* indices = NULL;
	JsonArray* _tmp3_;
	JsonArray* _tmp4_;
	CbTextEntity* _tmp5_;
	gint _tmp5__length1;
	guint _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	CbTextEntity _tmp11_ = {0};
	CbTextEntity _tmp12_;
	self = _data3_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = json_object_get_array_member (obj, "indices");
	_tmp4_ = _json_array_ref0 (_tmp3_);
	indices = _tmp4_;
	_tmp5_ = _data3_->urls;
	_tmp5__length1 = _data3_->urls_length1;
	_tmp6_ = index;
	_tmp7_ = json_array_get_int_element (indices, (guint) 0);
	_tmp8_ = json_array_get_int_element (indices, (guint) 1);
	_tmp9_ = json_object_get_string_member (obj, "expanded_url");
	_tmp10_ = g_strdup (_tmp9_);
	memset (&_tmp11_, 0, sizeof (CbTextEntity));
	_tmp11_.from = (guint) _tmp7_;
	_tmp11_.to = (guint) _tmp8_;
	_g_free0 (_tmp11_.display_text);
	_tmp11_.display_text = _tmp10_;
	_g_free0 (_tmp11_.target);
	_tmp11_.target = NULL;
	cb_text_entity_free (&_tmp5_[_tmp6_]);
	_tmp5_[_tmp6_] = _tmp11_;
	_tmp12_ = _tmp5_[_tmp6_];
	_json_array_unref0 (indices);
	_json_object_unref0 (obj);
}


static void ___lambda11__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda11_ (self, array, index_, element_node);
}


static gboolean account_query_user_info_by_screen_name_co (AccountQueryUserInfoByScreenNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->proxy;
	if (_data_->_tmp0_ == NULL) {
		g_error ("Account.vala:149: Proxy not initialized");
	}
	_data_->_tmp1_ = _data_->self->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/users/show.json");
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = _data_->screen_name;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->call;
		_data_->_tmp7_ = _data_->screen_name;
		rest_proxy_call_add_param (_data_->_tmp6_, "screen_name", _data_->_tmp7_);
		_data_->_tmp8_ = _data_->screen_name;
		_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
		_g_free0 (_data_->self->screen_name);
		_data_->self->screen_name = _data_->_tmp9_;
	} else {
		_data_->_tmp10_ = _data_->call;
		_data_->_tmp11_ = _data_->self->id;
		_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		rest_proxy_call_add_param (_data_->_tmp10_, "user_id", _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
	}
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "skip_status", "true");
	_data_->root_node = NULL;
	{
		_data_->_tmp16_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp16_, NULL, account_query_user_info_by_screen_name_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp17_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp15_ = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp18_ = _data_->_tmp15_;
		_data_->_tmp15_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp18_;
		__vala_JsonNode_free0 (_data_->_tmp15_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("Account.vala:166: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->values_changed = FALSE;
	_data_->_tmp21_ = _data_->root_node;
	_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
	_data_->_tmp23_ = _json_object_ref0 (_data_->_tmp22_);
	_data_->root = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->root;
	_data_->_tmp25_ = json_object_get_int_member (_data_->_tmp24_, "id");
	_data_->self->id = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->self->name;
	_data_->_tmp27_ = _data_->root;
	_data_->_tmp28_ = json_object_get_string_member (_data_->_tmp27_, "name");
	if (g_strcmp0 (_data_->_tmp26_, _data_->_tmp28_) != 0) {
		_data_->_tmp29_ = _data_->root;
		_data_->_tmp30_ = json_object_get_string_member (_data_->_tmp29_, "name");
		_data_->_tmp31_ = g_strdup (_data_->_tmp30_);
		_g_free0 (_data_->self->name);
		_data_->self->name = _data_->_tmp31_;
		_data_->values_changed = TRUE;
	}
	_data_->_tmp32_ = _data_->self->screen_name;
	_data_->_tmp33_ = _data_->root;
	_data_->_tmp34_ = json_object_get_string_member (_data_->_tmp33_, "screen_name");
	if (g_strcmp0 (_data_->_tmp32_, _data_->_tmp34_) != 0) {
		_data_->_tmp35_ = _data_->self->screen_name;
		_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
		_data_->old_screen_name = _data_->_tmp36_;
		_data_->_tmp37_ = _data_->root;
		_data_->_tmp38_ = json_object_get_string_member (_data_->_tmp37_, "screen_name");
		_data_->_tmp39_ = g_strdup (_data_->_tmp38_);
		_g_free0 (_data_->self->screen_name);
		_data_->self->screen_name = _data_->_tmp39_;
		_data_->_tmp40_ = _data_->old_screen_name;
		_data_->_tmp41_ = _data_->self->screen_name;
		utils_update_startup_account (_data_->_tmp40_, _data_->_tmp41_);
		_data_->values_changed = TRUE;
		_g_free0 (_data_->old_screen_name);
	}
	_data_->_tmp42_ = _data_->root;
	_data_->_tmp43_ = json_object_get_object_member (_data_->_tmp42_, "entities");
	_data_->_tmp44_ = json_object_get_object_member (_data_->_tmp43_, "description");
	_data_->_tmp45_ = json_object_get_array_member (_data_->_tmp44_, "urls");
	_data_->_tmp46_ = _json_array_ref0 (_data_->_tmp45_);
	_data_->desc_urls = _data_->_tmp46_;
	_data_->_tmp47_ = _data_->desc_urls;
	_data_->_tmp48_ = json_array_get_length (_data_->_tmp47_);
	_data_->_tmp49_ = g_new0 (CbTextEntity, _data_->_tmp48_);
	_data_->_data3_->urls = _data_->_tmp49_;
	_data_->_data3_->urls_length1 = _data_->_tmp48_;
	_data_->_data3_->_urls_size_ = _data_->_data3_->urls_length1;
	_data_->_tmp50_ = _data_->desc_urls;
	json_array_foreach_element (_data_->_tmp50_, ___lambda11__json_array_foreach, _data_->_data3_);
	_data_->_tmp51_ = _data_->root;
	_data_->_tmp52_ = json_object_get_string_member (_data_->_tmp51_, "description");
	_data_->_tmp53_ = _data_->_data3_->urls;
	_data_->_tmp53__length1 = _data_->_data3_->urls_length1;
	_data_->_tmp54_ = cb_text_transform_text (_data_->_tmp52_, _data_->_tmp53_, _data_->_tmp53__length1, (guint) CB_TEXT_TRANSFORM_EXPAND_LINKS, (gsize) 0, (gint64) 0, (guint) 0);
	_g_free0 (_data_->self->description);
	_data_->self->description = _data_->_tmp54_;
	_data_->_tmp55_ = _data_->root;
	_data_->_tmp56_ = json_object_has_member (_data_->_tmp55_, "profile_banner_url");
	if (_data_->_tmp56_) {
		_data_->_tmp57_ = _data_->root;
		_data_->_tmp58_ = json_object_get_string_member (_data_->_tmp57_, "profile_banner_url");
		_data_->_tmp59_ = g_strdup (_data_->_tmp58_);
		_g_free0 (_data_->self->banner_url);
		_data_->self->banner_url = _data_->_tmp59_;
	}
	_data_->_tmp60_ = _data_->root;
	_data_->_tmp61_ = json_object_get_object_member (_data_->_tmp60_, "entities");
	_data_->_tmp62_ = json_object_has_member (_data_->_tmp61_, "url");
	if (_data_->_tmp62_) {
		_data_->_tmp63_ = _data_->root;
		_data_->_tmp64_ = json_object_get_object_member (_data_->_tmp63_, "entities");
		_data_->_tmp65_ = json_object_get_object_member (_data_->_tmp64_, "url");
		_data_->_tmp66_ = json_object_get_array_member (_data_->_tmp65_, "urls");
		_data_->_tmp67_ = json_array_get_object_element (_data_->_tmp66_, (guint) 0);
		_data_->_tmp68_ = json_object_get_string_member (_data_->_tmp67_, "expanded_url");
		_data_->_tmp69_ = g_strdup (_data_->_tmp68_);
		_g_free0 (_data_->self->website);
		_data_->self->website = _data_->_tmp69_;
	} else {
		_data_->_tmp70_ = g_strdup ("");
		_g_free0 (_data_->self->website);
		_data_->self->website = _data_->_tmp70_;
	}
	_data_->_tmp71_ = _data_->root;
	_data_->_tmp72_ = json_object_get_string_member (_data_->_tmp71_, "profile_image_url");
	_data_->_tmp73_ = g_strdup (_data_->_tmp72_);
	_data_->avatar_url = _data_->_tmp73_;
	_data_->_tmp74_ = _data_->values_changed;
	_data_->_tmp75_ = _data_->avatar_url;
	_data_->_state_ = 2;
	account_update_avatar (_data_->self, _data_->_tmp75_, account_query_user_info_by_screen_name_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp76_ = account_update_avatar_finish (_data_->self, _data_->_res_);
	_data_->values_changed = _data_->_tmp74_ | _data_->_tmp76_;
	_data_->_tmp77_ = _data_->values_changed;
	if (_data_->_tmp77_) {
		_data_->_tmp78_ = _data_->self->db;
		if (_data_->_tmp78_ != NULL) {
			account_save_info (_data_->self);
		}
		_data_->_tmp79_ = _data_->self->screen_name;
		_data_->_tmp80_ = _data_->self->name;
		_data_->_tmp81_ = _data_->self->priv->_avatar_small;
		_data_->_tmp82_ = _data_->self->priv->_avatar;
		g_signal_emit (_data_->self, account_signals[ACCOUNT_INFO_CHANGED_SIGNAL], 0, _data_->_tmp79_, _data_->_tmp80_, _data_->_tmp81_, _data_->_tmp82_);
	}
	_g_free0 (_data_->avatar_url);
	_json_array_unref0 (_data_->desc_urls);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_init_information_data_free (gpointer _data) {
	AccountInitInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountInitInformationData, _data_);
}


void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountInitInformationData* _data_;
	Account* _tmp0_;
	_data_ = g_slice_new0 (AccountInitInformationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_init_information_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	account_init_information_co (_data_);
}


void account_init_information_finish (Account* self, GAsyncResult* _res_) {
	AccountInitInformationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Account* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda10_ (Block4Data* _data4_) {
	Account* self;
	self = _data4_->self;
	account_init_information_co (_data4_->_async_data_);
}


static void ___lambda10__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda10_ (self);
}


static void __lambda13_ (Block4Data* _data4_) {
	Account* self;
	self = _data4_->self;
	collect_emit (_data4_->collect_obj, NULL);
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda13_ (self);
	block4_data_unref (self);
}


static void __lambda14_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	self = _data4_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_;
		_tmp3_ = arr;
		account_set_disabled_rts (self, _tmp3_);
		collect_emit (_data4_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda14_ (self, source_object, res);
	block4_data_unref (self);
}


static void __lambda15_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	self = _data4_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_;
		_tmp3_ = arr;
		account_set_blocked (self, _tmp3_);
		collect_emit (_data4_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda15_ (self, source_object, res);
	block4_data_unref (self);
}


static void __lambda16_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	self = _data4_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_;
		_tmp3_ = arr;
		account_set_muted (self, _tmp3_);
		collect_emit (_data4_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda16__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda16_ (self, source_object, res);
	block4_data_unref (self);
}


static gboolean account_init_information_co (AccountInitInformationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = collect_new (4);
	_data_->_data4_->collect_obj = _data_->_tmp0_;
	g_signal_connect_data (_data_->_data4_->collect_obj, "finished", (GCallback) ___lambda10__collect_finished, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
	account_query_user_info_by_screen_name (_data_->self, NULL, ___lambda13__gasync_ready_callback, block4_data_ref (_data_->_data4_));
	account_load_id_array (_data_->self, _data_->_data4_->collect_obj, "1.1/friendships/no_retweets/ids.json", TRUE, ___lambda14__gasync_ready_callback, block4_data_ref (_data_->_data4_));
	account_load_id_array (_data_->self, _data_->_data4_->collect_obj, "1.1/blocks/ids.json", FALSE, ___lambda15__gasync_ready_callback, block4_data_ref (_data_->_data4_));
	account_load_id_array (_data_->self, _data_->_data4_->collect_obj, "1.1/mutes/users/ids.json", FALSE, ___lambda16__gasync_ready_callback, block4_data_ref (_data_->_data4_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_load_id_array_data_free (gpointer _data) {
	AccountLoadIdArrayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->collect_obj);
	_g_free0 (_data_->function);
	_json_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountLoadIdArrayData, _data_);
}


static void account_load_id_array (Account* self, Collect* collect_obj, const gchar* function, gboolean direct, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountLoadIdArrayData* _data_;
	Account* _tmp0_;
	Collect* _tmp1_;
	Collect* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (AccountLoadIdArrayData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_load_id_array_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = collect_obj;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->collect_obj);
	_data_->collect_obj = _tmp2_;
	_tmp3_ = function;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->function);
	_data_->function = _tmp4_;
	_tmp5_ = direct;
	_data_->direct = _tmp5_;
	account_load_id_array_co (_data_);
}


static JsonArray* account_load_id_array_finish (Account* self, GAsyncResult* _res_) {
	JsonArray* result;
	AccountLoadIdArrayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void account_load_id_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AccountLoadIdArrayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	account_load_id_array_co (_data_);
}


static gboolean account_load_id_array_co (AccountLoadIdArrayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->proxy;
	_data_->_tmp1_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->call;
	_data_->_tmp3_ = _data_->function;
	rest_proxy_call_set_function (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->root = NULL;
	{
		_data_->_tmp6_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp6_, NULL, account_load_id_array_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp8_;
		__vala_JsonNode_free0 (_data_->_tmp5_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("Account.vala:275: %s", _data_->_tmp10_);
		_data_->_tmp11_ = _data_->collect_obj;
		collect_emit (_data_->_tmp11_, NULL);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->direct;
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = _data_->root;
		_data_->_tmp14_ = json_node_get_array (_data_->_tmp13_);
		_data_->_tmp15_ = _json_array_ref0 (_data_->_tmp14_);
		_data_->result = _data_->_tmp15_;
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp16_ = _data_->root;
		_data_->_tmp17_ = json_node_get_object (_data_->_tmp16_);
		_data_->_tmp18_ = json_object_get_array_member (_data_->_tmp17_, "ids");
		_data_->_tmp19_ = _json_array_ref0 (_data_->_tmp18_);
		_data_->result = _data_->_tmp19_;
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
}


static void account_update_avatar_data_free (gpointer _data) {
	AccountUpdateAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountUpdateAvatarData, _data_);
}


static void account_update_avatar (Account* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountUpdateAvatarData* _data_;
	Account* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (AccountUpdateAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_update_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = url;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->url);
	_data_->url = _tmp2_;
	account_update_avatar_co (_data_);
}


static gboolean account_update_avatar_finish (Account* self, GAsyncResult* _res_) {
	gboolean result;
	AccountUpdateAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}


/**
   * Updates the account's avatar picture.
   * This means that the new avatar will be downloaded if necessary and
   * scaled appropriately.
   *
   * @param url The url of the (possibly) new avatar(optional).
   */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Account* self;
		self = _data5_->self;
		_g_free0 (_data5_->big_dest);
		_g_free0 (_data5_->dest_path);
		_g_free0 (_data5_->url);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Account* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->msg);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void ___lambda12_ (Block6Data* _data6_, SoupSession* _s, SoupMessage* _msg) {
	Block5Data* _data5_;
	Account* self;
	GMemoryInputStream* data_stream = NULL;
	SoupMessage* _tmp0_;
	SoupMessageBody* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GDestroyNotify _tmp4_;
	GMemoryInputStream* _tmp5_;
	gchar* type = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	SqlDatabase* _tmp42_;
	SqlUpdateStatement* _tmp43_;
	SqlUpdateStatement* _tmp44_;
	const gchar* _tmp45_;
	SqlUpdateStatement* _tmp46_;
	SqlUpdateStatement* _tmp47_;
	gint64 _tmp48_;
	SqlUpdateStatement* _tmp49_;
	SqlUpdateStatement* _tmp50_;
	GError * _inner_error_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data6_->msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = _tmp1_->data;
	_tmp2__length1 = (gint) _tmp1_->length;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = g_free;
	_tmp5_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, _tmp4_);
	data_stream = _tmp5_;
	_tmp6_ = _data5_->url;
	_tmp7_ = cb_utils_get_file_type (_tmp6_);
	type = _tmp7_;
	{
		GdkPixbuf* _tmp8_ = NULL;
		GMemoryInputStream* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GMemoryInputStream* _tmp15_;
		gdouble scale_x = 0.0;
		GdkPixbuf* _tmp16_;
		gint _tmp17_;
		gdouble scale_y = 0.0;
		GdkPixbuf* _tmp18_;
		gint _tmp19_;
		GdkPixbuf* scaled_pixbuf = NULL;
		GdkPixbuf* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		GdkPixbuf* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		GdkPixbuf* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GdkPixbuf* _tmp32_;
		cairo_surface_t* _tmp33_;
		cairo_surface_t* _tmp34_;
		GdkPixbuf* _tmp35_;
		cairo_surface_t* _tmp36_;
		cairo_surface_t* _tmp37_;
		_tmp9_ = data_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp11_;
		_tmp12_ = pixbuf;
		_tmp13_ = _data5_->big_dest;
		_tmp14_ = type;
		gdk_pixbuf_save (_tmp12_, _tmp13_, _tmp14_, &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			goto __catch4_g_error;
		}
		_tmp15_ = data_stream;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			goto __catch4_g_error;
		}
		_tmp16_ = pixbuf;
		_tmp17_ = gdk_pixbuf_get_width (_tmp16_);
		scale_x = 24.0 / _tmp17_;
		_tmp18_ = pixbuf;
		_tmp19_ = gdk_pixbuf_get_height (_tmp18_);
		scale_y = 24.0 / _tmp19_;
		_tmp20_ = pixbuf;
		_tmp21_ = gdk_pixbuf_get_has_alpha (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, _tmp22_, 8, 24, 24);
		scaled_pixbuf = _tmp23_;
		_tmp24_ = pixbuf;
		_tmp25_ = scaled_pixbuf;
		_tmp26_ = scale_x;
		_tmp27_ = scale_y;
		gdk_pixbuf_scale (_tmp24_, _tmp25_, 0, 0, 24, 24, (gdouble) 0, (gdouble) 0, _tmp26_, _tmp27_, GDK_INTERP_HYPER);
		_tmp28_ = scaled_pixbuf;
		_tmp29_ = _data5_->dest_path;
		_tmp30_ = type;
		gdk_pixbuf_save (_tmp28_, _tmp29_, _tmp30_, &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (scaled_pixbuf);
			_g_object_unref0 (_tmp8_);
			goto __catch4_g_error;
		}
		_tmp31_ = _data5_->dest_path;
		g_debug ("Account.vala:323: saving to %s", _tmp31_);
		_tmp32_ = scaled_pixbuf;
		_tmp33_ = gdk_cairo_surface_create_from_pixbuf (_tmp32_, 1, NULL);
		_tmp34_ = _tmp33_;
		account_set_avatar_small (self, _tmp34_);
		_cairo_surface_destroy0 (_tmp34_);
		_tmp35_ = pixbuf;
		_tmp36_ = gdk_cairo_surface_create_from_pixbuf (_tmp35_, 1, NULL);
		_tmp37_ = _tmp36_;
		account_set_avatar (self, _tmp37_);
		_cairo_surface_destroy0 (_tmp37_);
		_g_object_unref0 (scaled_pixbuf);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_critical ("Account.vala:327: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pixbuf);
		_g_free0 (type);
		_g_object_unref0 (data_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp40_ = _data5_->url;
	_tmp41_ = g_strdup (_tmp40_);
	_g_free0 (self->avatar_url);
	self->avatar_url = _tmp41_;
	_tmp42_ = corebird_db;
	_tmp43_ = sql_database_update (_tmp42_, "accounts");
	_tmp44_ = _tmp43_;
	_tmp45_ = _data5_->url;
	_tmp46_ = sql_update_statement_val (_tmp44_, "avatar_url", _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = self->id;
	_tmp49_ = sql_update_statement_where_eqi (_tmp47_, "id", _tmp48_);
	_tmp50_ = _tmp49_;
	sql_update_statement_run (_tmp50_);
	_g_object_unref0 (_tmp50_);
	_g_object_unref0 (_tmp47_);
	_g_object_unref0 (_tmp44_);
	account_update_avatar_co (_data5_->_async_data_);
	_g_object_unref0 (pixbuf);
	_g_free0 (type);
	_g_object_unref0 (data_stream);
}


static void ____lambda12__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	___lambda12_ (self, session, msg);
	block6_data_unref (self);
}


static gboolean account_update_avatar_co (AccountUpdateAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->url;
	_g_free0 (_data_->_data5_->url);
	_data_->_data5_->url = _data_->_tmp0_;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->id;
	_data_->_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_strconcat ("accounts/", _data_->_tmp3_, "_small.png", NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = dirs_config (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_data_->_data5_->dest_path = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->self->id;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strconcat ("accounts/", _data_->_tmp10_, ".png", NULL);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = dirs_config (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_data5_->big_dest = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->_data5_->url;
	_data_->_tmp17_ = strlen (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	if (_data_->_tmp18_ > 0) {
		_data_->_tmp19_ = _data_->_data5_->url;
		_data_->_tmp20_ = _data_->self->avatar_url;
		_data_->_tmp15_ = g_strcmp0 (_data_->_tmp19_, _data_->_tmp20_) == 0;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp22_ = _data_->_data5_->dest_path;
		_data_->_tmp23_ = g_file_test (_data_->_tmp22_, G_FILE_TEST_EXISTS);
		if (_data_->_tmp23_) {
			_data_->_tmp24_ = _data_->_data5_->big_dest;
			_data_->_tmp25_ = g_file_test (_data_->_tmp24_, G_FILE_TEST_EXISTS);
			_data_->_tmp21_ = _data_->_tmp25_;
		} else {
			_data_->_tmp21_ = FALSE;
		}
		if (_data_->_tmp21_) {
			_data_->result = FALSE;
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (g_task_get_completed (_data_->_async_result) != TRUE) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp26_ = _data_->_data5_->url;
	_data_->_tmp27_ = _data_->self->avatar_url;
	g_debug ("Account.vala:305: Using %s to update the avatar(old: %s)", _data_->_tmp26_, _data_->_tmp27_);
	_data_->_tmp28_ = _data_->_data5_->url;
	_data_->_tmp29_ = strlen (_data_->_tmp28_);
	_data_->_tmp30_ = _data_->_tmp29_;
	if (_data_->_tmp30_ > 0) {
		_data_->_data6_ = g_slice_new0 (Block6Data);
		_data_->_data6_->_ref_count_ = 1;
		_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
		_data_->_tmp31_ = _data_->_data5_->url;
		_data_->_tmp32_ = soup_message_new ("GET", _data_->_tmp31_);
		_data_->_data6_->msg = _data_->_tmp32_;
		_data_->_tmp33_ = SOUP_SESSION;
		_data_->_tmp34_ = _data_->_data6_->msg;
		_data_->_tmp35_ = _g_object_ref0 (_data_->_tmp34_);
		soup_session_queue_message (_data_->_tmp33_, _data_->_tmp35_, ____lambda12__soup_session_callback, block6_data_ref (_data_->_data6_));
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->result = TRUE;
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("Account.vala:336: Not implemented yet");
	}
	_data_->result = FALSE;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Saves the account info both in the account's database and in the
   * global one.
   */
void account_save_info (Account* self) {
	SqlDatabase* _tmp0_;
	SqlInsertStatement* _tmp1_;
	SqlInsertStatement* _tmp2_;
	gint64 _tmp3_;
	SqlInsertStatement* _tmp4_;
	SqlInsertStatement* _tmp5_;
	const gchar* _tmp6_;
	SqlInsertStatement* _tmp7_;
	SqlInsertStatement* _tmp8_;
	const gchar* _tmp9_;
	SqlInsertStatement* _tmp10_;
	SqlInsertStatement* _tmp11_;
	SqlDatabase* _tmp12_;
	SqlInsertStatement* _tmp13_;
	SqlInsertStatement* _tmp14_;
	gint64 _tmp15_;
	SqlInsertStatement* _tmp16_;
	SqlInsertStatement* _tmp17_;
	const gchar* _tmp18_;
	SqlInsertStatement* _tmp19_;
	SqlInsertStatement* _tmp20_;
	const gchar* _tmp21_;
	SqlInsertStatement* _tmp22_;
	SqlInsertStatement* _tmp23_;
	const gchar* _tmp24_;
	SqlInsertStatement* _tmp25_;
	SqlInsertStatement* _tmp26_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->db;
	_tmp1_ = sql_database_replace (_tmp0_, "info");
	_tmp2_ = _tmp1_;
	_tmp3_ = self->id;
	_tmp4_ = sql_insert_statement_vali64 (_tmp2_, "id", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->screen_name;
	_tmp7_ = sql_insert_statement_val (_tmp5_, "screen_name", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->name;
	_tmp10_ = sql_insert_statement_val (_tmp8_, "name", _tmp9_);
	_tmp11_ = _tmp10_;
	sql_insert_statement_run (_tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	_tmp12_ = corebird_db;
	_tmp13_ = sql_database_replace (_tmp12_, "accounts");
	_tmp14_ = _tmp13_;
	_tmp15_ = self->id;
	_tmp16_ = sql_insert_statement_vali64 (_tmp14_, "id", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->screen_name;
	_tmp19_ = sql_insert_statement_val (_tmp17_, "screen_name", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->name;
	_tmp22_ = sql_insert_statement_val (_tmp20_, "name", _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->avatar_url;
	_tmp25_ = sql_insert_statement_val (_tmp23_, "avatar_url", _tmp24_);
	_tmp26_ = _tmp25_;
	sql_insert_statement_run (_tmp26_);
	_g_object_unref0 (_tmp26_);
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp14_);
}


/**
   * Load all the filters from the database.
   */
static gboolean __lambda8_ (Account* self, gchar** cols, int cols_length1) {
	gboolean result = FALSE;
	CbFilter* f = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	CbFilter* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gint _tmp5_;
	GPtrArray* _tmp6_;
	CbFilter* _tmp7_;
	_tmp0_ = cols;
	_tmp0__length1 = cols_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = cb_filter_new (_tmp1_);
	f = _tmp2_;
	_tmp3_ = cols;
	_tmp3__length1 = cols_length1;
	_tmp4_ = _tmp3_[1];
	_tmp5_ = atoi (_tmp4_);
	cb_filter_set_id (f, _tmp5_);
	_tmp6_ = self->filters;
	_tmp7_ = _g_object_ref0 (f);
	g_ptr_array_add (_tmp6_, _tmp7_);
	result = TRUE;
	_g_object_unref0 (f);
	return result;
}


static gboolean ___lambda8__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda8_ ((Account*) self, vals, vals_length1);
	return result;
}


static void account_load_filters (Account* self) {
	SqlDatabase* _tmp0_;
	SqlSelectStatement* _tmp1_;
	SqlSelectStatement* _tmp2_;
	SqlSelectStatement* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->db;
	_tmp1_ = sql_database_select (_tmp0_, "filters");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "content", "id", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_order (_tmp4_, "id");
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda8__sql_select_callback, self);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


void account_add_filter (Account* self, CbFilter* f) {
	GPtrArray* _tmp0_;
	CbFilter* _tmp1_;
	CbFilter* _tmp2_;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (CB_IS_FILTER (f));
	_tmp0_ = self->filters;
	_tmp1_ = f;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
	_g_object_unref0 (f);
}


/**
   * Checks if any of the filters associated to this acount match
   * the given tweet.
   *
   * @param t The tweet to check for
   *
   * @return true iff at least one of the filters match, false otherwise.
   */
static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


gboolean account_filter_matches (Account* self, CbTweet* t) {
	gboolean result = FALSE;
	CbTweet* _tmp0_;
	CbMiniTweet _tmp1_;
	CbUserIdentity _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gchar* text = NULL;
	CbTweet* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	g_return_val_if_fail (CB_IS_TWEET (t), FALSE);
	_tmp0_ = t;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_.author;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = self->id;
	if (_tmp3_ == _tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = t;
	_tmp6_ = cb_tweet_get_filter_text (_tmp5_);
	text = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				CbFilter* f = NULL;
				GPtrArray* _tmp13_;
				gint _tmp14_;
				gconstpointer _tmp15_;
				CbFilter* _tmp16_;
				CbFilter* _tmp17_;
				const gchar* _tmp18_;
				gboolean _tmp19_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = self->filters;
				_tmp11_ = g_ptr_array_get_length (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = self->filters;
				_tmp14_ = i;
				_tmp15_ = g_ptr_array_index (_tmp13_, (guint) _tmp14_);
				_tmp16_ = _g_object_ref0 ((CbFilter*) _tmp15_);
				f = _tmp16_;
				_tmp17_ = f;
				_tmp18_ = text;
				_tmp19_ = cb_filter_matches (_tmp17_, _tmp18_);
				if (_tmp19_) {
					result = TRUE;
					_g_object_unref0 (f);
					_g_free0 (text);
					return result;
				}
				_g_object_unref0 (f);
			}
		}
	}
	result = FALSE;
	_g_free0 (text);
	return result;
}


void account_set_friends (Account* self, JsonArray* friends_array) {
	JsonArray* _tmp0_;
	guint _tmp1_;
	gint64* _tmp2_;
	gint64* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (friends_array != NULL);
	_tmp0_ = friends_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->friends = (g_free (self->friends), NULL);
	self->friends = _tmp2_;
	self->friends_length1 = _tmp1_;
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	g_debug ("Account.vala:399: Adding %d friends...", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				JsonArray* _tmp7_;
				guint _tmp8_;
				gint64* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				JsonArray* _tmp11_;
				gint _tmp12_;
				gint64 _tmp13_;
				gint64 _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = friends_array;
				_tmp8_ = json_array_get_length (_tmp7_);
				if (!(((guint) _tmp6_) < _tmp8_)) {
					break;
				}
				_tmp9_ = self->friends;
				_tmp9__length1 = self->friends_length1;
				_tmp10_ = i;
				_tmp11_ = friends_array;
				_tmp12_ = i;
				_tmp13_ = json_array_get_int_element (_tmp11_, (guint) _tmp12_);
				_tmp9_[_tmp10_] = _tmp13_;
				_tmp14_ = _tmp9_[_tmp10_];
			}
		}
	}
}


gboolean account_follows_id (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->friends;
	_tmp0__length1 = self->friends_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_;
				gint64 _tmp2_;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


void account_follow_id (Account* self, gint64 user_id) {
	gint64* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64 _tmp4_;
	gint64 _tmp5_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->friends;
	_tmp0__length1 = self->friends_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->friends = g_renew (gint64, self->friends, _tmp0__length1 + 1);
	(_tmp1_ > self->friends_length1) ? memset (self->friends + self->friends_length1, 0, sizeof (gint64) * (_tmp1_ - self->friends_length1)) : NULL;
	self->friends_length1 = _tmp1_;
	_tmp2_ = self->friends;
	_tmp2__length1 = self->friends_length1;
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	_tmp4_ = user_id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup2 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unfollow_id (Account* self, gint64 user_id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_;
	gint _tmp1__length1;
	gint64* new_friends = NULL;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64* _tmp4_;
	gint new_friends_length1;
	gint _new_friends_size_;
	gint o = 0;
	gboolean found = FALSE;
	gboolean _tmp20_;
	gint64* _tmp23_;
	gint _tmp23__length1;
	gint64* _tmp24_;
	gint _tmp24__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->friends;
	_tmp1__length1 = self->friends_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->friends;
		_tmp2__length1 = self->friends_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:420: friends == null");
		return;
	}
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1);
	new_friends = _tmp4_;
	new_friends_length1 = _tmp3__length1;
	_new_friends_size_ = new_friends_length1;
	o = 0;
	found = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint64* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gint64 _tmp11_;
				gint64 _tmp12_;
				gint64* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint64* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				gint _tmp19_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->friends;
				_tmp8__length1 = self->friends_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->friends;
				_tmp9__length1 = self->friends_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = user_id;
				if (_tmp11_ == _tmp12_) {
					found = TRUE;
					continue;
				}
				_tmp13_ = new_friends;
				_tmp13__length1 = new_friends_length1;
				_tmp14_ = o;
				_tmp15_ = self->friends;
				_tmp15__length1 = self->friends_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = found;
	if (_tmp20_) {
		gint64* _tmp21_;
		gint _tmp21__length1;
		gint _tmp22_;
		_tmp21_ = new_friends;
		_tmp21__length1 = new_friends_length1;
		_tmp22_ = _tmp21__length1 - 1;
		new_friends = g_renew (gint64, new_friends, _tmp21__length1 - 1);
		(_tmp22_ > new_friends_length1) ? memset (new_friends + new_friends_length1, 0, sizeof (gint64) * (_tmp22_ - new_friends_length1)) : NULL;
		new_friends_length1 = _tmp22_;
		_new_friends_size_ = _tmp22_;
	}
	_tmp23_ = new_friends;
	_tmp23__length1 = new_friends_length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup2 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
	_tmp24__length1 = _tmp23__length1;
	self->friends = (g_free (self->friends), NULL);
	self->friends = _tmp24_;
	self->friends_length1 = _tmp24__length1;
	new_friends = (g_free (new_friends), NULL);
}


void account_set_muted (Account* self, JsonArray* muted_array) {
	JsonArray* _tmp0_;
	guint _tmp1_;
	gint64* _tmp2_;
	gint64* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (muted_array != NULL);
	_tmp0_ = muted_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->muted = (g_free (self->muted), NULL);
	self->muted = _tmp2_;
	self->muted_length1 = _tmp1_;
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	g_debug ("Account.vala:443: Add %d muted ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint64* _tmp7_;
				gint _tmp7__length1;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				JsonArray* _tmp10_;
				gint _tmp11_;
				gint64 _tmp12_;
				gint64 _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->muted;
				_tmp7__length1 = self->muted_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->muted;
				_tmp8__length1 = self->muted_length1;
				_tmp9_ = i;
				_tmp10_ = muted_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_mute_id (Account* self, gint64 id) {
	gint64* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64 _tmp4_;
	gint64 _tmp5_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->muted;
	_tmp0__length1 = self->muted_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->muted = g_renew (gint64, self->muted, _tmp0__length1 + 1);
	(_tmp1_ > self->muted_length1) ? memset (self->muted + self->muted_length1, 0, sizeof (gint64) * (_tmp1_ - self->muted_length1)) : NULL;
	self->muted_length1 = _tmp1_;
	_tmp2_ = self->muted;
	_tmp2__length1 = self->muted_length1;
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	_tmp4_ = id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup3 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unmute_id (Account* self, gint64 id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_;
	gint _tmp1__length1;
	gint64* new_muted = NULL;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64* _tmp4_;
	gint new_muted_length1;
	gint _new_muted_size_;
	gint o = 0;
	gint64* _tmp20_;
	gint _tmp20__length1;
	gint64* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->muted;
	_tmp1__length1 = self->muted_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->muted;
		_tmp2__length1 = self->muted_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:456: muted == null");
		return;
	}
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_muted = _tmp4_;
	new_muted_length1 = _tmp3__length1 - 1;
	_new_muted_size_ = new_muted_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint64* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gint64 _tmp11_;
				gint64 _tmp12_;
				gint64* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint64* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				gint _tmp19_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->muted;
				_tmp8__length1 = self->muted_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->muted;
				_tmp9__length1 = self->muted_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->muted;
				_tmp13__length1 = self->muted_length1;
				_tmp14_ = o;
				_tmp15_ = self->muted;
				_tmp15__length1 = self->muted_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_muted;
	_tmp20__length1 = new_muted_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup3 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->muted = (g_free (self->muted), NULL);
	self->muted = _tmp21_;
	self->muted_length1 = _tmp21__length1;
	new_muted = (g_free (new_muted), NULL);
}


void account_set_blocked (Account* self, JsonArray* blocked_array) {
	JsonArray* _tmp0_;
	guint _tmp1_;
	gint64* _tmp2_;
	gint64* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (blocked_array != NULL);
	_tmp0_ = blocked_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->blocked = (g_free (self->blocked), NULL);
	self->blocked = _tmp2_;
	self->blocked_length1 = _tmp1_;
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	g_debug ("Account.vala:474: Add %d blocked ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint64* _tmp7_;
				gint _tmp7__length1;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				JsonArray* _tmp10_;
				gint _tmp11_;
				gint64 _tmp12_;
				gint64 _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->blocked;
				_tmp7__length1 = self->blocked_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->blocked;
				_tmp8__length1 = self->blocked_length1;
				_tmp9_ = i;
				_tmp10_ = blocked_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_block_id (Account* self, gint64 id) {
	gint64* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64 _tmp4_;
	gint64 _tmp5_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->blocked;
	_tmp0__length1 = self->blocked_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->blocked = g_renew (gint64, self->blocked, _tmp0__length1 + 1);
	(_tmp1_ > self->blocked_length1) ? memset (self->blocked + self->blocked_length1, 0, sizeof (gint64) * (_tmp1_ - self->blocked_length1)) : NULL;
	self->blocked_length1 = _tmp1_;
	_tmp2_ = self->blocked;
	_tmp2__length1 = self->blocked_length1;
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	_tmp4_ = id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup4 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unblock_id (Account* self, gint64 id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_;
	gint _tmp1__length1;
	gint64* new_blocked = NULL;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64* _tmp4_;
	gint new_blocked_length1;
	gint _new_blocked_size_;
	gint o = 0;
	gint64* _tmp20_;
	gint _tmp20__length1;
	gint64* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->blocked;
	_tmp1__length1 = self->blocked_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->blocked;
		_tmp2__length1 = self->blocked_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:487: blocked == null");
		return;
	}
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_blocked = _tmp4_;
	new_blocked_length1 = _tmp3__length1 - 1;
	_new_blocked_size_ = new_blocked_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint64* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gint64 _tmp11_;
				gint64 _tmp12_;
				gint64* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint64* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				gint _tmp19_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->blocked;
				_tmp8__length1 = self->blocked_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->blocked;
				_tmp9__length1 = self->blocked_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->blocked;
				_tmp13__length1 = self->blocked_length1;
				_tmp14_ = o;
				_tmp15_ = self->blocked;
				_tmp15__length1 = self->blocked_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_blocked;
	_tmp20__length1 = new_blocked_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->blocked = (g_free (self->blocked), NULL);
	self->blocked = _tmp21_;
	self->blocked_length1 = _tmp21__length1;
	new_blocked = (g_free (new_blocked), NULL);
}


void account_set_disabled_rts (Account* self, JsonArray* disabled_rts_array) {
	JsonArray* _tmp0_;
	guint _tmp1_;
	gint64* _tmp2_;
	gint64* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (disabled_rts_array != NULL);
	_tmp0_ = disabled_rts_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	self->disabled_rts = _tmp2_;
	self->disabled_rts_length1 = _tmp1_;
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	g_debug ("Account.vala:505: Add %d disabled_rts ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint64* _tmp7_;
				gint _tmp7__length1;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				JsonArray* _tmp10_;
				gint _tmp11_;
				gint64 _tmp12_;
				gint64 _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->disabled_rts;
				_tmp7__length1 = self->disabled_rts_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->disabled_rts;
				_tmp8__length1 = self->disabled_rts_length1;
				_tmp9_ = i;
				_tmp10_ = disabled_rts_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_add_disabled_rts_id (Account* self, gint64 user_id) {
	gint64* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64 _tmp4_;
	gint64 _tmp5_;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->disabled_rts;
	_tmp0__length1 = self->disabled_rts_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->disabled_rts = g_renew (gint64, self->disabled_rts, _tmp0__length1 + 1);
	(_tmp1_ > self->disabled_rts_length1) ? memset (self->disabled_rts + self->disabled_rts_length1, 0, sizeof (gint64) * (_tmp1_ - self->disabled_rts_length1)) : NULL;
	self->disabled_rts_length1 = _tmp1_;
	_tmp2_ = self->disabled_rts;
	_tmp2__length1 = self->disabled_rts_length1;
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	_tmp4_ = self->id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup5 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_remove_disabled_rts_id (Account* self, gint64 user_id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_;
	gint _tmp1__length1;
	gint64* new_disabled_rts = NULL;
	gint64* _tmp3_;
	gint _tmp3__length1;
	gint64* _tmp4_;
	gint new_disabled_rts_length1;
	gint _new_disabled_rts_size_;
	gint o = 0;
	gint64* _tmp20_;
	gint _tmp20__length1;
	gint64* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->disabled_rts;
	_tmp1__length1 = self->disabled_rts_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->disabled_rts;
		_tmp2__length1 = self->disabled_rts_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:518: disabled_rts == null");
		return;
	}
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_disabled_rts = _tmp4_;
	new_disabled_rts_length1 = _tmp3__length1 - 1;
	_new_disabled_rts_size_ = new_disabled_rts_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint64* _tmp8_;
				gint _tmp8__length1;
				gint64* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				gint64 _tmp11_;
				gint64 _tmp12_;
				gint64* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint64* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				gint _tmp19_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->disabled_rts;
				_tmp8__length1 = self->disabled_rts_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->disabled_rts;
				_tmp9__length1 = self->disabled_rts_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = self->id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->disabled_rts;
				_tmp13__length1 = self->disabled_rts_length1;
				_tmp14_ = o;
				_tmp15_ = self->disabled_rts;
				_tmp15__length1 = self->disabled_rts_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_disabled_rts;
	_tmp20__length1 = new_disabled_rts_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup5 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	self->disabled_rts = _tmp21_;
	self->disabled_rts_length1 = _tmp21__length1;
	new_disabled_rts = (g_free (new_disabled_rts), NULL);
}


gboolean account_blocked_or_muted (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_;
	gint _tmp0__length1;
	gint64* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->muted;
	_tmp0__length1 = self->muted_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_;
				gint64 _tmp2_;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp3_;
		id_collection_length1 = _tmp3__length1;
		for (id_it = 0; id_it < _tmp3__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp4_;
				gint64 _tmp5_;
				_tmp4_ = id;
				_tmp5_ = user_id;
				if (_tmp4_ == _tmp5_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean account_is_blocked (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->blocked;
	_tmp0__length1 = self->blocked_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_;
				gint64 _tmp2_;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean account_is_muted (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->muted;
	_tmp0__length1 = self->muted_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_;
				gint64 _tmp2_;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


Account* account_get_nth (guint index) {
	Account* result = NULL;
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	GPtrArray* _tmp2_;
	guint _tmp3_;
	gconstpointer _tmp4_;
	Account* _tmp5_;
	_tmp0_ = account_accounts;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		account_lookup_accounts ();
	}
	_tmp2_ = account_accounts;
	_tmp3_ = index;
	_tmp4_ = g_ptr_array_index (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((Account*) _tmp4_);
	result = _tmp5_;
	return result;
}


guint account_get_n (void) {
	guint result = 0U;
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	_tmp0_ = account_accounts;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		account_lookup_accounts ();
	}
	_tmp2_ = account_accounts;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	result = (guint) _tmp4_;
	return result;
}


/**
   * Look up the accounts. Each account has a <id>.db in ~/.corebird/accounts/
   * The accounts are initialized with only their screen_name and their ID.
   */
static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda137_ (gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	Account* acc = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	Account* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GPtrArray* _tmp11_;
	Account* _tmp12_;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	_tmp3_ = vals;
	_tmp3__length1 = vals_length1;
	_tmp4_ = _tmp3_[1];
	_tmp5_ = vals;
	_tmp5__length1 = vals_length1;
	_tmp6_ = _tmp5_[2];
	_tmp7_ = account_new (_tmp2_, _tmp4_, _tmp6_);
	acc = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[3];
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (acc->avatar_url);
	acc->avatar_url = _tmp10_;
	account_load_avatar (acc);
	_tmp11_ = account_accounts;
	_tmp12_ = _g_object_ref0 (acc);
	g_ptr_array_add (_tmp11_, _tmp12_);
	result = TRUE;
	_g_object_unref0 (acc);
	return result;
}


static gboolean ___lambda137__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda137_ (vals, vals_length1);
	return result;
}


static void account_lookup_accounts (void) {
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	SqlDatabase* _tmp2_;
	SqlSelectStatement* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	_tmp0_ = account_accounts;
	_vala_assert (_tmp0_ == NULL, "accounts == null");
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (account_accounts);
	account_accounts = _tmp1_;
	_tmp2_ = corebird_db;
	_tmp3_ = sql_database_select (_tmp2_, "accounts");
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_cols (_tmp4_, "id", "screen_name", "name", "avatar_url", NULL);
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda137__sql_select_callback, NULL);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
}


/**
   * Adds the given account to the end of the current account list.
   *
   * @param acc The account to add.
   */
void account_add_account (Account* acc) {
	GPtrArray* _tmp0_;
	Account* _tmp1_;
	Account* _tmp2_;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = account_accounts;
	_tmp1_ = acc;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


/**
   * Removes the acccunt with th given screen name from the account list.
   *
   * @param screen_name The screen name of the account to remove.
   */
void account_remove_account (const gchar* screen_name) {
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = account_accounts;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		account_lookup_accounts ();
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				Account* a = NULL;
				GPtrArray* _tmp8_;
				guint _tmp9_;
				gconstpointer _tmp10_;
				Account* _tmp11_;
				Account* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = account_accounts;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < ((guint) _tmp7_))) {
					break;
				}
				_tmp8_ = account_accounts;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, _tmp9_);
				_tmp11_ = _g_object_ref0 ((Account*) _tmp10_);
				a = _tmp11_;
				_tmp12_ = a;
				_tmp13_ = _tmp12_->screen_name;
				_tmp14_ = screen_name;
				if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
					GPtrArray* _tmp15_;
					Account* _tmp16_;
					_tmp15_ = account_accounts;
					_tmp16_ = a;
					g_ptr_array_remove (_tmp15_, _tmp16_);
					_g_object_unref0 (a);
					return;
				}
				_g_object_unref0 (a);
			}
		}
	}
}


/**
   * Returns an unowned reference to the account with the given screen name.
   *
   * @param screen_name The screen name of the account to return
   * @return An unowned reference to the account object with the given screen name or
   *         null of no such instance could be found.
   */
Account* account_query_account (const gchar* screen_name) {
	Account* result = NULL;
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (screen_name != NULL, NULL);
	_tmp0_ = account_accounts;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		account_lookup_accounts ();
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				Account* a = NULL;
				GPtrArray* _tmp8_;
				guint _tmp9_;
				gconstpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				const gchar* _tmp12_;
				Account* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = account_accounts;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < ((guint) _tmp7_))) {
					break;
				}
				_tmp8_ = account_accounts;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, _tmp9_);
				a = (Account*) _tmp10_;
				_tmp12_ = screen_name;
				_tmp13_ = a;
				_tmp14_ = _tmp13_->screen_name;
				if (g_strcmp0 (_tmp12_, _tmp14_) == 0) {
					_tmp11_ = TRUE;
				} else {
					const gchar* _tmp15_;
					Account* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp15_ = screen_name;
					_tmp16_ = a;
					_tmp17_ = _tmp16_->screen_name;
					_tmp18_ = g_strconcat ("@", _tmp17_, NULL);
					_tmp19_ = _tmp18_;
					_tmp11_ = g_strcmp0 (_tmp15_, _tmp19_) == 0;
					_g_free0 (_tmp19_);
				}
				if (_tmp11_) {
					Account* _tmp20_;
					_tmp20_ = a;
					result = _tmp20_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


Account* account_query_account_by_id (gint64 id) {
	Account* result = NULL;
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = account_accounts;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		account_lookup_accounts ();
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				Account* a = NULL;
				GPtrArray* _tmp8_;
				guint _tmp9_;
				gconstpointer _tmp10_;
				gint64 _tmp11_;
				Account* _tmp12_;
				gint64 _tmp13_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = account_accounts;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < ((guint) _tmp7_))) {
					break;
				}
				_tmp8_ = account_accounts;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, _tmp9_);
				a = (Account*) _tmp10_;
				_tmp11_ = id;
				_tmp12_ = a;
				_tmp13_ = _tmp12_->id;
				if (_tmp11_ == _tmp13_) {
					Account* _tmp14_;
					_tmp14_ = a;
					result = _tmp14_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


cairo_surface_t* account_get_avatar_small (Account* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_avatar_small;
	result = _tmp0_;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void account_set_avatar_small (Account* self, cairo_surface_t* value) {
	g_return_if_fail (IS_ACCOUNT (self));
	if (account_get_avatar_small (self) != value) {
		cairo_surface_t* _tmp0_;
		cairo_surface_t* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _cairo_surface_reference0 (_tmp0_);
		_cairo_surface_destroy0 (self->priv->_avatar_small);
		self->priv->_avatar_small = _tmp1_;
		g_object_notify ((GObject *) self, "avatar-small");
	}
}


cairo_surface_t* account_get_avatar (Account* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


void account_set_avatar (Account* self, cairo_surface_t* value) {
	g_return_if_fail (IS_ACCOUNT (self));
	if (account_get_avatar (self) != value) {
		cairo_surface_t* _tmp0_;
		cairo_surface_t* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _cairo_surface_reference0 (_tmp0_);
		_cairo_surface_destroy0 (self->priv->_avatar);
		self->priv->_avatar = _tmp1_;
		g_object_notify ((GObject *) self, "avatar");
	}
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_pointer (param_values + 4), data2);
}


static void account_class_init (AccountClass * klass) {
	account_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_account_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_account_set_property;
	G_OBJECT_CLASS (klass)->finalize = account_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_AVATAR_SMALL, g_param_spec_pointer ("avatar-small", "avatar-small", "avatar-small", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_AVATAR, g_param_spec_pointer ("avatar", "avatar", "avatar", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	account_signals[ACCOUNT_INFO_CHANGED_SIGNAL] = g_signal_new ("info_changed", TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
}


static void account_instance_init (Account * self) {
	self->priv = ACCOUNT_GET_PRIVATE (self);
}


static void account_finalize (GObject * obj) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT, Account);
	_g_object_unref0 (self->db);
	_g_free0 (self->screen_name);
	_g_free0 (self->name);
	_g_free0 (self->avatar_url);
	_g_free0 (self->banner_url);
	_g_free0 (self->website);
	_g_free0 (self->description);
	_cairo_surface_destroy0 (self->priv->_avatar_small);
	_cairo_surface_destroy0 (self->priv->_avatar);
	_g_object_unref0 (self->proxy);
	_g_object_unref0 (self->user_stream);
	_g_object_unref0 (self->user_counter);
	_g_object_unref0 (self->priv->event_receiver);
	_g_object_unref0 (self->notifications);
	self->friends = (g_free (self->friends), NULL);
	self->blocked = (g_free (self->blocked), NULL);
	self->muted = (g_free (self->muted), NULL);
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	_g_ptr_array_unref0 (self->filters);
	G_OBJECT_CLASS (account_parent_class)->finalize (obj);
}


GType account_get_type (void) {
	static volatile gsize account_type_id__volatile = 0;
	if (g_once_init_enter (&account_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Account), 0, (GInstanceInitFunc) account_instance_init, NULL };
		GType account_type_id;
		account_type_id = g_type_register_static (G_TYPE_OBJECT, "Account", &g_define_type_info, 0);
		g_once_init_leave (&account_type_id__volatile, account_type_id);
	}
	return account_type_id__volatile;
}


static void _vala_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNT, Account);
	switch (property_id) {
		case ACCOUNT_AVATAR_SMALL:
		g_value_set_pointer (value, account_get_avatar_small (self));
		break;
		case ACCOUNT_AVATAR:
		g_value_set_pointer (value, account_get_avatar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNT, Account);
	switch (property_id) {
		case ACCOUNT_AVATAR_SMALL:
		account_set_avatar_small (self, g_value_get_pointer (value));
		break;
		case ACCOUNT_AVATAR:
		account_set_avatar (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



