; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 -verify-machineinstrs < %s | FileCheck %s
;; A collection of basic functionality tests for statepoint lowering - most
;; interesting cornercases are exercised through the x86 tests.

%struct = type { i64, i64 }

declare zeroext i1 @return_i1()
declare zeroext i32 @return_i32()
declare ptr @return_i32ptr()
declare float @return_float()
declare %struct @return_struct()
declare void @varargf(i32, ...)

define i1 @test_i1_return() nounwind gc "statepoint-example" {
;; This is just checking that a i1 gets lowered normally when there's no extra
;; state arguments to the statepoint
; CHECK-LABEL: test_i1_return:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(return_i1)
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(i1 ()) @return_i1, i32 0, i32 0, i32 0, i32 0)
  %call1 = call zeroext i1 @llvm.experimental.gc.result.i1(token %safepoint_token)
  ret i1 %call1
}

define i32 @test_i32_return() nounwind gc "statepoint-example" {
; CHECK-LABEL: test_i32_return:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(return_i32)
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(i32 ()) @return_i32, i32 0, i32 0, i32 0, i32 0)
  %call1 = call zeroext i32 @llvm.experimental.gc.result.i32(token %safepoint_token)
  ret i32 %call1
}

define ptr @test_i32ptr_return() nounwind gc "statepoint-example" {
; CHECK-LABEL: test_i32ptr_return:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(return_i32ptr)
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(ptr ()) @return_i32ptr, i32 0, i32 0, i32 0, i32 0)
  %call1 = call ptr @llvm.experimental.gc.result.p0(token %safepoint_token)
  ret ptr %call1
}

define float @test_float_return() nounwind gc "statepoint-example" {
; CHECK-LABEL: test_float_return:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(return_float)
; CHECK-NEXT:  .Ltmp3:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(float ()) @return_float, i32 0, i32 0, i32 0, i32 0)
  %call1 = call float @llvm.experimental.gc.result.f32(token %safepoint_token)
  ret float %call1
}

define %struct @test_struct_return() nounwind gc "statepoint-example" {
; CHECK-LABEL: test_struct_return:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    bl %plt(return_struct)
; CHECK-NEXT:  .Ltmp4:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(%struct ()) @return_struct, i32 0, i32 0, i32 0, i32 0)
  %call1 = call %struct @llvm.experimental.gc.result.struct(token %safepoint_token)
  ret %struct %call1
}

define i1 @test_relocate(ptr addrspace(1) %a) nounwind gc "statepoint-example" {
; CHECK-LABEL: test_relocate:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $a0, $sp, 0
; CHECK-NEXT:    bl %plt(return_i1)
; CHECK-NEXT:  .Ltmp5:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(i1 ()) @return_i1, i32 0, i32 0, i32 0, i32 0) ["gc-live" (ptr addrspace(1) %a)]
  %call1 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %call2 = call zeroext i1 @llvm.experimental.gc.result.i1(token %safepoint_token)
  ret i1 %call2
}

define void @test_void_vararg() nounwind gc "statepoint-example" {
; CHECK-LABEL: test_void_vararg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    ori $a0, $zero, 42
; CHECK-NEXT:    ori $a1, $zero, 43
; CHECK-NEXT:    bl %plt(varargf)
; CHECK-NEXT:  .Ltmp6:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void (i32, ...)) @varargf, i32 2, i32 0, i32 42, i32 43, i32 0, i32 0)
  ;; if we try to use the result from a statepoint wrapping a
  ;; non-void-returning varargf, we will experience a crash.
  ret void
}

define i1 @test_i1_return_patchable() nounwind gc "statepoint-example" {
;; A patchable variant of test_i1_return
; CHECK-LABEL: test_i1_return_patchable:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; CHECK-NEXT:    nop
; CHECK-NEXT:  .Ltmp7:
; CHECK-NEXT:    ld.d $ra, $sp, 8 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 4, ptr elementtype(i1 ()) null, i32 0, i32 0, i32 0, i32 0)
  %call1 = call zeroext i1 @llvm.experimental.gc.result.i1(token %safepoint_token)
  ret i1 %call1
}

declare void @consume(ptr addrspace(1) %obj)

define i1 @test_cross_bb(ptr addrspace(1) %a, i1 %external_cond) nounwind gc "statepoint-example" {
; CHECK-LABEL: test_cross_bb:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    st.d $fp, $sp, 16 # 8-byte Folded Spill
; CHECK-NEXT:    andi $fp, $a1, 1
; CHECK-NEXT:    st.d $a0, $sp, 8
; CHECK-NEXT:    bl %plt(return_i1)
; CHECK-NEXT:  .Ltmp8:
; CHECK-NEXT:    beqz $fp, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %left
; CHECK-NEXT:    ld.d $a1, $sp, 8
; CHECK-NEXT:    move $fp, $a0
; CHECK-NEXT:    move $a0, $a1
; CHECK-NEXT:    bl %plt(consume)
; CHECK-NEXT:    move $a0, $fp
; CHECK-NEXT:    b .LBB8_3
; CHECK-NEXT:  .LBB8_2: # %right
; CHECK-NEXT:    ori $a0, $zero, 1
; CHECK-NEXT:  .LBB8_3: # %right
; CHECK-NEXT:    ld.d $fp, $sp, 16 # 8-byte Folded Reload
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
entry:
  %safepoint_token = tail call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(i1 ()) @return_i1, i32 0, i32 0, i32 0, i32 0) ["gc-live" (ptr addrspace(1) %a)]
  br i1 %external_cond, label %left, label %right

left:
  %call1 = call ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token %safepoint_token,  i32 0, i32 0)
  %call2 = call zeroext i1 @llvm.experimental.gc.result.i1(token %safepoint_token)
  call void @consume(ptr addrspace(1) %call1)
  ret i1 %call2

right:
  ret i1 true
}

%struct2 = type { i64, i64, i64 }

declare void @consume_attributes(i32, ptr nest, i32, ptr byval(%struct2))

define void @test_attributes(ptr byval(%struct2) %s) nounwind gc "statepoint-example" {
; CHECK-LABEL: test_attributes:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -32
; CHECK-NEXT:    st.d $ra, $sp, 24 # 8-byte Folded Spill
; CHECK-NEXT:    ld.d $a1, $a0, 16
; CHECK-NEXT:    st.d $a1, $sp, 16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vst $vr0, $sp, 0
; CHECK-NEXT:    ori $a0, $zero, 42
; CHECK-NEXT:    ori $a2, $zero, 17
; CHECK-NEXT:    addi.d $a3, $sp, 0
; CHECK-NEXT:    move $a1, $zero
; CHECK-NEXT:    bl %plt(consume_attributes)
; CHECK-NEXT:  .Ltmp9:
; CHECK-NEXT:    ld.d $ra, $sp, 24 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 32
; CHECK-NEXT:    ret
entry:
;; We call a function that has a nest argument and a byval argument.
  %statepoint_token = call token (i64, i32, ptr, i32, i32, ...) @llvm.experimental.gc.statepoint.p0(i64 0, i32 0, ptr elementtype(void (i32, ptr, i32, ptr)) @consume_attributes, i32 4, i32 0, i32 42, ptr nest null, i32 17, ptr byval(%struct2) %s, i32 0, i32 0)
  ret void
}

declare token @llvm.experimental.gc.statepoint.p0(i64, i32, ptr, i32, i32, ...)
declare i1 @llvm.experimental.gc.result.i1(token)
declare i32 @llvm.experimental.gc.result.i32(token)
declare ptr @llvm.experimental.gc.result.p0(token)
declare float @llvm.experimental.gc.result.f32(token)
declare %struct @llvm.experimental.gc.result.struct(token)
declare ptr addrspace(1) @llvm.experimental.gc.relocate.p1(token, i32, i32)
